/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerSegmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerSegmentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerSegmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Segment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerSegmentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerSegment extends VdmEntity<PartnerSegment>
{

    /**
     * Selector for all available fields of PartnerSegment.
     *
     */
    public final static PartnerSegmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Partner Segment
     */
    @Key
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static PartnerSegmentField<String> SEGMENT = new PartnerSegmentField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @return Partner Segment Description
     */
    @SerializedName( "Segment_Text" )
    @JsonProperty( "Segment_Text" )
    @Nullable
    @ODataField( odataName = "Segment_Text" )
    private String segment_Text;
    /**
     * Use with available fluent helpers to apply the <b>Segment_Text</b> field to query operations.
     *
     */
    public final static PartnerSegmentField<String> SEGMENT_TEXT = new PartnerSegmentField<String>("Segment_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static PartnerSegmentField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new PartnerSegmentField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnPartnerSegmentHier</b> for <b>PartnerSegment</b> to multiple
     * <b>PartnerSegmentHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerSegmentHier" )
    @JsonProperty( "to_CnsldtnPartnerSegmentHier" )
    @ODataField( odataName = "to_CnsldtnPartnerSegmentHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerSegmentHier> toCnsldtnPartnerSegmentHier;
    /**
     * Navigation property <b>to_CnsldtnPartnerSegmentT</b> for <b>PartnerSegment</b> to multiple
     * <b>PartnerSegmentText</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerSegmentT" )
    @JsonProperty( "to_CnsldtnPartnerSegmentT" )
    @ODataField( odataName = "to_CnsldtnPartnerSegmentT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PartnerSegmentText> toCnsldtnPartnerSegmentT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerSegmentHier</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerSegmentLink<PartnerSegmentHier> TO_CNSLDTN_PARTNER_SEGMENT_HIER =
        new PartnerSegmentLink<PartnerSegmentHier>("to_CnsldtnPartnerSegmentHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerSegmentT</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerSegmentLink<PartnerSegmentText> TO_CNSLDTN_PARTNER_SEGMENT_T =
        new PartnerSegmentLink<PartnerSegmentText>("to_CnsldtnPartnerSegmentT");

    @Nonnull
    @Override
    public Class<PartnerSegment> getType()
    {
        return PartnerSegment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Partner Segment
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @param segment_Text
     *            Partner Segment Description
     */
    public void setSegment_Text( @Nullable final String segment_Text )
    {
        rememberChangedField("Segment_Text", this.segment_Text);
        this.segment_Text = segment_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerSegment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Segment", getSegment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Segment", getSegment());
        values.put("Segment_Text", getSegment_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("Segment_Text") ) {
                final Object value = values.remove("Segment_Text");
                if( (value == null) || (!value.equals(getSegment_Text())) ) {
                    setSegment_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerSegmentHier") ) {
                final Object value = (values).remove("to_CnsldtnPartnerSegmentHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerSegmentHier == null ) {
                        toCnsldtnPartnerSegmentHier = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerSegmentHier = Lists.newArrayList(toCnsldtnPartnerSegmentHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerSegmentHier entity;
                        if( toCnsldtnPartnerSegmentHier.size() > i ) {
                            entity = toCnsldtnPartnerSegmentHier.get(i);
                        } else {
                            entity = new PartnerSegmentHier();
                            toCnsldtnPartnerSegmentHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnPartnerSegmentT") ) {
                final Object value = (values).remove("to_CnsldtnPartnerSegmentT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPartnerSegmentT == null ) {
                        toCnsldtnPartnerSegmentT = Lists.newArrayList();
                    } else {
                        toCnsldtnPartnerSegmentT = Lists.newArrayList(toCnsldtnPartnerSegmentT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PartnerSegmentText entity;
                        if( toCnsldtnPartnerSegmentT.size() > i ) {
                            entity = toCnsldtnPartnerSegmentT.get(i);
                        } else {
                            entity = new PartnerSegmentText();
                            toCnsldtnPartnerSegmentT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PartnerSegmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerSegmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerSegmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerSegmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerSegmentHier != null ) {
            (values).put("to_CnsldtnPartnerSegmentHier", toCnsldtnPartnerSegmentHier);
        }
        if( toCnsldtnPartnerSegmentT != null ) {
            (values).put("to_CnsldtnPartnerSegmentT", toCnsldtnPartnerSegmentT);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerSegmentHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerSegmentHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerSegmentHier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerSegmentHier> fetchCnsldtnPartnerSegmentHier()
    {
        return fetchFieldAsList("to_CnsldtnPartnerSegmentHier", PartnerSegmentHier.class);
    }

    /**
     * Retrieval of associated <b>PartnerSegmentHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerSegmentHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerSegmentHier</b> of a queried <b>PartnerSegment</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerSegmentHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerSegmentHier> getCnsldtnPartnerSegmentHierOrFetch()
    {
        if( toCnsldtnPartnerSegmentHier == null ) {
            toCnsldtnPartnerSegmentHier = fetchCnsldtnPartnerSegmentHier();
        }
        return toCnsldtnPartnerSegmentHier;
    }

    /**
     * Retrieval of associated <b>PartnerSegmentHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerSegmentHier</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerSegment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerSegmentHier</b> is already loaded, the
     *         result will contain the <b>PartnerSegmentHier</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerSegmentHier>> getCnsldtnPartnerSegmentHierIfPresent()
    {
        return Option.of(toCnsldtnPartnerSegmentHier);
    }

    /**
     * Overwrites the list of associated <b>PartnerSegmentHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerSegmentHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerSegmentHier</b> of a queried <b>PartnerSegment</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerSegmentHier</b> entities.
     */
    public void setCnsldtnPartnerSegmentHier( @Nonnull final List<PartnerSegmentHier> value )
    {
        if( toCnsldtnPartnerSegmentHier == null ) {
            toCnsldtnPartnerSegmentHier = Lists.newArrayList();
        }
        toCnsldtnPartnerSegmentHier.clear();
        toCnsldtnPartnerSegmentHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerSegmentHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerSegmentHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerSegmentHier</b> of a queried <b>PartnerSegment</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerSegmentHier</b> entities.
     */
    public void addCnsldtnPartnerSegmentHier( PartnerSegmentHier... entity )
    {
        if( toCnsldtnPartnerSegmentHier == null ) {
            toCnsldtnPartnerSegmentHier = Lists.newArrayList();
        }
        toCnsldtnPartnerSegmentHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>PartnerSegmentText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPartnerSegmentT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PartnerSegmentText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerSegmentText> fetchCnsldtnPartnerSegmentT()
    {
        return fetchFieldAsList("to_CnsldtnPartnerSegmentT", PartnerSegmentText.class);
    }

    /**
     * Retrieval of associated <b>PartnerSegmentText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerSegmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerSegmentT</b> of a queried <b>PartnerSegment</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerSegmentText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PartnerSegmentText> getCnsldtnPartnerSegmentTOrFetch()
    {
        if( toCnsldtnPartnerSegmentT == null ) {
            toCnsldtnPartnerSegmentT = fetchCnsldtnPartnerSegmentT();
        }
        return toCnsldtnPartnerSegmentT;
    }

    /**
     * Retrieval of associated <b>PartnerSegmentText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerSegmentT</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerSegment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerSegmentT</b> is already loaded, the result
     *         will contain the <b>PartnerSegmentText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PartnerSegmentText>> getCnsldtnPartnerSegmentTIfPresent()
    {
        return Option.of(toCnsldtnPartnerSegmentT);
    }

    /**
     * Overwrites the list of associated <b>PartnerSegmentText</b> entities for the loaded navigation property
     * <b>to_CnsldtnPartnerSegmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerSegmentT</b> of a queried <b>PartnerSegment</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PartnerSegmentText</b> entities.
     */
    public void setCnsldtnPartnerSegmentT( @Nonnull final List<PartnerSegmentText> value )
    {
        if( toCnsldtnPartnerSegmentT == null ) {
            toCnsldtnPartnerSegmentT = Lists.newArrayList();
        }
        toCnsldtnPartnerSegmentT.clear();
        toCnsldtnPartnerSegmentT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PartnerSegmentText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerSegmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerSegmentT</b> of a queried <b>PartnerSegment</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PartnerSegmentText</b> entities.
     */
    public void addCnsldtnPartnerSegmentT( PartnerSegmentText... entity )
    {
        if( toCnsldtnPartnerSegmentT == null ) {
            toCnsldtnPartnerSegmentT = Lists.newArrayList();
        }
        toCnsldtnPartnerSegmentT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PartnerSegment instances.
     *
     */
    public final static class PartnerSegmentBuilder
    {

        private List<PartnerSegmentHier> toCnsldtnPartnerSegmentHier = Lists.newArrayList();
        private List<PartnerSegmentText> toCnsldtnPartnerSegmentT = Lists.newArrayList();

        private PartnerSegment.PartnerSegmentBuilder toCnsldtnPartnerSegmentHier( final List<PartnerSegmentHier> value )
        {
            toCnsldtnPartnerSegmentHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerSegmentHier</b> for <b>PartnerSegment</b> to multiple
         * <b>PartnerSegmentHier</b>.
         *
         * @param value
         *            The PartnerSegmentHiers to build this PartnerSegment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerSegment.PartnerSegmentBuilder cnsldtnPartnerSegmentHier( PartnerSegmentHier... value )
        {
            return toCnsldtnPartnerSegmentHier(Lists.newArrayList(value));
        }

        private PartnerSegment.PartnerSegmentBuilder toCnsldtnPartnerSegmentT( final List<PartnerSegmentText> value )
        {
            toCnsldtnPartnerSegmentT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerSegmentT</b> for <b>PartnerSegment</b> to multiple
         * <b>PartnerSegmentText</b>.
         *
         * @param value
         *            The PartnerSegmentTexts to build this PartnerSegment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerSegment.PartnerSegmentBuilder cnsldtnPartnerSegmentT( PartnerSegmentText... value )
        {
            return toCnsldtnPartnerSegmentT(Lists.newArrayList(value));
        }

    }

}
