/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerSegmentHierSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerSegmentHier
 * PartnerSegmentHier} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class PartnerSegmentHierByKeyFluentHelper
    extends
    FluentHelperByKey<PartnerSegmentHierByKeyFluentHelper, PartnerSegmentHier, PartnerSegmentHierSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PartnerSegmentHier
     * PartnerSegmentHier} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param consolidationSegmentHierarchy
     *            Segment Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PartnerSegmentHier}
     * @param servicePath
     *            Service path to be used to fetch a single {@code PartnerSegmentHier}
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     */
    public PartnerSegmentHierByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationSegmentHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationSegmentHierarchy", consolidationSegmentHierarchy);
        this.key.put("HierarchyNode", hierarchyNode);
        this.key.put("ValidityEndDate", validityEndDate);
    }

    @Override
    @Nonnull
    protected Class<PartnerSegmentHier> getEntityClass()
    {
        return PartnerSegmentHier.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
