/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PartnerSegmentTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PartnerSegmentTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PartnerSegmentTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Partner Segment - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PartnerSegmentTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PartnerSegmentText extends VdmEntity<PartnerSegmentText>
{

    /**
     * Selector for all available fields of PartnerSegmentText.
     *
     */
    public final static PartnerSegmentTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PartnerSegmentTextField<String> LANGUAGE = new PartnerSegmentTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Partner Segment
     */
    @Key
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static PartnerSegmentTextField<String> SEGMENT = new PartnerSegmentTextField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegmentText</b>
     * </p>
     *
     * @return Partner Segment Description
     */
    @SerializedName( "PartnerSegmentText" )
    @JsonProperty( "PartnerSegmentText" )
    @Nullable
    @ODataField( odataName = "PartnerSegmentText" )
    private String partnerSegmentText;
    /**
     * Use with available fluent helpers to apply the <b>PartnerSegmentText</b> field to query operations.
     *
     */
    public final static PartnerSegmentTextField<String> PARTNER_SEGMENT_TEXT =
        new PartnerSegmentTextField<String>("PartnerSegmentText");
    /**
     * Navigation property <b>to_CnsldtnPartnerSegment</b> for <b>PartnerSegmentText</b> to single
     * <b>PartnerSegment</b>.
     *
     */
    @SerializedName( "to_CnsldtnPartnerSegment" )
    @JsonProperty( "to_CnsldtnPartnerSegment" )
    @ODataField( odataName = "to_CnsldtnPartnerSegment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PartnerSegment toCnsldtnPartnerSegment;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPartnerSegment</b> navigation property to query
     * operations.
     *
     */
    public final static PartnerSegmentTextOneToOneLink<PartnerSegment> TO_CNSLDTN_PARTNER_SEGMENT =
        new PartnerSegmentTextOneToOneLink<PartnerSegment>("to_CnsldtnPartnerSegment");

    @Nonnull
    @Override
    public Class<PartnerSegmentText> getType()
    {
        return PartnerSegmentText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Partner Segment
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>PartnerSegmentText</b>
     * </p>
     *
     * @param partnerSegmentText
     *            Partner Segment Description
     */
    public void setPartnerSegmentText( @Nullable final String partnerSegmentText )
    {
        rememberChangedField("PartnerSegmentText", this.partnerSegmentText);
        this.partnerSegmentText = partnerSegmentText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PartnerSegmentText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Segment", getSegment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Segment", getSegment());
        values.put("PartnerSegmentText", getPartnerSegmentText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("PartnerSegmentText") ) {
                final Object value = values.remove("PartnerSegmentText");
                if( (value == null) || (!value.equals(getPartnerSegmentText())) ) {
                    setPartnerSegmentText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPartnerSegment") ) {
                final Object value = (values).remove("to_CnsldtnPartnerSegment");
                if( value instanceof Map ) {
                    if( toCnsldtnPartnerSegment == null ) {
                        toCnsldtnPartnerSegment = new PartnerSegment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPartnerSegment.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PartnerSegmentTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PartnerSegmentTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PartnerSegmentTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PartnerSegmentTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPartnerSegment != null ) {
            (values).put("to_CnsldtnPartnerSegment", toCnsldtnPartnerSegment);
        }
        return values;
    }

    /**
     * Fetches the <b>PartnerSegment</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnPartnerSegment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PartnerSegment</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerSegment fetchCnsldtnPartnerSegment()
    {
        return fetchFieldAsSingle("to_CnsldtnPartnerSegment", PartnerSegment.class);
    }

    /**
     * Retrieval of associated <b>PartnerSegment</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerSegment</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPartnerSegment</b> of a queried <b>PartnerSegmentText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PartnerSegment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PartnerSegment getCnsldtnPartnerSegmentOrFetch()
    {
        if( toCnsldtnPartnerSegment == null ) {
            toCnsldtnPartnerSegment = fetchCnsldtnPartnerSegment();
        }
        return toCnsldtnPartnerSegment;
    }

    /**
     * Retrieval of associated <b>PartnerSegment</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPartnerSegment</b>.
     * <p>
     * If the navigation property for an entity <b>PartnerSegmentText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPartnerSegment</b> is already loaded, the result
     *         will contain the <b>PartnerSegment</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PartnerSegment> getCnsldtnPartnerSegmentIfPresent()
    {
        return Option.of(toCnsldtnPartnerSegment);
    }

    /**
     * Overwrites the associated <b>PartnerSegment</b> entity for the loaded navigation property
     * <b>to_CnsldtnPartnerSegment</b>.
     *
     * @param value
     *            New <b>PartnerSegment</b> entity.
     */
    public void setCnsldtnPartnerSegment( final PartnerSegment value )
    {
        toCnsldtnPartnerSegment = value;
    }

    /**
     * Helper class to allow for fluent creation of PartnerSegmentText instances.
     *
     */
    public final static class PartnerSegmentTextBuilder
    {

        private PartnerSegment toCnsldtnPartnerSegment;

        private PartnerSegmentText.PartnerSegmentTextBuilder toCnsldtnPartnerSegment( final PartnerSegment value )
        {
            toCnsldtnPartnerSegment = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPartnerSegment</b> for <b>PartnerSegmentText</b> to single
         * <b>PartnerSegment</b>.
         *
         * @param value
         *            The PartnerSegment to build this PartnerSegmentText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PartnerSegmentText.PartnerSegmentTextBuilder cnsldtnPartnerSegment( final PartnerSegment value )
        {
            return toCnsldtnPartnerSegment(value);
        }

    }

}
