/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PlantField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PlantLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PlantSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Plant
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PlantType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Plant extends VdmEntity<Plant>
{

    /**
     * Selector for all available fields of Plant.
     *
     */
    public final static PlantSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PlantField<String> PLANT = new PlantField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Plant_Text</b>
     * </p>
     *
     * @return Plant Description
     */
    @SerializedName( "Plant_Text" )
    @JsonProperty( "Plant_Text" )
    @Nullable
    @ODataField( odataName = "Plant_Text" )
    private String plant_Text;
    /**
     * Use with available fluent helpers to apply the <b>Plant_Text</b> field to query operations.
     *
     */
    public final static PlantField<String> PLANT_TEXT = new PlantField<String>("Plant_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static PlantField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new PlantField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnPlantT</b> for <b>Plant</b> to multiple <b>PlantText</b>.
     *
     */
    @SerializedName( "to_CnsldtnPlantT" )
    @JsonProperty( "to_CnsldtnPlantT" )
    @ODataField( odataName = "to_CnsldtnPlantT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PlantText> toCnsldtnPlantT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPlantT</b> navigation property to query operations.
     *
     */
    public final static PlantLink<PlantText> TO_CNSLDTN_PLANT_T = new PlantLink<PlantText>("to_CnsldtnPlantT");

    @Nonnull
    @Override
    public Class<Plant> getType()
    {
        return Plant.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>Plant_Text</b>
     * </p>
     *
     * @param plant_Text
     *            Plant Description
     */
    public void setPlant_Text( @Nullable final String plant_Text )
    {
        rememberChangedField("Plant_Text", this.plant_Text);
        this.plant_Text = plant_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Plant";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Plant", getPlant());
        values.put("Plant_Text", getPlant_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("Plant_Text") ) {
                final Object value = values.remove("Plant_Text");
                if( (value == null) || (!value.equals(getPlant_Text())) ) {
                    setPlant_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPlantT") ) {
                final Object value = (values).remove("to_CnsldtnPlantT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPlantT == null ) {
                        toCnsldtnPlantT = Lists.newArrayList();
                    } else {
                        toCnsldtnPlantT = Lists.newArrayList(toCnsldtnPlantT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PlantText entity;
                        if( toCnsldtnPlantT.size() > i ) {
                            entity = toCnsldtnPlantT.get(i);
                        } else {
                            entity = new PlantText();
                            toCnsldtnPlantT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PlantField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlantField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlantField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlantField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPlantT != null ) {
            (values).put("to_CnsldtnPlantT", toCnsldtnPlantT);
        }
        return values;
    }

    /**
     * Fetches the <b>PlantText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnPlantT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PlantText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlantText> fetchCnsldtnPlantT()
    {
        return fetchFieldAsList("to_CnsldtnPlantT", PlantText.class);
    }

    /**
     * Retrieval of associated <b>PlantText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnPlantT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPlantT</b> of a queried <b>Plant</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PlantText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PlantText> getCnsldtnPlantTOrFetch()
    {
        if( toCnsldtnPlantT == null ) {
            toCnsldtnPlantT = fetchCnsldtnPlantT();
        }
        return toCnsldtnPlantT;
    }

    /**
     * Retrieval of associated <b>PlantText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnPlantT</b>.
     * <p>
     * If the navigation property for an entity <b>Plant</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPlantT</b> is already loaded, the result will
     *         contain the <b>PlantText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PlantText>> getCnsldtnPlantTIfPresent()
    {
        return Option.of(toCnsldtnPlantT);
    }

    /**
     * Overwrites the list of associated <b>PlantText</b> entities for the loaded navigation property
     * <b>to_CnsldtnPlantT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPlantT</b> of a queried <b>Plant</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PlantText</b> entities.
     */
    public void setCnsldtnPlantT( @Nonnull final List<PlantText> value )
    {
        if( toCnsldtnPlantT == null ) {
            toCnsldtnPlantT = Lists.newArrayList();
        }
        toCnsldtnPlantT.clear();
        toCnsldtnPlantT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PlantText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnPlantT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPlantT</b> of a queried <b>Plant</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PlantText</b> entities.
     */
    public void addCnsldtnPlantT( PlantText... entity )
    {
        if( toCnsldtnPlantT == null ) {
            toCnsldtnPlantT = Lists.newArrayList();
        }
        toCnsldtnPlantT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Plant instances.
     *
     */
    public final static class PlantBuilder
    {

        private List<PlantText> toCnsldtnPlantT = Lists.newArrayList();

        private Plant.PlantBuilder toCnsldtnPlantT( final List<PlantText> value )
        {
            toCnsldtnPlantT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPlantT</b> for <b>Plant</b> to multiple <b>PlantText</b>.
         *
         * @param value
         *            The PlantTexts to build this Plant with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Plant.PlantBuilder cnsldtnPlantT( PlantText... value )
        {
            return toCnsldtnPlantT(Lists.newArrayList(value));
        }

    }

}
