/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PlantTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PlantTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PlantTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Plant Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PlantTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PlantText extends VdmEntity<PlantText>
{

    /**
     * Selector for all available fields of PlantText.
     *
     */
    public final static PlantTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PlantTextField<String> LANGUAGE = new PlantTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @Key
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static PlantTextField<String> PLANT = new PlantTextField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnPlantText</b>
     * </p>
     *
     * @return Plant Description
     */
    @SerializedName( "CnsldtnPlantText" )
    @JsonProperty( "CnsldtnPlantText" )
    @Nullable
    @ODataField( odataName = "CnsldtnPlantText" )
    private String cnsldtnPlantText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnPlantText</b> field to query operations.
     *
     */
    public final static PlantTextField<String> CNSLDTN_PLANT_TEXT = new PlantTextField<String>("CnsldtnPlantText");
    /**
     * Navigation property <b>to_CnsldtnPlant</b> for <b>PlantText</b> to single <b>Plant</b>.
     *
     */
    @SerializedName( "to_CnsldtnPlant" )
    @JsonProperty( "to_CnsldtnPlant" )
    @ODataField( odataName = "to_CnsldtnPlant" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Plant toCnsldtnPlant;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPlant</b> navigation property to query operations.
     *
     */
    public final static PlantTextOneToOneLink<Plant> TO_CNSLDTN_PLANT =
        new PlantTextOneToOneLink<Plant>("to_CnsldtnPlant");

    @Nonnull
    @Override
    public Class<PlantText> getType()
    {
        return PlantText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnPlantText</b>
     * </p>
     *
     * @param cnsldtnPlantText
     *            Plant Description
     */
    public void setCnsldtnPlantText( @Nullable final String cnsldtnPlantText )
    {
        rememberChangedField("CnsldtnPlantText", this.cnsldtnPlantText);
        this.cnsldtnPlantText = cnsldtnPlantText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PlantText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Plant", getPlant());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Plant", getPlant());
        values.put("CnsldtnPlantText", getCnsldtnPlantText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("CnsldtnPlantText") ) {
                final Object value = values.remove("CnsldtnPlantText");
                if( (value == null) || (!value.equals(getCnsldtnPlantText())) ) {
                    setCnsldtnPlantText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPlant") ) {
                final Object value = (values).remove("to_CnsldtnPlant");
                if( value instanceof Map ) {
                    if( toCnsldtnPlant == null ) {
                        toCnsldtnPlant = new Plant();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPlant.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> PlantTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PlantTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PlantTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PlantTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPlant != null ) {
            (values).put("to_CnsldtnPlant", toCnsldtnPlant);
        }
        return values;
    }

    /**
     * Fetches the <b>Plant</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnPlant</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Plant</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Plant fetchCnsldtnPlant()
    {
        return fetchFieldAsSingle("to_CnsldtnPlant", Plant.class);
    }

    /**
     * Retrieval of associated <b>Plant</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnPlant</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPlant</b> of a queried <b>PlantText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Plant</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Plant getCnsldtnPlantOrFetch()
    {
        if( toCnsldtnPlant == null ) {
            toCnsldtnPlant = fetchCnsldtnPlant();
        }
        return toCnsldtnPlant;
    }

    /**
     * Retrieval of associated <b>Plant</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnPlant</b>.
     * <p>
     * If the navigation property for an entity <b>PlantText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPlant</b> is already loaded, the result will
     *         contain the <b>Plant</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Plant> getCnsldtnPlantIfPresent()
    {
        return Option.of(toCnsldtnPlant);
    }

    /**
     * Overwrites the associated <b>Plant</b> entity for the loaded navigation property <b>to_CnsldtnPlant</b>.
     *
     * @param value
     *            New <b>Plant</b> entity.
     */
    public void setCnsldtnPlant( final Plant value )
    {
        toCnsldtnPlant = value;
    }

    /**
     * Helper class to allow for fluent creation of PlantText instances.
     *
     */
    public final static class PlantTextBuilder
    {

        private Plant toCnsldtnPlant;

        private PlantText.PlantTextBuilder toCnsldtnPlant( final Plant value )
        {
            toCnsldtnPlant = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPlant</b> for <b>PlantText</b> to single <b>Plant</b>.
         *
         * @param value
         *            The Plant to build this PlantText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PlantText.PlantTextBuilder cnsldtnPlant( final Plant value )
        {
            return toCnsldtnPlant(value);
        }

    }

}
