/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PostingLevelHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PostingLevelHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PostingLevelHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PostingLevelHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Posting Level - HierarchyNode
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PostingLevelHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PostingLevelHier extends VdmEntity<PostingLevelHier>
{

    /**
     * Selector for all available fields of PostingLevelHier.
     *
     */
    public final static PostingLevelHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostgLevelHier</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "ConsolidationPostgLevelHier" )
    @JsonProperty( "ConsolidationPostgLevelHier" )
    @Nullable
    @ODataField( odataName = "ConsolidationPostgLevelHier" )
    private String consolidationPostgLevelHier;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationPostgLevelHier</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> CONSOLIDATION_POSTG_LEVEL_HIER =
        new PostingLevelHierField<String>("ConsolidationPostgLevelHier");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> HIERARCHY_NODE =
        new PostingLevelHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> HIERARCHY_NODE_TEXT =
        new PostingLevelHierField<String>("HierarchyNode_Text");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> PARENT_NODE = new PostingLevelHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel</b>
     * </p>
     *
     * @return Posting Level
     */
    @SerializedName( "PostingLevel" )
    @JsonProperty( "PostingLevel" )
    @Nullable
    @ODataField( odataName = "PostingLevel" )
    private String postingLevel;
    /**
     * Use with available fluent helpers to apply the <b>PostingLevel</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> POSTING_LEVEL = new PostingLevelHierField<String>("PostingLevel");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel_Text</b>
     * </p>
     *
     * @return Posting Level Description
     */
    @SerializedName( "PostingLevel_Text" )
    @JsonProperty( "PostingLevel_Text" )
    @Nullable
    @ODataField( odataName = "PostingLevel_Text" )
    private String postingLevel_Text;
    /**
     * Use with available fluent helpers to apply the <b>PostingLevel_Text</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> POSTING_LEVEL_TEXT =
        new PostingLevelHierField<String>("PostingLevel_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> SEQUENCE_NUMBER =
        new PostingLevelHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> HIERARCHY_NODE_LEVEL =
        new PostingLevelHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static PostingLevelHierField<String> NODE_TYPE = new PostingLevelHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnPostingLevel</b> for <b>PostingLevelHier</b> to single <b>PostingLevel</b>.
     *
     */
    @SerializedName( "to_CnsldtnPostingLevel" )
    @JsonProperty( "to_CnsldtnPostingLevel" )
    @ODataField( odataName = "to_CnsldtnPostingLevel" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PostingLevel toCnsldtnPostingLevel;
    /**
     * Navigation property <b>to_CnsldtnPostingLevelHierT</b> for <b>PostingLevelHier</b> to multiple
     * <b>PostingLevelHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnPostingLevelHierT" )
    @JsonProperty( "to_CnsldtnPostingLevelHierT" )
    @ODataField( odataName = "to_CnsldtnPostingLevelHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<PostingLevelHierText> toCnsldtnPostingLevelHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPostingLevel</b> navigation property to query
     * operations.
     *
     */
    public final static PostingLevelHierOneToOneLink<PostingLevel> TO_CNSLDTN_POSTING_LEVEL =
        new PostingLevelHierOneToOneLink<PostingLevel>("to_CnsldtnPostingLevel");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPostingLevelHierT</b> navigation property to query
     * operations.
     *
     */
    public final static PostingLevelHierLink<PostingLevelHierText> TO_CNSLDTN_POSTING_LEVEL_HIER_T =
        new PostingLevelHierLink<PostingLevelHierText>("to_CnsldtnPostingLevelHierT");

    @Nonnull
    @Override
    public Class<PostingLevelHier> getType()
    {
        return PostingLevelHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostgLevelHier</b>
     * </p>
     *
     * @param consolidationPostgLevelHier
     *            Hierarchy ID
     */
    public void setConsolidationPostgLevelHier( @Nullable final String consolidationPostgLevelHier )
    {
        rememberChangedField("ConsolidationPostgLevelHier", this.consolidationPostgLevelHier);
        this.consolidationPostgLevelHier = consolidationPostgLevelHier;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Hierarchy node description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel</b>
     * </p>
     *
     * @param postingLevel
     *            Posting Level
     */
    public void setPostingLevel( @Nullable final String postingLevel )
    {
        rememberChangedField("PostingLevel", this.postingLevel);
        this.postingLevel = postingLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel_Text</b>
     * </p>
     *
     * @param postingLevel_Text
     *            Posting Level Description
     */
    public void setPostingLevel_Text( @Nullable final String postingLevel_Text )
    {
        rememberChangedField("PostingLevel_Text", this.postingLevel_Text);
        this.postingLevel_Text = postingLevel_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Hierarchy Sequence Number
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PostingLevelHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationPostgLevelHier", getConsolidationPostgLevelHier());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationPostgLevelHier", getConsolidationPostgLevelHier());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ParentNode", getParentNode());
        values.put("PostingLevel", getPostingLevel());
        values.put("PostingLevel_Text", getPostingLevel_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationPostgLevelHier") ) {
                final Object value = values.remove("ConsolidationPostgLevelHier");
                if( (value == null) || (!value.equals(getConsolidationPostgLevelHier())) ) {
                    setConsolidationPostgLevelHier(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("PostingLevel") ) {
                final Object value = values.remove("PostingLevel");
                if( (value == null) || (!value.equals(getPostingLevel())) ) {
                    setPostingLevel(((String) value));
                }
            }
            if( values.containsKey("PostingLevel_Text") ) {
                final Object value = values.remove("PostingLevel_Text");
                if( (value == null) || (!value.equals(getPostingLevel_Text())) ) {
                    setPostingLevel_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPostingLevel") ) {
                final Object value = (values).remove("to_CnsldtnPostingLevel");
                if( value instanceof Map ) {
                    if( toCnsldtnPostingLevel == null ) {
                        toCnsldtnPostingLevel = new PostingLevel();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPostingLevel.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnPostingLevelHierT") ) {
                final Object value = (values).remove("to_CnsldtnPostingLevelHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPostingLevelHierT == null ) {
                        toCnsldtnPostingLevelHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnPostingLevelHierT = Lists.newArrayList(toCnsldtnPostingLevelHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        PostingLevelHierText entity;
                        if( toCnsldtnPostingLevelHierT.size() > i ) {
                            entity = toCnsldtnPostingLevelHierT.get(i);
                        } else {
                            entity = new PostingLevelHierText();
                            toCnsldtnPostingLevelHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PostingLevelHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PostingLevelHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PostingLevelHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PostingLevelHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPostingLevel != null ) {
            (values).put("to_CnsldtnPostingLevel", toCnsldtnPostingLevel);
        }
        if( toCnsldtnPostingLevelHierT != null ) {
            (values).put("to_CnsldtnPostingLevelHierT", toCnsldtnPostingLevelHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>PostingLevel</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnPostingLevel</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PostingLevel</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PostingLevel fetchCnsldtnPostingLevel()
    {
        return fetchFieldAsSingle("to_CnsldtnPostingLevel", PostingLevel.class);
    }

    /**
     * Retrieval of associated <b>PostingLevel</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPostingLevel</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPostingLevel</b> of a queried <b>PostingLevelHier</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PostingLevel</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PostingLevel getCnsldtnPostingLevelOrFetch()
    {
        if( toCnsldtnPostingLevel == null ) {
            toCnsldtnPostingLevel = fetchCnsldtnPostingLevel();
        }
        return toCnsldtnPostingLevel;
    }

    /**
     * Retrieval of associated <b>PostingLevel</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPostingLevel</b>.
     * <p>
     * If the navigation property for an entity <b>PostingLevelHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPostingLevel</b> is already loaded, the result
     *         will contain the <b>PostingLevel</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PostingLevel> getCnsldtnPostingLevelIfPresent()
    {
        return Option.of(toCnsldtnPostingLevel);
    }

    /**
     * Overwrites the associated <b>PostingLevel</b> entity for the loaded navigation property
     * <b>to_CnsldtnPostingLevel</b>.
     *
     * @param value
     *            New <b>PostingLevel</b> entity.
     */
    public void setCnsldtnPostingLevel( final PostingLevel value )
    {
        toCnsldtnPostingLevel = value;
    }

    /**
     * Fetches the <b>PostingLevelHierText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnPostingLevelHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>PostingLevelHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PostingLevelHierText> fetchCnsldtnPostingLevelHierT()
    {
        return fetchFieldAsList("to_CnsldtnPostingLevelHierT", PostingLevelHierText.class);
    }

    /**
     * Retrieval of associated <b>PostingLevelHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPostingLevelHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPostingLevelHierT</b> of a queried <b>PostingLevelHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PostingLevelHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<PostingLevelHierText> getCnsldtnPostingLevelHierTOrFetch()
    {
        if( toCnsldtnPostingLevelHierT == null ) {
            toCnsldtnPostingLevelHierT = fetchCnsldtnPostingLevelHierT();
        }
        return toCnsldtnPostingLevelHierT;
    }

    /**
     * Retrieval of associated <b>PostingLevelHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPostingLevelHierT</b>.
     * <p>
     * If the navigation property for an entity <b>PostingLevelHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPostingLevelHierT</b> is already loaded, the
     *         result will contain the <b>PostingLevelHierText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<PostingLevelHierText>> getCnsldtnPostingLevelHierTIfPresent()
    {
        return Option.of(toCnsldtnPostingLevelHierT);
    }

    /**
     * Overwrites the list of associated <b>PostingLevelHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnPostingLevelHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPostingLevelHierT</b> of a queried <b>PostingLevelHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>PostingLevelHierText</b> entities.
     */
    public void setCnsldtnPostingLevelHierT( @Nonnull final List<PostingLevelHierText> value )
    {
        if( toCnsldtnPostingLevelHierT == null ) {
            toCnsldtnPostingLevelHierT = Lists.newArrayList();
        }
        toCnsldtnPostingLevelHierT.clear();
        toCnsldtnPostingLevelHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>PostingLevelHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPostingLevelHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPostingLevelHierT</b> of a queried <b>PostingLevelHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>PostingLevelHierText</b> entities.
     */
    public void addCnsldtnPostingLevelHierT( PostingLevelHierText... entity )
    {
        if( toCnsldtnPostingLevelHierT == null ) {
            toCnsldtnPostingLevelHierT = Lists.newArrayList();
        }
        toCnsldtnPostingLevelHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of PostingLevelHier instances.
     *
     */
    public final static class PostingLevelHierBuilder
    {

        private PostingLevel toCnsldtnPostingLevel;
        private List<PostingLevelHierText> toCnsldtnPostingLevelHierT = Lists.newArrayList();

        private PostingLevelHier.PostingLevelHierBuilder toCnsldtnPostingLevel( final PostingLevel value )
        {
            toCnsldtnPostingLevel = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPostingLevel</b> for <b>PostingLevelHier</b> to single <b>PostingLevel</b>.
         *
         * @param value
         *            The PostingLevel to build this PostingLevelHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PostingLevelHier.PostingLevelHierBuilder cnsldtnPostingLevel( final PostingLevel value )
        {
            return toCnsldtnPostingLevel(value);
        }

        private PostingLevelHier.PostingLevelHierBuilder toCnsldtnPostingLevelHierT(
            final List<PostingLevelHierText> value )
        {
            toCnsldtnPostingLevelHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPostingLevelHierT</b> for <b>PostingLevelHier</b> to multiple
         * <b>PostingLevelHierText</b>.
         *
         * @param value
         *            The PostingLevelHierTexts to build this PostingLevelHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PostingLevelHier.PostingLevelHierBuilder cnsldtnPostingLevelHierT( PostingLevelHierText... value )
        {
            return toCnsldtnPostingLevelHierT(Lists.newArrayList(value));
        }

    }

}
