/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PostingLevelHierSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PostingLevelHier
 * PostingLevelHier} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class PostingLevelHierByKeyFluentHelper
    extends
    FluentHelperByKey<PostingLevelHierByKeyFluentHelper, PostingLevelHier, PostingLevelHierSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.PostingLevelHier
     * PostingLevelHier} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code PostingLevelHier}
     * @param consolidationPostgLevelHier
     *            Hierarchy ID
     *            <p>
     *            Constraints: Not nullable, Maximum length: 42
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code PostingLevelHier}
     * @param hierarchyNode
     *            Hierarchy node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     */
    public PostingLevelHierByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String consolidationPostgLevelHier,
        final String hierarchyNode )
    {
        super(servicePath, entityCollection);
        this.key.put("ConsolidationPostgLevelHier", consolidationPostgLevelHier);
        this.key.put("HierarchyNode", hierarchyNode);
    }

    @Override
    @Nonnull
    protected Class<PostingLevelHier> getEntityClass()
    {
        return PostingLevelHier.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
