/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PostingLevelHierTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PostingLevelHierTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PostingLevelHierTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Posting Level HierarchyNode - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PostingLevelHierTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PostingLevelHierText extends VdmEntity<PostingLevelHierText>
{

    /**
     * Selector for all available fields of PostingLevelHierText.
     *
     */
    public final static PostingLevelHierTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PostingLevelHierTextField<String> LANGUAGE = new PostingLevelHierTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostgLevelHier</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "ConsolidationPostgLevelHier" )
    @JsonProperty( "ConsolidationPostgLevelHier" )
    @Nullable
    @ODataField( odataName = "ConsolidationPostgLevelHier" )
    private String consolidationPostgLevelHier;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationPostgLevelHier</b> field to query operations.
     *
     */
    public final static PostingLevelHierTextField<String> CONSOLIDATION_POSTG_LEVEL_HIER =
        new PostingLevelHierTextField<String>("ConsolidationPostgLevelHier");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static PostingLevelHierTextField<String> HIERARCHY_NODE =
        new PostingLevelHierTextField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNodeText" )
    @JsonProperty( "HierarchyNodeText" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeText" )
    private String hierarchyNodeText;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeText</b> field to query operations.
     *
     */
    public final static PostingLevelHierTextField<String> HIERARCHY_NODE_TEXT =
        new PostingLevelHierTextField<String>("HierarchyNodeText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static PostingLevelHierTextField<String> NODE_TYPE = new PostingLevelHierTextField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnPostingLevelHier</b> for <b>PostingLevelHierText</b> to single
     * <b>PostingLevelHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnPostingLevelHier" )
    @JsonProperty( "to_CnsldtnPostingLevelHier" )
    @ODataField( odataName = "to_CnsldtnPostingLevelHier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PostingLevelHier toCnsldtnPostingLevelHier;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPostingLevelHier</b> navigation property to query
     * operations.
     *
     */
    public final static PostingLevelHierTextOneToOneLink<PostingLevelHier> TO_CNSLDTN_POSTING_LEVEL_HIER =
        new PostingLevelHierTextOneToOneLink<PostingLevelHier>("to_CnsldtnPostingLevelHier");

    @Nonnull
    @Override
    public Class<PostingLevelHierText> getType()
    {
        return PostingLevelHierText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationPostgLevelHier</b>
     * </p>
     *
     * @param consolidationPostgLevelHier
     *            Hierarchy ID
     */
    public void setConsolidationPostgLevelHier( @Nullable final String consolidationPostgLevelHier )
    {
        rememberChangedField("ConsolidationPostgLevelHier", this.consolidationPostgLevelHier);
        this.consolidationPostgLevelHier = consolidationPostgLevelHier;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @param hierarchyNodeText
     *            Hierarchy node description
     */
    public void setHierarchyNodeText( @Nullable final String hierarchyNodeText )
    {
        rememberChangedField("HierarchyNodeText", this.hierarchyNodeText);
        this.hierarchyNodeText = hierarchyNodeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PostingLevelHierText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConsolidationPostgLevelHier", getConsolidationPostgLevelHier());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConsolidationPostgLevelHier", getConsolidationPostgLevelHier());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNodeText", getHierarchyNodeText());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationPostgLevelHier") ) {
                final Object value = values.remove("ConsolidationPostgLevelHier");
                if( (value == null) || (!value.equals(getConsolidationPostgLevelHier())) ) {
                    setConsolidationPostgLevelHier(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeText") ) {
                final Object value = values.remove("HierarchyNodeText");
                if( (value == null) || (!value.equals(getHierarchyNodeText())) ) {
                    setHierarchyNodeText(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPostingLevelHier") ) {
                final Object value = (values).remove("to_CnsldtnPostingLevelHier");
                if( value instanceof Map ) {
                    if( toCnsldtnPostingLevelHier == null ) {
                        toCnsldtnPostingLevelHier = new PostingLevelHier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPostingLevelHier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PostingLevelHierTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PostingLevelHierTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PostingLevelHierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PostingLevelHierTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPostingLevelHier != null ) {
            (values).put("to_CnsldtnPostingLevelHier", toCnsldtnPostingLevelHier);
        }
        return values;
    }

    /**
     * Fetches the <b>PostingLevelHier</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnPostingLevelHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PostingLevelHier</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PostingLevelHier fetchCnsldtnPostingLevelHier()
    {
        return fetchFieldAsSingle("to_CnsldtnPostingLevelHier", PostingLevelHier.class);
    }

    /**
     * Retrieval of associated <b>PostingLevelHier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPostingLevelHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPostingLevelHier</b> of a queried <b>PostingLevelHierText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PostingLevelHier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PostingLevelHier getCnsldtnPostingLevelHierOrFetch()
    {
        if( toCnsldtnPostingLevelHier == null ) {
            toCnsldtnPostingLevelHier = fetchCnsldtnPostingLevelHier();
        }
        return toCnsldtnPostingLevelHier;
    }

    /**
     * Retrieval of associated <b>PostingLevelHier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPostingLevelHier</b>.
     * <p>
     * If the navigation property for an entity <b>PostingLevelHierText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPostingLevelHier</b> is already loaded, the
     *         result will contain the <b>PostingLevelHier</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PostingLevelHier> getCnsldtnPostingLevelHierIfPresent()
    {
        return Option.of(toCnsldtnPostingLevelHier);
    }

    /**
     * Overwrites the associated <b>PostingLevelHier</b> entity for the loaded navigation property
     * <b>to_CnsldtnPostingLevelHier</b>.
     *
     * @param value
     *            New <b>PostingLevelHier</b> entity.
     */
    public void setCnsldtnPostingLevelHier( final PostingLevelHier value )
    {
        toCnsldtnPostingLevelHier = value;
    }

    /**
     * Helper class to allow for fluent creation of PostingLevelHierText instances.
     *
     */
    public final static class PostingLevelHierTextBuilder
    {

        private PostingLevelHier toCnsldtnPostingLevelHier;

        private PostingLevelHierText.PostingLevelHierTextBuilder toCnsldtnPostingLevelHier(
            final PostingLevelHier value )
        {
            toCnsldtnPostingLevelHier = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPostingLevelHier</b> for <b>PostingLevelHierText</b> to single
         * <b>PostingLevelHier</b>.
         *
         * @param value
         *            The PostingLevelHier to build this PostingLevelHierText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PostingLevelHierText.PostingLevelHierTextBuilder cnsldtnPostingLevelHier( final PostingLevelHier value )
        {
            return toCnsldtnPostingLevelHier(value);
        }

    }

}
