/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.PostingLevelTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.PostingLevelTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.PostingLevelTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Posting Level - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>PostingLevelTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class PostingLevelText extends VdmEntity<PostingLevelText>
{

    /**
     * Selector for all available fields of PostingLevelText.
     *
     */
    public final static PostingLevelTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static PostingLevelTextField<String> LANGUAGE = new PostingLevelTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel</b>
     * </p>
     *
     * @return Posting Level
     */
    @Key
    @SerializedName( "PostingLevel" )
    @JsonProperty( "PostingLevel" )
    @Nullable
    @ODataField( odataName = "PostingLevel" )
    private String postingLevel;
    /**
     * Use with available fluent helpers to apply the <b>PostingLevel</b> field to query operations.
     *
     */
    public final static PostingLevelTextField<String> POSTING_LEVEL = new PostingLevelTextField<String>("PostingLevel");
    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevelText</b>
     * </p>
     *
     * @return Posting Level Description
     */
    @SerializedName( "PostingLevelText" )
    @JsonProperty( "PostingLevelText" )
    @Nullable
    @ODataField( odataName = "PostingLevelText" )
    private String postingLevelText;
    /**
     * Use with available fluent helpers to apply the <b>PostingLevelText</b> field to query operations.
     *
     */
    public final static PostingLevelTextField<String> POSTING_LEVEL_TEXT =
        new PostingLevelTextField<String>("PostingLevelText");
    /**
     * Navigation property <b>to_CnsldtnPostingLevel</b> for <b>PostingLevelText</b> to single <b>PostingLevel</b>.
     *
     */
    @SerializedName( "to_CnsldtnPostingLevel" )
    @JsonProperty( "to_CnsldtnPostingLevel" )
    @ODataField( odataName = "to_CnsldtnPostingLevel" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private PostingLevel toCnsldtnPostingLevel;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPostingLevel</b> navigation property to query
     * operations.
     *
     */
    public final static PostingLevelTextOneToOneLink<PostingLevel> TO_CNSLDTN_POSTING_LEVEL =
        new PostingLevelTextOneToOneLink<PostingLevel>("to_CnsldtnPostingLevel");

    @Nonnull
    @Override
    public Class<PostingLevelText> getType()
    {
        return PostingLevelText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevel</b>
     * </p>
     *
     * @param postingLevel
     *            Posting Level
     */
    public void setPostingLevel( @Nullable final String postingLevel )
    {
        rememberChangedField("PostingLevel", this.postingLevel);
        this.postingLevel = postingLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 60
     * <p>
     * Original property name from the Odata EDM: <b>PostingLevelText</b>
     * </p>
     *
     * @param postingLevelText
     *            Posting Level Description
     */
    public void setPostingLevelText( @Nullable final String postingLevelText )
    {
        rememberChangedField("PostingLevelText", this.postingLevelText);
        this.postingLevelText = postingLevelText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "PostingLevelText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("PostingLevel", getPostingLevel());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("PostingLevel", getPostingLevel());
        values.put("PostingLevelText", getPostingLevelText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("PostingLevel") ) {
                final Object value = values.remove("PostingLevel");
                if( (value == null) || (!value.equals(getPostingLevel())) ) {
                    setPostingLevel(((String) value));
                }
            }
            if( values.containsKey("PostingLevelText") ) {
                final Object value = values.remove("PostingLevelText");
                if( (value == null) || (!value.equals(getPostingLevelText())) ) {
                    setPostingLevelText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPostingLevel") ) {
                final Object value = (values).remove("to_CnsldtnPostingLevel");
                if( value instanceof Map ) {
                    if( toCnsldtnPostingLevel == null ) {
                        toCnsldtnPostingLevel = new PostingLevel();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnPostingLevel.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> PostingLevelTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new PostingLevelTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> PostingLevelTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new PostingLevelTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPostingLevel != null ) {
            (values).put("to_CnsldtnPostingLevel", toCnsldtnPostingLevel);
        }
        return values;
    }

    /**
     * Fetches the <b>PostingLevel</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnPostingLevel</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>PostingLevel</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PostingLevel fetchCnsldtnPostingLevel()
    {
        return fetchFieldAsSingle("to_CnsldtnPostingLevel", PostingLevel.class);
    }

    /**
     * Retrieval of associated <b>PostingLevel</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPostingLevel</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPostingLevel</b> of a queried <b>PostingLevelText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>PostingLevel</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public PostingLevel getCnsldtnPostingLevelOrFetch()
    {
        if( toCnsldtnPostingLevel == null ) {
            toCnsldtnPostingLevel = fetchCnsldtnPostingLevel();
        }
        return toCnsldtnPostingLevel;
    }

    /**
     * Retrieval of associated <b>PostingLevel</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnPostingLevel</b>.
     * <p>
     * If the navigation property for an entity <b>PostingLevelText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPostingLevel</b> is already loaded, the result
     *         will contain the <b>PostingLevel</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<PostingLevel> getCnsldtnPostingLevelIfPresent()
    {
        return Option.of(toCnsldtnPostingLevel);
    }

    /**
     * Overwrites the associated <b>PostingLevel</b> entity for the loaded navigation property
     * <b>to_CnsldtnPostingLevel</b>.
     *
     * @param value
     *            New <b>PostingLevel</b> entity.
     */
    public void setCnsldtnPostingLevel( final PostingLevel value )
    {
        toCnsldtnPostingLevel = value;
    }

    /**
     * Helper class to allow for fluent creation of PostingLevelText instances.
     *
     */
    public final static class PostingLevelTextBuilder
    {

        private PostingLevel toCnsldtnPostingLevel;

        private PostingLevelText.PostingLevelTextBuilder toCnsldtnPostingLevel( final PostingLevel value )
        {
            toCnsldtnPostingLevel = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPostingLevel</b> for <b>PostingLevelText</b> to single <b>PostingLevel</b>.
         *
         * @param value
         *            The PostingLevel to build this PostingLevelText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public PostingLevelText.PostingLevelTextBuilder cnsldtnPostingLevel( final PostingLevel value )
        {
            return toCnsldtnPostingLevel(value);
        }

    }

}
