/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ProfitCenterField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ProfitCenterLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ProfitCenterSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Profit Center
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProfitCenterType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProfitCenter extends VdmEntity<ProfitCenter>
{

    /**
     * Selector for all available fields of ProfitCenter.
     *
     */
    public final static ProfitCenterSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Consolidation Profit Center
     */
    @Key
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER = new ProfitCenterField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @return Profit Center Description
     */
    @SerializedName( "ProfitCenter_Text" )
    @JsonProperty( "ProfitCenter_Text" )
    @Nullable
    @ODataField( odataName = "ProfitCenter_Text" )
    private String profitCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter_Text</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> PROFIT_CENTER_TEXT =
        new ProfitCenterField<String>("ProfitCenter_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> CONTROLLING_AREA = new ProfitCenterField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static ProfitCenterField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new ProfitCenterField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnProfitCenterHier</b> for <b>ProfitCenter</b> to multiple
     * <b>ProfitCenterHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnProfitCenterHier" )
    @JsonProperty( "to_CnsldtnProfitCenterHier" )
    @ODataField( odataName = "to_CnsldtnProfitCenterHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProfitCenterHier> toCnsldtnProfitCenterHier;
    /**
     * Navigation property <b>to_CnsldtnProfitCenterT</b> for <b>ProfitCenter</b> to multiple <b>ProfitCenterText</b>.
     *
     */
    @SerializedName( "to_CnsldtnProfitCenterT" )
    @JsonProperty( "to_CnsldtnProfitCenterT" )
    @ODataField( odataName = "to_CnsldtnProfitCenterT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProfitCenterText> toCnsldtnProfitCenterT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProfitCenterHier</b> navigation property to query
     * operations.
     *
     */
    public final static ProfitCenterLink<ProfitCenterHier> TO_CNSLDTN_PROFIT_CENTER_HIER =
        new ProfitCenterLink<ProfitCenterHier>("to_CnsldtnProfitCenterHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProfitCenterT</b> navigation property to query
     * operations.
     *
     */
    public final static ProfitCenterLink<ProfitCenterText> TO_CNSLDTN_PROFIT_CENTER_T =
        new ProfitCenterLink<ProfitCenterText>("to_CnsldtnProfitCenterT");

    @Nonnull
    @Override
    public Class<ProfitCenter> getType()
    {
        return ProfitCenter.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Consolidation Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @param profitCenter_Text
     *            Profit Center Description
     */
    public void setProfitCenter_Text( @Nullable final String profitCenter_Text )
    {
        rememberChangedField("ProfitCenter_Text", this.profitCenter_Text);
        this.profitCenter_Text = profitCenter_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProfitCenter";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProfitCenter", getProfitCenter());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitCenter_Text", getProfitCenter_Text());
        values.put("ControllingArea", getControllingArea());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter_Text") ) {
                final Object value = values.remove("ProfitCenter_Text");
                if( (value == null) || (!value.equals(getProfitCenter_Text())) ) {
                    setProfitCenter_Text(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnProfitCenterHier") ) {
                final Object value = (values).remove("to_CnsldtnProfitCenterHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnProfitCenterHier == null ) {
                        toCnsldtnProfitCenterHier = Lists.newArrayList();
                    } else {
                        toCnsldtnProfitCenterHier = Lists.newArrayList(toCnsldtnProfitCenterHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProfitCenterHier entity;
                        if( toCnsldtnProfitCenterHier.size() > i ) {
                            entity = toCnsldtnProfitCenterHier.get(i);
                        } else {
                            entity = new ProfitCenterHier();
                            toCnsldtnProfitCenterHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnProfitCenterT") ) {
                final Object value = (values).remove("to_CnsldtnProfitCenterT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnProfitCenterT == null ) {
                        toCnsldtnProfitCenterT = Lists.newArrayList();
                    } else {
                        toCnsldtnProfitCenterT = Lists.newArrayList(toCnsldtnProfitCenterT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProfitCenterText entity;
                        if( toCnsldtnProfitCenterT.size() > i ) {
                            entity = toCnsldtnProfitCenterT.get(i);
                        } else {
                            entity = new ProfitCenterText();
                            toCnsldtnProfitCenterT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProfitCenterField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProfitCenterField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProfitCenterField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProfitCenterField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnProfitCenterHier != null ) {
            (values).put("to_CnsldtnProfitCenterHier", toCnsldtnProfitCenterHier);
        }
        if( toCnsldtnProfitCenterT != null ) {
            (values).put("to_CnsldtnProfitCenterT", toCnsldtnProfitCenterT);
        }
        return values;
    }

    /**
     * Fetches the <b>ProfitCenterHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnProfitCenterHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProfitCenterHier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfitCenterHier> fetchCnsldtnProfitCenterHier()
    {
        return fetchFieldAsList("to_CnsldtnProfitCenterHier", ProfitCenterHier.class);
    }

    /**
     * Retrieval of associated <b>ProfitCenterHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProfitCenterHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCenterHier</b> of a queried <b>ProfitCenter</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProfitCenterHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfitCenterHier> getCnsldtnProfitCenterHierOrFetch()
    {
        if( toCnsldtnProfitCenterHier == null ) {
            toCnsldtnProfitCenterHier = fetchCnsldtnProfitCenterHier();
        }
        return toCnsldtnProfitCenterHier;
    }

    /**
     * Retrieval of associated <b>ProfitCenterHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProfitCenterHier</b>.
     * <p>
     * If the navigation property for an entity <b>ProfitCenter</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProfitCenterHier</b> is already loaded, the
     *         result will contain the <b>ProfitCenterHier</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProfitCenterHier>> getCnsldtnProfitCenterHierIfPresent()
    {
        return Option.of(toCnsldtnProfitCenterHier);
    }

    /**
     * Overwrites the list of associated <b>ProfitCenterHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnProfitCenterHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCenterHier</b> of a queried <b>ProfitCenter</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProfitCenterHier</b> entities.
     */
    public void setCnsldtnProfitCenterHier( @Nonnull final List<ProfitCenterHier> value )
    {
        if( toCnsldtnProfitCenterHier == null ) {
            toCnsldtnProfitCenterHier = Lists.newArrayList();
        }
        toCnsldtnProfitCenterHier.clear();
        toCnsldtnProfitCenterHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProfitCenterHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnProfitCenterHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCenterHier</b> of a queried <b>ProfitCenter</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProfitCenterHier</b> entities.
     */
    public void addCnsldtnProfitCenterHier( ProfitCenterHier... entity )
    {
        if( toCnsldtnProfitCenterHier == null ) {
            toCnsldtnProfitCenterHier = Lists.newArrayList();
        }
        toCnsldtnProfitCenterHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProfitCenterText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnProfitCenterT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProfitCenterText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfitCenterText> fetchCnsldtnProfitCenterT()
    {
        return fetchFieldAsList("to_CnsldtnProfitCenterT", ProfitCenterText.class);
    }

    /**
     * Retrieval of associated <b>ProfitCenterText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProfitCenterT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCenterT</b> of a queried <b>ProfitCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProfitCenterText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfitCenterText> getCnsldtnProfitCenterTOrFetch()
    {
        if( toCnsldtnProfitCenterT == null ) {
            toCnsldtnProfitCenterT = fetchCnsldtnProfitCenterT();
        }
        return toCnsldtnProfitCenterT;
    }

    /**
     * Retrieval of associated <b>ProfitCenterText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProfitCenterT</b>.
     * <p>
     * If the navigation property for an entity <b>ProfitCenter</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProfitCenterT</b> is already loaded, the result
     *         will contain the <b>ProfitCenterText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProfitCenterText>> getCnsldtnProfitCenterTIfPresent()
    {
        return Option.of(toCnsldtnProfitCenterT);
    }

    /**
     * Overwrites the list of associated <b>ProfitCenterText</b> entities for the loaded navigation property
     * <b>to_CnsldtnProfitCenterT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCenterT</b> of a queried <b>ProfitCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProfitCenterText</b> entities.
     */
    public void setCnsldtnProfitCenterT( @Nonnull final List<ProfitCenterText> value )
    {
        if( toCnsldtnProfitCenterT == null ) {
            toCnsldtnProfitCenterT = Lists.newArrayList();
        }
        toCnsldtnProfitCenterT.clear();
        toCnsldtnProfitCenterT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProfitCenterText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnProfitCenterT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCenterT</b> of a queried <b>ProfitCenter</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProfitCenterText</b> entities.
     */
    public void addCnsldtnProfitCenterT( ProfitCenterText... entity )
    {
        if( toCnsldtnProfitCenterT == null ) {
            toCnsldtnProfitCenterT = Lists.newArrayList();
        }
        toCnsldtnProfitCenterT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProfitCenter instances.
     *
     */
    public final static class ProfitCenterBuilder
    {

        private List<ProfitCenterHier> toCnsldtnProfitCenterHier = Lists.newArrayList();
        private List<ProfitCenterText> toCnsldtnProfitCenterT = Lists.newArrayList();

        private ProfitCenter.ProfitCenterBuilder toCnsldtnProfitCenterHier( final List<ProfitCenterHier> value )
        {
            toCnsldtnProfitCenterHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProfitCenterHier</b> for <b>ProfitCenter</b> to multiple
         * <b>ProfitCenterHier</b>.
         *
         * @param value
         *            The ProfitCenterHiers to build this ProfitCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProfitCenter.ProfitCenterBuilder cnsldtnProfitCenterHier( ProfitCenterHier... value )
        {
            return toCnsldtnProfitCenterHier(Lists.newArrayList(value));
        }

        private ProfitCenter.ProfitCenterBuilder toCnsldtnProfitCenterT( final List<ProfitCenterText> value )
        {
            toCnsldtnProfitCenterT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProfitCenterT</b> for <b>ProfitCenter</b> to multiple
         * <b>ProfitCenterText</b>.
         *
         * @param value
         *            The ProfitCenterTexts to build this ProfitCenter with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProfitCenter.ProfitCenterBuilder cnsldtnProfitCenterT( ProfitCenterText... value )
        {
            return toCnsldtnProfitCenterT(Lists.newArrayList(value));
        }

    }

}
