/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ProfitCenterForEliminationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ProfitCenterForEliminationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ProfitCenterForEliminationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Profit Center for Elimination
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProfitCenterForEliminationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProfitCenterForElimination extends VdmEntity<ProfitCenterForElimination>
{

    /**
     * Selector for all available fields of ProfitCenterForElimination.
     *
     */
    public final static ProfitCenterForEliminationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Consolidation Profit Center for Elimination
     */
    @Key
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static ProfitCenterForEliminationField<String> PROFIT_CENTER =
        new ProfitCenterForEliminationField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @return Profit Center for Elimination Description
     */
    @SerializedName( "ProfitCenter_Text" )
    @JsonProperty( "ProfitCenter_Text" )
    @Nullable
    @ODataField( odataName = "ProfitCenter_Text" )
    private String profitCenter_Text;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter_Text</b> field to query operations.
     *
     */
    public final static ProfitCenterForEliminationField<String> PROFIT_CENTER_TEXT =
        new ProfitCenterForEliminationField<String>("ProfitCenter_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Consolidation Controlling Area
     */
    @Key
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static ProfitCenterForEliminationField<String> CONTROLLING_AREA =
        new ProfitCenterForEliminationField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static ProfitCenterForEliminationField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new ProfitCenterForEliminationField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnPrftCtrHierForElim</b> for <b>ProfitCenterForElimination</b> to multiple
     * <b>ProfitCenterHierForElim</b>.
     *
     */
    @SerializedName( "to_CnsldtnPrftCtrHierForElim" )
    @JsonProperty( "to_CnsldtnPrftCtrHierForElim" )
    @ODataField( odataName = "to_CnsldtnPrftCtrHierForElim" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProfitCenterHierForElim> toCnsldtnPrftCtrHierForElim;
    /**
     * Navigation property <b>to_CnsldtnProfitCtrForElimT</b> for <b>ProfitCenterForElimination</b> to multiple
     * <b>ProfitCenterForElimText</b>.
     *
     */
    @SerializedName( "to_CnsldtnProfitCtrForElimT" )
    @JsonProperty( "to_CnsldtnProfitCtrForElimT" )
    @ODataField( odataName = "to_CnsldtnProfitCtrForElimT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProfitCenterForElimText> toCnsldtnProfitCtrForElimT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnPrftCtrHierForElim</b> navigation property to query
     * operations.
     *
     */
    public final static ProfitCenterForEliminationLink<ProfitCenterHierForElim> TO_CNSLDTN_PRFT_CTR_HIER_FOR_ELIM =
        new ProfitCenterForEliminationLink<ProfitCenterHierForElim>("to_CnsldtnPrftCtrHierForElim");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProfitCtrForElimT</b> navigation property to query
     * operations.
     *
     */
    public final static ProfitCenterForEliminationLink<ProfitCenterForElimText> TO_CNSLDTN_PROFIT_CTR_FOR_ELIM_T =
        new ProfitCenterForEliminationLink<ProfitCenterForElimText>("to_CnsldtnProfitCtrForElimT");

    @Nonnull
    @Override
    public Class<ProfitCenterForElimination> getType()
    {
        return ProfitCenterForElimination.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Consolidation Profit Center for Elimination
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter_Text</b>
     * </p>
     *
     * @param profitCenter_Text
     *            Profit Center for Elimination Description
     */
    public void setProfitCenter_Text( @Nullable final String profitCenter_Text )
    {
        rememberChangedField("ProfitCenter_Text", this.profitCenter_Text);
        this.profitCenter_Text = profitCenter_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Consolidation Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProfitCenterForElimination";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ProfitCenter", getProfitCenter());
        result.put("ControllingArea", getControllingArea());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProfitCenter_Text", getProfitCenter_Text());
        values.put("ControllingArea", getControllingArea());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter_Text") ) {
                final Object value = values.remove("ProfitCenter_Text");
                if( (value == null) || (!value.equals(getProfitCenter_Text())) ) {
                    setProfitCenter_Text(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnPrftCtrHierForElim") ) {
                final Object value = (values).remove("to_CnsldtnPrftCtrHierForElim");
                if( value instanceof Iterable ) {
                    if( toCnsldtnPrftCtrHierForElim == null ) {
                        toCnsldtnPrftCtrHierForElim = Lists.newArrayList();
                    } else {
                        toCnsldtnPrftCtrHierForElim = Lists.newArrayList(toCnsldtnPrftCtrHierForElim);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProfitCenterHierForElim entity;
                        if( toCnsldtnPrftCtrHierForElim.size() > i ) {
                            entity = toCnsldtnPrftCtrHierForElim.get(i);
                        } else {
                            entity = new ProfitCenterHierForElim();
                            toCnsldtnPrftCtrHierForElim.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnProfitCtrForElimT") ) {
                final Object value = (values).remove("to_CnsldtnProfitCtrForElimT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnProfitCtrForElimT == null ) {
                        toCnsldtnProfitCtrForElimT = Lists.newArrayList();
                    } else {
                        toCnsldtnProfitCtrForElimT = Lists.newArrayList(toCnsldtnProfitCtrForElimT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProfitCenterForElimText entity;
                        if( toCnsldtnProfitCtrForElimT.size() > i ) {
                            entity = toCnsldtnProfitCtrForElimT.get(i);
                        } else {
                            entity = new ProfitCenterForElimText();
                            toCnsldtnProfitCtrForElimT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProfitCenterForEliminationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final Class<T> fieldType )
    {
        return new ProfitCenterForEliminationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProfitCenterForEliminationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProfitCenterForEliminationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnPrftCtrHierForElim != null ) {
            (values).put("to_CnsldtnPrftCtrHierForElim", toCnsldtnPrftCtrHierForElim);
        }
        if( toCnsldtnProfitCtrForElimT != null ) {
            (values).put("to_CnsldtnProfitCtrForElimT", toCnsldtnProfitCtrForElimT);
        }
        return values;
    }

    /**
     * Fetches the <b>ProfitCenterHierForElim</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnPrftCtrHierForElim</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProfitCenterHierForElim</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfitCenterHierForElim> fetchCnsldtnPrftCtrHierForElim()
    {
        return fetchFieldAsList("to_CnsldtnPrftCtrHierForElim", ProfitCenterHierForElim.class);
    }

    /**
     * Retrieval of associated <b>ProfitCenterHierForElim</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPrftCtrHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPrftCtrHierForElim</b> of a queried <b>ProfitCenterForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProfitCenterHierForElim</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfitCenterHierForElim> getCnsldtnPrftCtrHierForElimOrFetch()
    {
        if( toCnsldtnPrftCtrHierForElim == null ) {
            toCnsldtnPrftCtrHierForElim = fetchCnsldtnPrftCtrHierForElim();
        }
        return toCnsldtnPrftCtrHierForElim;
    }

    /**
     * Retrieval of associated <b>ProfitCenterHierForElim</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnPrftCtrHierForElim</b>.
     * <p>
     * If the navigation property for an entity <b>ProfitCenterForElimination</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnPrftCtrHierForElim</b> is already loaded, the
     *         result will contain the <b>ProfitCenterHierForElim</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProfitCenterHierForElim>> getCnsldtnPrftCtrHierForElimIfPresent()
    {
        return Option.of(toCnsldtnPrftCtrHierForElim);
    }

    /**
     * Overwrites the list of associated <b>ProfitCenterHierForElim</b> entities for the loaded navigation property
     * <b>to_CnsldtnPrftCtrHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPrftCtrHierForElim</b> of a queried <b>ProfitCenterForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProfitCenterHierForElim</b> entities.
     */
    public void setCnsldtnPrftCtrHierForElim( @Nonnull final List<ProfitCenterHierForElim> value )
    {
        if( toCnsldtnPrftCtrHierForElim == null ) {
            toCnsldtnPrftCtrHierForElim = Lists.newArrayList();
        }
        toCnsldtnPrftCtrHierForElim.clear();
        toCnsldtnPrftCtrHierForElim.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProfitCenterHierForElim</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnPrftCtrHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnPrftCtrHierForElim</b> of a queried <b>ProfitCenterForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProfitCenterHierForElim</b> entities.
     */
    public void addCnsldtnPrftCtrHierForElim( ProfitCenterHierForElim... entity )
    {
        if( toCnsldtnPrftCtrHierForElim == null ) {
            toCnsldtnPrftCtrHierForElim = Lists.newArrayList();
        }
        toCnsldtnPrftCtrHierForElim.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProfitCenterForElimText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnProfitCtrForElimT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProfitCenterForElimText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfitCenterForElimText> fetchCnsldtnProfitCtrForElimT()
    {
        return fetchFieldAsList("to_CnsldtnProfitCtrForElimT", ProfitCenterForElimText.class);
    }

    /**
     * Retrieval of associated <b>ProfitCenterForElimText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnProfitCtrForElimT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCtrForElimT</b> of a queried <b>ProfitCenterForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProfitCenterForElimText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProfitCenterForElimText> getCnsldtnProfitCtrForElimTOrFetch()
    {
        if( toCnsldtnProfitCtrForElimT == null ) {
            toCnsldtnProfitCtrForElimT = fetchCnsldtnProfitCtrForElimT();
        }
        return toCnsldtnProfitCtrForElimT;
    }

    /**
     * Retrieval of associated <b>ProfitCenterForElimText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnProfitCtrForElimT</b>.
     * <p>
     * If the navigation property for an entity <b>ProfitCenterForElimination</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProfitCtrForElimT</b> is already loaded, the
     *         result will contain the <b>ProfitCenterForElimText</b> entities. If not, an <code>Option</code> with
     *         result state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProfitCenterForElimText>> getCnsldtnProfitCtrForElimTIfPresent()
    {
        return Option.of(toCnsldtnProfitCtrForElimT);
    }

    /**
     * Overwrites the list of associated <b>ProfitCenterForElimText</b> entities for the loaded navigation property
     * <b>to_CnsldtnProfitCtrForElimT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCtrForElimT</b> of a queried <b>ProfitCenterForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProfitCenterForElimText</b> entities.
     */
    public void setCnsldtnProfitCtrForElimT( @Nonnull final List<ProfitCenterForElimText> value )
    {
        if( toCnsldtnProfitCtrForElimT == null ) {
            toCnsldtnProfitCtrForElimT = Lists.newArrayList();
        }
        toCnsldtnProfitCtrForElimT.clear();
        toCnsldtnProfitCtrForElimT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProfitCenterForElimText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnProfitCtrForElimT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProfitCtrForElimT</b> of a queried <b>ProfitCenterForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProfitCenterForElimText</b> entities.
     */
    public void addCnsldtnProfitCtrForElimT( ProfitCenterForElimText... entity )
    {
        if( toCnsldtnProfitCtrForElimT == null ) {
            toCnsldtnProfitCtrForElimT = Lists.newArrayList();
        }
        toCnsldtnProfitCtrForElimT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ProfitCenterForElimination instances.
     *
     */
    public final static class ProfitCenterForEliminationBuilder
    {

        private List<ProfitCenterHierForElim> toCnsldtnPrftCtrHierForElim = Lists.newArrayList();
        private List<ProfitCenterForElimText> toCnsldtnProfitCtrForElimT = Lists.newArrayList();

        private ProfitCenterForElimination.ProfitCenterForEliminationBuilder toCnsldtnPrftCtrHierForElim(
            final List<ProfitCenterHierForElim> value )
        {
            toCnsldtnPrftCtrHierForElim.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnPrftCtrHierForElim</b> for <b>ProfitCenterForElimination</b> to multiple
         * <b>ProfitCenterHierForElim</b>.
         *
         * @param value
         *            The ProfitCenterHierForElims to build this ProfitCenterForElimination with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProfitCenterForElimination.ProfitCenterForEliminationBuilder cnsldtnPrftCtrHierForElim(
            ProfitCenterHierForElim... value )
        {
            return toCnsldtnPrftCtrHierForElim(Lists.newArrayList(value));
        }

        private ProfitCenterForElimination.ProfitCenterForEliminationBuilder toCnsldtnProfitCtrForElimT(
            final List<ProfitCenterForElimText> value )
        {
            toCnsldtnProfitCtrForElimT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProfitCtrForElimT</b> for <b>ProfitCenterForElimination</b> to multiple
         * <b>ProfitCenterForElimText</b>.
         *
         * @param value
         *            The ProfitCenterForElimTexts to build this ProfitCenterForElimination with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProfitCenterForElimination.ProfitCenterForEliminationBuilder cnsldtnProfitCtrForElimT(
            ProfitCenterForElimText... value )
        {
            return toCnsldtnProfitCtrForElimT(Lists.newArrayList(value));
        }

    }

}
