/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ProfitCenterHierSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier
 * ProfitCenterHier} entity using key fields. This fluent helper allows methods which modify the underlying query to be
 * called before executing the query itself.
 *
 */
public class ProfitCenterHierByKeyFluentHelper
    extends
    FluentHelperByKey<ProfitCenterHierByKeyFluentHelper, ProfitCenterHier, ProfitCenterHierSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHier
     * ProfitCenterHier} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProfitCenterHier}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProfitCenterHier}
     * @param controllingArea
     *            Consolidation Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param additionalMasterDataHierarchy
     *            Profit Center Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     */
    public ProfitCenterHierByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String controllingArea,
        final String additionalMasterDataHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate )
    {
        super(servicePath, entityCollection);
        this.key.put("ControllingArea", controllingArea);
        this.key.put("AdditionalMasterDataHierarchy", additionalMasterDataHierarchy);
        this.key.put("HierarchyNode", hierarchyNode);
        this.key.put("ValidityEndDate", validityEndDate);
    }

    @Override
    @Nonnull
    protected Class<ProfitCenterHier> getEntityClass()
    {
        return ProfitCenterHier.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
