/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ProfitCenterHierTextSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierText
 * ProfitCenterHierText} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class ProfitCenterHierTextByKeyFluentHelper
    extends
    FluentHelperByKey<ProfitCenterHierTextByKeyFluentHelper, ProfitCenterHierText, ProfitCenterHierTextSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.ProfitCenterHierText
     * ProfitCenterHierText} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code ProfitCenterHierText}
     * @param servicePath
     *            Service path to be used to fetch a single {@code ProfitCenterHierText}
     * @param language
     *            Language Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 2
     *            </p>
     * @param controllingArea
     *            Consolidation Controlling Area
     *            <p>
     *            Constraints: Not nullable, Maximum length: 4
     *            </p>
     * @param validityEndDate
     *            Validity End Date
     *            <p>
     *            Constraints: Not nullable, Precision: 0
     *            </p>
     * @param additionalMasterDataHierarchy
     *            Profit Center Hierarchy
     *            <p>
     *            Constraints: Not nullable, Maximum length: 40
     *            </p>
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     *            <p>
     *            Constraints: Not nullable, Maximum length: 50
     *            </p>
     */
    public ProfitCenterHierTextByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String controllingArea,
        final String additionalMasterDataHierarchy,
        final String hierarchyNode,
        final LocalDateTime validityEndDate,
        final String language )
    {
        super(servicePath, entityCollection);
        this.key.put("ControllingArea", controllingArea);
        this.key.put("AdditionalMasterDataHierarchy", additionalMasterDataHierarchy);
        this.key.put("HierarchyNode", hierarchyNode);
        this.key.put("ValidityEndDate", validityEndDate);
        this.key.put("Language", language);
    }

    @Override
    @Nonnull
    protected Class<ProfitCenterHierText> getEntityClass()
    {
        return ProfitCenterHierText.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
