/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ProjectField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ProjectLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ProjectSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Project
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProjectType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Project extends VdmEntity<Project>
{

    /**
     * Selector for all available fields of Project.
     *
     */
    public final static ProjectSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project Definition
     */
    @Key
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT = new ProjectField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Project_Text</b>
     * </p>
     *
     * @return Project Definition Description
     */
    @SerializedName( "Project_Text" )
    @JsonProperty( "Project_Text" )
    @Nullable
    @ODataField( odataName = "Project_Text" )
    private String project_Text;
    /**
     * Use with available fluent helpers to apply the <b>Project_Text</b> field to query operations.
     *
     */
    public final static ProjectField<String> PROJECT_TEXT = new ProjectField<String>("Project_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static ProjectField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new ProjectField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnProjectHier</b> for <b>Project</b> to multiple <b>ProjectHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnProjectHier" )
    @JsonProperty( "to_CnsldtnProjectHier" )
    @ODataField( odataName = "to_CnsldtnProjectHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjectHier> toCnsldtnProjectHier;
    /**
     * Navigation property <b>to_CnsldtnProjectT</b> for <b>Project</b> to multiple <b>ProjectText</b>.
     *
     */
    @SerializedName( "to_CnsldtnProjectT" )
    @JsonProperty( "to_CnsldtnProjectT" )
    @ODataField( odataName = "to_CnsldtnProjectT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ProjectText> toCnsldtnProjectT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProjectHier</b> navigation property to query
     * operations.
     *
     */
    public final static ProjectLink<ProjectHier> TO_CNSLDTN_PROJECT_HIER =
        new ProjectLink<ProjectHier>("to_CnsldtnProjectHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProjectT</b> navigation property to query operations.
     *
     */
    public final static ProjectLink<ProjectText> TO_CNSLDTN_PROJECT_T =
        new ProjectLink<ProjectText>("to_CnsldtnProjectT");

    @Nonnull
    @Override
    public Class<Project> getType()
    {
        return Project.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project Definition
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Project_Text</b>
     * </p>
     *
     * @param project_Text
     *            Project Definition Description
     */
    public void setProject_Text( @Nullable final String project_Text )
    {
        rememberChangedField("Project_Text", this.project_Text);
        this.project_Text = project_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Project";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Project", getProject());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Project", getProject());
        values.put("Project_Text", getProject_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("Project_Text") ) {
                final Object value = values.remove("Project_Text");
                if( (value == null) || (!value.equals(getProject_Text())) ) {
                    setProject_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnProjectHier") ) {
                final Object value = (values).remove("to_CnsldtnProjectHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnProjectHier == null ) {
                        toCnsldtnProjectHier = Lists.newArrayList();
                    } else {
                        toCnsldtnProjectHier = Lists.newArrayList(toCnsldtnProjectHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjectHier entity;
                        if( toCnsldtnProjectHier.size() > i ) {
                            entity = toCnsldtnProjectHier.get(i);
                        } else {
                            entity = new ProjectHier();
                            toCnsldtnProjectHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnProjectT") ) {
                final Object value = (values).remove("to_CnsldtnProjectT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnProjectT == null ) {
                        toCnsldtnProjectT = Lists.newArrayList();
                    } else {
                        toCnsldtnProjectT = Lists.newArrayList(toCnsldtnProjectT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ProjectText entity;
                        if( toCnsldtnProjectT.size() > i ) {
                            entity = toCnsldtnProjectT.get(i);
                        } else {
                            entity = new ProjectText();
                            toCnsldtnProjectT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnProjectHier != null ) {
            (values).put("to_CnsldtnProjectHier", toCnsldtnProjectHier);
        }
        if( toCnsldtnProjectT != null ) {
            (values).put("to_CnsldtnProjectT", toCnsldtnProjectT);
        }
        return values;
    }

    /**
     * Fetches the <b>ProjectHier</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnProjectHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjectHier</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectHier> fetchCnsldtnProjectHier()
    {
        return fetchFieldAsList("to_CnsldtnProjectHier", ProjectHier.class);
    }

    /**
     * Retrieval of associated <b>ProjectHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProjectHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProjectHier</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectHier> getCnsldtnProjectHierOrFetch()
    {
        if( toCnsldtnProjectHier == null ) {
            toCnsldtnProjectHier = fetchCnsldtnProjectHier();
        }
        return toCnsldtnProjectHier;
    }

    /**
     * Retrieval of associated <b>ProjectHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProjectHier</b>.
     * <p>
     * If the navigation property for an entity <b>Project</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProjectHier</b> is already loaded, the result
     *         will contain the <b>ProjectHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjectHier>> getCnsldtnProjectHierIfPresent()
    {
        return Option.of(toCnsldtnProjectHier);
    }

    /**
     * Overwrites the list of associated <b>ProjectHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnProjectHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProjectHier</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjectHier</b> entities.
     */
    public void setCnsldtnProjectHier( @Nonnull final List<ProjectHier> value )
    {
        if( toCnsldtnProjectHier == null ) {
            toCnsldtnProjectHier = Lists.newArrayList();
        }
        toCnsldtnProjectHier.clear();
        toCnsldtnProjectHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjectHier</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnProjectHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProjectHier</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjectHier</b> entities.
     */
    public void addCnsldtnProjectHier( ProjectHier... entity )
    {
        if( toCnsldtnProjectHier == null ) {
            toCnsldtnProjectHier = Lists.newArrayList();
        }
        toCnsldtnProjectHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ProjectText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnProjectT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ProjectText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectText> fetchCnsldtnProjectT()
    {
        return fetchFieldAsList("to_CnsldtnProjectT", ProjectText.class);
    }

    /**
     * Retrieval of associated <b>ProjectText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProjectT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProjectT</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ProjectText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ProjectText> getCnsldtnProjectTOrFetch()
    {
        if( toCnsldtnProjectT == null ) {
            toCnsldtnProjectT = fetchCnsldtnProjectT();
        }
        return toCnsldtnProjectT;
    }

    /**
     * Retrieval of associated <b>ProjectText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProjectT</b>.
     * <p>
     * If the navigation property for an entity <b>Project</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProjectT</b> is already loaded, the result will
     *         contain the <b>ProjectText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ProjectText>> getCnsldtnProjectTIfPresent()
    {
        return Option.of(toCnsldtnProjectT);
    }

    /**
     * Overwrites the list of associated <b>ProjectText</b> entities for the loaded navigation property
     * <b>to_CnsldtnProjectT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProjectT</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ProjectText</b> entities.
     */
    public void setCnsldtnProjectT( @Nonnull final List<ProjectText> value )
    {
        if( toCnsldtnProjectT == null ) {
            toCnsldtnProjectT = Lists.newArrayList();
        }
        toCnsldtnProjectT.clear();
        toCnsldtnProjectT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ProjectText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnProjectT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProjectT</b> of a queried <b>Project</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ProjectText</b> entities.
     */
    public void addCnsldtnProjectT( ProjectText... entity )
    {
        if( toCnsldtnProjectT == null ) {
            toCnsldtnProjectT = Lists.newArrayList();
        }
        toCnsldtnProjectT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Project instances.
     *
     */
    public final static class ProjectBuilder
    {

        private List<ProjectHier> toCnsldtnProjectHier = Lists.newArrayList();
        private List<ProjectText> toCnsldtnProjectT = Lists.newArrayList();

        private Project.ProjectBuilder toCnsldtnProjectHier( final List<ProjectHier> value )
        {
            toCnsldtnProjectHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProjectHier</b> for <b>Project</b> to multiple <b>ProjectHier</b>.
         *
         * @param value
         *            The ProjectHiers to build this Project with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Project.ProjectBuilder cnsldtnProjectHier( ProjectHier... value )
        {
            return toCnsldtnProjectHier(Lists.newArrayList(value));
        }

        private Project.ProjectBuilder toCnsldtnProjectT( final List<ProjectText> value )
        {
            toCnsldtnProjectT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProjectT</b> for <b>Project</b> to multiple <b>ProjectText</b>.
         *
         * @param value
         *            The ProjectTexts to build this Project with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Project.ProjectBuilder cnsldtnProjectT( ProjectText... value )
        {
            return toCnsldtnProjectT(Lists.newArrayList(value));
        }

    }

}
