/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ProjectTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ProjectTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ProjectTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Project Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ProjectTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ProjectText extends VdmEntity<ProjectText>
{

    /**
     * Selector for all available fields of ProjectText.
     *
     */
    public final static ProjectTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ProjectTextField<String> LANGUAGE = new ProjectTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project Definition
     */
    @Key
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static ProjectTextField<String> PROJECT = new ProjectTextField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnProjectText</b>
     * </p>
     *
     * @return Project Definition Description
     */
    @SerializedName( "CnsldtnProjectText" )
    @JsonProperty( "CnsldtnProjectText" )
    @Nullable
    @ODataField( odataName = "CnsldtnProjectText" )
    private String cnsldtnProjectText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnProjectText</b> field to query operations.
     *
     */
    public final static ProjectTextField<String> CNSLDTN_PROJECT_TEXT =
        new ProjectTextField<String>("CnsldtnProjectText");
    /**
     * Navigation property <b>to_CnsldtnProject</b> for <b>ProjectText</b> to single <b>Project</b>.
     *
     */
    @SerializedName( "to_CnsldtnProject" )
    @JsonProperty( "to_CnsldtnProject" )
    @ODataField( odataName = "to_CnsldtnProject" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Project toCnsldtnProject;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProject</b> navigation property to query operations.
     *
     */
    public final static ProjectTextOneToOneLink<Project> TO_CNSLDTN_PROJECT =
        new ProjectTextOneToOneLink<Project>("to_CnsldtnProject");

    @Nonnull
    @Override
    public Class<ProjectText> getType()
    {
        return ProjectText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project Definition
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnProjectText</b>
     * </p>
     *
     * @param cnsldtnProjectText
     *            Project Definition Description
     */
    public void setCnsldtnProjectText( @Nullable final String cnsldtnProjectText )
    {
        rememberChangedField("CnsldtnProjectText", this.cnsldtnProjectText);
        this.cnsldtnProjectText = cnsldtnProjectText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ProjectText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Project", getProject());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Project", getProject());
        values.put("CnsldtnProjectText", getCnsldtnProjectText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("CnsldtnProjectText") ) {
                final Object value = values.remove("CnsldtnProjectText");
                if( (value == null) || (!value.equals(getCnsldtnProjectText())) ) {
                    setCnsldtnProjectText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnProject") ) {
                final Object value = (values).remove("to_CnsldtnProject");
                if( value instanceof Map ) {
                    if( toCnsldtnProject == null ) {
                        toCnsldtnProject = new Project();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnProject.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ProjectTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ProjectTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ProjectTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ProjectTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnProject != null ) {
            (values).put("to_CnsldtnProject", toCnsldtnProject);
        }
        return values;
    }

    /**
     * Fetches the <b>Project</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnProject</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Project</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Project fetchCnsldtnProject()
    {
        return fetchFieldAsSingle("to_CnsldtnProject", Project.class);
    }

    /**
     * Retrieval of associated <b>Project</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnProject</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProject</b> of a queried <b>ProjectText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Project</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Project getCnsldtnProjectOrFetch()
    {
        if( toCnsldtnProject == null ) {
            toCnsldtnProject = fetchCnsldtnProject();
        }
        return toCnsldtnProject;
    }

    /**
     * Retrieval of associated <b>Project</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnProject</b>.
     * <p>
     * If the navigation property for an entity <b>ProjectText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProject</b> is already loaded, the result will
     *         contain the <b>Project</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Project> getCnsldtnProjectIfPresent()
    {
        return Option.of(toCnsldtnProject);
    }

    /**
     * Overwrites the associated <b>Project</b> entity for the loaded navigation property <b>to_CnsldtnProject</b>.
     *
     * @param value
     *            New <b>Project</b> entity.
     */
    public void setCnsldtnProject( final Project value )
    {
        toCnsldtnProject = value;
    }

    /**
     * Helper class to allow for fluent creation of ProjectText instances.
     *
     */
    public final static class ProjectTextBuilder
    {

        private Project toCnsldtnProject;

        private ProjectText.ProjectTextBuilder toCnsldtnProject( final Project value )
        {
            toCnsldtnProject = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProject</b> for <b>ProjectText</b> to single <b>Project</b>.
         *
         * @param value
         *            The Project to build this ProjectText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ProjectText.ProjectTextBuilder cnsldtnProject( final Project value )
        {
            return toCnsldtnProject(value);
        }

    }

}
