/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ReportingItemField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ReportingItemLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ReportingItemSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Reporting Item
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ReportingItemType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReportingItem extends VdmEntity<ReportingItem>
{

    /**
     * Selector for all available fields of ReportingItem.
     *
     */
    public final static ReportingItemSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static ReportingItemField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new ReportingItemField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static ReportingItemField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new ReportingItemField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem</b>
     * </p>
     *
     * @return Reporting Item
     */
    @Key
    @SerializedName( "ConsolidationReportingItem" )
    @JsonProperty( "ConsolidationReportingItem" )
    @Nullable
    @ODataField( odataName = "ConsolidationReportingItem" )
    private String consolidationReportingItem;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationReportingItem</b> field to query operations.
     *
     */
    public final static ReportingItemField<String> CONSOLIDATION_REPORTING_ITEM =
        new ReportingItemField<String>("ConsolidationReportingItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem_Text</b>
     * </p>
     *
     * @return Reporting Item Medium Description
     */
    @SerializedName( "ConsolidationReportingItem_Text" )
    @JsonProperty( "ConsolidationReportingItem_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationReportingItem_Text" )
    private String consolidationReportingItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationReportingItem_Text</b> field to query operations.
     *
     */
    public final static ReportingItemField<String> CONSOLIDATION_REPORTING_ITEM_TEXT =
        new ReportingItemField<String>("ConsolidationReportingItem_Text");
    /**
     * Navigation property <b>to_CnsldtnRptgItmHier</b> for <b>ReportingItem</b> to multiple <b>ReportingItemHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnRptgItmHier" )
    @JsonProperty( "to_CnsldtnRptgItmHier" )
    @ODataField( odataName = "to_CnsldtnRptgItmHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ReportingItemHier> toCnsldtnRptgItmHier;
    /**
     * Navigation property <b>to_CnsldtnRptgItmT</b> for <b>ReportingItem</b> to multiple <b>ReportingItemText</b>.
     *
     */
    @SerializedName( "to_CnsldtnRptgItmT" )
    @JsonProperty( "to_CnsldtnRptgItmT" )
    @ODataField( odataName = "to_CnsldtnRptgItmT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ReportingItemText> toCnsldtnRptgItmT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnRptgItmHier</b> navigation property to query
     * operations.
     *
     */
    public final static ReportingItemLink<ReportingItemHier> TO_CNSLDTN_RPTG_ITM_HIER =
        new ReportingItemLink<ReportingItemHier>("to_CnsldtnRptgItmHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnRptgItmT</b> navigation property to query operations.
     *
     */
    public final static ReportingItemLink<ReportingItemText> TO_CNSLDTN_RPTG_ITM_T =
        new ReportingItemLink<ReportingItemText>("to_CnsldtnRptgItmT");

    @Nonnull
    @Override
    public Class<ReportingItem> getType()
    {
        return ReportingItem.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem</b>
     * </p>
     *
     * @param consolidationReportingItem
     *            Reporting Item
     */
    public void setConsolidationReportingItem( @Nullable final String consolidationReportingItem )
    {
        rememberChangedField("ConsolidationReportingItem", this.consolidationReportingItem);
        this.consolidationReportingItem = consolidationReportingItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem_Text</b>
     * </p>
     *
     * @param consolidationReportingItem_Text
     *            Reporting Item Medium Description
     */
    public void setConsolidationReportingItem_Text( @Nullable final String consolidationReportingItem_Text )
    {
        rememberChangedField("ConsolidationReportingItem_Text", this.consolidationReportingItem_Text);
        this.consolidationReportingItem_Text = consolidationReportingItem_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ReportingItem";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("ConsolidationReportingItem", getConsolidationReportingItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("ConsolidationReportingItem", getConsolidationReportingItem());
        values.put("ConsolidationReportingItem_Text", getConsolidationReportingItem_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationReportingItem") ) {
                final Object value = values.remove("ConsolidationReportingItem");
                if( (value == null) || (!value.equals(getConsolidationReportingItem())) ) {
                    setConsolidationReportingItem(((String) value));
                }
            }
            if( values.containsKey("ConsolidationReportingItem_Text") ) {
                final Object value = values.remove("ConsolidationReportingItem_Text");
                if( (value == null) || (!value.equals(getConsolidationReportingItem_Text())) ) {
                    setConsolidationReportingItem_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnRptgItmHier") ) {
                final Object value = (values).remove("to_CnsldtnRptgItmHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnRptgItmHier == null ) {
                        toCnsldtnRptgItmHier = Lists.newArrayList();
                    } else {
                        toCnsldtnRptgItmHier = Lists.newArrayList(toCnsldtnRptgItmHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ReportingItemHier entity;
                        if( toCnsldtnRptgItmHier.size() > i ) {
                            entity = toCnsldtnRptgItmHier.get(i);
                        } else {
                            entity = new ReportingItemHier();
                            toCnsldtnRptgItmHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnRptgItmT") ) {
                final Object value = (values).remove("to_CnsldtnRptgItmT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnRptgItmT == null ) {
                        toCnsldtnRptgItmT = Lists.newArrayList();
                    } else {
                        toCnsldtnRptgItmT = Lists.newArrayList(toCnsldtnRptgItmT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ReportingItemText entity;
                        if( toCnsldtnRptgItmT.size() > i ) {
                            entity = toCnsldtnRptgItmT.get(i);
                        } else {
                            entity = new ReportingItemText();
                            toCnsldtnRptgItmT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ReportingItemField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReportingItemField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReportingItemField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReportingItemField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnRptgItmHier != null ) {
            (values).put("to_CnsldtnRptgItmHier", toCnsldtnRptgItmHier);
        }
        if( toCnsldtnRptgItmT != null ) {
            (values).put("to_CnsldtnRptgItmT", toCnsldtnRptgItmT);
        }
        return values;
    }

    /**
     * Fetches the <b>ReportingItemHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnRptgItmHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ReportingItemHier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReportingItemHier> fetchCnsldtnRptgItmHier()
    {
        return fetchFieldAsList("to_CnsldtnRptgItmHier", ReportingItemHier.class);
    }

    /**
     * Retrieval of associated <b>ReportingItemHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItmHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmHier</b> of a queried <b>ReportingItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReportingItemHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReportingItemHier> getCnsldtnRptgItmHierOrFetch()
    {
        if( toCnsldtnRptgItmHier == null ) {
            toCnsldtnRptgItmHier = fetchCnsldtnRptgItmHier();
        }
        return toCnsldtnRptgItmHier;
    }

    /**
     * Retrieval of associated <b>ReportingItemHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItmHier</b>.
     * <p>
     * If the navigation property for an entity <b>ReportingItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnRptgItmHier</b> is already loaded, the result
     *         will contain the <b>ReportingItemHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ReportingItemHier>> getCnsldtnRptgItmHierIfPresent()
    {
        return Option.of(toCnsldtnRptgItmHier);
    }

    /**
     * Overwrites the list of associated <b>ReportingItemHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnRptgItmHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmHier</b> of a queried <b>ReportingItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ReportingItemHier</b> entities.
     */
    public void setCnsldtnRptgItmHier( @Nonnull final List<ReportingItemHier> value )
    {
        if( toCnsldtnRptgItmHier == null ) {
            toCnsldtnRptgItmHier = Lists.newArrayList();
        }
        toCnsldtnRptgItmHier.clear();
        toCnsldtnRptgItmHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ReportingItemHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnRptgItmHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmHier</b> of a queried <b>ReportingItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ReportingItemHier</b> entities.
     */
    public void addCnsldtnRptgItmHier( ReportingItemHier... entity )
    {
        if( toCnsldtnRptgItmHier == null ) {
            toCnsldtnRptgItmHier = Lists.newArrayList();
        }
        toCnsldtnRptgItmHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>ReportingItemText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnRptgItmT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ReportingItemText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReportingItemText> fetchCnsldtnRptgItmT()
    {
        return fetchFieldAsList("to_CnsldtnRptgItmT", ReportingItemText.class);
    }

    /**
     * Retrieval of associated <b>ReportingItemText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItmT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmT</b> of a queried <b>ReportingItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReportingItemText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReportingItemText> getCnsldtnRptgItmTOrFetch()
    {
        if( toCnsldtnRptgItmT == null ) {
            toCnsldtnRptgItmT = fetchCnsldtnRptgItmT();
        }
        return toCnsldtnRptgItmT;
    }

    /**
     * Retrieval of associated <b>ReportingItemText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItmT</b>.
     * <p>
     * If the navigation property for an entity <b>ReportingItem</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnRptgItmT</b> is already loaded, the result will
     *         contain the <b>ReportingItemText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ReportingItemText>> getCnsldtnRptgItmTIfPresent()
    {
        return Option.of(toCnsldtnRptgItmT);
    }

    /**
     * Overwrites the list of associated <b>ReportingItemText</b> entities for the loaded navigation property
     * <b>to_CnsldtnRptgItmT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmT</b> of a queried <b>ReportingItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ReportingItemText</b> entities.
     */
    public void setCnsldtnRptgItmT( @Nonnull final List<ReportingItemText> value )
    {
        if( toCnsldtnRptgItmT == null ) {
            toCnsldtnRptgItmT = Lists.newArrayList();
        }
        toCnsldtnRptgItmT.clear();
        toCnsldtnRptgItmT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ReportingItemText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnRptgItmT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmT</b> of a queried <b>ReportingItem</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ReportingItemText</b> entities.
     */
    public void addCnsldtnRptgItmT( ReportingItemText... entity )
    {
        if( toCnsldtnRptgItmT == null ) {
            toCnsldtnRptgItmT = Lists.newArrayList();
        }
        toCnsldtnRptgItmT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ReportingItem instances.
     *
     */
    public final static class ReportingItemBuilder
    {

        private List<ReportingItemHier> toCnsldtnRptgItmHier = Lists.newArrayList();
        private List<ReportingItemText> toCnsldtnRptgItmT = Lists.newArrayList();

        private ReportingItem.ReportingItemBuilder toCnsldtnRptgItmHier( final List<ReportingItemHier> value )
        {
            toCnsldtnRptgItmHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnRptgItmHier</b> for <b>ReportingItem</b> to multiple
         * <b>ReportingItemHier</b>.
         *
         * @param value
         *            The ReportingItemHiers to build this ReportingItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReportingItem.ReportingItemBuilder cnsldtnRptgItmHier( ReportingItemHier... value )
        {
            return toCnsldtnRptgItmHier(Lists.newArrayList(value));
        }

        private ReportingItem.ReportingItemBuilder toCnsldtnRptgItmT( final List<ReportingItemText> value )
        {
            toCnsldtnRptgItmT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnRptgItmT</b> for <b>ReportingItem</b> to multiple <b>ReportingItemText</b>.
         *
         * @param value
         *            The ReportingItemTexts to build this ReportingItem with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReportingItem.ReportingItemBuilder cnsldtnRptgItmT( ReportingItemText... value )
        {
            return toCnsldtnRptgItmT(Lists.newArrayList(value));
        }

    }

}
