/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ReportingItemHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ReportingItemHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ReportingItemHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ReportingItemHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Reporting Item Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ReportingItemHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReportingItemHier extends VdmEntity<ReportingItemHier>
{

    /**
     * Selector for all available fields of ReportingItemHier.
     *
     */
    public final static ReportingItemHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new ReportingItemHierField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static ReportingItemHierField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new ReportingItemHierField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItemHier</b>
     * </p>
     *
     * @return Reporting Item Hierarchy
     */
    @Key
    @SerializedName( "ConsolidationReportingItemHier" )
    @JsonProperty( "ConsolidationReportingItemHier" )
    @Nullable
    @ODataField( odataName = "ConsolidationReportingItemHier" )
    private String consolidationReportingItemHier;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationReportingItemHier</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> CONSOLIDATION_REPORTING_ITEM_HIER =
        new ReportingItemHierField<String>("ConsolidationReportingItemHier");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> HIERARCHY_NODE =
        new ReportingItemHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> HIERARCHY_NODE_TEXT =
        new ReportingItemHierField<String>("HierarchyNode_Text");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Parent Node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> PARENT_NODE = new ReportingItemHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @return Consolidation Hierarchy Version
     */
    @SerializedName( "HierarchyVersion" )
    @JsonProperty( "HierarchyVersion" )
    @Nullable
    @ODataField( odataName = "HierarchyVersion" )
    private String hierarchyVersion;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyVersion</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> HIERARCHY_VERSION =
        new ReportingItemHierField<String>("HierarchyVersion");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem</b>
     * </p>
     *
     * @return Reporting Item
     */
    @SerializedName( "ConsolidationReportingItem" )
    @JsonProperty( "ConsolidationReportingItem" )
    @Nullable
    @ODataField( odataName = "ConsolidationReportingItem" )
    private String consolidationReportingItem;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationReportingItem</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> CONSOLIDATION_REPORTING_ITEM =
        new ReportingItemHierField<String>("ConsolidationReportingItem");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem_Text</b>
     * </p>
     *
     * @return Reporting Item Medium Description
     */
    @SerializedName( "ConsolidationReportingItem_Text" )
    @JsonProperty( "ConsolidationReportingItem_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationReportingItem_Text" )
    private String consolidationReportingItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationReportingItem_Text</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> CONSOLIDATION_REPORTING_ITEM_TEXT =
        new ReportingItemHierField<String>("ConsolidationReportingItem_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Consolidation Hierarchy Sequence Number
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> SEQUENCE_NUMBER =
        new ReportingItemHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Consolidation Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> HIERARCHY_NODE_LEVEL =
        new ReportingItemHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static ReportingItemHierField<String> NODE_TYPE = new ReportingItemHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnRptgItm</b> for <b>ReportingItemHier</b> to single <b>ReportingItem</b>.
     *
     */
    @SerializedName( "to_CnsldtnRptgItm" )
    @JsonProperty( "to_CnsldtnRptgItm" )
    @ODataField( odataName = "to_CnsldtnRptgItm" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ReportingItem toCnsldtnRptgItm;
    /**
     * Navigation property <b>to_CnsldtnRptgItmHierT</b> for <b>ReportingItemHier</b> to multiple
     * <b>ReportingItemHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnRptgItmHierT" )
    @JsonProperty( "to_CnsldtnRptgItmHierT" )
    @ODataField( odataName = "to_CnsldtnRptgItmHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ReportingItemHierText> toCnsldtnRptgItmHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnRptgItm</b> navigation property to query operations.
     *
     */
    public final static ReportingItemHierOneToOneLink<ReportingItem> TO_CNSLDTN_RPTG_ITM =
        new ReportingItemHierOneToOneLink<ReportingItem>("to_CnsldtnRptgItm");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnRptgItmHierT</b> navigation property to query
     * operations.
     *
     */
    public final static ReportingItemHierLink<ReportingItemHierText> TO_CNSLDTN_RPTG_ITM_HIER_T =
        new ReportingItemHierLink<ReportingItemHierText>("to_CnsldtnRptgItmHierT");

    @Nonnull
    @Override
    public Class<ReportingItemHier> getType()
    {
        return ReportingItemHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItemHier</b>
     * </p>
     *
     * @param consolidationReportingItemHier
     *            Reporting Item Hierarchy
     */
    public void setConsolidationReportingItemHier( @Nullable final String consolidationReportingItemHier )
    {
        rememberChangedField("ConsolidationReportingItemHier", this.consolidationReportingItemHier);
        this.consolidationReportingItemHier = consolidationReportingItemHier;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Consolidation Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @param hierarchyVersion
     *            Consolidation Hierarchy Version
     */
    public void setHierarchyVersion( @Nullable final String hierarchyVersion )
    {
        rememberChangedField("HierarchyVersion", this.hierarchyVersion);
        this.hierarchyVersion = hierarchyVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem</b>
     * </p>
     *
     * @param consolidationReportingItem
     *            Reporting Item
     */
    public void setConsolidationReportingItem( @Nullable final String consolidationReportingItem )
    {
        rememberChangedField("ConsolidationReportingItem", this.consolidationReportingItem);
        this.consolidationReportingItem = consolidationReportingItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem_Text</b>
     * </p>
     *
     * @param consolidationReportingItem_Text
     *            Reporting Item Medium Description
     */
    public void setConsolidationReportingItem_Text( @Nullable final String consolidationReportingItem_Text )
    {
        rememberChangedField("ConsolidationReportingItem_Text", this.consolidationReportingItem_Text);
        this.consolidationReportingItem_Text = consolidationReportingItem_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Consolidation Hierarchy Sequence Number
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Consolidation Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ReportingItemHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("ConsolidationReportingItemHier", getConsolidationReportingItemHier());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("ConsolidationReportingItemHier", getConsolidationReportingItemHier());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ParentNode", getParentNode());
        values.put("HierarchyVersion", getHierarchyVersion());
        values.put("ConsolidationReportingItem", getConsolidationReportingItem());
        values.put("ConsolidationReportingItem_Text", getConsolidationReportingItem_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationReportingItemHier") ) {
                final Object value = values.remove("ConsolidationReportingItemHier");
                if( (value == null) || (!value.equals(getConsolidationReportingItemHier())) ) {
                    setConsolidationReportingItemHier(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyVersion") ) {
                final Object value = values.remove("HierarchyVersion");
                if( (value == null) || (!value.equals(getHierarchyVersion())) ) {
                    setHierarchyVersion(((String) value));
                }
            }
            if( values.containsKey("ConsolidationReportingItem") ) {
                final Object value = values.remove("ConsolidationReportingItem");
                if( (value == null) || (!value.equals(getConsolidationReportingItem())) ) {
                    setConsolidationReportingItem(((String) value));
                }
            }
            if( values.containsKey("ConsolidationReportingItem_Text") ) {
                final Object value = values.remove("ConsolidationReportingItem_Text");
                if( (value == null) || (!value.equals(getConsolidationReportingItem_Text())) ) {
                    setConsolidationReportingItem_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnRptgItm") ) {
                final Object value = (values).remove("to_CnsldtnRptgItm");
                if( value instanceof Map ) {
                    if( toCnsldtnRptgItm == null ) {
                        toCnsldtnRptgItm = new ReportingItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnRptgItm.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnRptgItmHierT") ) {
                final Object value = (values).remove("to_CnsldtnRptgItmHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnRptgItmHierT == null ) {
                        toCnsldtnRptgItmHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnRptgItmHierT = Lists.newArrayList(toCnsldtnRptgItmHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ReportingItemHierText entity;
                        if( toCnsldtnRptgItmHierT.size() > i ) {
                            entity = toCnsldtnRptgItmHierT.get(i);
                        } else {
                            entity = new ReportingItemHierText();
                            toCnsldtnRptgItmHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ReportingItemHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReportingItemHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReportingItemHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReportingItemHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnRptgItm != null ) {
            (values).put("to_CnsldtnRptgItm", toCnsldtnRptgItm);
        }
        if( toCnsldtnRptgItmHierT != null ) {
            (values).put("to_CnsldtnRptgItmHierT", toCnsldtnRptgItmHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>ReportingItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnRptgItm</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ReportingItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ReportingItem fetchCnsldtnRptgItm()
    {
        return fetchFieldAsSingle("to_CnsldtnRptgItm", ReportingItem.class);
    }

    /**
     * Retrieval of associated <b>ReportingItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItm</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItm</b> of a queried <b>ReportingItemHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReportingItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ReportingItem getCnsldtnRptgItmOrFetch()
    {
        if( toCnsldtnRptgItm == null ) {
            toCnsldtnRptgItm = fetchCnsldtnRptgItm();
        }
        return toCnsldtnRptgItm;
    }

    /**
     * Retrieval of associated <b>ReportingItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItm</b>.
     * <p>
     * If the navigation property for an entity <b>ReportingItemHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnRptgItm</b> is already loaded, the result will
     *         contain the <b>ReportingItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ReportingItem> getCnsldtnRptgItmIfPresent()
    {
        return Option.of(toCnsldtnRptgItm);
    }

    /**
     * Overwrites the associated <b>ReportingItem</b> entity for the loaded navigation property
     * <b>to_CnsldtnRptgItm</b>.
     *
     * @param value
     *            New <b>ReportingItem</b> entity.
     */
    public void setCnsldtnRptgItm( final ReportingItem value )
    {
        toCnsldtnRptgItm = value;
    }

    /**
     * Fetches the <b>ReportingItemHierText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnRptgItmHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ReportingItemHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReportingItemHierText> fetchCnsldtnRptgItmHierT()
    {
        return fetchFieldAsList("to_CnsldtnRptgItmHierT", ReportingItemHierText.class);
    }

    /**
     * Retrieval of associated <b>ReportingItemHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnRptgItmHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmHierT</b> of a queried <b>ReportingItemHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReportingItemHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ReportingItemHierText> getCnsldtnRptgItmHierTOrFetch()
    {
        if( toCnsldtnRptgItmHierT == null ) {
            toCnsldtnRptgItmHierT = fetchCnsldtnRptgItmHierT();
        }
        return toCnsldtnRptgItmHierT;
    }

    /**
     * Retrieval of associated <b>ReportingItemHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnRptgItmHierT</b>.
     * <p>
     * If the navigation property for an entity <b>ReportingItemHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnRptgItmHierT</b> is already loaded, the result
     *         will contain the <b>ReportingItemHierText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ReportingItemHierText>> getCnsldtnRptgItmHierTIfPresent()
    {
        return Option.of(toCnsldtnRptgItmHierT);
    }

    /**
     * Overwrites the list of associated <b>ReportingItemHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnRptgItmHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmHierT</b> of a queried <b>ReportingItemHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ReportingItemHierText</b> entities.
     */
    public void setCnsldtnRptgItmHierT( @Nonnull final List<ReportingItemHierText> value )
    {
        if( toCnsldtnRptgItmHierT == null ) {
            toCnsldtnRptgItmHierT = Lists.newArrayList();
        }
        toCnsldtnRptgItmHierT.clear();
        toCnsldtnRptgItmHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ReportingItemHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnRptgItmHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmHierT</b> of a queried <b>ReportingItemHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ReportingItemHierText</b> entities.
     */
    public void addCnsldtnRptgItmHierT( ReportingItemHierText... entity )
    {
        if( toCnsldtnRptgItmHierT == null ) {
            toCnsldtnRptgItmHierT = Lists.newArrayList();
        }
        toCnsldtnRptgItmHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ReportingItemHier instances.
     *
     */
    public final static class ReportingItemHierBuilder
    {

        private ReportingItem toCnsldtnRptgItm;
        private List<ReportingItemHierText> toCnsldtnRptgItmHierT = Lists.newArrayList();

        private ReportingItemHier.ReportingItemHierBuilder toCnsldtnRptgItm( final ReportingItem value )
        {
            toCnsldtnRptgItm = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnRptgItm</b> for <b>ReportingItemHier</b> to single <b>ReportingItem</b>.
         *
         * @param value
         *            The ReportingItem to build this ReportingItemHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReportingItemHier.ReportingItemHierBuilder cnsldtnRptgItm( final ReportingItem value )
        {
            return toCnsldtnRptgItm(value);
        }

        private ReportingItemHier.ReportingItemHierBuilder toCnsldtnRptgItmHierT(
            final List<ReportingItemHierText> value )
        {
            toCnsldtnRptgItmHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnRptgItmHierT</b> for <b>ReportingItemHier</b> to multiple
         * <b>ReportingItemHierText</b>.
         *
         * @param value
         *            The ReportingItemHierTexts to build this ReportingItemHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReportingItemHier.ReportingItemHierBuilder cnsldtnRptgItmHierT( ReportingItemHierText... value )
        {
            return toCnsldtnRptgItmHierT(Lists.newArrayList(value));
        }

    }

}
