/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ReportingItemHierTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ReportingItemHierTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ReportingItemHierTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Reporting Item HierarchyNode - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ReportingItemHierTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReportingItemHierText extends VdmEntity<ReportingItemHierText>
{

    /**
     * Selector for all available fields of ReportingItemHierText.
     *
     */
    public final static ReportingItemHierTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ReportingItemHierTextField<String> LANGUAGE =
        new ReportingItemHierTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static ReportingItemHierTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new ReportingItemHierTextField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static ReportingItemHierTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new ReportingItemHierTextField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItemHier</b>
     * </p>
     *
     * @return Reporting Item Hierarchy
     */
    @Key
    @SerializedName( "ConsolidationReportingItemHier" )
    @JsonProperty( "ConsolidationReportingItemHier" )
    @Nullable
    @ODataField( odataName = "ConsolidationReportingItemHier" )
    private String consolidationReportingItemHier;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationReportingItemHier</b> field to query operations.
     *
     */
    public final static ReportingItemHierTextField<String> CONSOLIDATION_REPORTING_ITEM_HIER =
        new ReportingItemHierTextField<String>("ConsolidationReportingItemHier");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static ReportingItemHierTextField<String> HIERARCHY_NODE =
        new ReportingItemHierTextField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNodeText" )
    @JsonProperty( "HierarchyNodeText" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeText" )
    private String hierarchyNodeText;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeText</b> field to query operations.
     *
     */
    public final static ReportingItemHierTextField<String> HIERARCHY_NODE_TEXT =
        new ReportingItemHierTextField<String>("HierarchyNodeText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static ReportingItemHierTextField<String> NODE_TYPE =
        new ReportingItemHierTextField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnRptgItmHier</b> for <b>ReportingItemHierText</b> to single
     * <b>ReportingItemHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnRptgItmHier" )
    @JsonProperty( "to_CnsldtnRptgItmHier" )
    @ODataField( odataName = "to_CnsldtnRptgItmHier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ReportingItemHier toCnsldtnRptgItmHier;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnRptgItmHier</b> navigation property to query
     * operations.
     *
     */
    public final static ReportingItemHierTextOneToOneLink<ReportingItemHier> TO_CNSLDTN_RPTG_ITM_HIER =
        new ReportingItemHierTextOneToOneLink<ReportingItemHier>("to_CnsldtnRptgItmHier");

    @Nonnull
    @Override
    public Class<ReportingItemHierText> getType()
    {
        return ReportingItemHierText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItemHier</b>
     * </p>
     *
     * @param consolidationReportingItemHier
     *            Reporting Item Hierarchy
     */
    public void setConsolidationReportingItemHier( @Nullable final String consolidationReportingItemHier )
    {
        rememberChangedField("ConsolidationReportingItemHier", this.consolidationReportingItemHier);
        this.consolidationReportingItemHier = consolidationReportingItemHier;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @param hierarchyNodeText
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNodeText( @Nullable final String hierarchyNodeText )
    {
        rememberChangedField("HierarchyNodeText", this.hierarchyNodeText);
        this.hierarchyNodeText = hierarchyNodeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ReportingItemHierText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("ConsolidationReportingItemHier", getConsolidationReportingItemHier());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("ConsolidationReportingItemHier", getConsolidationReportingItemHier());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNodeText", getHierarchyNodeText());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationReportingItemHier") ) {
                final Object value = values.remove("ConsolidationReportingItemHier");
                if( (value == null) || (!value.equals(getConsolidationReportingItemHier())) ) {
                    setConsolidationReportingItemHier(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeText") ) {
                final Object value = values.remove("HierarchyNodeText");
                if( (value == null) || (!value.equals(getHierarchyNodeText())) ) {
                    setHierarchyNodeText(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnRptgItmHier") ) {
                final Object value = (values).remove("to_CnsldtnRptgItmHier");
                if( value instanceof Map ) {
                    if( toCnsldtnRptgItmHier == null ) {
                        toCnsldtnRptgItmHier = new ReportingItemHier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnRptgItmHier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ReportingItemHierTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReportingItemHierTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReportingItemHierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReportingItemHierTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnRptgItmHier != null ) {
            (values).put("to_CnsldtnRptgItmHier", toCnsldtnRptgItmHier);
        }
        return values;
    }

    /**
     * Fetches the <b>ReportingItemHier</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnRptgItmHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ReportingItemHier</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ReportingItemHier fetchCnsldtnRptgItmHier()
    {
        return fetchFieldAsSingle("to_CnsldtnRptgItmHier", ReportingItemHier.class);
    }

    /**
     * Retrieval of associated <b>ReportingItemHier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItmHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItmHier</b> of a queried <b>ReportingItemHierText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReportingItemHier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ReportingItemHier getCnsldtnRptgItmHierOrFetch()
    {
        if( toCnsldtnRptgItmHier == null ) {
            toCnsldtnRptgItmHier = fetchCnsldtnRptgItmHier();
        }
        return toCnsldtnRptgItmHier;
    }

    /**
     * Retrieval of associated <b>ReportingItemHier</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItmHier</b>.
     * <p>
     * If the navigation property for an entity <b>ReportingItemHierText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnRptgItmHier</b> is already loaded, the result
     *         will contain the <b>ReportingItemHier</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ReportingItemHier> getCnsldtnRptgItmHierIfPresent()
    {
        return Option.of(toCnsldtnRptgItmHier);
    }

    /**
     * Overwrites the associated <b>ReportingItemHier</b> entity for the loaded navigation property
     * <b>to_CnsldtnRptgItmHier</b>.
     *
     * @param value
     *            New <b>ReportingItemHier</b> entity.
     */
    public void setCnsldtnRptgItmHier( final ReportingItemHier value )
    {
        toCnsldtnRptgItmHier = value;
    }

    /**
     * Helper class to allow for fluent creation of ReportingItemHierText instances.
     *
     */
    public final static class ReportingItemHierTextBuilder
    {

        private ReportingItemHier toCnsldtnRptgItmHier;

        private ReportingItemHierText.ReportingItemHierTextBuilder toCnsldtnRptgItmHier( final ReportingItemHier value )
        {
            toCnsldtnRptgItmHier = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnRptgItmHier</b> for <b>ReportingItemHierText</b> to single
         * <b>ReportingItemHier</b>.
         *
         * @param value
         *            The ReportingItemHier to build this ReportingItemHierText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReportingItemHierText.ReportingItemHierTextBuilder cnsldtnRptgItmHier( final ReportingItemHier value )
        {
            return toCnsldtnRptgItmHier(value);
        }

    }

}
