/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ReportingItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ReportingItemTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ReportingItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Reporting Item - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ReportingItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ReportingItemText extends VdmEntity<ReportingItemText>
{

    /**
     * Selector for all available fields of ReportingItemText.
     *
     */
    public final static ReportingItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts
     */
    @Key
    @SerializedName( "ConsolidationChartOfAccounts" )
    @JsonProperty( "ConsolidationChartOfAccounts" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts" )
    private String consolidationChartOfAccounts;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts</b> field to query operations.
     *
     */
    public final static ReportingItemTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS =
        new ReportingItemTextField<String>("ConsolidationChartOfAccounts");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @return Consolidation Chart of Accounts Description
     */
    @SerializedName( "ConsolidationChartOfAccounts_Text" )
    @JsonProperty( "ConsolidationChartOfAccounts_Text" )
    @Nullable
    @ODataField( odataName = "ConsolidationChartOfAccounts_Text" )
    private String consolidationChartOfAccounts_Text;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationChartOfAccounts_Text</b> field to query
     * operations.
     *
     */
    public final static ReportingItemTextField<String> CONSOLIDATION_CHART_OF_ACCOUNTS_TEXT =
        new ReportingItemTextField<String>("ConsolidationChartOfAccounts_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem</b>
     * </p>
     *
     * @return Reporting Item
     */
    @Key
    @SerializedName( "ConsolidationReportingItem" )
    @JsonProperty( "ConsolidationReportingItem" )
    @Nullable
    @ODataField( odataName = "ConsolidationReportingItem" )
    private String consolidationReportingItem;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationReportingItem</b> field to query operations.
     *
     */
    public final static ReportingItemTextField<String> CONSOLIDATION_REPORTING_ITEM =
        new ReportingItemTextField<String>("ConsolidationReportingItem");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ReportingItemTextField<String> LANGUAGE = new ReportingItemTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItemText</b>
     * </p>
     *
     * @return Reporting Item Description
     */
    @SerializedName( "ConsolidationReportingItemText" )
    @JsonProperty( "ConsolidationReportingItemText" )
    @Nullable
    @ODataField( odataName = "ConsolidationReportingItemText" )
    private String consolidationReportingItemText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationReportingItemText</b> field to query operations.
     *
     */
    public final static ReportingItemTextField<String> CONSOLIDATION_REPORTING_ITEM_TEXT =
        new ReportingItemTextField<String>("ConsolidationReportingItemText");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationRptgItemMdmText</b>
     * </p>
     *
     * @return Reporting Item Medium Description
     */
    @SerializedName( "ConsolidationRptgItemMdmText" )
    @JsonProperty( "ConsolidationRptgItemMdmText" )
    @Nullable
    @ODataField( odataName = "ConsolidationRptgItemMdmText" )
    private String consolidationRptgItemMdmText;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationRptgItemMdmText</b> field to query operations.
     *
     */
    public final static ReportingItemTextField<String> CONSOLIDATION_RPTG_ITEM_MDM_TEXT =
        new ReportingItemTextField<String>("ConsolidationRptgItemMdmText");
    /**
     * Navigation property <b>to_CnsldtnRptgItm</b> for <b>ReportingItemText</b> to single <b>ReportingItem</b>.
     *
     */
    @SerializedName( "to_CnsldtnRptgItm" )
    @JsonProperty( "to_CnsldtnRptgItm" )
    @ODataField( odataName = "to_CnsldtnRptgItm" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ReportingItem toCnsldtnRptgItm;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnRptgItm</b> navigation property to query operations.
     *
     */
    public final static ReportingItemTextOneToOneLink<ReportingItem> TO_CNSLDTN_RPTG_ITM =
        new ReportingItemTextOneToOneLink<ReportingItem>("to_CnsldtnRptgItm");

    @Nonnull
    @Override
    public Class<ReportingItemText> getType()
    {
        return ReportingItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts</b>
     * </p>
     *
     * @param consolidationChartOfAccounts
     *            Consolidation Chart of Accounts
     */
    public void setConsolidationChartOfAccounts( @Nullable final String consolidationChartOfAccounts )
    {
        rememberChangedField("ConsolidationChartOfAccounts", this.consolidationChartOfAccounts);
        this.consolidationChartOfAccounts = consolidationChartOfAccounts;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationChartOfAccounts_Text</b>
     * </p>
     *
     * @param consolidationChartOfAccounts_Text
     *            Consolidation Chart of Accounts Description
     */
    public void setConsolidationChartOfAccounts_Text( @Nullable final String consolidationChartOfAccounts_Text )
    {
        rememberChangedField("ConsolidationChartOfAccounts_Text", this.consolidationChartOfAccounts_Text);
        this.consolidationChartOfAccounts_Text = consolidationChartOfAccounts_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItem</b>
     * </p>
     *
     * @param consolidationReportingItem
     *            Reporting Item
     */
    public void setConsolidationReportingItem( @Nullable final String consolidationReportingItem )
    {
        rememberChangedField("ConsolidationReportingItem", this.consolidationReportingItem);
        this.consolidationReportingItem = consolidationReportingItem;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationReportingItemText</b>
     * </p>
     *
     * @param consolidationReportingItemText
     *            Reporting Item Description
     */
    public void setConsolidationReportingItemText( @Nullable final String consolidationReportingItemText )
    {
        rememberChangedField("ConsolidationReportingItemText", this.consolidationReportingItemText);
        this.consolidationReportingItemText = consolidationReportingItemText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationRptgItemMdmText</b>
     * </p>
     *
     * @param consolidationRptgItemMdmText
     *            Reporting Item Medium Description
     */
    public void setConsolidationRptgItemMdmText( @Nullable final String consolidationRptgItemMdmText )
    {
        rememberChangedField("ConsolidationRptgItemMdmText", this.consolidationRptgItemMdmText);
        this.consolidationRptgItemMdmText = consolidationRptgItemMdmText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ReportingItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        result.put("ConsolidationReportingItem", getConsolidationReportingItem());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationChartOfAccounts", getConsolidationChartOfAccounts());
        values.put("ConsolidationChartOfAccounts_Text", getConsolidationChartOfAccounts_Text());
        values.put("ConsolidationReportingItem", getConsolidationReportingItem());
        values.put("Language", getLanguage());
        values.put("ConsolidationReportingItemText", getConsolidationReportingItemText());
        values.put("ConsolidationRptgItemMdmText", getConsolidationRptgItemMdmText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationChartOfAccounts") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts())) ) {
                    setConsolidationChartOfAccounts(((String) value));
                }
            }
            if( values.containsKey("ConsolidationChartOfAccounts_Text") ) {
                final Object value = values.remove("ConsolidationChartOfAccounts_Text");
                if( (value == null) || (!value.equals(getConsolidationChartOfAccounts_Text())) ) {
                    setConsolidationChartOfAccounts_Text(((String) value));
                }
            }
            if( values.containsKey("ConsolidationReportingItem") ) {
                final Object value = values.remove("ConsolidationReportingItem");
                if( (value == null) || (!value.equals(getConsolidationReportingItem())) ) {
                    setConsolidationReportingItem(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationReportingItemText") ) {
                final Object value = values.remove("ConsolidationReportingItemText");
                if( (value == null) || (!value.equals(getConsolidationReportingItemText())) ) {
                    setConsolidationReportingItemText(((String) value));
                }
            }
            if( values.containsKey("ConsolidationRptgItemMdmText") ) {
                final Object value = values.remove("ConsolidationRptgItemMdmText");
                if( (value == null) || (!value.equals(getConsolidationRptgItemMdmText())) ) {
                    setConsolidationRptgItemMdmText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnRptgItm") ) {
                final Object value = (values).remove("to_CnsldtnRptgItm");
                if( value instanceof Map ) {
                    if( toCnsldtnRptgItm == null ) {
                        toCnsldtnRptgItm = new ReportingItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnRptgItm.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ReportingItemTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ReportingItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ReportingItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ReportingItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnRptgItm != null ) {
            (values).put("to_CnsldtnRptgItm", toCnsldtnRptgItm);
        }
        return values;
    }

    /**
     * Fetches the <b>ReportingItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnRptgItm</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ReportingItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ReportingItem fetchCnsldtnRptgItm()
    {
        return fetchFieldAsSingle("to_CnsldtnRptgItm", ReportingItem.class);
    }

    /**
     * Retrieval of associated <b>ReportingItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItm</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnRptgItm</b> of a queried <b>ReportingItemText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ReportingItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ReportingItem getCnsldtnRptgItmOrFetch()
    {
        if( toCnsldtnRptgItm == null ) {
            toCnsldtnRptgItm = fetchCnsldtnRptgItm();
        }
        return toCnsldtnRptgItm;
    }

    /**
     * Retrieval of associated <b>ReportingItem</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnRptgItm</b>.
     * <p>
     * If the navigation property for an entity <b>ReportingItemText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnRptgItm</b> is already loaded, the result will
     *         contain the <b>ReportingItem</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ReportingItem> getCnsldtnRptgItmIfPresent()
    {
        return Option.of(toCnsldtnRptgItm);
    }

    /**
     * Overwrites the associated <b>ReportingItem</b> entity for the loaded navigation property
     * <b>to_CnsldtnRptgItm</b>.
     *
     * @param value
     *            New <b>ReportingItem</b> entity.
     */
    public void setCnsldtnRptgItm( final ReportingItem value )
    {
        toCnsldtnRptgItm = value;
    }

    /**
     * Helper class to allow for fluent creation of ReportingItemText instances.
     *
     */
    public final static class ReportingItemTextBuilder
    {

        private ReportingItem toCnsldtnRptgItm;

        private ReportingItemText.ReportingItemTextBuilder toCnsldtnRptgItm( final ReportingItem value )
        {
            toCnsldtnRptgItm = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnRptgItm</b> for <b>ReportingItemText</b> to single <b>ReportingItem</b>.
         *
         * @param value
         *            The ReportingItem to build this ReportingItemText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ReportingItemText.ReportingItemTextBuilder cnsldtnRptgItm( final ReportingItem value )
        {
            return toCnsldtnRptgItm(value);
        }

    }

}
