/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SalesDistrictSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SalesDistrict SalesDistrict}
 * entity using key fields. This fluent helper allows methods which modify the underlying query to be called before
 * executing the query itself.
 *
 */
public class SalesDistrictByKeyFluentHelper
    extends
    FluentHelperByKey<SalesDistrictByKeyFluentHelper, SalesDistrict, SalesDistrictSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SalesDistrict
     * SalesDistrict} entity with the provided key field values. To perform execution, call the {@link #executeRequest
     * executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SalesDistrict}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SalesDistrict}
     * @param salesDistrict
     *            Sales District
     *            <p>
     *            Constraints: Not nullable, Maximum length: 6
     *            </p>
     */
    public SalesDistrictByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String salesDistrict )
    {
        super(servicePath, entityCollection);
        this.key.put("SalesDistrict", salesDistrict);
    }

    @Override
    @Nonnull
    protected Class<SalesDistrict> getEntityClass()
    {
        return SalesDistrict.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
