/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SalesOrganizationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SalesOrganizationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SalesOrganizationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Sales Organization
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesOrganizationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrganization extends VdmEntity<SalesOrganization>
{

    /**
     * Selector for all available fields of SalesOrganization.
     *
     */
    public final static SalesOrganizationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Consolidation Sales Organization
     */
    @Key
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static SalesOrganizationField<String> SALES_ORGANIZATION =
        new SalesOrganizationField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization_Text</b>
     * </p>
     *
     * @return Sales Organization Description
     */
    @SerializedName( "SalesOrganization_Text" )
    @JsonProperty( "SalesOrganization_Text" )
    @Nullable
    @ODataField( odataName = "SalesOrganization_Text" )
    private String salesOrganization_Text;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization_Text</b> field to query operations.
     *
     */
    public final static SalesOrganizationField<String> SALES_ORGANIZATION_TEXT =
        new SalesOrganizationField<String>("SalesOrganization_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static SalesOrganizationField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new SalesOrganizationField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnSalesOrgHier</b> for <b>SalesOrganization</b> to multiple
     * <b>SalesOrganizationHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnSalesOrgHier" )
    @JsonProperty( "to_CnsldtnSalesOrgHier" )
    @ODataField( odataName = "to_CnsldtnSalesOrgHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrganizationHier> toCnsldtnSalesOrgHier;
    /**
     * Navigation property <b>to_CnsldtnSalesOrgT</b> for <b>SalesOrganization</b> to multiple
     * <b>SalesOrganizationText</b>.
     *
     */
    @SerializedName( "to_CnsldtnSalesOrgT" )
    @JsonProperty( "to_CnsldtnSalesOrgT" )
    @ODataField( odataName = "to_CnsldtnSalesOrgT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrganizationText> toCnsldtnSalesOrgT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSalesOrgHier</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrganizationLink<SalesOrganizationHier> TO_CNSLDTN_SALES_ORG_HIER =
        new SalesOrganizationLink<SalesOrganizationHier>("to_CnsldtnSalesOrgHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSalesOrgT</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrganizationLink<SalesOrganizationText> TO_CNSLDTN_SALES_ORG_T =
        new SalesOrganizationLink<SalesOrganizationText>("to_CnsldtnSalesOrgT");

    @Nonnull
    @Override
    public Class<SalesOrganization> getType()
    {
        return SalesOrganization.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Consolidation Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization_Text</b>
     * </p>
     *
     * @param salesOrganization_Text
     *            Sales Organization Description
     */
    public void setSalesOrganization_Text( @Nullable final String salesOrganization_Text )
    {
        rememberChangedField("SalesOrganization_Text", this.salesOrganization_Text);
        this.salesOrganization_Text = salesOrganization_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SalesOrganization";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SalesOrganization", getSalesOrganization());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SalesOrganization", getSalesOrganization());
        values.put("SalesOrganization_Text", getSalesOrganization_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization_Text") ) {
                final Object value = values.remove("SalesOrganization_Text");
                if( (value == null) || (!value.equals(getSalesOrganization_Text())) ) {
                    setSalesOrganization_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSalesOrgHier") ) {
                final Object value = (values).remove("to_CnsldtnSalesOrgHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSalesOrgHier == null ) {
                        toCnsldtnSalesOrgHier = Lists.newArrayList();
                    } else {
                        toCnsldtnSalesOrgHier = Lists.newArrayList(toCnsldtnSalesOrgHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrganizationHier entity;
                        if( toCnsldtnSalesOrgHier.size() > i ) {
                            entity = toCnsldtnSalesOrgHier.get(i);
                        } else {
                            entity = new SalesOrganizationHier();
                            toCnsldtnSalesOrgHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnSalesOrgT") ) {
                final Object value = (values).remove("to_CnsldtnSalesOrgT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSalesOrgT == null ) {
                        toCnsldtnSalesOrgT = Lists.newArrayList();
                    } else {
                        toCnsldtnSalesOrgT = Lists.newArrayList(toCnsldtnSalesOrgT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrganizationText entity;
                        if( toCnsldtnSalesOrgT.size() > i ) {
                            entity = toCnsldtnSalesOrgT.get(i);
                        } else {
                            entity = new SalesOrganizationText();
                            toCnsldtnSalesOrgT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrganizationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrganizationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrganizationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrganizationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSalesOrgHier != null ) {
            (values).put("to_CnsldtnSalesOrgHier", toCnsldtnSalesOrgHier);
        }
        if( toCnsldtnSalesOrgT != null ) {
            (values).put("to_CnsldtnSalesOrgT", toCnsldtnSalesOrgT);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrganizationHier</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnSalesOrgHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrganizationHier</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrganizationHier> fetchCnsldtnSalesOrgHier()
    {
        return fetchFieldAsList("to_CnsldtnSalesOrgHier", SalesOrganizationHier.class);
    }

    /**
     * Retrieval of associated <b>SalesOrganizationHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgHier</b> of a queried <b>SalesOrganization</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrganizationHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrganizationHier> getCnsldtnSalesOrgHierOrFetch()
    {
        if( toCnsldtnSalesOrgHier == null ) {
            toCnsldtnSalesOrgHier = fetchCnsldtnSalesOrgHier();
        }
        return toCnsldtnSalesOrgHier;
    }

    /**
     * Retrieval of associated <b>SalesOrganizationHier</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgHier</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrganization</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSalesOrgHier</b> is already loaded, the result
     *         will contain the <b>SalesOrganizationHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrganizationHier>> getCnsldtnSalesOrgHierIfPresent()
    {
        return Option.of(toCnsldtnSalesOrgHier);
    }

    /**
     * Overwrites the list of associated <b>SalesOrganizationHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnSalesOrgHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgHier</b> of a queried <b>SalesOrganization</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrganizationHier</b> entities.
     */
    public void setCnsldtnSalesOrgHier( @Nonnull final List<SalesOrganizationHier> value )
    {
        if( toCnsldtnSalesOrgHier == null ) {
            toCnsldtnSalesOrgHier = Lists.newArrayList();
        }
        toCnsldtnSalesOrgHier.clear();
        toCnsldtnSalesOrgHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrganizationHier</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgHier</b> of a queried <b>SalesOrganization</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrganizationHier</b> entities.
     */
    public void addCnsldtnSalesOrgHier( SalesOrganizationHier... entity )
    {
        if( toCnsldtnSalesOrgHier == null ) {
            toCnsldtnSalesOrgHier = Lists.newArrayList();
        }
        toCnsldtnSalesOrgHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SalesOrganizationText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnSalesOrgT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrganizationText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrganizationText> fetchCnsldtnSalesOrgT()
    {
        return fetchFieldAsList("to_CnsldtnSalesOrgT", SalesOrganizationText.class);
    }

    /**
     * Retrieval of associated <b>SalesOrganizationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgT</b> of a queried <b>SalesOrganization</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrganizationText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrganizationText> getCnsldtnSalesOrgTOrFetch()
    {
        if( toCnsldtnSalesOrgT == null ) {
            toCnsldtnSalesOrgT = fetchCnsldtnSalesOrgT();
        }
        return toCnsldtnSalesOrgT;
    }

    /**
     * Retrieval of associated <b>SalesOrganizationText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgT</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrganization</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSalesOrgT</b> is already loaded, the result will
     *         contain the <b>SalesOrganizationText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrganizationText>> getCnsldtnSalesOrgTIfPresent()
    {
        return Option.of(toCnsldtnSalesOrgT);
    }

    /**
     * Overwrites the list of associated <b>SalesOrganizationText</b> entities for the loaded navigation property
     * <b>to_CnsldtnSalesOrgT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgT</b> of a queried <b>SalesOrganization</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrganizationText</b> entities.
     */
    public void setCnsldtnSalesOrgT( @Nonnull final List<SalesOrganizationText> value )
    {
        if( toCnsldtnSalesOrgT == null ) {
            toCnsldtnSalesOrgT = Lists.newArrayList();
        }
        toCnsldtnSalesOrgT.clear();
        toCnsldtnSalesOrgT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrganizationText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgT</b> of a queried <b>SalesOrganization</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrganizationText</b> entities.
     */
    public void addCnsldtnSalesOrgT( SalesOrganizationText... entity )
    {
        if( toCnsldtnSalesOrgT == null ) {
            toCnsldtnSalesOrgT = Lists.newArrayList();
        }
        toCnsldtnSalesOrgT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesOrganization instances.
     *
     */
    public final static class SalesOrganizationBuilder
    {

        private List<SalesOrganizationHier> toCnsldtnSalesOrgHier = Lists.newArrayList();
        private List<SalesOrganizationText> toCnsldtnSalesOrgT = Lists.newArrayList();

        private SalesOrganization.SalesOrganizationBuilder toCnsldtnSalesOrgHier(
            final List<SalesOrganizationHier> value )
        {
            toCnsldtnSalesOrgHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSalesOrgHier</b> for <b>SalesOrganization</b> to multiple
         * <b>SalesOrganizationHier</b>.
         *
         * @param value
         *            The SalesOrganizationHiers to build this SalesOrganization with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrganization.SalesOrganizationBuilder cnsldtnSalesOrgHier( SalesOrganizationHier... value )
        {
            return toCnsldtnSalesOrgHier(Lists.newArrayList(value));
        }

        private SalesOrganization.SalesOrganizationBuilder toCnsldtnSalesOrgT( final List<SalesOrganizationText> value )
        {
            toCnsldtnSalesOrgT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSalesOrgT</b> for <b>SalesOrganization</b> to multiple
         * <b>SalesOrganizationText</b>.
         *
         * @param value
         *            The SalesOrganizationTexts to build this SalesOrganization with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrganization.SalesOrganizationBuilder cnsldtnSalesOrgT( SalesOrganizationText... value )
        {
            return toCnsldtnSalesOrgT(Lists.newArrayList(value));
        }

    }

}
