/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SalesOrganizationHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SalesOrganizationHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SalesOrganizationHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SalesOrganizationHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Sales Organization Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesOrganizationHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrganizationHier extends VdmEntity<SalesOrganizationHier>
{

    /**
     * Selector for all available fields of SalesOrganizationHier.
     *
     */
    public final static SalesOrganizationHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @return Consolidation Hierarchy ID
     */
    @Key
    @SerializedName( "AdditionalMasterDataHierarchy" )
    @JsonProperty( "AdditionalMasterDataHierarchy" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataHierarchy" )
    private String additionalMasterDataHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataHierarchy</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> ADDITIONAL_MASTER_DATA_HIERARCHY =
        new SalesOrganizationHierField<String>("AdditionalMasterDataHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> HIERARCHY_NODE =
        new SalesOrganizationHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> HIERARCHY_NODE_TEXT =
        new SalesOrganizationHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<LocalDateTime> VALIDITY_END_DATE =
        new SalesOrganizationHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> PARENT_NODE =
        new SalesOrganizationHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<LocalDateTime> VALIDITY_START_DATE =
        new SalesOrganizationHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Sales Organization
     */
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> SALES_ORGANIZATION =
        new SalesOrganizationHierField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization_Text</b>
     * </p>
     *
     * @return Sales Organization Description
     */
    @SerializedName( "SalesOrganization_Text" )
    @JsonProperty( "SalesOrganization_Text" )
    @Nullable
    @ODataField( odataName = "SalesOrganization_Text" )
    private String salesOrganization_Text;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization_Text</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> SALES_ORGANIZATION_TEXT =
        new SalesOrganizationHierField<String>("SalesOrganization_Text");
    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return The sequenceNumber contained in this entity.
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> SEQUENCE_NUMBER =
        new SalesOrganizationHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> HIERARCHY_NODE_SEQUENCE =
        new SalesOrganizationHierField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> HIERARCHY_NODE_LEVEL =
        new SalesOrganizationHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static SalesOrganizationHierField<String> NODE_TYPE =
        new SalesOrganizationHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnSalesOrg</b> for <b>SalesOrganizationHier</b> to single
     * <b>SalesOrganization</b>.
     *
     */
    @SerializedName( "to_CnsldtnSalesOrg" )
    @JsonProperty( "to_CnsldtnSalesOrg" )
    @ODataField( odataName = "to_CnsldtnSalesOrg" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrganization toCnsldtnSalesOrg;
    /**
     * Navigation property <b>to_CnsldtnSalesOrgHierT</b> for <b>SalesOrganizationHier</b> to multiple
     * <b>SalesOrganizationHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnSalesOrgHierT" )
    @JsonProperty( "to_CnsldtnSalesOrgHierT" )
    @ODataField( odataName = "to_CnsldtnSalesOrgHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SalesOrganizationHierText> toCnsldtnSalesOrgHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSalesOrg</b> navigation property to query operations.
     *
     */
    public final static SalesOrganizationHierOneToOneLink<SalesOrganization> TO_CNSLDTN_SALES_ORG =
        new SalesOrganizationHierOneToOneLink<SalesOrganization>("to_CnsldtnSalesOrg");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSalesOrgHierT</b> navigation property to query
     * operations.
     *
     */
    public final static SalesOrganizationHierLink<SalesOrganizationHierText> TO_CNSLDTN_SALES_ORG_HIER_T =
        new SalesOrganizationHierLink<SalesOrganizationHierText>("to_CnsldtnSalesOrgHierT");

    @Nonnull
    @Override
    public Class<SalesOrganizationHier> getType()
    {
        return SalesOrganizationHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataHierarchy</b>
     * </p>
     *
     * @param additionalMasterDataHierarchy
     *            Consolidation Hierarchy ID
     */
    public void setAdditionalMasterDataHierarchy( @Nullable final String additionalMasterDataHierarchy )
    {
        rememberChangedField("AdditionalMasterDataHierarchy", this.additionalMasterDataHierarchy);
        this.additionalMasterDataHierarchy = additionalMasterDataHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization_Text</b>
     * </p>
     *
     * @param salesOrganization_Text
     *            Sales Organization Description
     */
    public void setSalesOrganization_Text( @Nullable final String salesOrganization_Text )
    {
        rememberChangedField("SalesOrganization_Text", this.salesOrganization_Text);
        this.salesOrganization_Text = salesOrganization_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            The sequenceNumber to set.
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SalesOrganizationHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("AdditionalMasterDataHierarchy", getAdditionalMasterDataHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("SalesOrganization_Text", getSalesOrganization_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("AdditionalMasterDataHierarchy") ) {
                final Object value = values.remove("AdditionalMasterDataHierarchy");
                if( (value == null) || (!value.equals(getAdditionalMasterDataHierarchy())) ) {
                    setAdditionalMasterDataHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization_Text") ) {
                final Object value = values.remove("SalesOrganization_Text");
                if( (value == null) || (!value.equals(getSalesOrganization_Text())) ) {
                    setSalesOrganization_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSalesOrg") ) {
                final Object value = (values).remove("to_CnsldtnSalesOrg");
                if( value instanceof Map ) {
                    if( toCnsldtnSalesOrg == null ) {
                        toCnsldtnSalesOrg = new SalesOrganization();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSalesOrg.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnSalesOrgHierT") ) {
                final Object value = (values).remove("to_CnsldtnSalesOrgHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSalesOrgHierT == null ) {
                        toCnsldtnSalesOrgHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnSalesOrgHierT = Lists.newArrayList(toCnsldtnSalesOrgHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SalesOrganizationHierText entity;
                        if( toCnsldtnSalesOrgHierT.size() > i ) {
                            entity = toCnsldtnSalesOrgHierT.get(i);
                        } else {
                            entity = new SalesOrganizationHierText();
                            toCnsldtnSalesOrgHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrganizationHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrganizationHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrganizationHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrganizationHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSalesOrg != null ) {
            (values).put("to_CnsldtnSalesOrg", toCnsldtnSalesOrg);
        }
        if( toCnsldtnSalesOrgHierT != null ) {
            (values).put("to_CnsldtnSalesOrgHierT", toCnsldtnSalesOrgHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrganization</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnSalesOrg</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrganization</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrganization fetchCnsldtnSalesOrg()
    {
        return fetchFieldAsSingle("to_CnsldtnSalesOrg", SalesOrganization.class);
    }

    /**
     * Retrieval of associated <b>SalesOrganization</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnSalesOrg</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrg</b> of a queried <b>SalesOrganizationHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrganization</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrganization getCnsldtnSalesOrgOrFetch()
    {
        if( toCnsldtnSalesOrg == null ) {
            toCnsldtnSalesOrg = fetchCnsldtnSalesOrg();
        }
        return toCnsldtnSalesOrg;
    }

    /**
     * Retrieval of associated <b>SalesOrganization</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnSalesOrg</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrganizationHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSalesOrg</b> is already loaded, the result will
     *         contain the <b>SalesOrganization</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrganization> getCnsldtnSalesOrgIfPresent()
    {
        return Option.of(toCnsldtnSalesOrg);
    }

    /**
     * Overwrites the associated <b>SalesOrganization</b> entity for the loaded navigation property
     * <b>to_CnsldtnSalesOrg</b>.
     *
     * @param value
     *            New <b>SalesOrganization</b> entity.
     */
    public void setCnsldtnSalesOrg( final SalesOrganization value )
    {
        toCnsldtnSalesOrg = value;
    }

    /**
     * Fetches the <b>SalesOrganizationHierText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnSalesOrgHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SalesOrganizationHierText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrganizationHierText> fetchCnsldtnSalesOrgHierT()
    {
        return fetchFieldAsList("to_CnsldtnSalesOrgHierT", SalesOrganizationHierText.class);
    }

    /**
     * Retrieval of associated <b>SalesOrganizationHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgHierT</b> of a queried <b>SalesOrganizationHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrganizationHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SalesOrganizationHierText> getCnsldtnSalesOrgHierTOrFetch()
    {
        if( toCnsldtnSalesOrgHierT == null ) {
            toCnsldtnSalesOrgHierT = fetchCnsldtnSalesOrgHierT();
        }
        return toCnsldtnSalesOrgHierT;
    }

    /**
     * Retrieval of associated <b>SalesOrganizationHierText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgHierT</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrganizationHier</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSalesOrgHierT</b> is already loaded, the result
     *         will contain the <b>SalesOrganizationHierText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SalesOrganizationHierText>> getCnsldtnSalesOrgHierTIfPresent()
    {
        return Option.of(toCnsldtnSalesOrgHierT);
    }

    /**
     * Overwrites the list of associated <b>SalesOrganizationHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnSalesOrgHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgHierT</b> of a queried <b>SalesOrganizationHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SalesOrganizationHierText</b> entities.
     */
    public void setCnsldtnSalesOrgHierT( @Nonnull final List<SalesOrganizationHierText> value )
    {
        if( toCnsldtnSalesOrgHierT == null ) {
            toCnsldtnSalesOrgHierT = Lists.newArrayList();
        }
        toCnsldtnSalesOrgHierT.clear();
        toCnsldtnSalesOrgHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SalesOrganizationHierText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnSalesOrgHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrgHierT</b> of a queried <b>SalesOrganizationHier</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SalesOrganizationHierText</b> entities.
     */
    public void addCnsldtnSalesOrgHierT( SalesOrganizationHierText... entity )
    {
        if( toCnsldtnSalesOrgHierT == null ) {
            toCnsldtnSalesOrgHierT = Lists.newArrayList();
        }
        toCnsldtnSalesOrgHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SalesOrganizationHier instances.
     *
     */
    public final static class SalesOrganizationHierBuilder
    {

        private SalesOrganization toCnsldtnSalesOrg;
        private List<SalesOrganizationHierText> toCnsldtnSalesOrgHierT = Lists.newArrayList();

        private SalesOrganizationHier.SalesOrganizationHierBuilder toCnsldtnSalesOrg( final SalesOrganization value )
        {
            toCnsldtnSalesOrg = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSalesOrg</b> for <b>SalesOrganizationHier</b> to single
         * <b>SalesOrganization</b>.
         *
         * @param value
         *            The SalesOrganization to build this SalesOrganizationHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrganizationHier.SalesOrganizationHierBuilder cnsldtnSalesOrg( final SalesOrganization value )
        {
            return toCnsldtnSalesOrg(value);
        }

        private SalesOrganizationHier.SalesOrganizationHierBuilder toCnsldtnSalesOrgHierT(
            final List<SalesOrganizationHierText> value )
        {
            toCnsldtnSalesOrgHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSalesOrgHierT</b> for <b>SalesOrganizationHier</b> to multiple
         * <b>SalesOrganizationHierText</b>.
         *
         * @param value
         *            The SalesOrganizationHierTexts to build this SalesOrganizationHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrganizationHier.SalesOrganizationHierBuilder cnsldtnSalesOrgHierT(
            SalesOrganizationHierText... value )
        {
            return toCnsldtnSalesOrgHierT(Lists.newArrayList(value));
        }

    }

}
