/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SalesOrganizationTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SalesOrganizationTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SalesOrganizationTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Sales Organization - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SalesOrganizationTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SalesOrganizationText extends VdmEntity<SalesOrganizationText>
{

    /**
     * Selector for all available fields of SalesOrganizationText.
     *
     */
    public final static SalesOrganizationTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SalesOrganizationTextField<String> LANGUAGE =
        new SalesOrganizationTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @return Consolidation Sales Organization
     */
    @Key
    @SerializedName( "SalesOrganization" )
    @JsonProperty( "SalesOrganization" )
    @Nullable
    @ODataField( odataName = "SalesOrganization" )
    private String salesOrganization;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganization</b> field to query operations.
     *
     */
    public final static SalesOrganizationTextField<String> SALES_ORGANIZATION =
        new SalesOrganizationTextField<String>("SalesOrganization");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationText</b>
     * </p>
     *
     * @return Sales Organization Description
     */
    @SerializedName( "SalesOrganizationText" )
    @JsonProperty( "SalesOrganizationText" )
    @Nullable
    @ODataField( odataName = "SalesOrganizationText" )
    private String salesOrganizationText;
    /**
     * Use with available fluent helpers to apply the <b>SalesOrganizationText</b> field to query operations.
     *
     */
    public final static SalesOrganizationTextField<String> SALES_ORGANIZATION_TEXT =
        new SalesOrganizationTextField<String>("SalesOrganizationText");
    /**
     * Navigation property <b>to_CnsldtnSalesOrg</b> for <b>SalesOrganizationText</b> to single
     * <b>SalesOrganization</b>.
     *
     */
    @SerializedName( "to_CnsldtnSalesOrg" )
    @JsonProperty( "to_CnsldtnSalesOrg" )
    @ODataField( odataName = "to_CnsldtnSalesOrg" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SalesOrganization toCnsldtnSalesOrg;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSalesOrg</b> navigation property to query operations.
     *
     */
    public final static SalesOrganizationTextOneToOneLink<SalesOrganization> TO_CNSLDTN_SALES_ORG =
        new SalesOrganizationTextOneToOneLink<SalesOrganization>("to_CnsldtnSalesOrg");

    @Nonnull
    @Override
    public Class<SalesOrganizationText> getType()
    {
        return SalesOrganizationText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganization</b>
     * </p>
     *
     * @param salesOrganization
     *            Consolidation Sales Organization
     */
    public void setSalesOrganization( @Nullable final String salesOrganization )
    {
        rememberChangedField("SalesOrganization", this.salesOrganization);
        this.salesOrganization = salesOrganization;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SalesOrganizationText</b>
     * </p>
     *
     * @param salesOrganizationText
     *            Sales Organization Description
     */
    public void setSalesOrganizationText( @Nullable final String salesOrganizationText )
    {
        rememberChangedField("SalesOrganizationText", this.salesOrganizationText);
        this.salesOrganizationText = salesOrganizationText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SalesOrganizationText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("SalesOrganization", getSalesOrganization());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("SalesOrganization", getSalesOrganization());
        values.put("SalesOrganizationText", getSalesOrganizationText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SalesOrganization") ) {
                final Object value = values.remove("SalesOrganization");
                if( (value == null) || (!value.equals(getSalesOrganization())) ) {
                    setSalesOrganization(((String) value));
                }
            }
            if( values.containsKey("SalesOrganizationText") ) {
                final Object value = values.remove("SalesOrganizationText");
                if( (value == null) || (!value.equals(getSalesOrganizationText())) ) {
                    setSalesOrganizationText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSalesOrg") ) {
                final Object value = (values).remove("to_CnsldtnSalesOrg");
                if( value instanceof Map ) {
                    if( toCnsldtnSalesOrg == null ) {
                        toCnsldtnSalesOrg = new SalesOrganization();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSalesOrg.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SalesOrganizationTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SalesOrganizationTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SalesOrganizationTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SalesOrganizationTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSalesOrg != null ) {
            (values).put("to_CnsldtnSalesOrg", toCnsldtnSalesOrg);
        }
        return values;
    }

    /**
     * Fetches the <b>SalesOrganization</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnSalesOrg</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SalesOrganization</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrganization fetchCnsldtnSalesOrg()
    {
        return fetchFieldAsSingle("to_CnsldtnSalesOrg", SalesOrganization.class);
    }

    /**
     * Retrieval of associated <b>SalesOrganization</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnSalesOrg</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSalesOrg</b> of a queried <b>SalesOrganizationText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SalesOrganization</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SalesOrganization getCnsldtnSalesOrgOrFetch()
    {
        if( toCnsldtnSalesOrg == null ) {
            toCnsldtnSalesOrg = fetchCnsldtnSalesOrg();
        }
        return toCnsldtnSalesOrg;
    }

    /**
     * Retrieval of associated <b>SalesOrganization</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnSalesOrg</b>.
     * <p>
     * If the navigation property for an entity <b>SalesOrganizationText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSalesOrg</b> is already loaded, the result will
     *         contain the <b>SalesOrganization</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SalesOrganization> getCnsldtnSalesOrgIfPresent()
    {
        return Option.of(toCnsldtnSalesOrg);
    }

    /**
     * Overwrites the associated <b>SalesOrganization</b> entity for the loaded navigation property
     * <b>to_CnsldtnSalesOrg</b>.
     *
     * @param value
     *            New <b>SalesOrganization</b> entity.
     */
    public void setCnsldtnSalesOrg( final SalesOrganization value )
    {
        toCnsldtnSalesOrg = value;
    }

    /**
     * Helper class to allow for fluent creation of SalesOrganizationText instances.
     *
     */
    public final static class SalesOrganizationTextBuilder
    {

        private SalesOrganization toCnsldtnSalesOrg;

        private SalesOrganizationText.SalesOrganizationTextBuilder toCnsldtnSalesOrg( final SalesOrganization value )
        {
            toCnsldtnSalesOrg = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSalesOrg</b> for <b>SalesOrganizationText</b> to single
         * <b>SalesOrganization</b>.
         *
         * @param value
         *            The SalesOrganization to build this SalesOrganizationText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SalesOrganizationText.SalesOrganizationTextBuilder cnsldtnSalesOrg( final SalesOrganization value )
        {
            return toCnsldtnSalesOrg(value);
        }

    }

}
