/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SegmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SegmentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SegmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Segment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SegmentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Segment extends VdmEntity<Segment>
{

    /**
     * Selector for all available fields of Segment.
     *
     */
    public final static SegmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment
     */
    @Key
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static SegmentField<String> SEGMENT = new SegmentField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @return Segment Description
     */
    @SerializedName( "Segment_Text" )
    @JsonProperty( "Segment_Text" )
    @Nullable
    @ODataField( odataName = "Segment_Text" )
    private String segment_Text;
    /**
     * Use with available fluent helpers to apply the <b>Segment_Text</b> field to query operations.
     *
     */
    public final static SegmentField<String> SEGMENT_TEXT = new SegmentField<String>("Segment_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static SegmentField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new SegmentField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnSegmentHier</b> for <b>Segment</b> to multiple <b>SegmentHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnSegmentHier" )
    @JsonProperty( "to_CnsldtnSegmentHier" )
    @ODataField( odataName = "to_CnsldtnSegmentHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SegmentHier> toCnsldtnSegmentHier;
    /**
     * Navigation property <b>to_CnsldtnSegmentT</b> for <b>Segment</b> to multiple <b>SegmentText</b>.
     *
     */
    @SerializedName( "to_CnsldtnSegmentT" )
    @JsonProperty( "to_CnsldtnSegmentT" )
    @ODataField( odataName = "to_CnsldtnSegmentT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SegmentText> toCnsldtnSegmentT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSegmentHier</b> navigation property to query
     * operations.
     *
     */
    public final static SegmentLink<SegmentHier> TO_CNSLDTN_SEGMENT_HIER =
        new SegmentLink<SegmentHier>("to_CnsldtnSegmentHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSegmentT</b> navigation property to query operations.
     *
     */
    public final static SegmentLink<SegmentText> TO_CNSLDTN_SEGMENT_T =
        new SegmentLink<SegmentText>("to_CnsldtnSegmentT");

    @Nonnull
    @Override
    public Class<Segment> getType()
    {
        return Segment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @param segment_Text
     *            Segment Description
     */
    public void setSegment_Text( @Nullable final String segment_Text )
    {
        rememberChangedField("Segment_Text", this.segment_Text);
        this.segment_Text = segment_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Segment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Segment", getSegment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Segment", getSegment());
        values.put("Segment_Text", getSegment_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("Segment_Text") ) {
                final Object value = values.remove("Segment_Text");
                if( (value == null) || (!value.equals(getSegment_Text())) ) {
                    setSegment_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSegmentHier") ) {
                final Object value = (values).remove("to_CnsldtnSegmentHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSegmentHier == null ) {
                        toCnsldtnSegmentHier = Lists.newArrayList();
                    } else {
                        toCnsldtnSegmentHier = Lists.newArrayList(toCnsldtnSegmentHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SegmentHier entity;
                        if( toCnsldtnSegmentHier.size() > i ) {
                            entity = toCnsldtnSegmentHier.get(i);
                        } else {
                            entity = new SegmentHier();
                            toCnsldtnSegmentHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnSegmentT") ) {
                final Object value = (values).remove("to_CnsldtnSegmentT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSegmentT == null ) {
                        toCnsldtnSegmentT = Lists.newArrayList();
                    } else {
                        toCnsldtnSegmentT = Lists.newArrayList(toCnsldtnSegmentT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SegmentText entity;
                        if( toCnsldtnSegmentT.size() > i ) {
                            entity = toCnsldtnSegmentT.get(i);
                        } else {
                            entity = new SegmentText();
                            toCnsldtnSegmentT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SegmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SegmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SegmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SegmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSegmentHier != null ) {
            (values).put("to_CnsldtnSegmentHier", toCnsldtnSegmentHier);
        }
        if( toCnsldtnSegmentT != null ) {
            (values).put("to_CnsldtnSegmentT", toCnsldtnSegmentT);
        }
        return values;
    }

    /**
     * Fetches the <b>SegmentHier</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SegmentHier</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentHier> fetchCnsldtnSegmentHier()
    {
        return fetchFieldAsList("to_CnsldtnSegmentHier", SegmentHier.class);
    }

    /**
     * Retrieval of associated <b>SegmentHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHier</b> of a queried <b>Segment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SegmentHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentHier> getCnsldtnSegmentHierOrFetch()
    {
        if( toCnsldtnSegmentHier == null ) {
            toCnsldtnSegmentHier = fetchCnsldtnSegmentHier();
        }
        return toCnsldtnSegmentHier;
    }

    /**
     * Retrieval of associated <b>SegmentHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentHier</b>.
     * <p>
     * If the navigation property for an entity <b>Segment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSegmentHier</b> is already loaded, the result
     *         will contain the <b>SegmentHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SegmentHier>> getCnsldtnSegmentHierIfPresent()
    {
        return Option.of(toCnsldtnSegmentHier);
    }

    /**
     * Overwrites the list of associated <b>SegmentHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnSegmentHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHier</b> of a queried <b>Segment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SegmentHier</b> entities.
     */
    public void setCnsldtnSegmentHier( @Nonnull final List<SegmentHier> value )
    {
        if( toCnsldtnSegmentHier == null ) {
            toCnsldtnSegmentHier = Lists.newArrayList();
        }
        toCnsldtnSegmentHier.clear();
        toCnsldtnSegmentHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SegmentHier</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHier</b> of a queried <b>Segment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SegmentHier</b> entities.
     */
    public void addCnsldtnSegmentHier( SegmentHier... entity )
    {
        if( toCnsldtnSegmentHier == null ) {
            toCnsldtnSegmentHier = Lists.newArrayList();
        }
        toCnsldtnSegmentHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SegmentText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SegmentText</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentText> fetchCnsldtnSegmentT()
    {
        return fetchFieldAsList("to_CnsldtnSegmentT", SegmentText.class);
    }

    /**
     * Retrieval of associated <b>SegmentText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentT</b> of a queried <b>Segment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SegmentText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentText> getCnsldtnSegmentTOrFetch()
    {
        if( toCnsldtnSegmentT == null ) {
            toCnsldtnSegmentT = fetchCnsldtnSegmentT();
        }
        return toCnsldtnSegmentT;
    }

    /**
     * Retrieval of associated <b>SegmentText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentT</b>.
     * <p>
     * If the navigation property for an entity <b>Segment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSegmentT</b> is already loaded, the result will
     *         contain the <b>SegmentText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SegmentText>> getCnsldtnSegmentTIfPresent()
    {
        return Option.of(toCnsldtnSegmentT);
    }

    /**
     * Overwrites the list of associated <b>SegmentText</b> entities for the loaded navigation property
     * <b>to_CnsldtnSegmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentT</b> of a queried <b>Segment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SegmentText</b> entities.
     */
    public void setCnsldtnSegmentT( @Nonnull final List<SegmentText> value )
    {
        if( toCnsldtnSegmentT == null ) {
            toCnsldtnSegmentT = Lists.newArrayList();
        }
        toCnsldtnSegmentT.clear();
        toCnsldtnSegmentT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SegmentText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentT</b> of a queried <b>Segment</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SegmentText</b> entities.
     */
    public void addCnsldtnSegmentT( SegmentText... entity )
    {
        if( toCnsldtnSegmentT == null ) {
            toCnsldtnSegmentT = Lists.newArrayList();
        }
        toCnsldtnSegmentT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Segment instances.
     *
     */
    public final static class SegmentBuilder
    {

        private List<SegmentHier> toCnsldtnSegmentHier = Lists.newArrayList();
        private List<SegmentText> toCnsldtnSegmentT = Lists.newArrayList();

        private Segment.SegmentBuilder toCnsldtnSegmentHier( final List<SegmentHier> value )
        {
            toCnsldtnSegmentHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSegmentHier</b> for <b>Segment</b> to multiple <b>SegmentHier</b>.
         *
         * @param value
         *            The SegmentHiers to build this Segment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Segment.SegmentBuilder cnsldtnSegmentHier( SegmentHier... value )
        {
            return toCnsldtnSegmentHier(Lists.newArrayList(value));
        }

        private Segment.SegmentBuilder toCnsldtnSegmentT( final List<SegmentText> value )
        {
            toCnsldtnSegmentT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSegmentT</b> for <b>Segment</b> to multiple <b>SegmentText</b>.
         *
         * @param value
         *            The SegmentTexts to build this Segment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Segment.SegmentBuilder cnsldtnSegmentT( SegmentText... value )
        {
            return toCnsldtnSegmentT(Lists.newArrayList(value));
        }

    }

}
