/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SegmentForElimTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SegmentForElimTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SegmentForElimTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Segment for Elimination Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SegmentForElimTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SegmentForElimText extends VdmEntity<SegmentForElimText>
{

    /**
     * Selector for all available fields of SegmentForElimText.
     *
     */
    public final static SegmentForElimTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment for Elimination
     */
    @Key
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static SegmentForElimTextField<String> SEGMENT = new SegmentForElimTextField<String>("Segment");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SegmentForElimTextField<String> LANGUAGE = new SegmentForElimTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SegmentForElimText</b>
     * </p>
     *
     * @return Segment for Elimination Description
     */
    @SerializedName( "SegmentForElimText" )
    @JsonProperty( "SegmentForElimText" )
    @Nullable
    @ODataField( odataName = "SegmentForElimText" )
    private String segmentForElimText;
    /**
     * Use with available fluent helpers to apply the <b>SegmentForElimText</b> field to query operations.
     *
     */
    public final static SegmentForElimTextField<String> SEGMENT_FOR_ELIM_TEXT =
        new SegmentForElimTextField<String>("SegmentForElimText");
    /**
     * Navigation property <b>to_CnsldtnSegmentForElim</b> for <b>SegmentForElimText</b> to single
     * <b>SegmentForElimination</b>.
     *
     */
    @SerializedName( "to_CnsldtnSegmentForElim" )
    @JsonProperty( "to_CnsldtnSegmentForElim" )
    @ODataField( odataName = "to_CnsldtnSegmentForElim" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SegmentForElimination toCnsldtnSegmentForElim;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSegmentForElim</b> navigation property to query
     * operations.
     *
     */
    public final static SegmentForElimTextOneToOneLink<SegmentForElimination> TO_CNSLDTN_SEGMENT_FOR_ELIM =
        new SegmentForElimTextOneToOneLink<SegmentForElimination>("to_CnsldtnSegmentForElim");

    @Nonnull
    @Override
    public Class<SegmentForElimText> getType()
    {
        return SegmentForElimText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment for Elimination
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>SegmentForElimText</b>
     * </p>
     *
     * @param segmentForElimText
     *            Segment for Elimination Description
     */
    public void setSegmentForElimText( @Nullable final String segmentForElimText )
    {
        rememberChangedField("SegmentForElimText", this.segmentForElimText);
        this.segmentForElimText = segmentForElimText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SegmentForElimText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Segment", getSegment());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Segment", getSegment());
        values.put("Language", getLanguage());
        values.put("SegmentForElimText", getSegmentForElimText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SegmentForElimText") ) {
                final Object value = values.remove("SegmentForElimText");
                if( (value == null) || (!value.equals(getSegmentForElimText())) ) {
                    setSegmentForElimText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSegmentForElim") ) {
                final Object value = (values).remove("to_CnsldtnSegmentForElim");
                if( value instanceof Map ) {
                    if( toCnsldtnSegmentForElim == null ) {
                        toCnsldtnSegmentForElim = new SegmentForElimination();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSegmentForElim.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SegmentForElimTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SegmentForElimTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SegmentForElimTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SegmentForElimTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSegmentForElim != null ) {
            (values).put("to_CnsldtnSegmentForElim", toCnsldtnSegmentForElim);
        }
        return values;
    }

    /**
     * Fetches the <b>SegmentForElimination</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnSegmentForElim</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SegmentForElimination</b> entity, or {@code null} if an entity is not
     *         associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SegmentForElimination fetchCnsldtnSegmentForElim()
    {
        return fetchFieldAsSingle("to_CnsldtnSegmentForElim", SegmentForElimination.class);
    }

    /**
     * Retrieval of associated <b>SegmentForElimination</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentForElim</b> of a queried <b>SegmentForElimText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SegmentForElimination</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SegmentForElimination getCnsldtnSegmentForElimOrFetch()
    {
        if( toCnsldtnSegmentForElim == null ) {
            toCnsldtnSegmentForElim = fetchCnsldtnSegmentForElim();
        }
        return toCnsldtnSegmentForElim;
    }

    /**
     * Retrieval of associated <b>SegmentForElimination</b> entity (one to one). This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentForElim</b>.
     * <p>
     * If the navigation property for an entity <b>SegmentForElimText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSegmentForElim</b> is already loaded, the result
     *         will contain the <b>SegmentForElimination</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SegmentForElimination> getCnsldtnSegmentForElimIfPresent()
    {
        return Option.of(toCnsldtnSegmentForElim);
    }

    /**
     * Overwrites the associated <b>SegmentForElimination</b> entity for the loaded navigation property
     * <b>to_CnsldtnSegmentForElim</b>.
     *
     * @param value
     *            New <b>SegmentForElimination</b> entity.
     */
    public void setCnsldtnSegmentForElim( final SegmentForElimination value )
    {
        toCnsldtnSegmentForElim = value;
    }

    /**
     * Helper class to allow for fluent creation of SegmentForElimText instances.
     *
     */
    public final static class SegmentForElimTextBuilder
    {

        private SegmentForElimination toCnsldtnSegmentForElim;

        private SegmentForElimText.SegmentForElimTextBuilder toCnsldtnSegmentForElim(
            final SegmentForElimination value )
        {
            toCnsldtnSegmentForElim = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSegmentForElim</b> for <b>SegmentForElimText</b> to single
         * <b>SegmentForElimination</b>.
         *
         * @param value
         *            The SegmentForElimination to build this SegmentForElimText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SegmentForElimText.SegmentForElimTextBuilder cnsldtnSegmentForElim( final SegmentForElimination value )
        {
            return toCnsldtnSegmentForElim(value);
        }

    }

}
