/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SegmentForEliminationField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SegmentForEliminationLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SegmentForEliminationSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Segment for Elimination
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SegmentForEliminationType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SegmentForElimination extends VdmEntity<SegmentForElimination>
{

    /**
     * Selector for all available fields of SegmentForElimination.
     *
     */
    public final static SegmentForEliminationSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Consolidation Segment for Elimination
     */
    @Key
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static SegmentForEliminationField<String> SEGMENT = new SegmentForEliminationField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @return Segment for Elimination Description
     */
    @SerializedName( "Segment_Text" )
    @JsonProperty( "Segment_Text" )
    @Nullable
    @ODataField( odataName = "Segment_Text" )
    private String segment_Text;
    /**
     * Use with available fluent helpers to apply the <b>Segment_Text</b> field to query operations.
     *
     */
    public final static SegmentForEliminationField<String> SEGMENT_TEXT =
        new SegmentForEliminationField<String>("Segment_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static SegmentForEliminationField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new SegmentForEliminationField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnSegmentForElimT</b> for <b>SegmentForElimination</b> to multiple
     * <b>SegmentForElimText</b>.
     *
     */
    @SerializedName( "to_CnsldtnSegmentForElimT" )
    @JsonProperty( "to_CnsldtnSegmentForElimT" )
    @ODataField( odataName = "to_CnsldtnSegmentForElimT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SegmentForElimText> toCnsldtnSegmentForElimT;
    /**
     * Navigation property <b>to_CnsldtnSegmentHierForElim</b> for <b>SegmentForElimination</b> to multiple
     * <b>SegmentHierForElim</b>.
     *
     */
    @SerializedName( "to_CnsldtnSegmentHierForElim" )
    @JsonProperty( "to_CnsldtnSegmentHierForElim" )
    @ODataField( odataName = "to_CnsldtnSegmentHierForElim" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SegmentHierForElim> toCnsldtnSegmentHierForElim;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSegmentForElimT</b> navigation property to query
     * operations.
     *
     */
    public final static SegmentForEliminationLink<SegmentForElimText> TO_CNSLDTN_SEGMENT_FOR_ELIM_T =
        new SegmentForEliminationLink<SegmentForElimText>("to_CnsldtnSegmentForElimT");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSegmentHierForElim</b> navigation property to query
     * operations.
     *
     */
    public final static SegmentForEliminationLink<SegmentHierForElim> TO_CNSLDTN_SEGMENT_HIER_FOR_ELIM =
        new SegmentForEliminationLink<SegmentHierForElim>("to_CnsldtnSegmentHierForElim");

    @Nonnull
    @Override
    public Class<SegmentForElimination> getType()
    {
        return SegmentForElimination.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Consolidation Segment for Elimination
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @param segment_Text
     *            Segment for Elimination Description
     */
    public void setSegment_Text( @Nullable final String segment_Text )
    {
        rememberChangedField("Segment_Text", this.segment_Text);
        this.segment_Text = segment_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SegmentForElimination";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Segment", getSegment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Segment", getSegment());
        values.put("Segment_Text", getSegment_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("Segment_Text") ) {
                final Object value = values.remove("Segment_Text");
                if( (value == null) || (!value.equals(getSegment_Text())) ) {
                    setSegment_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSegmentForElimT") ) {
                final Object value = (values).remove("to_CnsldtnSegmentForElimT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSegmentForElimT == null ) {
                        toCnsldtnSegmentForElimT = Lists.newArrayList();
                    } else {
                        toCnsldtnSegmentForElimT = Lists.newArrayList(toCnsldtnSegmentForElimT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SegmentForElimText entity;
                        if( toCnsldtnSegmentForElimT.size() > i ) {
                            entity = toCnsldtnSegmentForElimT.get(i);
                        } else {
                            entity = new SegmentForElimText();
                            toCnsldtnSegmentForElimT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnSegmentHierForElim") ) {
                final Object value = (values).remove("to_CnsldtnSegmentHierForElim");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSegmentHierForElim == null ) {
                        toCnsldtnSegmentHierForElim = Lists.newArrayList();
                    } else {
                        toCnsldtnSegmentHierForElim = Lists.newArrayList(toCnsldtnSegmentHierForElim);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SegmentHierForElim entity;
                        if( toCnsldtnSegmentHierForElim.size() > i ) {
                            entity = toCnsldtnSegmentHierForElim.get(i);
                        } else {
                            entity = new SegmentHierForElim();
                            toCnsldtnSegmentHierForElim.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SegmentForEliminationField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SegmentForEliminationField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SegmentForEliminationField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SegmentForEliminationField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSegmentForElimT != null ) {
            (values).put("to_CnsldtnSegmentForElimT", toCnsldtnSegmentForElimT);
        }
        if( toCnsldtnSegmentHierForElim != null ) {
            (values).put("to_CnsldtnSegmentHierForElim", toCnsldtnSegmentHierForElim);
        }
        return values;
    }

    /**
     * Fetches the <b>SegmentForElimText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnSegmentForElimT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SegmentForElimText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentForElimText> fetchCnsldtnSegmentForElimT()
    {
        return fetchFieldAsList("to_CnsldtnSegmentForElimT", SegmentForElimText.class);
    }

    /**
     * Retrieval of associated <b>SegmentForElimText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentForElimT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentForElimT</b> of a queried <b>SegmentForElimination</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SegmentForElimText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentForElimText> getCnsldtnSegmentForElimTOrFetch()
    {
        if( toCnsldtnSegmentForElimT == null ) {
            toCnsldtnSegmentForElimT = fetchCnsldtnSegmentForElimT();
        }
        return toCnsldtnSegmentForElimT;
    }

    /**
     * Retrieval of associated <b>SegmentForElimText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentForElimT</b>.
     * <p>
     * If the navigation property for an entity <b>SegmentForElimination</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSegmentForElimT</b> is already loaded, the result
     *         will contain the <b>SegmentForElimText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SegmentForElimText>> getCnsldtnSegmentForElimTIfPresent()
    {
        return Option.of(toCnsldtnSegmentForElimT);
    }

    /**
     * Overwrites the list of associated <b>SegmentForElimText</b> entities for the loaded navigation property
     * <b>to_CnsldtnSegmentForElimT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentForElimT</b> of a queried <b>SegmentForElimination</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SegmentForElimText</b> entities.
     */
    public void setCnsldtnSegmentForElimT( @Nonnull final List<SegmentForElimText> value )
    {
        if( toCnsldtnSegmentForElimT == null ) {
            toCnsldtnSegmentForElimT = Lists.newArrayList();
        }
        toCnsldtnSegmentForElimT.clear();
        toCnsldtnSegmentForElimT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SegmentForElimText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentForElimT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentForElimT</b> of a queried <b>SegmentForElimination</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SegmentForElimText</b> entities.
     */
    public void addCnsldtnSegmentForElimT( SegmentForElimText... entity )
    {
        if( toCnsldtnSegmentForElimT == null ) {
            toCnsldtnSegmentForElimT = Lists.newArrayList();
        }
        toCnsldtnSegmentForElimT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SegmentHierForElim</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnSegmentHierForElim</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SegmentHierForElim</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentHierForElim> fetchCnsldtnSegmentHierForElim()
    {
        return fetchFieldAsList("to_CnsldtnSegmentHierForElim", SegmentHierForElim.class);
    }

    /**
     * Retrieval of associated <b>SegmentHierForElim</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHierForElim</b> of a queried <b>SegmentForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SegmentHierForElim</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentHierForElim> getCnsldtnSegmentHierForElimOrFetch()
    {
        if( toCnsldtnSegmentHierForElim == null ) {
            toCnsldtnSegmentHierForElim = fetchCnsldtnSegmentHierForElim();
        }
        return toCnsldtnSegmentHierForElim;
    }

    /**
     * Retrieval of associated <b>SegmentHierForElim</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentHierForElim</b>.
     * <p>
     * If the navigation property for an entity <b>SegmentForElimination</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSegmentHierForElim</b> is already loaded, the
     *         result will contain the <b>SegmentHierForElim</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SegmentHierForElim>> getCnsldtnSegmentHierForElimIfPresent()
    {
        return Option.of(toCnsldtnSegmentHierForElim);
    }

    /**
     * Overwrites the list of associated <b>SegmentHierForElim</b> entities for the loaded navigation property
     * <b>to_CnsldtnSegmentHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHierForElim</b> of a queried <b>SegmentForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SegmentHierForElim</b> entities.
     */
    public void setCnsldtnSegmentHierForElim( @Nonnull final List<SegmentHierForElim> value )
    {
        if( toCnsldtnSegmentHierForElim == null ) {
            toCnsldtnSegmentHierForElim = Lists.newArrayList();
        }
        toCnsldtnSegmentHierForElim.clear();
        toCnsldtnSegmentHierForElim.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SegmentHierForElim</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnSegmentHierForElim</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHierForElim</b> of a queried <b>SegmentForElimination</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SegmentHierForElim</b> entities.
     */
    public void addCnsldtnSegmentHierForElim( SegmentHierForElim... entity )
    {
        if( toCnsldtnSegmentHierForElim == null ) {
            toCnsldtnSegmentHierForElim = Lists.newArrayList();
        }
        toCnsldtnSegmentHierForElim.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SegmentForElimination instances.
     *
     */
    public final static class SegmentForEliminationBuilder
    {

        private List<SegmentForElimText> toCnsldtnSegmentForElimT = Lists.newArrayList();
        private List<SegmentHierForElim> toCnsldtnSegmentHierForElim = Lists.newArrayList();

        private SegmentForElimination.SegmentForEliminationBuilder toCnsldtnSegmentForElimT(
            final List<SegmentForElimText> value )
        {
            toCnsldtnSegmentForElimT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSegmentForElimT</b> for <b>SegmentForElimination</b> to multiple
         * <b>SegmentForElimText</b>.
         *
         * @param value
         *            The SegmentForElimTexts to build this SegmentForElimination with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SegmentForElimination.SegmentForEliminationBuilder cnsldtnSegmentForElimT( SegmentForElimText... value )
        {
            return toCnsldtnSegmentForElimT(Lists.newArrayList(value));
        }

        private SegmentForElimination.SegmentForEliminationBuilder toCnsldtnSegmentHierForElim(
            final List<SegmentHierForElim> value )
        {
            toCnsldtnSegmentHierForElim.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSegmentHierForElim</b> for <b>SegmentForElimination</b> to multiple
         * <b>SegmentHierForElim</b>.
         *
         * @param value
         *            The SegmentHierForElims to build this SegmentForElimination with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SegmentForElimination.SegmentForEliminationBuilder cnsldtnSegmentHierForElim(
            SegmentHierForElim... value )
        {
            return toCnsldtnSegmentHierForElim(Lists.newArrayList(value));
        }

    }

}
