/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SegmentForEliminationSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentForElimination
 * SegmentForElimination} entity using key fields. This fluent helper allows methods which modify the underlying query
 * to be called before executing the query itself.
 *
 */
public class SegmentForEliminationByKeyFluentHelper
    extends
    FluentHelperByKey<SegmentForEliminationByKeyFluentHelper, SegmentForElimination, SegmentForEliminationSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.SegmentForElimination
     * SegmentForElimination} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code SegmentForElimination}
     * @param servicePath
     *            Service path to be used to fetch a single {@code SegmentForElimination}
     * @param segment
     *            Consolidation Segment for Elimination
     *            <p>
     *            Constraints: Not nullable, Maximum length: 25
     *            </p>
     */
    public SegmentForEliminationByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String segment )
    {
        super(servicePath, entityCollection);
        this.key.put("Segment", segment);
    }

    @Override
    @Nonnull
    protected Class<SegmentForElimination> getEntityClass()
    {
        return SegmentForElimination.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
