/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SegmentHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SegmentHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SegmentHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SegmentHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Segment - HierarchyNode
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SegmentHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SegmentHier extends VdmEntity<SegmentHier>
{

    /**
     * Selector for all available fields of SegmentHier.
     *
     */
    public final static SegmentHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSegmentHierarchy</b>
     * </p>
     *
     * @return Segment Hierarchy
     */
    @Key
    @SerializedName( "ConsolidationSegmentHierarchy" )
    @JsonProperty( "ConsolidationSegmentHierarchy" )
    @Nullable
    @ODataField( odataName = "ConsolidationSegmentHierarchy" )
    private String consolidationSegmentHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationSegmentHierarchy</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> CONSOLIDATION_SEGMENT_HIERARCHY =
        new SegmentHierField<String>("ConsolidationSegmentHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> HIERARCHY_NODE = new SegmentHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> HIERARCHY_NODE_TEXT =
        new SegmentHierField<String>("HierarchyNode_Text");
    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @return Validity End Date
     */
    @Key
    @SerializedName( "ValidityEndDate" )
    @JsonProperty( "ValidityEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityEndDate</b> field to query operations.
     *
     */
    public final static SegmentHierField<LocalDateTime> VALIDITY_END_DATE =
        new SegmentHierField<LocalDateTime>("ValidityEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Consolidation Hierarchy Parent Node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> PARENT_NODE = new SegmentHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @return Validity Start Date
     */
    @SerializedName( "ValidityStartDate" )
    @JsonProperty( "ValidityStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ValidityStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime validityStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ValidityStartDate</b> field to query operations.
     *
     */
    public final static SegmentHierField<LocalDateTime> VALIDITY_START_DATE =
        new SegmentHierField<LocalDateTime>("ValidityStartDate");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment
     */
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> SEGMENT = new SegmentHierField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @return Segment Description
     */
    @SerializedName( "Segment_Text" )
    @JsonProperty( "Segment_Text" )
    @Nullable
    @ODataField( odataName = "Segment_Text" )
    private String segment_Text;
    /**
     * Use with available fluent helpers to apply the <b>Segment_Text</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> SEGMENT_TEXT = new SegmentHierField<String>("Segment_Text");
    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return The sequenceNumber contained in this entity.
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> SEQUENCE_NUMBER = new SegmentHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @return Consolidation Hierarchy Sequence Number
     */
    @SerializedName( "HierarchyNodeSequence" )
    @JsonProperty( "HierarchyNodeSequence" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeSequence" )
    private String hierarchyNodeSequence;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeSequence</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> HIERARCHY_NODE_SEQUENCE =
        new SegmentHierField<String>("HierarchyNodeSequence");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Consolidation Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> HIERARCHY_NODE_LEVEL =
        new SegmentHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Consolidation Hierarchy Node Type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static SegmentHierField<String> NODE_TYPE = new SegmentHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnSegment</b> for <b>SegmentHier</b> to single <b>Segment</b>.
     *
     */
    @SerializedName( "to_CnsldtnSegment" )
    @JsonProperty( "to_CnsldtnSegment" )
    @ODataField( odataName = "to_CnsldtnSegment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Segment toCnsldtnSegment;
    /**
     * Navigation property <b>to_CnsldtnSegmentHierT</b> for <b>SegmentHier</b> to multiple <b>SegmentHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnSegmentHierT" )
    @JsonProperty( "to_CnsldtnSegmentHierT" )
    @ODataField( odataName = "to_CnsldtnSegmentHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SegmentHierText> toCnsldtnSegmentHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSegment</b> navigation property to query operations.
     *
     */
    public final static SegmentHierOneToOneLink<Segment> TO_CNSLDTN_SEGMENT =
        new SegmentHierOneToOneLink<Segment>("to_CnsldtnSegment");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSegmentHierT</b> navigation property to query
     * operations.
     *
     */
    public final static SegmentHierLink<SegmentHierText> TO_CNSLDTN_SEGMENT_HIER_T =
        new SegmentHierLink<SegmentHierText>("to_CnsldtnSegmentHierT");

    @Nonnull
    @Override
    public Class<SegmentHier> getType()
    {
        return SegmentHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSegmentHierarchy</b>
     * </p>
     *
     * @param consolidationSegmentHierarchy
     *            Segment Hierarchy
     */
    public void setConsolidationSegmentHierarchy( @Nullable final String consolidationSegmentHierarchy )
    {
        rememberChangedField("ConsolidationSegmentHierarchy", this.consolidationSegmentHierarchy);
        this.consolidationSegmentHierarchy = consolidationSegmentHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Consolidation Hierarchy Node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Consolidation Hierarchy Node Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityEndDate</b>
     * </p>
     *
     * @param validityEndDate
     *            Validity End Date
     */
    public void setValidityEndDate( @Nullable final LocalDateTime validityEndDate )
    {
        rememberChangedField("ValidityEndDate", this.validityEndDate);
        this.validityEndDate = validityEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Consolidation Hierarchy Parent Node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ValidityStartDate</b>
     * </p>
     *
     * @param validityStartDate
     *            Validity Start Date
     */
    public void setValidityStartDate( @Nullable final LocalDateTime validityStartDate )
    {
        rememberChangedField("ValidityStartDate", this.validityStartDate);
        this.validityStartDate = validityStartDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>Segment_Text</b>
     * </p>
     *
     * @param segment_Text
     *            Segment Description
     */
    public void setSegment_Text( @Nullable final String segment_Text )
    {
        rememberChangedField("Segment_Text", this.segment_Text);
        this.segment_Text = segment_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 56
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            The sequenceNumber to set.
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeSequence</b>
     * </p>
     *
     * @param hierarchyNodeSequence
     *            Consolidation Hierarchy Sequence Number
     */
    public void setHierarchyNodeSequence( @Nullable final String hierarchyNodeSequence )
    {
        rememberChangedField("HierarchyNodeSequence", this.hierarchyNodeSequence);
        this.hierarchyNodeSequence = hierarchyNodeSequence;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Consolidation Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Consolidation Hierarchy Node Type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SegmentHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationSegmentHierarchy", getConsolidationSegmentHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        result.put("ValidityEndDate", getValidityEndDate());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationSegmentHierarchy", getConsolidationSegmentHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("ValidityEndDate", getValidityEndDate());
        values.put("ParentNode", getParentNode());
        values.put("ValidityStartDate", getValidityStartDate());
        values.put("Segment", getSegment());
        values.put("Segment_Text", getSegment_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeSequence", getHierarchyNodeSequence());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationSegmentHierarchy") ) {
                final Object value = values.remove("ConsolidationSegmentHierarchy");
                if( (value == null) || (!value.equals(getConsolidationSegmentHierarchy())) ) {
                    setConsolidationSegmentHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("ValidityEndDate") ) {
                final Object value = values.remove("ValidityEndDate");
                if( (value == null) || (!value.equals(getValidityEndDate())) ) {
                    setValidityEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("ValidityStartDate") ) {
                final Object value = values.remove("ValidityStartDate");
                if( (value == null) || (!value.equals(getValidityStartDate())) ) {
                    setValidityStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("Segment_Text") ) {
                final Object value = values.remove("Segment_Text");
                if( (value == null) || (!value.equals(getSegment_Text())) ) {
                    setSegment_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeSequence") ) {
                final Object value = values.remove("HierarchyNodeSequence");
                if( (value == null) || (!value.equals(getHierarchyNodeSequence())) ) {
                    setHierarchyNodeSequence(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSegment") ) {
                final Object value = (values).remove("to_CnsldtnSegment");
                if( value instanceof Map ) {
                    if( toCnsldtnSegment == null ) {
                        toCnsldtnSegment = new Segment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSegment.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnSegmentHierT") ) {
                final Object value = (values).remove("to_CnsldtnSegmentHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSegmentHierT == null ) {
                        toCnsldtnSegmentHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnSegmentHierT = Lists.newArrayList(toCnsldtnSegmentHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SegmentHierText entity;
                        if( toCnsldtnSegmentHierT.size() > i ) {
                            entity = toCnsldtnSegmentHierT.get(i);
                        } else {
                            entity = new SegmentHierText();
                            toCnsldtnSegmentHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SegmentHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SegmentHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SegmentHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SegmentHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSegment != null ) {
            (values).put("to_CnsldtnSegment", toCnsldtnSegment);
        }
        if( toCnsldtnSegmentHierT != null ) {
            (values).put("to_CnsldtnSegmentHierT", toCnsldtnSegmentHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>Segment</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSegment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Segment</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Segment fetchCnsldtnSegment()
    {
        return fetchFieldAsSingle("to_CnsldtnSegment", Segment.class);
    }

    /**
     * Retrieval of associated <b>Segment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSegment</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegment</b> of a queried <b>SegmentHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Segment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Segment getCnsldtnSegmentOrFetch()
    {
        if( toCnsldtnSegment == null ) {
            toCnsldtnSegment = fetchCnsldtnSegment();
        }
        return toCnsldtnSegment;
    }

    /**
     * Retrieval of associated <b>Segment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSegment</b>.
     * <p>
     * If the navigation property for an entity <b>SegmentHier</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSegment</b> is already loaded, the result will
     *         contain the <b>Segment</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Segment> getCnsldtnSegmentIfPresent()
    {
        return Option.of(toCnsldtnSegment);
    }

    /**
     * Overwrites the associated <b>Segment</b> entity for the loaded navigation property <b>to_CnsldtnSegment</b>.
     *
     * @param value
     *            New <b>Segment</b> entity.
     */
    public void setCnsldtnSegment( final Segment value )
    {
        toCnsldtnSegment = value;
    }

    /**
     * Fetches the <b>SegmentHierText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnSegmentHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SegmentHierText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentHierText> fetchCnsldtnSegmentHierT()
    {
        return fetchFieldAsList("to_CnsldtnSegmentHierT", SegmentHierText.class);
    }

    /**
     * Retrieval of associated <b>SegmentHierText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHierT</b> of a queried <b>SegmentHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SegmentHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SegmentHierText> getCnsldtnSegmentHierTOrFetch()
    {
        if( toCnsldtnSegmentHierT == null ) {
            toCnsldtnSegmentHierT = fetchCnsldtnSegmentHierT();
        }
        return toCnsldtnSegmentHierT;
    }

    /**
     * Retrieval of associated <b>SegmentHierText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentHierT</b>.
     * <p>
     * If the navigation property for an entity <b>SegmentHier</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSegmentHierT</b> is already loaded, the result
     *         will contain the <b>SegmentHierText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SegmentHierText>> getCnsldtnSegmentHierTIfPresent()
    {
        return Option.of(toCnsldtnSegmentHierT);
    }

    /**
     * Overwrites the list of associated <b>SegmentHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnSegmentHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHierT</b> of a queried <b>SegmentHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SegmentHierText</b> entities.
     */
    public void setCnsldtnSegmentHierT( @Nonnull final List<SegmentHierText> value )
    {
        if( toCnsldtnSegmentHierT == null ) {
            toCnsldtnSegmentHierT = Lists.newArrayList();
        }
        toCnsldtnSegmentHierT.clear();
        toCnsldtnSegmentHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SegmentHierText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnSegmentHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegmentHierT</b> of a queried <b>SegmentHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SegmentHierText</b> entities.
     */
    public void addCnsldtnSegmentHierT( SegmentHierText... entity )
    {
        if( toCnsldtnSegmentHierT == null ) {
            toCnsldtnSegmentHierT = Lists.newArrayList();
        }
        toCnsldtnSegmentHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SegmentHier instances.
     *
     */
    public final static class SegmentHierBuilder
    {

        private Segment toCnsldtnSegment;
        private List<SegmentHierText> toCnsldtnSegmentHierT = Lists.newArrayList();

        private SegmentHier.SegmentHierBuilder toCnsldtnSegment( final Segment value )
        {
            toCnsldtnSegment = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSegment</b> for <b>SegmentHier</b> to single <b>Segment</b>.
         *
         * @param value
         *            The Segment to build this SegmentHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SegmentHier.SegmentHierBuilder cnsldtnSegment( final Segment value )
        {
            return toCnsldtnSegment(value);
        }

        private SegmentHier.SegmentHierBuilder toCnsldtnSegmentHierT( final List<SegmentHierText> value )
        {
            toCnsldtnSegmentHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSegmentHierT</b> for <b>SegmentHier</b> to multiple <b>SegmentHierText</b>.
         *
         * @param value
         *            The SegmentHierTexts to build this SegmentHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SegmentHier.SegmentHierBuilder cnsldtnSegmentHierT( SegmentHierText... value )
        {
            return toCnsldtnSegmentHierT(Lists.newArrayList(value));
        }

    }

}
