/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SegmentTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SegmentTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SegmentTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Segment Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SegmentTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SegmentText extends VdmEntity<SegmentText>
{

    /**
     * Selector for all available fields of SegmentText.
     *
     */
    public final static SegmentTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SegmentTextField<String> LANGUAGE = new SegmentTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @return Segment
     */
    @Key
    @SerializedName( "Segment" )
    @JsonProperty( "Segment" )
    @Nullable
    @ODataField( odataName = "Segment" )
    private String segment;
    /**
     * Use with available fluent helpers to apply the <b>Segment</b> field to query operations.
     *
     */
    public final static SegmentTextField<String> SEGMENT = new SegmentTextField<String>("Segment");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSegmentText</b>
     * </p>
     *
     * @return Segment Description
     */
    @SerializedName( "CnsldtnSegmentText" )
    @JsonProperty( "CnsldtnSegmentText" )
    @Nullable
    @ODataField( odataName = "CnsldtnSegmentText" )
    private String cnsldtnSegmentText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnSegmentText</b> field to query operations.
     *
     */
    public final static SegmentTextField<String> CNSLDTN_SEGMENT_TEXT =
        new SegmentTextField<String>("CnsldtnSegmentText");
    /**
     * Navigation property <b>to_CnsldtnSegment</b> for <b>SegmentText</b> to single <b>Segment</b>.
     *
     */
    @SerializedName( "to_CnsldtnSegment" )
    @JsonProperty( "to_CnsldtnSegment" )
    @ODataField( odataName = "to_CnsldtnSegment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Segment toCnsldtnSegment;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSegment</b> navigation property to query operations.
     *
     */
    public final static SegmentTextOneToOneLink<Segment> TO_CNSLDTN_SEGMENT =
        new SegmentTextOneToOneLink<Segment>("to_CnsldtnSegment");

    @Nonnull
    @Override
    public Class<SegmentText> getType()
    {
        return SegmentText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Segment</b>
     * </p>
     *
     * @param segment
     *            Segment
     */
    public void setSegment( @Nullable final String segment )
    {
        rememberChangedField("Segment", this.segment);
        this.segment = segment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSegmentText</b>
     * </p>
     *
     * @param cnsldtnSegmentText
     *            Segment Description
     */
    public void setCnsldtnSegmentText( @Nullable final String cnsldtnSegmentText )
    {
        rememberChangedField("CnsldtnSegmentText", this.cnsldtnSegmentText);
        this.cnsldtnSegmentText = cnsldtnSegmentText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SegmentText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Segment", getSegment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Segment", getSegment());
        values.put("CnsldtnSegmentText", getCnsldtnSegmentText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Segment") ) {
                final Object value = values.remove("Segment");
                if( (value == null) || (!value.equals(getSegment())) ) {
                    setSegment(((String) value));
                }
            }
            if( values.containsKey("CnsldtnSegmentText") ) {
                final Object value = values.remove("CnsldtnSegmentText");
                if( (value == null) || (!value.equals(getCnsldtnSegmentText())) ) {
                    setCnsldtnSegmentText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSegment") ) {
                final Object value = (values).remove("to_CnsldtnSegment");
                if( value instanceof Map ) {
                    if( toCnsldtnSegment == null ) {
                        toCnsldtnSegment = new Segment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSegment.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SegmentTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SegmentTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SegmentTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SegmentTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSegment != null ) {
            (values).put("to_CnsldtnSegment", toCnsldtnSegment);
        }
        return values;
    }

    /**
     * Fetches the <b>Segment</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSegment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Segment</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Segment fetchCnsldtnSegment()
    {
        return fetchFieldAsSingle("to_CnsldtnSegment", Segment.class);
    }

    /**
     * Retrieval of associated <b>Segment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSegment</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSegment</b> of a queried <b>SegmentText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Segment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Segment getCnsldtnSegmentOrFetch()
    {
        if( toCnsldtnSegment == null ) {
            toCnsldtnSegment = fetchCnsldtnSegment();
        }
        return toCnsldtnSegment;
    }

    /**
     * Retrieval of associated <b>Segment</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSegment</b>.
     * <p>
     * If the navigation property for an entity <b>SegmentText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSegment</b> is already loaded, the result will
     *         contain the <b>Segment</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<Segment> getCnsldtnSegmentIfPresent()
    {
        return Option.of(toCnsldtnSegment);
    }

    /**
     * Overwrites the associated <b>Segment</b> entity for the loaded navigation property <b>to_CnsldtnSegment</b>.
     *
     * @param value
     *            New <b>Segment</b> entity.
     */
    public void setCnsldtnSegment( final Segment value )
    {
        toCnsldtnSegment = value;
    }

    /**
     * Helper class to allow for fluent creation of SegmentText instances.
     *
     */
    public final static class SegmentTextBuilder
    {

        private Segment toCnsldtnSegment;

        private SegmentText.SegmentTextBuilder toCnsldtnSegment( final Segment value )
        {
            toCnsldtnSegment = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSegment</b> for <b>SegmentText</b> to single <b>Segment</b>.
         *
         * @param value
         *            The Segment to build this SegmentText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SegmentText.SegmentTextBuilder cnsldtnSegment( final Segment value )
        {
            return toCnsldtnSegment(value);
        }

    }

}
