/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ShipToPartyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ShipToPartyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ShipToPartySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Ship to Party
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ShipToPartyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ShipToParty extends VdmEntity<ShipToParty>
{

    /**
     * Selector for all available fields of ShipToParty.
     *
     */
    public final static ShipToPartySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Consolidation Customer
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static ShipToPartyField<String> CUSTOMER = new ShipToPartyField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @return Ship-To Party Description
     */
    @SerializedName( "Customer_Text" )
    @JsonProperty( "Customer_Text" )
    @Nullable
    @ODataField( odataName = "Customer_Text" )
    private String customer_Text;
    /**
     * Use with available fluent helpers to apply the <b>Customer_Text</b> field to query operations.
     *
     */
    public final static ShipToPartyField<String> CUSTOMER_TEXT = new ShipToPartyField<String>("Customer_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static ShipToPartyField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new ShipToPartyField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnShipToPartyT</b> for <b>ShipToParty</b> to multiple <b>ShipToPartyText</b>.
     *
     */
    @SerializedName( "to_CnsldtnShipToPartyT" )
    @JsonProperty( "to_CnsldtnShipToPartyT" )
    @ODataField( odataName = "to_CnsldtnShipToPartyT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<ShipToPartyText> toCnsldtnShipToPartyT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnShipToPartyT</b> navigation property to query
     * operations.
     *
     */
    public final static ShipToPartyLink<ShipToPartyText> TO_CNSLDTN_SHIP_TO_PARTY_T =
        new ShipToPartyLink<ShipToPartyText>("to_CnsldtnShipToPartyT");

    @Nonnull
    @Override
    public Class<ShipToParty> getType()
    {
        return ShipToParty.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Consolidation Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Customer_Text</b>
     * </p>
     *
     * @param customer_Text
     *            Ship-To Party Description
     */
    public void setCustomer_Text( @Nullable final String customer_Text )
    {
        rememberChangedField("Customer_Text", this.customer_Text);
        this.customer_Text = customer_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ShipToParty";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Customer", getCustomer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Customer", getCustomer());
        values.put("Customer_Text", getCustomer_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("Customer_Text") ) {
                final Object value = values.remove("Customer_Text");
                if( (value == null) || (!value.equals(getCustomer_Text())) ) {
                    setCustomer_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnShipToPartyT") ) {
                final Object value = (values).remove("to_CnsldtnShipToPartyT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnShipToPartyT == null ) {
                        toCnsldtnShipToPartyT = Lists.newArrayList();
                    } else {
                        toCnsldtnShipToPartyT = Lists.newArrayList(toCnsldtnShipToPartyT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        ShipToPartyText entity;
                        if( toCnsldtnShipToPartyT.size() > i ) {
                            entity = toCnsldtnShipToPartyT.get(i);
                        } else {
                            entity = new ShipToPartyText();
                            toCnsldtnShipToPartyT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> ShipToPartyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ShipToPartyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ShipToPartyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ShipToPartyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnShipToPartyT != null ) {
            (values).put("to_CnsldtnShipToPartyT", toCnsldtnShipToPartyT);
        }
        return values;
    }

    /**
     * Fetches the <b>ShipToPartyText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnShipToPartyT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>ShipToPartyText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ShipToPartyText> fetchCnsldtnShipToPartyT()
    {
        return fetchFieldAsList("to_CnsldtnShipToPartyT", ShipToPartyText.class);
    }

    /**
     * Retrieval of associated <b>ShipToPartyText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnShipToPartyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnShipToPartyT</b> of a queried <b>ShipToParty</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ShipToPartyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<ShipToPartyText> getCnsldtnShipToPartyTOrFetch()
    {
        if( toCnsldtnShipToPartyT == null ) {
            toCnsldtnShipToPartyT = fetchCnsldtnShipToPartyT();
        }
        return toCnsldtnShipToPartyT;
    }

    /**
     * Retrieval of associated <b>ShipToPartyText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnShipToPartyT</b>.
     * <p>
     * If the navigation property for an entity <b>ShipToParty</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnShipToPartyT</b> is already loaded, the result
     *         will contain the <b>ShipToPartyText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<ShipToPartyText>> getCnsldtnShipToPartyTIfPresent()
    {
        return Option.of(toCnsldtnShipToPartyT);
    }

    /**
     * Overwrites the list of associated <b>ShipToPartyText</b> entities for the loaded navigation property
     * <b>to_CnsldtnShipToPartyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnShipToPartyT</b> of a queried <b>ShipToParty</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>ShipToPartyText</b> entities.
     */
    public void setCnsldtnShipToPartyT( @Nonnull final List<ShipToPartyText> value )
    {
        if( toCnsldtnShipToPartyT == null ) {
            toCnsldtnShipToPartyT = Lists.newArrayList();
        }
        toCnsldtnShipToPartyT.clear();
        toCnsldtnShipToPartyT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>ShipToPartyText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnShipToPartyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnShipToPartyT</b> of a queried <b>ShipToParty</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>ShipToPartyText</b> entities.
     */
    public void addCnsldtnShipToPartyT( ShipToPartyText... entity )
    {
        if( toCnsldtnShipToPartyT == null ) {
            toCnsldtnShipToPartyT = Lists.newArrayList();
        }
        toCnsldtnShipToPartyT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of ShipToParty instances.
     *
     */
    public final static class ShipToPartyBuilder
    {

        private List<ShipToPartyText> toCnsldtnShipToPartyT = Lists.newArrayList();

        private ShipToParty.ShipToPartyBuilder toCnsldtnShipToPartyT( final List<ShipToPartyText> value )
        {
            toCnsldtnShipToPartyT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnShipToPartyT</b> for <b>ShipToParty</b> to multiple <b>ShipToPartyText</b>.
         *
         * @param value
         *            The ShipToPartyTexts to build this ShipToParty with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ShipToParty.ShipToPartyBuilder cnsldtnShipToPartyT( ShipToPartyText... value )
        {
            return toCnsldtnShipToPartyT(Lists.newArrayList(value));
        }

    }

}
