/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.ShipToPartyTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.ShipToPartyTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.ShipToPartyTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Ship to Party Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>ShipToPartyTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class ShipToPartyText extends VdmEntity<ShipToPartyText>
{

    /**
     * Selector for all available fields of ShipToPartyText.
     *
     */
    public final static ShipToPartyTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static ShipToPartyTextField<String> LANGUAGE = new ShipToPartyTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @return Consolidation Customer
     */
    @Key
    @SerializedName( "Customer" )
    @JsonProperty( "Customer" )
    @Nullable
    @ODataField( odataName = "Customer" )
    private String customer;
    /**
     * Use with available fluent helpers to apply the <b>Customer</b> field to query operations.
     *
     */
    public final static ShipToPartyTextField<String> CUSTOMER = new ShipToPartyTextField<String>("Customer");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ShipToPartyText</b>
     * </p>
     *
     * @return Ship-To Party Description
     */
    @SerializedName( "ShipToPartyText" )
    @JsonProperty( "ShipToPartyText" )
    @Nullable
    @ODataField( odataName = "ShipToPartyText" )
    private String shipToPartyText;
    /**
     * Use with available fluent helpers to apply the <b>ShipToPartyText</b> field to query operations.
     *
     */
    public final static ShipToPartyTextField<String> SHIP_TO_PARTY_TEXT =
        new ShipToPartyTextField<String>("ShipToPartyText");
    /**
     * Navigation property <b>to_CnsldtnShipToParty</b> for <b>ShipToPartyText</b> to single <b>ShipToParty</b>.
     *
     */
    @SerializedName( "to_CnsldtnShipToParty" )
    @JsonProperty( "to_CnsldtnShipToParty" )
    @ODataField( odataName = "to_CnsldtnShipToParty" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private ShipToParty toCnsldtnShipToParty;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnShipToParty</b> navigation property to query
     * operations.
     *
     */
    public final static ShipToPartyTextOneToOneLink<ShipToParty> TO_CNSLDTN_SHIP_TO_PARTY =
        new ShipToPartyTextOneToOneLink<ShipToParty>("to_CnsldtnShipToParty");

    @Nonnull
    @Override
    public Class<ShipToPartyText> getType()
    {
        return ShipToPartyText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Customer</b>
     * </p>
     *
     * @param customer
     *            Consolidation Customer
     */
    public void setCustomer( @Nullable final String customer )
    {
        rememberChangedField("Customer", this.customer);
        this.customer = customer;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>ShipToPartyText</b>
     * </p>
     *
     * @param shipToPartyText
     *            Ship-To Party Description
     */
    public void setShipToPartyText( @Nullable final String shipToPartyText )
    {
        rememberChangedField("ShipToPartyText", this.shipToPartyText);
        this.shipToPartyText = shipToPartyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "ShipToPartyText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Customer", getCustomer());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Customer", getCustomer());
        values.put("ShipToPartyText", getShipToPartyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Customer") ) {
                final Object value = values.remove("Customer");
                if( (value == null) || (!value.equals(getCustomer())) ) {
                    setCustomer(((String) value));
                }
            }
            if( values.containsKey("ShipToPartyText") ) {
                final Object value = values.remove("ShipToPartyText");
                if( (value == null) || (!value.equals(getShipToPartyText())) ) {
                    setShipToPartyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnShipToParty") ) {
                final Object value = (values).remove("to_CnsldtnShipToParty");
                if( value instanceof Map ) {
                    if( toCnsldtnShipToParty == null ) {
                        toCnsldtnShipToParty = new ShipToParty();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnShipToParty.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> ShipToPartyTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new ShipToPartyTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> ShipToPartyTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new ShipToPartyTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnShipToParty != null ) {
            (values).put("to_CnsldtnShipToParty", toCnsldtnShipToParty);
        }
        return values;
    }

    /**
     * Fetches the <b>ShipToParty</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnShipToParty</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>ShipToParty</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ShipToParty fetchCnsldtnShipToParty()
    {
        return fetchFieldAsSingle("to_CnsldtnShipToParty", ShipToParty.class);
    }

    /**
     * Retrieval of associated <b>ShipToParty</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnShipToParty</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnShipToParty</b> of a queried <b>ShipToPartyText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>ShipToParty</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public ShipToParty getCnsldtnShipToPartyOrFetch()
    {
        if( toCnsldtnShipToParty == null ) {
            toCnsldtnShipToParty = fetchCnsldtnShipToParty();
        }
        return toCnsldtnShipToParty;
    }

    /**
     * Retrieval of associated <b>ShipToParty</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnShipToParty</b>.
     * <p>
     * If the navigation property for an entity <b>ShipToPartyText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnShipToParty</b> is already loaded, the result
     *         will contain the <b>ShipToParty</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<ShipToParty> getCnsldtnShipToPartyIfPresent()
    {
        return Option.of(toCnsldtnShipToParty);
    }

    /**
     * Overwrites the associated <b>ShipToParty</b> entity for the loaded navigation property
     * <b>to_CnsldtnShipToParty</b>.
     *
     * @param value
     *            New <b>ShipToParty</b> entity.
     */
    public void setCnsldtnShipToParty( final ShipToParty value )
    {
        toCnsldtnShipToParty = value;
    }

    /**
     * Helper class to allow for fluent creation of ShipToPartyText instances.
     *
     */
    public final static class ShipToPartyTextBuilder
    {

        private ShipToParty toCnsldtnShipToParty;

        private ShipToPartyText.ShipToPartyTextBuilder toCnsldtnShipToParty( final ShipToParty value )
        {
            toCnsldtnShipToParty = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnShipToParty</b> for <b>ShipToPartyText</b> to single <b>ShipToParty</b>.
         *
         * @param value
         *            The ShipToParty to build this ShipToPartyText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public ShipToPartyText.ShipToPartyTextBuilder cnsldtnShipToParty( final ShipToParty value )
        {
            return toCnsldtnShipToParty(value);
        }

    }

}
