/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SoldProductField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SoldProductLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SoldProductSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Product Sold
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SoldProductType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SoldProduct extends VdmEntity<SoldProduct>
{

    /**
     * Selector for all available fields of SoldProduct.
     *
     */
    public final static SoldProductSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Product Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SoldProductField<String> MATERIAL = new SoldProductField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material_Text</b>
     * </p>
     *
     * @return Product Sold Description
     */
    @SerializedName( "Material_Text" )
    @JsonProperty( "Material_Text" )
    @Nullable
    @ODataField( odataName = "Material_Text" )
    private String material_Text;
    /**
     * Use with available fluent helpers to apply the <b>Material_Text</b> field to query operations.
     *
     */
    public final static SoldProductField<String> MATERIAL_TEXT = new SoldProductField<String>("Material_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static SoldProductField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new SoldProductField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnProductSoldHier</b> for <b>SoldProduct</b> to multiple <b>SoldProductHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnProductSoldHier" )
    @JsonProperty( "to_CnsldtnProductSoldHier" )
    @ODataField( odataName = "to_CnsldtnProductSoldHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SoldProductHier> toCnsldtnProductSoldHier;
    /**
     * Navigation property <b>to_CnsldtnProductSoldT</b> for <b>SoldProduct</b> to multiple <b>SoldProductText</b>.
     *
     */
    @SerializedName( "to_CnsldtnProductSoldT" )
    @JsonProperty( "to_CnsldtnProductSoldT" )
    @ODataField( odataName = "to_CnsldtnProductSoldT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SoldProductText> toCnsldtnProductSoldT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProductSoldHier</b> navigation property to query
     * operations.
     *
     */
    public final static SoldProductLink<SoldProductHier> TO_CNSLDTN_PRODUCT_SOLD_HIER =
        new SoldProductLink<SoldProductHier>("to_CnsldtnProductSoldHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProductSoldT</b> navigation property to query
     * operations.
     *
     */
    public final static SoldProductLink<SoldProductText> TO_CNSLDTN_PRODUCT_SOLD_T =
        new SoldProductLink<SoldProductText>("to_CnsldtnProductSoldT");

    @Nonnull
    @Override
    public Class<SoldProduct> getType()
    {
        return SoldProduct.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Product Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material_Text</b>
     * </p>
     *
     * @param material_Text
     *            Product Sold Description
     */
    public void setMaterial_Text( @Nullable final String material_Text )
    {
        rememberChangedField("Material_Text", this.material_Text);
        this.material_Text = material_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SoldProduct";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Material", getMaterial());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Material", getMaterial());
        values.put("Material_Text", getMaterial_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("Material_Text") ) {
                final Object value = values.remove("Material_Text");
                if( (value == null) || (!value.equals(getMaterial_Text())) ) {
                    setMaterial_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnProductSoldHier") ) {
                final Object value = (values).remove("to_CnsldtnProductSoldHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnProductSoldHier == null ) {
                        toCnsldtnProductSoldHier = Lists.newArrayList();
                    } else {
                        toCnsldtnProductSoldHier = Lists.newArrayList(toCnsldtnProductSoldHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SoldProductHier entity;
                        if( toCnsldtnProductSoldHier.size() > i ) {
                            entity = toCnsldtnProductSoldHier.get(i);
                        } else {
                            entity = new SoldProductHier();
                            toCnsldtnProductSoldHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnProductSoldT") ) {
                final Object value = (values).remove("to_CnsldtnProductSoldT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnProductSoldT == null ) {
                        toCnsldtnProductSoldT = Lists.newArrayList();
                    } else {
                        toCnsldtnProductSoldT = Lists.newArrayList(toCnsldtnProductSoldT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SoldProductText entity;
                        if( toCnsldtnProductSoldT.size() > i ) {
                            entity = toCnsldtnProductSoldT.get(i);
                        } else {
                            entity = new SoldProductText();
                            toCnsldtnProductSoldT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SoldProductField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SoldProductField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SoldProductField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SoldProductField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnProductSoldHier != null ) {
            (values).put("to_CnsldtnProductSoldHier", toCnsldtnProductSoldHier);
        }
        if( toCnsldtnProductSoldT != null ) {
            (values).put("to_CnsldtnProductSoldT", toCnsldtnProductSoldT);
        }
        return values;
    }

    /**
     * Fetches the <b>SoldProductHier</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnProductSoldHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SoldProductHier</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SoldProductHier> fetchCnsldtnProductSoldHier()
    {
        return fetchFieldAsList("to_CnsldtnProductSoldHier", SoldProductHier.class);
    }

    /**
     * Retrieval of associated <b>SoldProductHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProductSoldHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldHier</b> of a queried <b>SoldProduct</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SoldProductHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SoldProductHier> getCnsldtnProductSoldHierOrFetch()
    {
        if( toCnsldtnProductSoldHier == null ) {
            toCnsldtnProductSoldHier = fetchCnsldtnProductSoldHier();
        }
        return toCnsldtnProductSoldHier;
    }

    /**
     * Retrieval of associated <b>SoldProductHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProductSoldHier</b>.
     * <p>
     * If the navigation property for an entity <b>SoldProduct</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProductSoldHier</b> is already loaded, the result
     *         will contain the <b>SoldProductHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SoldProductHier>> getCnsldtnProductSoldHierIfPresent()
    {
        return Option.of(toCnsldtnProductSoldHier);
    }

    /**
     * Overwrites the list of associated <b>SoldProductHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnProductSoldHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldHier</b> of a queried <b>SoldProduct</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SoldProductHier</b> entities.
     */
    public void setCnsldtnProductSoldHier( @Nonnull final List<SoldProductHier> value )
    {
        if( toCnsldtnProductSoldHier == null ) {
            toCnsldtnProductSoldHier = Lists.newArrayList();
        }
        toCnsldtnProductSoldHier.clear();
        toCnsldtnProductSoldHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SoldProductHier</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnProductSoldHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldHier</b> of a queried <b>SoldProduct</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SoldProductHier</b> entities.
     */
    public void addCnsldtnProductSoldHier( SoldProductHier... entity )
    {
        if( toCnsldtnProductSoldHier == null ) {
            toCnsldtnProductSoldHier = Lists.newArrayList();
        }
        toCnsldtnProductSoldHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SoldProductText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnProductSoldT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SoldProductText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SoldProductText> fetchCnsldtnProductSoldT()
    {
        return fetchFieldAsList("to_CnsldtnProductSoldT", SoldProductText.class);
    }

    /**
     * Retrieval of associated <b>SoldProductText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProductSoldT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldT</b> of a queried <b>SoldProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SoldProductText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SoldProductText> getCnsldtnProductSoldTOrFetch()
    {
        if( toCnsldtnProductSoldT == null ) {
            toCnsldtnProductSoldT = fetchCnsldtnProductSoldT();
        }
        return toCnsldtnProductSoldT;
    }

    /**
     * Retrieval of associated <b>SoldProductText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnProductSoldT</b>.
     * <p>
     * If the navigation property for an entity <b>SoldProduct</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProductSoldT</b> is already loaded, the result
     *         will contain the <b>SoldProductText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SoldProductText>> getCnsldtnProductSoldTIfPresent()
    {
        return Option.of(toCnsldtnProductSoldT);
    }

    /**
     * Overwrites the list of associated <b>SoldProductText</b> entities for the loaded navigation property
     * <b>to_CnsldtnProductSoldT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldT</b> of a queried <b>SoldProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SoldProductText</b> entities.
     */
    public void setCnsldtnProductSoldT( @Nonnull final List<SoldProductText> value )
    {
        if( toCnsldtnProductSoldT == null ) {
            toCnsldtnProductSoldT = Lists.newArrayList();
        }
        toCnsldtnProductSoldT.clear();
        toCnsldtnProductSoldT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SoldProductText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnProductSoldT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldT</b> of a queried <b>SoldProduct</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SoldProductText</b> entities.
     */
    public void addCnsldtnProductSoldT( SoldProductText... entity )
    {
        if( toCnsldtnProductSoldT == null ) {
            toCnsldtnProductSoldT = Lists.newArrayList();
        }
        toCnsldtnProductSoldT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SoldProduct instances.
     *
     */
    public final static class SoldProductBuilder
    {

        private List<SoldProductHier> toCnsldtnProductSoldHier = Lists.newArrayList();
        private List<SoldProductText> toCnsldtnProductSoldT = Lists.newArrayList();

        private SoldProduct.SoldProductBuilder toCnsldtnProductSoldHier( final List<SoldProductHier> value )
        {
            toCnsldtnProductSoldHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProductSoldHier</b> for <b>SoldProduct</b> to multiple
         * <b>SoldProductHier</b>.
         *
         * @param value
         *            The SoldProductHiers to build this SoldProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SoldProduct.SoldProductBuilder cnsldtnProductSoldHier( SoldProductHier... value )
        {
            return toCnsldtnProductSoldHier(Lists.newArrayList(value));
        }

        private SoldProduct.SoldProductBuilder toCnsldtnProductSoldT( final List<SoldProductText> value )
        {
            toCnsldtnProductSoldT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProductSoldT</b> for <b>SoldProduct</b> to multiple <b>SoldProductText</b>.
         *
         * @param value
         *            The SoldProductTexts to build this SoldProduct with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SoldProduct.SoldProductBuilder cnsldtnProductSoldT( SoldProductText... value )
        {
            return toCnsldtnProductSoldT(Lists.newArrayList(value));
        }

    }

}
