/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SoldProductGroupField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SoldProductGroupLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SoldProductGroupSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Product Sold Group
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SoldProductGroupType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SoldProductGroup extends VdmEntity<SoldProductGroup>
{

    /**
     * Selector for all available fields of SoldProductGroup.
     *
     */
    public final static SoldProductGroupSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @Key
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SoldProductGroupField<String> MATERIAL_GROUP =
        new SoldProductGroupField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_Text</b>
     * </p>
     *
     * @return Product Sold Group Description
     */
    @SerializedName( "MaterialGroup_Text" )
    @JsonProperty( "MaterialGroup_Text" )
    @Nullable
    @ODataField( odataName = "MaterialGroup_Text" )
    private String materialGroup_Text;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup_Text</b> field to query operations.
     *
     */
    public final static SoldProductGroupField<String> MATERIAL_GROUP_TEXT =
        new SoldProductGroupField<String>("MaterialGroup_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static SoldProductGroupField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new SoldProductGroupField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnProductSoldGroupT</b> for <b>SoldProductGroup</b> to multiple
     * <b>SoldProductGroupText</b>.
     *
     */
    @SerializedName( "to_CnsldtnProductSoldGroupT" )
    @JsonProperty( "to_CnsldtnProductSoldGroupT" )
    @ODataField( odataName = "to_CnsldtnProductSoldGroupT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SoldProductGroupText> toCnsldtnProductSoldGroupT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProductSoldGroupT</b> navigation property to query
     * operations.
     *
     */
    public final static SoldProductGroupLink<SoldProductGroupText> TO_CNSLDTN_PRODUCT_SOLD_GROUP_T =
        new SoldProductGroupLink<SoldProductGroupText>("to_CnsldtnProductSoldGroupT");

    @Nonnull
    @Override
    public Class<SoldProductGroup> getType()
    {
        return SoldProductGroup.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup_Text</b>
     * </p>
     *
     * @param materialGroup_Text
     *            Product Sold Group Description
     */
    public void setMaterialGroup_Text( @Nullable final String materialGroup_Text )
    {
        rememberChangedField("MaterialGroup_Text", this.materialGroup_Text);
        this.materialGroup_Text = materialGroup_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SoldProductGroup";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("MaterialGroup", getMaterialGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("MaterialGroup", getMaterialGroup());
        values.put("MaterialGroup_Text", getMaterialGroup_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup_Text") ) {
                final Object value = values.remove("MaterialGroup_Text");
                if( (value == null) || (!value.equals(getMaterialGroup_Text())) ) {
                    setMaterialGroup_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnProductSoldGroupT") ) {
                final Object value = (values).remove("to_CnsldtnProductSoldGroupT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnProductSoldGroupT == null ) {
                        toCnsldtnProductSoldGroupT = Lists.newArrayList();
                    } else {
                        toCnsldtnProductSoldGroupT = Lists.newArrayList(toCnsldtnProductSoldGroupT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SoldProductGroupText entity;
                        if( toCnsldtnProductSoldGroupT.size() > i ) {
                            entity = toCnsldtnProductSoldGroupT.get(i);
                        } else {
                            entity = new SoldProductGroupText();
                            toCnsldtnProductSoldGroupT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SoldProductGroupField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SoldProductGroupField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SoldProductGroupField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SoldProductGroupField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnProductSoldGroupT != null ) {
            (values).put("to_CnsldtnProductSoldGroupT", toCnsldtnProductSoldGroupT);
        }
        return values;
    }

    /**
     * Fetches the <b>SoldProductGroupText</b> entities (one to many) associated with this entity. This corresponds to
     * the OData navigation property <b>to_CnsldtnProductSoldGroupT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SoldProductGroupText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SoldProductGroupText> fetchCnsldtnProductSoldGroupT()
    {
        return fetchFieldAsList("to_CnsldtnProductSoldGroupT", SoldProductGroupText.class);
    }

    /**
     * Retrieval of associated <b>SoldProductGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnProductSoldGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldGroupT</b> of a queried <b>SoldProductGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SoldProductGroupText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SoldProductGroupText> getCnsldtnProductSoldGroupTOrFetch()
    {
        if( toCnsldtnProductSoldGroupT == null ) {
            toCnsldtnProductSoldGroupT = fetchCnsldtnProductSoldGroupT();
        }
        return toCnsldtnProductSoldGroupT;
    }

    /**
     * Retrieval of associated <b>SoldProductGroupText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnProductSoldGroupT</b>.
     * <p>
     * If the navigation property for an entity <b>SoldProductGroup</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProductSoldGroupT</b> is already loaded, the
     *         result will contain the <b>SoldProductGroupText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SoldProductGroupText>> getCnsldtnProductSoldGroupTIfPresent()
    {
        return Option.of(toCnsldtnProductSoldGroupT);
    }

    /**
     * Overwrites the list of associated <b>SoldProductGroupText</b> entities for the loaded navigation property
     * <b>to_CnsldtnProductSoldGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldGroupT</b> of a queried <b>SoldProductGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SoldProductGroupText</b> entities.
     */
    public void setCnsldtnProductSoldGroupT( @Nonnull final List<SoldProductGroupText> value )
    {
        if( toCnsldtnProductSoldGroupT == null ) {
            toCnsldtnProductSoldGroupT = Lists.newArrayList();
        }
        toCnsldtnProductSoldGroupT.clear();
        toCnsldtnProductSoldGroupT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SoldProductGroupText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnProductSoldGroupT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldGroupT</b> of a queried <b>SoldProductGroup</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SoldProductGroupText</b> entities.
     */
    public void addCnsldtnProductSoldGroupT( SoldProductGroupText... entity )
    {
        if( toCnsldtnProductSoldGroupT == null ) {
            toCnsldtnProductSoldGroupT = Lists.newArrayList();
        }
        toCnsldtnProductSoldGroupT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SoldProductGroup instances.
     *
     */
    public final static class SoldProductGroupBuilder
    {

        private List<SoldProductGroupText> toCnsldtnProductSoldGroupT = Lists.newArrayList();

        private SoldProductGroup.SoldProductGroupBuilder toCnsldtnProductSoldGroupT(
            final List<SoldProductGroupText> value )
        {
            toCnsldtnProductSoldGroupT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProductSoldGroupT</b> for <b>SoldProductGroup</b> to multiple
         * <b>SoldProductGroupText</b>.
         *
         * @param value
         *            The SoldProductGroupTexts to build this SoldProductGroup with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SoldProductGroup.SoldProductGroupBuilder cnsldtnProductSoldGroupT( SoldProductGroupText... value )
        {
            return toCnsldtnProductSoldGroupT(Lists.newArrayList(value));
        }

    }

}
