/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SoldProductGroupTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SoldProductGroupTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SoldProductGroupTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Product Sold Group - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SoldProductGroupTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SoldProductGroupText extends VdmEntity<SoldProductGroupText>
{

    /**
     * Selector for all available fields of SoldProductGroupText.
     *
     */
    public final static SoldProductGroupTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SoldProductGroupTextField<String> LANGUAGE = new SoldProductGroupTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @return Product Group
     */
    @Key
    @SerializedName( "MaterialGroup" )
    @JsonProperty( "MaterialGroup" )
    @Nullable
    @ODataField( odataName = "MaterialGroup" )
    private String materialGroup;
    /**
     * Use with available fluent helpers to apply the <b>MaterialGroup</b> field to query operations.
     *
     */
    public final static SoldProductGroupTextField<String> MATERIAL_GROUP =
        new SoldProductGroupTextField<String>("MaterialGroup");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroupText</b>
     * </p>
     *
     * @return Product Sold Group Description
     */
    @SerializedName( "SoldProductGroupText" )
    @JsonProperty( "SoldProductGroupText" )
    @Nullable
    @ODataField( odataName = "SoldProductGroupText" )
    private String soldProductGroupText;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductGroupText</b> field to query operations.
     *
     */
    public final static SoldProductGroupTextField<String> SOLD_PRODUCT_GROUP_TEXT =
        new SoldProductGroupTextField<String>("SoldProductGroupText");
    /**
     * Navigation property <b>to_CnsldtnProductSoldGroup</b> for <b>SoldProductGroupText</b> to single
     * <b>SoldProductGroup</b>.
     *
     */
    @SerializedName( "to_CnsldtnProductSoldGroup" )
    @JsonProperty( "to_CnsldtnProductSoldGroup" )
    @ODataField( odataName = "to_CnsldtnProductSoldGroup" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SoldProductGroup toCnsldtnProductSoldGroup;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProductSoldGroup</b> navigation property to query
     * operations.
     *
     */
    public final static SoldProductGroupTextOneToOneLink<SoldProductGroup> TO_CNSLDTN_PRODUCT_SOLD_GROUP =
        new SoldProductGroupTextOneToOneLink<SoldProductGroup>("to_CnsldtnProductSoldGroup");

    @Nonnull
    @Override
    public Class<SoldProductGroupText> getType()
    {
        return SoldProductGroupText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 9
     * <p>
     * Original property name from the Odata EDM: <b>MaterialGroup</b>
     * </p>
     *
     * @param materialGroup
     *            Product Group
     */
    public void setMaterialGroup( @Nullable final String materialGroup )
    {
        rememberChangedField("MaterialGroup", this.materialGroup);
        this.materialGroup = materialGroup;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductGroupText</b>
     * </p>
     *
     * @param soldProductGroupText
     *            Product Sold Group Description
     */
    public void setSoldProductGroupText( @Nullable final String soldProductGroupText )
    {
        rememberChangedField("SoldProductGroupText", this.soldProductGroupText);
        this.soldProductGroupText = soldProductGroupText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SoldProductGroupText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("MaterialGroup", getMaterialGroup());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("MaterialGroup", getMaterialGroup());
        values.put("SoldProductGroupText", getSoldProductGroupText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("MaterialGroup") ) {
                final Object value = values.remove("MaterialGroup");
                if( (value == null) || (!value.equals(getMaterialGroup())) ) {
                    setMaterialGroup(((String) value));
                }
            }
            if( values.containsKey("SoldProductGroupText") ) {
                final Object value = values.remove("SoldProductGroupText");
                if( (value == null) || (!value.equals(getSoldProductGroupText())) ) {
                    setSoldProductGroupText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnProductSoldGroup") ) {
                final Object value = (values).remove("to_CnsldtnProductSoldGroup");
                if( value instanceof Map ) {
                    if( toCnsldtnProductSoldGroup == null ) {
                        toCnsldtnProductSoldGroup = new SoldProductGroup();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnProductSoldGroup.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SoldProductGroupTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SoldProductGroupTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SoldProductGroupTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SoldProductGroupTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnProductSoldGroup != null ) {
            (values).put("to_CnsldtnProductSoldGroup", toCnsldtnProductSoldGroup);
        }
        return values;
    }

    /**
     * Fetches the <b>SoldProductGroup</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnProductSoldGroup</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SoldProductGroup</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SoldProductGroup fetchCnsldtnProductSoldGroup()
    {
        return fetchFieldAsSingle("to_CnsldtnProductSoldGroup", SoldProductGroup.class);
    }

    /**
     * Retrieval of associated <b>SoldProductGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnProductSoldGroup</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSoldGroup</b> of a queried <b>SoldProductGroupText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SoldProductGroup</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SoldProductGroup getCnsldtnProductSoldGroupOrFetch()
    {
        if( toCnsldtnProductSoldGroup == null ) {
            toCnsldtnProductSoldGroup = fetchCnsldtnProductSoldGroup();
        }
        return toCnsldtnProductSoldGroup;
    }

    /**
     * Retrieval of associated <b>SoldProductGroup</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnProductSoldGroup</b>.
     * <p>
     * If the navigation property for an entity <b>SoldProductGroupText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProductSoldGroup</b> is already loaded, the
     *         result will contain the <b>SoldProductGroup</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SoldProductGroup> getCnsldtnProductSoldGroupIfPresent()
    {
        return Option.of(toCnsldtnProductSoldGroup);
    }

    /**
     * Overwrites the associated <b>SoldProductGroup</b> entity for the loaded navigation property
     * <b>to_CnsldtnProductSoldGroup</b>.
     *
     * @param value
     *            New <b>SoldProductGroup</b> entity.
     */
    public void setCnsldtnProductSoldGroup( final SoldProductGroup value )
    {
        toCnsldtnProductSoldGroup = value;
    }

    /**
     * Helper class to allow for fluent creation of SoldProductGroupText instances.
     *
     */
    public final static class SoldProductGroupTextBuilder
    {

        private SoldProductGroup toCnsldtnProductSoldGroup;

        private SoldProductGroupText.SoldProductGroupTextBuilder toCnsldtnProductSoldGroup(
            final SoldProductGroup value )
        {
            toCnsldtnProductSoldGroup = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProductSoldGroup</b> for <b>SoldProductGroupText</b> to single
         * <b>SoldProductGroup</b>.
         *
         * @param value
         *            The SoldProductGroup to build this SoldProductGroupText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SoldProductGroupText.SoldProductGroupTextBuilder cnsldtnProductSoldGroup( final SoldProductGroup value )
        {
            return toCnsldtnProductSoldGroup(value);
        }

    }

}
