/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SoldProductTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SoldProductTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SoldProductTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Product Sold - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SoldProductTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SoldProductText extends VdmEntity<SoldProductText>
{

    /**
     * Selector for all available fields of SoldProductText.
     *
     */
    public final static SoldProductTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SoldProductTextField<String> LANGUAGE = new SoldProductTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @return Material Number
     */
    @Key
    @SerializedName( "Material" )
    @JsonProperty( "Material" )
    @Nullable
    @ODataField( odataName = "Material" )
    private String material;
    /**
     * Use with available fluent helpers to apply the <b>Material</b> field to query operations.
     *
     */
    public final static SoldProductTextField<String> MATERIAL = new SoldProductTextField<String>("Material");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductText</b>
     * </p>
     *
     * @return Product Sold Description
     */
    @SerializedName( "SoldProductText" )
    @JsonProperty( "SoldProductText" )
    @Nullable
    @ODataField( odataName = "SoldProductText" )
    private String soldProductText;
    /**
     * Use with available fluent helpers to apply the <b>SoldProductText</b> field to query operations.
     *
     */
    public final static SoldProductTextField<String> SOLD_PRODUCT_TEXT =
        new SoldProductTextField<String>("SoldProductText");
    /**
     * Navigation property <b>to_CnsldtnProductSold</b> for <b>SoldProductText</b> to single <b>SoldProduct</b>.
     *
     */
    @SerializedName( "to_CnsldtnProductSold" )
    @JsonProperty( "to_CnsldtnProductSold" )
    @ODataField( odataName = "to_CnsldtnProductSold" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SoldProduct toCnsldtnProductSold;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnProductSold</b> navigation property to query
     * operations.
     *
     */
    public final static SoldProductTextOneToOneLink<SoldProduct> TO_CNSLDTN_PRODUCT_SOLD =
        new SoldProductTextOneToOneLink<SoldProduct>("to_CnsldtnProductSold");

    @Nonnull
    @Override
    public Class<SoldProductText> getType()
    {
        return SoldProductText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Material</b>
     * </p>
     *
     * @param material
     *            Material Number
     */
    public void setMaterial( @Nullable final String material )
    {
        rememberChangedField("Material", this.material);
        this.material = material;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>SoldProductText</b>
     * </p>
     *
     * @param soldProductText
     *            Product Sold Description
     */
    public void setSoldProductText( @Nullable final String soldProductText )
    {
        rememberChangedField("SoldProductText", this.soldProductText);
        this.soldProductText = soldProductText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SoldProductText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Material", getMaterial());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Material", getMaterial());
        values.put("SoldProductText", getSoldProductText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Material") ) {
                final Object value = values.remove("Material");
                if( (value == null) || (!value.equals(getMaterial())) ) {
                    setMaterial(((String) value));
                }
            }
            if( values.containsKey("SoldProductText") ) {
                final Object value = values.remove("SoldProductText");
                if( (value == null) || (!value.equals(getSoldProductText())) ) {
                    setSoldProductText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnProductSold") ) {
                final Object value = (values).remove("to_CnsldtnProductSold");
                if( value instanceof Map ) {
                    if( toCnsldtnProductSold == null ) {
                        toCnsldtnProductSold = new SoldProduct();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnProductSold.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SoldProductTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SoldProductTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SoldProductTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SoldProductTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnProductSold != null ) {
            (values).put("to_CnsldtnProductSold", toCnsldtnProductSold);
        }
        return values;
    }

    /**
     * Fetches the <b>SoldProduct</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnProductSold</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SoldProduct</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SoldProduct fetchCnsldtnProductSold()
    {
        return fetchFieldAsSingle("to_CnsldtnProductSold", SoldProduct.class);
    }

    /**
     * Retrieval of associated <b>SoldProduct</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnProductSold</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnProductSold</b> of a queried <b>SoldProductText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SoldProduct</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SoldProduct getCnsldtnProductSoldOrFetch()
    {
        if( toCnsldtnProductSold == null ) {
            toCnsldtnProductSold = fetchCnsldtnProductSold();
        }
        return toCnsldtnProductSold;
    }

    /**
     * Retrieval of associated <b>SoldProduct</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnProductSold</b>.
     * <p>
     * If the navigation property for an entity <b>SoldProductText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnProductSold</b> is already loaded, the result
     *         will contain the <b>SoldProduct</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SoldProduct> getCnsldtnProductSoldIfPresent()
    {
        return Option.of(toCnsldtnProductSold);
    }

    /**
     * Overwrites the associated <b>SoldProduct</b> entity for the loaded navigation property
     * <b>to_CnsldtnProductSold</b>.
     *
     * @param value
     *            New <b>SoldProduct</b> entity.
     */
    public void setCnsldtnProductSold( final SoldProduct value )
    {
        toCnsldtnProductSold = value;
    }

    /**
     * Helper class to allow for fluent creation of SoldProductText instances.
     *
     */
    public final static class SoldProductTextBuilder
    {

        private SoldProduct toCnsldtnProductSold;

        private SoldProductText.SoldProductTextBuilder toCnsldtnProductSold( final SoldProduct value )
        {
            toCnsldtnProductSold = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnProductSold</b> for <b>SoldProductText</b> to single <b>SoldProduct</b>.
         *
         * @param value
         *            The SoldProduct to build this SoldProductText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SoldProductText.SoldProductTextBuilder cnsldtnProductSold( final SoldProduct value )
        {
            return toCnsldtnProductSold(value);
        }

    }

}
