/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SubItemCategoryTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubItemCategoryTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SubItemCategoryTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Subitem Category Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SubItemCategoryTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubItemCategoryText extends VdmEntity<SubItemCategoryText>
{

    /**
     * Selector for all available fields of SubItemCategoryText.
     *
     */
    public final static SubItemCategoryTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @return Subitem Category
     */
    @Key
    @SerializedName( "SubItemCategory" )
    @JsonProperty( "SubItemCategory" )
    @Nullable
    @ODataField( odataName = "SubItemCategory" )
    private String subItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory</b> field to query operations.
     *
     */
    public final static SubItemCategoryTextField<String> SUB_ITEM_CATEGORY =
        new SubItemCategoryTextField<String>("SubItemCategory");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SubItemCategoryTextField<String> LANGUAGE = new SubItemCategoryTextField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategoryText</b>
     * </p>
     *
     * @return Subitem Category Description
     */
    @SerializedName( "SubItemCategoryText" )
    @JsonProperty( "SubItemCategoryText" )
    @Nullable
    @ODataField( odataName = "SubItemCategoryText" )
    private String subItemCategoryText;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategoryText</b> field to query operations.
     *
     */
    public final static SubItemCategoryTextField<String> SUB_ITEM_CATEGORY_TEXT =
        new SubItemCategoryTextField<String>("SubItemCategoryText");
    /**
     * Navigation property <b>to_CnsldtnSubitemCategory</b> for <b>SubItemCategoryText</b> to single
     * <b>SubItemCategory</b>.
     *
     */
    @SerializedName( "to_CnsldtnSubitemCategory" )
    @JsonProperty( "to_CnsldtnSubitemCategory" )
    @ODataField( odataName = "to_CnsldtnSubitemCategory" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SubItemCategory toCnsldtnSubitemCategory;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSubitemCategory</b> navigation property to query
     * operations.
     *
     */
    public final static SubItemCategoryTextOneToOneLink<SubItemCategory> TO_CNSLDTN_SUBITEM_CATEGORY =
        new SubItemCategoryTextOneToOneLink<SubItemCategory>("to_CnsldtnSubitemCategory");

    @Nonnull
    @Override
    public Class<SubItemCategoryText> getType()
    {
        return SubItemCategoryText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @param subItemCategory
     *            Subitem Category
     */
    public void setSubItemCategory( @Nullable final String subItemCategory )
    {
        rememberChangedField("SubItemCategory", this.subItemCategory);
        this.subItemCategory = subItemCategory;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategoryText</b>
     * </p>
     *
     * @param subItemCategoryText
     *            Subitem Category Description
     */
    public void setSubItemCategoryText( @Nullable final String subItemCategoryText )
    {
        rememberChangedField("SubItemCategoryText", this.subItemCategoryText);
        this.subItemCategoryText = subItemCategoryText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SubItemCategoryText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SubItemCategory", getSubItemCategory());
        result.put("Language", getLanguage());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SubItemCategory", getSubItemCategory());
        values.put("Language", getLanguage());
        values.put("SubItemCategoryText", getSubItemCategoryText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SubItemCategory") ) {
                final Object value = values.remove("SubItemCategory");
                if( (value == null) || (!value.equals(getSubItemCategory())) ) {
                    setSubItemCategory(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SubItemCategoryText") ) {
                final Object value = values.remove("SubItemCategoryText");
                if( (value == null) || (!value.equals(getSubItemCategoryText())) ) {
                    setSubItemCategoryText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSubitemCategory") ) {
                final Object value = (values).remove("to_CnsldtnSubitemCategory");
                if( value instanceof Map ) {
                    if( toCnsldtnSubitemCategory == null ) {
                        toCnsldtnSubitemCategory = new SubItemCategory();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSubitemCategory.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SubItemCategoryTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubItemCategoryTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubItemCategoryTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubItemCategoryTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSubitemCategory != null ) {
            (values).put("to_CnsldtnSubitemCategory", toCnsldtnSubitemCategory);
        }
        return values;
    }

    /**
     * Fetches the <b>SubItemCategory</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSubitemCategory</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SubItemCategory</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SubItemCategory fetchCnsldtnSubitemCategory()
    {
        return fetchFieldAsSingle("to_CnsldtnSubitemCategory", SubItemCategory.class);
    }

    /**
     * Retrieval of associated <b>SubItemCategory</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnSubitemCategory</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubitemCategory</b> of a queried <b>SubItemCategoryText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SubItemCategory</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SubItemCategory getCnsldtnSubitemCategoryOrFetch()
    {
        if( toCnsldtnSubitemCategory == null ) {
            toCnsldtnSubitemCategory = fetchCnsldtnSubitemCategory();
        }
        return toCnsldtnSubitemCategory;
    }

    /**
     * Retrieval of associated <b>SubItemCategory</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnSubitemCategory</b>.
     * <p>
     * If the navigation property for an entity <b>SubItemCategoryText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSubitemCategory</b> is already loaded, the result
     *         will contain the <b>SubItemCategory</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SubItemCategory> getCnsldtnSubitemCategoryIfPresent()
    {
        return Option.of(toCnsldtnSubitemCategory);
    }

    /**
     * Overwrites the associated <b>SubItemCategory</b> entity for the loaded navigation property
     * <b>to_CnsldtnSubitemCategory</b>.
     *
     * @param value
     *            New <b>SubItemCategory</b> entity.
     */
    public void setCnsldtnSubitemCategory( final SubItemCategory value )
    {
        toCnsldtnSubitemCategory = value;
    }

    /**
     * Helper class to allow for fluent creation of SubItemCategoryText instances.
     *
     */
    public final static class SubItemCategoryTextBuilder
    {

        private SubItemCategory toCnsldtnSubitemCategory;

        private SubItemCategoryText.SubItemCategoryTextBuilder toCnsldtnSubitemCategory( final SubItemCategory value )
        {
            toCnsldtnSubitemCategory = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSubitemCategory</b> for <b>SubItemCategoryText</b> to single
         * <b>SubItemCategory</b>.
         *
         * @param value
         *            The SubItemCategory to build this SubItemCategoryText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SubItemCategoryText.SubItemCategoryTextBuilder cnsldtnSubitemCategory( final SubItemCategory value )
        {
            return toCnsldtnSubitemCategory(value);
        }

    }

}
