/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SubItemTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubItemTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SubItemTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Subitem Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SubItemTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubItemText extends VdmEntity<SubItemText>
{

    /**
     * Selector for all available fields of SubItemText.
     *
     */
    public final static SubItemTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @return Subitem Category
     */
    @Key
    @SerializedName( "SubItemCategory" )
    @JsonProperty( "SubItemCategory" )
    @Nullable
    @ODataField( odataName = "SubItemCategory" )
    private String subItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory</b> field to query operations.
     *
     */
    public final static SubItemTextField<String> SUB_ITEM_CATEGORY = new SubItemTextField<String>("SubItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory_Text</b>
     * </p>
     *
     * @return Subitem Category Description
     */
    @SerializedName( "SubItemCategory_Text" )
    @JsonProperty( "SubItemCategory_Text" )
    @Nullable
    @ODataField( odataName = "SubItemCategory_Text" )
    private String subItemCategory_Text;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory_Text</b> field to query operations.
     *
     */
    public final static SubItemTextField<String> SUB_ITEM_CATEGORY_TEXT =
        new SubItemTextField<String>("SubItemCategory_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SubItemTextField<String> LANGUAGE = new SubItemTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubItem</b>
     * </p>
     *
     * @return Subitem
     */
    @Key
    @SerializedName( "SubItem" )
    @JsonProperty( "SubItem" )
    @Nullable
    @ODataField( odataName = "SubItem" )
    private String subItem;
    /**
     * Use with available fluent helpers to apply the <b>SubItem</b> field to query operations.
     *
     */
    public final static SubItemTextField<String> SUB_ITEM = new SubItemTextField<String>("SubItem");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemText</b>
     * </p>
     *
     * @return Subitem Description
     */
    @SerializedName( "SubItemText" )
    @JsonProperty( "SubItemText" )
    @Nullable
    @ODataField( odataName = "SubItemText" )
    private String subItemText;
    /**
     * Use with available fluent helpers to apply the <b>SubItemText</b> field to query operations.
     *
     */
    public final static SubItemTextField<String> SUB_ITEM_TEXT = new SubItemTextField<String>("SubItemText");
    /**
     * Navigation property <b>to_CnsldtnSubItem</b> for <b>SubItemText</b> to single <b>SubItem</b>.
     *
     */
    @SerializedName( "to_CnsldtnSubItem" )
    @JsonProperty( "to_CnsldtnSubItem" )
    @ODataField( odataName = "to_CnsldtnSubItem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SubItem toCnsldtnSubItem;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSubItem</b> navigation property to query operations.
     *
     */
    public final static SubItemTextOneToOneLink<SubItem> TO_CNSLDTN_SUB_ITEM =
        new SubItemTextOneToOneLink<SubItem>("to_CnsldtnSubItem");

    @Nonnull
    @Override
    public Class<SubItemText> getType()
    {
        return SubItemText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @param subItemCategory
     *            Subitem Category
     */
    public void setSubItemCategory( @Nullable final String subItemCategory )
    {
        rememberChangedField("SubItemCategory", this.subItemCategory);
        this.subItemCategory = subItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory_Text</b>
     * </p>
     *
     * @param subItemCategory_Text
     *            Subitem Category Description
     */
    public void setSubItemCategory_Text( @Nullable final String subItemCategory_Text )
    {
        rememberChangedField("SubItemCategory_Text", this.subItemCategory_Text);
        this.subItemCategory_Text = subItemCategory_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubItem</b>
     * </p>
     *
     * @param subItem
     *            Subitem
     */
    public void setSubItem( @Nullable final String subItem )
    {
        rememberChangedField("SubItem", this.subItem);
        this.subItem = subItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemText</b>
     * </p>
     *
     * @param subItemText
     *            Subitem Description
     */
    public void setSubItemText( @Nullable final String subItemText )
    {
        rememberChangedField("SubItemText", this.subItemText);
        this.subItemText = subItemText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SubItemText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("SubItemCategory", getSubItemCategory());
        result.put("Language", getLanguage());
        result.put("SubItem", getSubItem());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("SubItemCategory", getSubItemCategory());
        values.put("SubItemCategory_Text", getSubItemCategory_Text());
        values.put("Language", getLanguage());
        values.put("SubItem", getSubItem());
        values.put("SubItemText", getSubItemText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("SubItemCategory") ) {
                final Object value = values.remove("SubItemCategory");
                if( (value == null) || (!value.equals(getSubItemCategory())) ) {
                    setSubItemCategory(((String) value));
                }
            }
            if( values.containsKey("SubItemCategory_Text") ) {
                final Object value = values.remove("SubItemCategory_Text");
                if( (value == null) || (!value.equals(getSubItemCategory_Text())) ) {
                    setSubItemCategory_Text(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("SubItem") ) {
                final Object value = values.remove("SubItem");
                if( (value == null) || (!value.equals(getSubItem())) ) {
                    setSubItem(((String) value));
                }
            }
            if( values.containsKey("SubItemText") ) {
                final Object value = values.remove("SubItemText");
                if( (value == null) || (!value.equals(getSubItemText())) ) {
                    setSubItemText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSubItem") ) {
                final Object value = (values).remove("to_CnsldtnSubItem");
                if( value instanceof Map ) {
                    if( toCnsldtnSubItem == null ) {
                        toCnsldtnSubItem = new SubItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSubItem.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SubItemTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubItemTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubItemTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubItemTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSubItem != null ) {
            (values).put("to_CnsldtnSubItem", toCnsldtnSubItem);
        }
        return values;
    }

    /**
     * Fetches the <b>SubItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSubItem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SubItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SubItem fetchCnsldtnSubItem()
    {
        return fetchFieldAsSingle("to_CnsldtnSubItem", SubItem.class);
    }

    /**
     * Retrieval of associated <b>SubItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSubItem</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubItem</b> of a queried <b>SubItemText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SubItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SubItem getCnsldtnSubItemOrFetch()
    {
        if( toCnsldtnSubItem == null ) {
            toCnsldtnSubItem = fetchCnsldtnSubItem();
        }
        return toCnsldtnSubItem;
    }

    /**
     * Retrieval of associated <b>SubItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSubItem</b>.
     * <p>
     * If the navigation property for an entity <b>SubItemText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSubItem</b> is already loaded, the result will
     *         contain the <b>SubItem</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<SubItem> getCnsldtnSubItemIfPresent()
    {
        return Option.of(toCnsldtnSubItem);
    }

    /**
     * Overwrites the associated <b>SubItem</b> entity for the loaded navigation property <b>to_CnsldtnSubItem</b>.
     *
     * @param value
     *            New <b>SubItem</b> entity.
     */
    public void setCnsldtnSubItem( final SubItem value )
    {
        toCnsldtnSubItem = value;
    }

    /**
     * Helper class to allow for fluent creation of SubItemText instances.
     *
     */
    public final static class SubItemTextBuilder
    {

        private SubItem toCnsldtnSubItem;

        private SubItemText.SubItemTextBuilder toCnsldtnSubItem( final SubItem value )
        {
            toCnsldtnSubItem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSubItem</b> for <b>SubItemText</b> to single <b>SubItem</b>.
         *
         * @param value
         *            The SubItem to build this SubItemText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SubItemText.SubItemTextBuilder cnsldtnSubItem( final SubItem value )
        {
            return toCnsldtnSubItem(value);
        }

    }

}
