/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SubassignmentField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubassignmentLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SubassignmentSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Subassignment
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SubassignmentType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Subassignment extends VdmEntity<Subassignment>
{

    /**
     * Selector for all available fields of Subassignment.
     *
     */
    public final static SubassignmentSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment</b>
     * </p>
     *
     * @return Subassignment
     */
    @Key
    @SerializedName( "CnsldtnSubassignment" )
    @JsonProperty( "CnsldtnSubassignment" )
    @Nullable
    @ODataField( odataName = "CnsldtnSubassignment" )
    private String cnsldtnSubassignment;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnSubassignment</b> field to query operations.
     *
     */
    public final static SubassignmentField<String> CNSLDTN_SUBASSIGNMENT =
        new SubassignmentField<String>("CnsldtnSubassignment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment_Text</b>
     * </p>
     *
     * @return Subassignment Description
     */
    @SerializedName( "CnsldtnSubassignment_Text" )
    @JsonProperty( "CnsldtnSubassignment_Text" )
    @Nullable
    @ODataField( odataName = "CnsldtnSubassignment_Text" )
    private String cnsldtnSubassignment_Text;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnSubassignment_Text</b> field to query operations.
     *
     */
    public final static SubassignmentField<String> CNSLDTN_SUBASSIGNMENT_TEXT =
        new SubassignmentField<String>("CnsldtnSubassignment_Text");
    /**
     * Navigation property <b>to_CnsldtnSubassignmentT</b> for <b>Subassignment</b> to multiple
     * <b>SubassignmentText</b>.
     *
     */
    @SerializedName( "to_CnsldtnSubassignmentT" )
    @JsonProperty( "to_CnsldtnSubassignmentT" )
    @ODataField( odataName = "to_CnsldtnSubassignmentT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SubassignmentText> toCnsldtnSubassignmentT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSubassignmentT</b> navigation property to query
     * operations.
     *
     */
    public final static SubassignmentLink<SubassignmentText> TO_CNSLDTN_SUBASSIGNMENT_T =
        new SubassignmentLink<SubassignmentText>("to_CnsldtnSubassignmentT");

    @Nonnull
    @Override
    public Class<Subassignment> getType()
    {
        return Subassignment.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment</b>
     * </p>
     *
     * @param cnsldtnSubassignment
     *            Subassignment
     */
    public void setCnsldtnSubassignment( @Nullable final String cnsldtnSubassignment )
    {
        rememberChangedField("CnsldtnSubassignment", this.cnsldtnSubassignment);
        this.cnsldtnSubassignment = cnsldtnSubassignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment_Text</b>
     * </p>
     *
     * @param cnsldtnSubassignment_Text
     *            Subassignment Description
     */
    public void setCnsldtnSubassignment_Text( @Nullable final String cnsldtnSubassignment_Text )
    {
        rememberChangedField("CnsldtnSubassignment_Text", this.cnsldtnSubassignment_Text);
        this.cnsldtnSubassignment_Text = cnsldtnSubassignment_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Subassignment";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("CnsldtnSubassignment", getCnsldtnSubassignment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("CnsldtnSubassignment", getCnsldtnSubassignment());
        values.put("CnsldtnSubassignment_Text", getCnsldtnSubassignment_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("CnsldtnSubassignment") ) {
                final Object value = values.remove("CnsldtnSubassignment");
                if( (value == null) || (!value.equals(getCnsldtnSubassignment())) ) {
                    setCnsldtnSubassignment(((String) value));
                }
            }
            if( values.containsKey("CnsldtnSubassignment_Text") ) {
                final Object value = values.remove("CnsldtnSubassignment_Text");
                if( (value == null) || (!value.equals(getCnsldtnSubassignment_Text())) ) {
                    setCnsldtnSubassignment_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSubassignmentT") ) {
                final Object value = (values).remove("to_CnsldtnSubassignmentT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSubassignmentT == null ) {
                        toCnsldtnSubassignmentT = Lists.newArrayList();
                    } else {
                        toCnsldtnSubassignmentT = Lists.newArrayList(toCnsldtnSubassignmentT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SubassignmentText entity;
                        if( toCnsldtnSubassignmentT.size() > i ) {
                            entity = toCnsldtnSubassignmentT.get(i);
                        } else {
                            entity = new SubassignmentText();
                            toCnsldtnSubassignmentT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SubassignmentField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubassignmentField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubassignmentField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubassignmentField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSubassignmentT != null ) {
            (values).put("to_CnsldtnSubassignmentT", toCnsldtnSubassignmentT);
        }
        return values;
    }

    /**
     * Fetches the <b>SubassignmentText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnSubassignmentT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SubassignmentText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SubassignmentText> fetchCnsldtnSubassignmentT()
    {
        return fetchFieldAsList("to_CnsldtnSubassignmentT", SubassignmentText.class);
    }

    /**
     * Retrieval of associated <b>SubassignmentText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSubassignmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubassignmentT</b> of a queried <b>Subassignment</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SubassignmentText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SubassignmentText> getCnsldtnSubassignmentTOrFetch()
    {
        if( toCnsldtnSubassignmentT == null ) {
            toCnsldtnSubassignmentT = fetchCnsldtnSubassignmentT();
        }
        return toCnsldtnSubassignmentT;
    }

    /**
     * Retrieval of associated <b>SubassignmentText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSubassignmentT</b>.
     * <p>
     * If the navigation property for an entity <b>Subassignment</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSubassignmentT</b> is already loaded, the result
     *         will contain the <b>SubassignmentText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SubassignmentText>> getCnsldtnSubassignmentTIfPresent()
    {
        return Option.of(toCnsldtnSubassignmentT);
    }

    /**
     * Overwrites the list of associated <b>SubassignmentText</b> entities for the loaded navigation property
     * <b>to_CnsldtnSubassignmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubassignmentT</b> of a queried <b>Subassignment</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SubassignmentText</b> entities.
     */
    public void setCnsldtnSubassignmentT( @Nonnull final List<SubassignmentText> value )
    {
        if( toCnsldtnSubassignmentT == null ) {
            toCnsldtnSubassignmentT = Lists.newArrayList();
        }
        toCnsldtnSubassignmentT.clear();
        toCnsldtnSubassignmentT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SubassignmentText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnSubassignmentT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubassignmentT</b> of a queried <b>Subassignment</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SubassignmentText</b> entities.
     */
    public void addCnsldtnSubassignmentT( SubassignmentText... entity )
    {
        if( toCnsldtnSubassignmentT == null ) {
            toCnsldtnSubassignmentT = Lists.newArrayList();
        }
        toCnsldtnSubassignmentT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Subassignment instances.
     *
     */
    public final static class SubassignmentBuilder
    {

        private List<SubassignmentText> toCnsldtnSubassignmentT = Lists.newArrayList();

        private Subassignment.SubassignmentBuilder toCnsldtnSubassignmentT( final List<SubassignmentText> value )
        {
            toCnsldtnSubassignmentT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSubassignmentT</b> for <b>Subassignment</b> to multiple
         * <b>SubassignmentText</b>.
         *
         * @param value
         *            The SubassignmentTexts to build this Subassignment with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Subassignment.SubassignmentBuilder cnsldtnSubassignmentT( SubassignmentText... value )
        {
            return toCnsldtnSubassignmentT(Lists.newArrayList(value));
        }

    }

}
