/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SubassignmentTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubassignmentTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SubassignmentTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Subassignment - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SubassignmentTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubassignmentText extends VdmEntity<SubassignmentText>
{

    /**
     * Selector for all available fields of SubassignmentText.
     *
     */
    public final static SubassignmentTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SubassignmentTextField<String> LANGUAGE = new SubassignmentTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment</b>
     * </p>
     *
     * @return Subassignment
     */
    @Key
    @SerializedName( "CnsldtnSubassignment" )
    @JsonProperty( "CnsldtnSubassignment" )
    @Nullable
    @ODataField( odataName = "CnsldtnSubassignment" )
    private String cnsldtnSubassignment;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnSubassignment</b> field to query operations.
     *
     */
    public final static SubassignmentTextField<String> CNSLDTN_SUBASSIGNMENT =
        new SubassignmentTextField<String>("CnsldtnSubassignment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignmentText</b>
     * </p>
     *
     * @return Subassignment Description
     */
    @SerializedName( "CnsldtnSubassignmentText" )
    @JsonProperty( "CnsldtnSubassignmentText" )
    @Nullable
    @ODataField( odataName = "CnsldtnSubassignmentText" )
    private String cnsldtnSubassignmentText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnSubassignmentText</b> field to query operations.
     *
     */
    public final static SubassignmentTextField<String> CNSLDTN_SUBASSIGNMENT_TEXT =
        new SubassignmentTextField<String>("CnsldtnSubassignmentText");
    /**
     * Navigation property <b>to_CnsldtnSubassignment</b> for <b>SubassignmentText</b> to single <b>Subassignment</b>.
     *
     */
    @SerializedName( "to_CnsldtnSubassignment" )
    @JsonProperty( "to_CnsldtnSubassignment" )
    @ODataField( odataName = "to_CnsldtnSubassignment" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Subassignment toCnsldtnSubassignment;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSubassignment</b> navigation property to query
     * operations.
     *
     */
    public final static SubassignmentTextOneToOneLink<Subassignment> TO_CNSLDTN_SUBASSIGNMENT =
        new SubassignmentTextOneToOneLink<Subassignment>("to_CnsldtnSubassignment");

    @Nonnull
    @Override
    public Class<SubassignmentText> getType()
    {
        return SubassignmentText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignment</b>
     * </p>
     *
     * @param cnsldtnSubassignment
     *            Subassignment
     */
    public void setCnsldtnSubassignment( @Nullable final String cnsldtnSubassignment )
    {
        rememberChangedField("CnsldtnSubassignment", this.cnsldtnSubassignment);
        this.cnsldtnSubassignment = cnsldtnSubassignment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSubassignmentText</b>
     * </p>
     *
     * @param cnsldtnSubassignmentText
     *            Subassignment Description
     */
    public void setCnsldtnSubassignmentText( @Nullable final String cnsldtnSubassignmentText )
    {
        rememberChangedField("CnsldtnSubassignmentText", this.cnsldtnSubassignmentText);
        this.cnsldtnSubassignmentText = cnsldtnSubassignmentText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SubassignmentText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("CnsldtnSubassignment", getCnsldtnSubassignment());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("CnsldtnSubassignment", getCnsldtnSubassignment());
        values.put("CnsldtnSubassignmentText", getCnsldtnSubassignmentText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CnsldtnSubassignment") ) {
                final Object value = values.remove("CnsldtnSubassignment");
                if( (value == null) || (!value.equals(getCnsldtnSubassignment())) ) {
                    setCnsldtnSubassignment(((String) value));
                }
            }
            if( values.containsKey("CnsldtnSubassignmentText") ) {
                final Object value = values.remove("CnsldtnSubassignmentText");
                if( (value == null) || (!value.equals(getCnsldtnSubassignmentText())) ) {
                    setCnsldtnSubassignmentText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSubassignment") ) {
                final Object value = (values).remove("to_CnsldtnSubassignment");
                if( value instanceof Map ) {
                    if( toCnsldtnSubassignment == null ) {
                        toCnsldtnSubassignment = new Subassignment();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSubassignment.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SubassignmentTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubassignmentTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubassignmentTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubassignmentTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSubassignment != null ) {
            (values).put("to_CnsldtnSubassignment", toCnsldtnSubassignment);
        }
        return values;
    }

    /**
     * Fetches the <b>Subassignment</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSubassignment</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Subassignment</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Subassignment fetchCnsldtnSubassignment()
    {
        return fetchFieldAsSingle("to_CnsldtnSubassignment", Subassignment.class);
    }

    /**
     * Retrieval of associated <b>Subassignment</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnSubassignment</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubassignment</b> of a queried <b>SubassignmentText</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Subassignment</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Subassignment getCnsldtnSubassignmentOrFetch()
    {
        if( toCnsldtnSubassignment == null ) {
            toCnsldtnSubassignment = fetchCnsldtnSubassignment();
        }
        return toCnsldtnSubassignment;
    }

    /**
     * Retrieval of associated <b>Subassignment</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnSubassignment</b>.
     * <p>
     * If the navigation property for an entity <b>SubassignmentText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSubassignment</b> is already loaded, the result
     *         will contain the <b>Subassignment</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<Subassignment> getCnsldtnSubassignmentIfPresent()
    {
        return Option.of(toCnsldtnSubassignment);
    }

    /**
     * Overwrites the associated <b>Subassignment</b> entity for the loaded navigation property
     * <b>to_CnsldtnSubassignment</b>.
     *
     * @param value
     *            New <b>Subassignment</b> entity.
     */
    public void setCnsldtnSubassignment( final Subassignment value )
    {
        toCnsldtnSubassignment = value;
    }

    /**
     * Helper class to allow for fluent creation of SubassignmentText instances.
     *
     */
    public final static class SubassignmentTextBuilder
    {

        private Subassignment toCnsldtnSubassignment;
        private String cnsldtnSubassignment = null;

        private SubassignmentText.SubassignmentTextBuilder toCnsldtnSubassignment( final Subassignment value )
        {
            toCnsldtnSubassignment = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSubassignment</b> for <b>SubassignmentText</b> to single
         * <b>Subassignment</b>.
         *
         * @param value
         *            The Subassignment to build this SubassignmentText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SubassignmentText.SubassignmentTextBuilder cnsldtnSubassignment( final Subassignment value )
        {
            return toCnsldtnSubassignment(value);
        }

        /**
         * (Key Field) Constraints: Not nullable, Maximum length: 30
         * <p>
         * Original property name from the Odata EDM: <b>CnsldtnSubassignment</b>
         * </p>
         *
         * @param value
         *            The cnsldtnSubassignment to build this SubassignmentText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SubassignmentText.SubassignmentTextBuilder cnsldtnSubassignment( final String value )
        {
            cnsldtnSubassignment = value;
            return this;
        }

    }

}
