/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SubitemHierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubitemHierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubitemHierOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SubitemHierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Subitem Hierarchy
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SubitemHierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubitemHier extends VdmEntity<SubitemHier>
{

    /**
     * Selector for all available fields of SubitemHier.
     *
     */
    public final static SubitemHierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSubitemHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "ConsolidationSubitemHierarchy" )
    @JsonProperty( "ConsolidationSubitemHierarchy" )
    @Nullable
    @ODataField( odataName = "ConsolidationSubitemHierarchy" )
    private String consolidationSubitemHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationSubitemHierarchy</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> CONSOLIDATION_SUBITEM_HIERARCHY =
        new SubitemHierField<String>("ConsolidationSubitemHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> HIERARCHY_NODE = new SubitemHierField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @return Subitem Description
     */
    @SerializedName( "HierarchyNode_Text" )
    @JsonProperty( "HierarchyNode_Text" )
    @Nullable
    @ODataField( odataName = "HierarchyNode_Text" )
    private String hierarchyNode_Text;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode_Text</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> HIERARCHY_NODE_TEXT =
        new SubitemHierField<String>("HierarchyNode_Text");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @return Subitem Category
     */
    @SerializedName( "SubItemCategory" )
    @JsonProperty( "SubItemCategory" )
    @Nullable
    @ODataField( odataName = "SubItemCategory" )
    private String subItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> SUB_ITEM_CATEGORY = new SubitemHierField<String>("SubItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory_Text</b>
     * </p>
     *
     * @return Subitem Category Description
     */
    @SerializedName( "SubItemCategory_Text" )
    @JsonProperty( "SubItemCategory_Text" )
    @Nullable
    @ODataField( odataName = "SubItemCategory_Text" )
    private String subItemCategory_Text;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory_Text</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> SUB_ITEM_CATEGORY_TEXT =
        new SubitemHierField<String>("SubItemCategory_Text");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @return Hierarchy parent node
     */
    @SerializedName( "ParentNode" )
    @JsonProperty( "ParentNode" )
    @Nullable
    @ODataField( odataName = "ParentNode" )
    private String parentNode;
    /**
     * Use with available fluent helpers to apply the <b>ParentNode</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> PARENT_NODE = new SubitemHierField<String>("ParentNode");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @return Hierarchy version
     */
    @SerializedName( "HierarchyVersion" )
    @JsonProperty( "HierarchyVersion" )
    @Nullable
    @ODataField( odataName = "HierarchyVersion" )
    private String hierarchyVersion;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyVersion</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> HIERARCHY_VERSION = new SubitemHierField<String>("HierarchyVersion");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubItem</b>
     * </p>
     *
     * @return Subitem
     */
    @SerializedName( "SubItem" )
    @JsonProperty( "SubItem" )
    @Nullable
    @ODataField( odataName = "SubItem" )
    private String subItem;
    /**
     * Use with available fluent helpers to apply the <b>SubItem</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> SUB_ITEM = new SubitemHierField<String>("SubItem");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItem_Text</b>
     * </p>
     *
     * @return Subitem Description
     */
    @SerializedName( "SubItem_Text" )
    @JsonProperty( "SubItem_Text" )
    @Nullable
    @ODataField( odataName = "SubItem_Text" )
    private String subItem_Text;
    /**
     * Use with available fluent helpers to apply the <b>SubItem_Text</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> SUB_ITEM_TEXT = new SubitemHierField<String>("SubItem_Text");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @return Hierarchy Sequence Number
     */
    @SerializedName( "SequenceNumber" )
    @JsonProperty( "SequenceNumber" )
    @Nullable
    @ODataField( odataName = "SequenceNumber" )
    private String sequenceNumber;
    /**
     * Use with available fluent helpers to apply the <b>SequenceNumber</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> SEQUENCE_NUMBER = new SubitemHierField<String>("SequenceNumber");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @return Hierarchy Level
     */
    @SerializedName( "HierarchyNodeLevel" )
    @JsonProperty( "HierarchyNodeLevel" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeLevel" )
    private String hierarchyNodeLevel;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeLevel</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> HIERARCHY_NODE_LEVEL =
        new SubitemHierField<String>("HierarchyNodeLevel");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static SubitemHierField<String> NODE_TYPE = new SubitemHierField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnSubitem</b> for <b>SubitemHier</b> to single <b>SubItem</b>.
     *
     */
    @SerializedName( "to_CnsldtnSubitem" )
    @JsonProperty( "to_CnsldtnSubitem" )
    @ODataField( odataName = "to_CnsldtnSubitem" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SubItem toCnsldtnSubitem;
    /**
     * Navigation property <b>to_CnsldtnSubitemHierT</b> for <b>SubitemHier</b> to multiple <b>SubitemHierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnSubitemHierT" )
    @JsonProperty( "to_CnsldtnSubitemHierT" )
    @ODataField( odataName = "to_CnsldtnSubitemHierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SubitemHierText> toCnsldtnSubitemHierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSubitem</b> navigation property to query operations.
     *
     */
    public final static SubitemHierOneToOneLink<SubItem> TO_CNSLDTN_SUBITEM =
        new SubitemHierOneToOneLink<SubItem>("to_CnsldtnSubitem");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSubitemHierT</b> navigation property to query
     * operations.
     *
     */
    public final static SubitemHierLink<SubitemHierText> TO_CNSLDTN_SUBITEM_HIER_T =
        new SubitemHierLink<SubitemHierText>("to_CnsldtnSubitemHierT");

    @Nonnull
    @Override
    public Class<SubitemHier> getType()
    {
        return SubitemHier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSubitemHierarchy</b>
     * </p>
     *
     * @param consolidationSubitemHierarchy
     *            Hierarchy ID
     */
    public void setConsolidationSubitemHierarchy( @Nullable final String consolidationSubitemHierarchy )
    {
        rememberChangedField("ConsolidationSubitemHierarchy", this.consolidationSubitemHierarchy);
        this.consolidationSubitemHierarchy = consolidationSubitemHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode_Text</b>
     * </p>
     *
     * @param hierarchyNode_Text
     *            Subitem Description
     */
    public void setHierarchyNode_Text( @Nullable final String hierarchyNode_Text )
    {
        rememberChangedField("HierarchyNode_Text", this.hierarchyNode_Text);
        this.hierarchyNode_Text = hierarchyNode_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @param subItemCategory
     *            Subitem Category
     */
    public void setSubItemCategory( @Nullable final String subItemCategory )
    {
        rememberChangedField("SubItemCategory", this.subItemCategory);
        this.subItemCategory = subItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory_Text</b>
     * </p>
     *
     * @param subItemCategory_Text
     *            Subitem Category Description
     */
    public void setSubItemCategory_Text( @Nullable final String subItemCategory_Text )
    {
        rememberChangedField("SubItemCategory_Text", this.subItemCategory_Text);
        this.subItemCategory_Text = subItemCategory_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>ParentNode</b>
     * </p>
     *
     * @param parentNode
     *            Hierarchy parent node
     */
    public void setParentNode( @Nullable final String parentNode )
    {
        rememberChangedField("ParentNode", this.parentNode);
        this.parentNode = parentNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyVersion</b>
     * </p>
     *
     * @param hierarchyVersion
     *            Hierarchy version
     */
    public void setHierarchyVersion( @Nullable final String hierarchyVersion )
    {
        rememberChangedField("HierarchyVersion", this.hierarchyVersion);
        this.hierarchyVersion = hierarchyVersion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>SubItem</b>
     * </p>
     *
     * @param subItem
     *            Subitem
     */
    public void setSubItem( @Nullable final String subItem )
    {
        rememberChangedField("SubItem", this.subItem);
        this.subItem = subItem;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItem_Text</b>
     * </p>
     *
     * @param subItem_Text
     *            Subitem Description
     */
    public void setSubItem_Text( @Nullable final String subItem_Text )
    {
        rememberChangedField("SubItem_Text", this.subItem_Text);
        this.subItem_Text = subItem_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>SequenceNumber</b>
     * </p>
     *
     * @param sequenceNumber
     *            Hierarchy Sequence Number
     */
    public void setSequenceNumber( @Nullable final String sequenceNumber )
    {
        rememberChangedField("SequenceNumber", this.sequenceNumber);
        this.sequenceNumber = sequenceNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeLevel</b>
     * </p>
     *
     * @param hierarchyNodeLevel
     *            Hierarchy Level
     */
    public void setHierarchyNodeLevel( @Nullable final String hierarchyNodeLevel )
    {
        rememberChangedField("HierarchyNodeLevel", this.hierarchyNodeLevel);
        this.hierarchyNodeLevel = hierarchyNodeLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SubitemHier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("ConsolidationSubitemHierarchy", getConsolidationSubitemHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("ConsolidationSubitemHierarchy", getConsolidationSubitemHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("HierarchyNode_Text", getHierarchyNode_Text());
        values.put("SubItemCategory", getSubItemCategory());
        values.put("SubItemCategory_Text", getSubItemCategory_Text());
        values.put("ParentNode", getParentNode());
        values.put("HierarchyVersion", getHierarchyVersion());
        values.put("SubItem", getSubItem());
        values.put("SubItem_Text", getSubItem_Text());
        values.put("SequenceNumber", getSequenceNumber());
        values.put("HierarchyNodeLevel", getHierarchyNodeLevel());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("ConsolidationSubitemHierarchy") ) {
                final Object value = values.remove("ConsolidationSubitemHierarchy");
                if( (value == null) || (!value.equals(getConsolidationSubitemHierarchy())) ) {
                    setConsolidationSubitemHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode_Text") ) {
                final Object value = values.remove("HierarchyNode_Text");
                if( (value == null) || (!value.equals(getHierarchyNode_Text())) ) {
                    setHierarchyNode_Text(((String) value));
                }
            }
            if( values.containsKey("SubItemCategory") ) {
                final Object value = values.remove("SubItemCategory");
                if( (value == null) || (!value.equals(getSubItemCategory())) ) {
                    setSubItemCategory(((String) value));
                }
            }
            if( values.containsKey("SubItemCategory_Text") ) {
                final Object value = values.remove("SubItemCategory_Text");
                if( (value == null) || (!value.equals(getSubItemCategory_Text())) ) {
                    setSubItemCategory_Text(((String) value));
                }
            }
            if( values.containsKey("ParentNode") ) {
                final Object value = values.remove("ParentNode");
                if( (value == null) || (!value.equals(getParentNode())) ) {
                    setParentNode(((String) value));
                }
            }
            if( values.containsKey("HierarchyVersion") ) {
                final Object value = values.remove("HierarchyVersion");
                if( (value == null) || (!value.equals(getHierarchyVersion())) ) {
                    setHierarchyVersion(((String) value));
                }
            }
            if( values.containsKey("SubItem") ) {
                final Object value = values.remove("SubItem");
                if( (value == null) || (!value.equals(getSubItem())) ) {
                    setSubItem(((String) value));
                }
            }
            if( values.containsKey("SubItem_Text") ) {
                final Object value = values.remove("SubItem_Text");
                if( (value == null) || (!value.equals(getSubItem_Text())) ) {
                    setSubItem_Text(((String) value));
                }
            }
            if( values.containsKey("SequenceNumber") ) {
                final Object value = values.remove("SequenceNumber");
                if( (value == null) || (!value.equals(getSequenceNumber())) ) {
                    setSequenceNumber(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeLevel") ) {
                final Object value = values.remove("HierarchyNodeLevel");
                if( (value == null) || (!value.equals(getHierarchyNodeLevel())) ) {
                    setHierarchyNodeLevel(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSubitem") ) {
                final Object value = (values).remove("to_CnsldtnSubitem");
                if( value instanceof Map ) {
                    if( toCnsldtnSubitem == null ) {
                        toCnsldtnSubitem = new SubItem();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSubitem.fromMap(inputMap);
                }
            }
            if( (values).containsKey("to_CnsldtnSubitemHierT") ) {
                final Object value = (values).remove("to_CnsldtnSubitemHierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSubitemHierT == null ) {
                        toCnsldtnSubitemHierT = Lists.newArrayList();
                    } else {
                        toCnsldtnSubitemHierT = Lists.newArrayList(toCnsldtnSubitemHierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SubitemHierText entity;
                        if( toCnsldtnSubitemHierT.size() > i ) {
                            entity = toCnsldtnSubitemHierT.get(i);
                        } else {
                            entity = new SubitemHierText();
                            toCnsldtnSubitemHierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SubitemHierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubitemHierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubitemHierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubitemHierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSubitem != null ) {
            (values).put("to_CnsldtnSubitem", toCnsldtnSubitem);
        }
        if( toCnsldtnSubitemHierT != null ) {
            (values).put("to_CnsldtnSubitemHierT", toCnsldtnSubitemHierT);
        }
        return values;
    }

    /**
     * Fetches the <b>SubItem</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSubitem</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SubItem</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SubItem fetchCnsldtnSubitem()
    {
        return fetchFieldAsSingle("to_CnsldtnSubitem", SubItem.class);
    }

    /**
     * Retrieval of associated <b>SubItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSubitem</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubitem</b> of a queried <b>SubitemHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SubItem</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SubItem getCnsldtnSubitemOrFetch()
    {
        if( toCnsldtnSubitem == null ) {
            toCnsldtnSubitem = fetchCnsldtnSubitem();
        }
        return toCnsldtnSubitem;
    }

    /**
     * Retrieval of associated <b>SubItem</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSubitem</b>.
     * <p>
     * If the navigation property for an entity <b>SubitemHier</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSubitem</b> is already loaded, the result will
     *         contain the <b>SubItem</b> entity. If not, an <code>Option</code> with result state <code>empty</code> is
     *         returned.
     */
    @Nonnull
    public Option<SubItem> getCnsldtnSubitemIfPresent()
    {
        return Option.of(toCnsldtnSubitem);
    }

    /**
     * Overwrites the associated <b>SubItem</b> entity for the loaded navigation property <b>to_CnsldtnSubitem</b>.
     *
     * @param value
     *            New <b>SubItem</b> entity.
     */
    public void setCnsldtnSubitem( final SubItem value )
    {
        toCnsldtnSubitem = value;
    }

    /**
     * Fetches the <b>SubitemHierText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnSubitemHierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SubitemHierText</b> entities. If no entities are associated
     *         then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SubitemHierText> fetchCnsldtnSubitemHierT()
    {
        return fetchFieldAsList("to_CnsldtnSubitemHierT", SubitemHierText.class);
    }

    /**
     * Retrieval of associated <b>SubitemHierText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSubitemHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubitemHierT</b> of a queried <b>SubitemHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SubitemHierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SubitemHierText> getCnsldtnSubitemHierTOrFetch()
    {
        if( toCnsldtnSubitemHierT == null ) {
            toCnsldtnSubitemHierT = fetchCnsldtnSubitemHierT();
        }
        return toCnsldtnSubitemHierT;
    }

    /**
     * Retrieval of associated <b>SubitemHierText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSubitemHierT</b>.
     * <p>
     * If the navigation property for an entity <b>SubitemHier</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSubitemHierT</b> is already loaded, the result
     *         will contain the <b>SubitemHierText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SubitemHierText>> getCnsldtnSubitemHierTIfPresent()
    {
        return Option.of(toCnsldtnSubitemHierT);
    }

    /**
     * Overwrites the list of associated <b>SubitemHierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnSubitemHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubitemHierT</b> of a queried <b>SubitemHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SubitemHierText</b> entities.
     */
    public void setCnsldtnSubitemHierT( @Nonnull final List<SubitemHierText> value )
    {
        if( toCnsldtnSubitemHierT == null ) {
            toCnsldtnSubitemHierT = Lists.newArrayList();
        }
        toCnsldtnSubitemHierT.clear();
        toCnsldtnSubitemHierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SubitemHierText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnSubitemHierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubitemHierT</b> of a queried <b>SubitemHier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SubitemHierText</b> entities.
     */
    public void addCnsldtnSubitemHierT( SubitemHierText... entity )
    {
        if( toCnsldtnSubitemHierT == null ) {
            toCnsldtnSubitemHierT = Lists.newArrayList();
        }
        toCnsldtnSubitemHierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of SubitemHier instances.
     *
     */
    public final static class SubitemHierBuilder
    {

        private SubItem toCnsldtnSubitem;
        private List<SubitemHierText> toCnsldtnSubitemHierT = Lists.newArrayList();

        private SubitemHier.SubitemHierBuilder toCnsldtnSubitem( final SubItem value )
        {
            toCnsldtnSubitem = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSubitem</b> for <b>SubitemHier</b> to single <b>SubItem</b>.
         *
         * @param value
         *            The SubItem to build this SubitemHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SubitemHier.SubitemHierBuilder cnsldtnSubitem( final SubItem value )
        {
            return toCnsldtnSubitem(value);
        }

        private SubitemHier.SubitemHierBuilder toCnsldtnSubitemHierT( final List<SubitemHierText> value )
        {
            toCnsldtnSubitemHierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSubitemHierT</b> for <b>SubitemHier</b> to multiple <b>SubitemHierText</b>.
         *
         * @param value
         *            The SubitemHierTexts to build this SubitemHier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SubitemHier.SubitemHierBuilder cnsldtnSubitemHierT( SubitemHierText... value )
        {
            return toCnsldtnSubitemHierT(Lists.newArrayList(value));
        }

    }

}
