/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SubitemHierTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SubitemHierTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SubitemHierTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Subitem Hierarchy Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SubitemHierTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SubitemHierText extends VdmEntity<SubitemHierText>
{

    /**
     * Selector for all available fields of SubitemHierText.
     *
     */
    public final static SubitemHierTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SubitemHierTextField<String> LANGUAGE = new SubitemHierTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSubitemHierarchy</b>
     * </p>
     *
     * @return Hierarchy ID
     */
    @Key
    @SerializedName( "ConsolidationSubitemHierarchy" )
    @JsonProperty( "ConsolidationSubitemHierarchy" )
    @Nullable
    @ODataField( odataName = "ConsolidationSubitemHierarchy" )
    private String consolidationSubitemHierarchy;
    /**
     * Use with available fluent helpers to apply the <b>ConsolidationSubitemHierarchy</b> field to query operations.
     *
     */
    public final static SubitemHierTextField<String> CONSOLIDATION_SUBITEM_HIERARCHY =
        new SubitemHierTextField<String>("ConsolidationSubitemHierarchy");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @return Hierarchy node
     */
    @Key
    @SerializedName( "HierarchyNode" )
    @JsonProperty( "HierarchyNode" )
    @Nullable
    @ODataField( odataName = "HierarchyNode" )
    private String hierarchyNode;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNode</b> field to query operations.
     *
     */
    public final static SubitemHierTextField<String> HIERARCHY_NODE = new SubitemHierTextField<String>("HierarchyNode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @return Subitem Category
     */
    @SerializedName( "SubItemCategory" )
    @JsonProperty( "SubItemCategory" )
    @Nullable
    @ODataField( odataName = "SubItemCategory" )
    private String subItemCategory;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory</b> field to query operations.
     *
     */
    public final static SubitemHierTextField<String> SUB_ITEM_CATEGORY =
        new SubitemHierTextField<String>("SubItemCategory");
    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory_Text</b>
     * </p>
     *
     * @return Subitem Category Description
     */
    @SerializedName( "SubItemCategory_Text" )
    @JsonProperty( "SubItemCategory_Text" )
    @Nullable
    @ODataField( odataName = "SubItemCategory_Text" )
    private String subItemCategory_Text;
    /**
     * Use with available fluent helpers to apply the <b>SubItemCategory_Text</b> field to query operations.
     *
     */
    public final static SubitemHierTextField<String> SUB_ITEM_CATEGORY_TEXT =
        new SubitemHierTextField<String>("SubItemCategory_Text");
    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @return Hierarchy node description
     */
    @SerializedName( "HierarchyNodeText" )
    @JsonProperty( "HierarchyNodeText" )
    @Nullable
    @ODataField( odataName = "HierarchyNodeText" )
    private String hierarchyNodeText;
    /**
     * Use with available fluent helpers to apply the <b>HierarchyNodeText</b> field to query operations.
     *
     */
    public final static SubitemHierTextField<String> HIERARCHY_NODE_TEXT =
        new SubitemHierTextField<String>("HierarchyNodeText");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @return Hierarchy node type
     */
    @SerializedName( "NodeType" )
    @JsonProperty( "NodeType" )
    @Nullable
    @ODataField( odataName = "NodeType" )
    private String nodeType;
    /**
     * Use with available fluent helpers to apply the <b>NodeType</b> field to query operations.
     *
     */
    public final static SubitemHierTextField<String> NODE_TYPE = new SubitemHierTextField<String>("NodeType");
    /**
     * Navigation property <b>to_CnsldtnSubitemHier</b> for <b>SubitemHierText</b> to single <b>SubitemHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnSubitemHier" )
    @JsonProperty( "to_CnsldtnSubitemHier" )
    @ODataField( odataName = "to_CnsldtnSubitemHier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private SubitemHier toCnsldtnSubitemHier;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSubitemHier</b> navigation property to query
     * operations.
     *
     */
    public final static SubitemHierTextOneToOneLink<SubitemHier> TO_CNSLDTN_SUBITEM_HIER =
        new SubitemHierTextOneToOneLink<SubitemHier>("to_CnsldtnSubitemHier");

    @Nonnull
    @Override
    public Class<SubitemHierText> getType()
    {
        return SubitemHierText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 42
     * <p>
     * Original property name from the Odata EDM: <b>ConsolidationSubitemHierarchy</b>
     * </p>
     *
     * @param consolidationSubitemHierarchy
     *            Hierarchy ID
     */
    public void setConsolidationSubitemHierarchy( @Nullable final String consolidationSubitemHierarchy )
    {
        rememberChangedField("ConsolidationSubitemHierarchy", this.consolidationSubitemHierarchy);
        this.consolidationSubitemHierarchy = consolidationSubitemHierarchy;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNode</b>
     * </p>
     *
     * @param hierarchyNode
     *            Hierarchy node
     */
    public void setHierarchyNode( @Nullable final String hierarchyNode )
    {
        rememberChangedField("HierarchyNode", this.hierarchyNode);
        this.hierarchyNode = hierarchyNode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory</b>
     * </p>
     *
     * @param subItemCategory
     *            Subitem Category
     */
    public void setSubItemCategory( @Nullable final String subItemCategory )
    {
        rememberChangedField("SubItemCategory", this.subItemCategory);
        this.subItemCategory = subItemCategory;
    }

    /**
     * Constraints: Not nullable, Maximum length: 30
     * <p>
     * Original property name from the Odata EDM: <b>SubItemCategory_Text</b>
     * </p>
     *
     * @param subItemCategory_Text
     *            Subitem Category Description
     */
    public void setSubItemCategory_Text( @Nullable final String subItemCategory_Text )
    {
        rememberChangedField("SubItemCategory_Text", this.subItemCategory_Text);
        this.subItemCategory_Text = subItemCategory_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 50
     * <p>
     * Original property name from the Odata EDM: <b>HierarchyNodeText</b>
     * </p>
     *
     * @param hierarchyNodeText
     *            Hierarchy node description
     */
    public void setHierarchyNodeText( @Nullable final String hierarchyNodeText )
    {
        rememberChangedField("HierarchyNodeText", this.hierarchyNodeText);
        this.hierarchyNodeText = hierarchyNodeText;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>NodeType</b>
     * </p>
     *
     * @param nodeType
     *            Hierarchy node type
     */
    public void setNodeType( @Nullable final String nodeType )
    {
        rememberChangedField("NodeType", this.nodeType);
        this.nodeType = nodeType;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SubitemHierText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("ConsolidationSubitemHierarchy", getConsolidationSubitemHierarchy());
        result.put("HierarchyNode", getHierarchyNode());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("ConsolidationSubitemHierarchy", getConsolidationSubitemHierarchy());
        values.put("HierarchyNode", getHierarchyNode());
        values.put("SubItemCategory", getSubItemCategory());
        values.put("SubItemCategory_Text", getSubItemCategory_Text());
        values.put("HierarchyNodeText", getHierarchyNodeText());
        values.put("NodeType", getNodeType());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("ConsolidationSubitemHierarchy") ) {
                final Object value = values.remove("ConsolidationSubitemHierarchy");
                if( (value == null) || (!value.equals(getConsolidationSubitemHierarchy())) ) {
                    setConsolidationSubitemHierarchy(((String) value));
                }
            }
            if( values.containsKey("HierarchyNode") ) {
                final Object value = values.remove("HierarchyNode");
                if( (value == null) || (!value.equals(getHierarchyNode())) ) {
                    setHierarchyNode(((String) value));
                }
            }
            if( values.containsKey("SubItemCategory") ) {
                final Object value = values.remove("SubItemCategory");
                if( (value == null) || (!value.equals(getSubItemCategory())) ) {
                    setSubItemCategory(((String) value));
                }
            }
            if( values.containsKey("SubItemCategory_Text") ) {
                final Object value = values.remove("SubItemCategory_Text");
                if( (value == null) || (!value.equals(getSubItemCategory_Text())) ) {
                    setSubItemCategory_Text(((String) value));
                }
            }
            if( values.containsKey("HierarchyNodeText") ) {
                final Object value = values.remove("HierarchyNodeText");
                if( (value == null) || (!value.equals(getHierarchyNodeText())) ) {
                    setHierarchyNodeText(((String) value));
                }
            }
            if( values.containsKey("NodeType") ) {
                final Object value = values.remove("NodeType");
                if( (value == null) || (!value.equals(getNodeType())) ) {
                    setNodeType(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSubitemHier") ) {
                final Object value = (values).remove("to_CnsldtnSubitemHier");
                if( value instanceof Map ) {
                    if( toCnsldtnSubitemHier == null ) {
                        toCnsldtnSubitemHier = new SubitemHier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSubitemHier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> SubitemHierTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SubitemHierTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SubitemHierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SubitemHierTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSubitemHier != null ) {
            (values).put("to_CnsldtnSubitemHier", toCnsldtnSubitemHier);
        }
        return values;
    }

    /**
     * Fetches the <b>SubitemHier</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSubitemHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>SubitemHier</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SubitemHier fetchCnsldtnSubitemHier()
    {
        return fetchFieldAsSingle("to_CnsldtnSubitemHier", SubitemHier.class);
    }

    /**
     * Retrieval of associated <b>SubitemHier</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSubitemHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSubitemHier</b> of a queried <b>SubitemHierText</b> is operated lazily,
     * an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SubitemHier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public SubitemHier getCnsldtnSubitemHierOrFetch()
    {
        if( toCnsldtnSubitemHier == null ) {
            toCnsldtnSubitemHier = fetchCnsldtnSubitemHier();
        }
        return toCnsldtnSubitemHier;
    }

    /**
     * Retrieval of associated <b>SubitemHier</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSubitemHier</b>.
     * <p>
     * If the navigation property for an entity <b>SubitemHierText</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSubitemHier</b> is already loaded, the result
     *         will contain the <b>SubitemHier</b> entity. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<SubitemHier> getCnsldtnSubitemHierIfPresent()
    {
        return Option.of(toCnsldtnSubitemHier);
    }

    /**
     * Overwrites the associated <b>SubitemHier</b> entity for the loaded navigation property
     * <b>to_CnsldtnSubitemHier</b>.
     *
     * @param value
     *            New <b>SubitemHier</b> entity.
     */
    public void setCnsldtnSubitemHier( final SubitemHier value )
    {
        toCnsldtnSubitemHier = value;
    }

    /**
     * Helper class to allow for fluent creation of SubitemHierText instances.
     *
     */
    public final static class SubitemHierTextBuilder
    {

        private SubitemHier toCnsldtnSubitemHier;

        private SubitemHierText.SubitemHierTextBuilder toCnsldtnSubitemHier( final SubitemHier value )
        {
            toCnsldtnSubitemHier = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSubitemHier</b> for <b>SubitemHierText</b> to single <b>SubitemHier</b>.
         *
         * @param value
         *            The SubitemHier to build this SubitemHierText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SubitemHierText.SubitemHierTextBuilder cnsldtnSubitemHier( final SubitemHier value )
        {
            return toCnsldtnSubitemHier(value);
        }

    }

}
