/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SupplierField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SupplierLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SupplierSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Supplier
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SupplierType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class Supplier extends VdmEntity<Supplier>
{

    /**
     * Selector for all available fields of Supplier.
     *
     */
    public final static SupplierSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @Key
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SupplierField<String> SUPPLIER = new SupplierField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Supplier_Text</b>
     * </p>
     *
     * @return Supplier Description
     */
    @SerializedName( "Supplier_Text" )
    @JsonProperty( "Supplier_Text" )
    @Nullable
    @ODataField( odataName = "Supplier_Text" )
    private String supplier_Text;
    /**
     * Use with available fluent helpers to apply the <b>Supplier_Text</b> field to query operations.
     *
     */
    public final static SupplierField<String> SUPPLIER_TEXT = new SupplierField<String>("Supplier_Text");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Consolidation Additional Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static SupplierField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new SupplierField<String>("AdditionalMasterDataSource");
    /**
     * Navigation property <b>to_CnsldtnSupplierHier</b> for <b>Supplier</b> to multiple <b>SupplierHier</b>.
     *
     */
    @SerializedName( "to_CnsldtnSupplierHier" )
    @JsonProperty( "to_CnsldtnSupplierHier" )
    @ODataField( odataName = "to_CnsldtnSupplierHier" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupplierHier> toCnsldtnSupplierHier;
    /**
     * Navigation property <b>to_CnsldtnSupplierT</b> for <b>Supplier</b> to multiple <b>SupplierText</b>.
     *
     */
    @SerializedName( "to_CnsldtnSupplierT" )
    @JsonProperty( "to_CnsldtnSupplierT" )
    @ODataField( odataName = "to_CnsldtnSupplierT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<SupplierText> toCnsldtnSupplierT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSupplierHier</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierLink<SupplierHier> TO_CNSLDTN_SUPPLIER_HIER =
        new SupplierLink<SupplierHier>("to_CnsldtnSupplierHier");
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSupplierT</b> navigation property to query
     * operations.
     *
     */
    public final static SupplierLink<SupplierText> TO_CNSLDTN_SUPPLIER_T =
        new SupplierLink<SupplierText>("to_CnsldtnSupplierT");

    @Nonnull
    @Override
    public Class<Supplier> getType()
    {
        return Supplier.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>Supplier_Text</b>
     * </p>
     *
     * @param supplier_Text
     *            Supplier Description
     */
    public void setSupplier_Text( @Nullable final String supplier_Text )
    {
        rememberChangedField("Supplier_Text", this.supplier_Text);
        this.supplier_Text = supplier_Text;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Consolidation Additional Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    @Override
    protected String getEntityCollection()
    {
        return "Supplier";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Supplier", getSupplier());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Supplier", getSupplier());
        values.put("Supplier_Text", getSupplier_Text());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("Supplier_Text") ) {
                final Object value = values.remove("Supplier_Text");
                if( (value == null) || (!value.equals(getSupplier_Text())) ) {
                    setSupplier_Text(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSupplierHier") ) {
                final Object value = (values).remove("to_CnsldtnSupplierHier");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSupplierHier == null ) {
                        toCnsldtnSupplierHier = Lists.newArrayList();
                    } else {
                        toCnsldtnSupplierHier = Lists.newArrayList(toCnsldtnSupplierHier);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupplierHier entity;
                        if( toCnsldtnSupplierHier.size() > i ) {
                            entity = toCnsldtnSupplierHier.get(i);
                        } else {
                            entity = new SupplierHier();
                            toCnsldtnSupplierHier.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
            if( (values).containsKey("to_CnsldtnSupplierT") ) {
                final Object value = (values).remove("to_CnsldtnSupplierT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnSupplierT == null ) {
                        toCnsldtnSupplierT = Lists.newArrayList();
                    } else {
                        toCnsldtnSupplierT = Lists.newArrayList(toCnsldtnSupplierT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        SupplierText entity;
                        if( toCnsldtnSupplierT.size() > i ) {
                            entity = toCnsldtnSupplierT.get(i);
                        } else {
                            entity = new SupplierText();
                            toCnsldtnSupplierT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SupplierField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSupplierHier != null ) {
            (values).put("to_CnsldtnSupplierHier", toCnsldtnSupplierHier);
        }
        if( toCnsldtnSupplierT != null ) {
            (values).put("to_CnsldtnSupplierT", toCnsldtnSupplierT);
        }
        return values;
    }

    /**
     * Fetches the <b>SupplierHier</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSupplierHier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SupplierHier</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierHier> fetchCnsldtnSupplierHier()
    {
        return fetchFieldAsList("to_CnsldtnSupplierHier", SupplierHier.class);
    }

    /**
     * Retrieval of associated <b>SupplierHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSupplierHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSupplierHier</b> of a queried <b>Supplier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SupplierHier</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierHier> getCnsldtnSupplierHierOrFetch()
    {
        if( toCnsldtnSupplierHier == null ) {
            toCnsldtnSupplierHier = fetchCnsldtnSupplierHier();
        }
        return toCnsldtnSupplierHier;
    }

    /**
     * Retrieval of associated <b>SupplierHier</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSupplierHier</b>.
     * <p>
     * If the navigation property for an entity <b>Supplier</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSupplierHier</b> is already loaded, the result
     *         will contain the <b>SupplierHier</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupplierHier>> getCnsldtnSupplierHierIfPresent()
    {
        return Option.of(toCnsldtnSupplierHier);
    }

    /**
     * Overwrites the list of associated <b>SupplierHier</b> entities for the loaded navigation property
     * <b>to_CnsldtnSupplierHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSupplierHier</b> of a queried <b>Supplier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SupplierHier</b> entities.
     */
    public void setCnsldtnSupplierHier( @Nonnull final List<SupplierHier> value )
    {
        if( toCnsldtnSupplierHier == null ) {
            toCnsldtnSupplierHier = Lists.newArrayList();
        }
        toCnsldtnSupplierHier.clear();
        toCnsldtnSupplierHier.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupplierHier</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnSupplierHier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSupplierHier</b> of a queried <b>Supplier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SupplierHier</b> entities.
     */
    public void addCnsldtnSupplierHier( SupplierHier... entity )
    {
        if( toCnsldtnSupplierHier == null ) {
            toCnsldtnSupplierHier = Lists.newArrayList();
        }
        toCnsldtnSupplierHier.addAll(Lists.newArrayList(entity));
    }

    /**
     * Fetches the <b>SupplierText</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSupplierT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>SupplierText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierText> fetchCnsldtnSupplierT()
    {
        return fetchFieldAsList("to_CnsldtnSupplierT", SupplierText.class);
    }

    /**
     * Retrieval of associated <b>SupplierText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSupplierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSupplierT</b> of a queried <b>Supplier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>SupplierText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<SupplierText> getCnsldtnSupplierTOrFetch()
    {
        if( toCnsldtnSupplierT == null ) {
            toCnsldtnSupplierT = fetchCnsldtnSupplierT();
        }
        return toCnsldtnSupplierT;
    }

    /**
     * Retrieval of associated <b>SupplierText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnSupplierT</b>.
     * <p>
     * If the navigation property for an entity <b>Supplier</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSupplierT</b> is already loaded, the result will
     *         contain the <b>SupplierText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<SupplierText>> getCnsldtnSupplierTIfPresent()
    {
        return Option.of(toCnsldtnSupplierT);
    }

    /**
     * Overwrites the list of associated <b>SupplierText</b> entities for the loaded navigation property
     * <b>to_CnsldtnSupplierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSupplierT</b> of a queried <b>Supplier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>SupplierText</b> entities.
     */
    public void setCnsldtnSupplierT( @Nonnull final List<SupplierText> value )
    {
        if( toCnsldtnSupplierT == null ) {
            toCnsldtnSupplierT = Lists.newArrayList();
        }
        toCnsldtnSupplierT.clear();
        toCnsldtnSupplierT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>SupplierText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnSupplierT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSupplierT</b> of a queried <b>Supplier</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>SupplierText</b> entities.
     */
    public void addCnsldtnSupplierT( SupplierText... entity )
    {
        if( toCnsldtnSupplierT == null ) {
            toCnsldtnSupplierT = Lists.newArrayList();
        }
        toCnsldtnSupplierT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of Supplier instances.
     *
     */
    public final static class SupplierBuilder
    {

        private List<SupplierHier> toCnsldtnSupplierHier = Lists.newArrayList();
        private List<SupplierText> toCnsldtnSupplierT = Lists.newArrayList();

        private Supplier.SupplierBuilder toCnsldtnSupplierHier( final List<SupplierHier> value )
        {
            toCnsldtnSupplierHier.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSupplierHier</b> for <b>Supplier</b> to multiple <b>SupplierHier</b>.
         *
         * @param value
         *            The SupplierHiers to build this Supplier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Supplier.SupplierBuilder cnsldtnSupplierHier( SupplierHier... value )
        {
            return toCnsldtnSupplierHier(Lists.newArrayList(value));
        }

        private Supplier.SupplierBuilder toCnsldtnSupplierT( final List<SupplierText> value )
        {
            toCnsldtnSupplierT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSupplierT</b> for <b>Supplier</b> to multiple <b>SupplierText</b>.
         *
         * @param value
         *            The SupplierTexts to build this Supplier with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public Supplier.SupplierBuilder cnsldtnSupplierT( SupplierText... value )
        {
            return toCnsldtnSupplierT(Lists.newArrayList(value));
        }

    }

}
