/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.SupplierTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.SupplierTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.SupplierTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined Supplier Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>SupplierTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class SupplierText extends VdmEntity<SupplierText>
{

    /**
     * Selector for all available fields of SupplierText.
     *
     */
    public final static SupplierTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static SupplierTextField<String> LANGUAGE = new SupplierTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @return Supplier
     */
    @Key
    @SerializedName( "Supplier" )
    @JsonProperty( "Supplier" )
    @Nullable
    @ODataField( odataName = "Supplier" )
    private String supplier;
    /**
     * Use with available fluent helpers to apply the <b>Supplier</b> field to query operations.
     *
     */
    public final static SupplierTextField<String> SUPPLIER = new SupplierTextField<String>("Supplier");
    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSupplierText</b>
     * </p>
     *
     * @return Supplier Description
     */
    @SerializedName( "CnsldtnSupplierText" )
    @JsonProperty( "CnsldtnSupplierText" )
    @Nullable
    @ODataField( odataName = "CnsldtnSupplierText" )
    private String cnsldtnSupplierText;
    /**
     * Use with available fluent helpers to apply the <b>CnsldtnSupplierText</b> field to query operations.
     *
     */
    public final static SupplierTextField<String> CNSLDTN_SUPPLIER_TEXT =
        new SupplierTextField<String>("CnsldtnSupplierText");
    /**
     * Navigation property <b>to_CnsldtnSupplier</b> for <b>SupplierText</b> to single <b>Supplier</b>.
     *
     */
    @SerializedName( "to_CnsldtnSupplier" )
    @JsonProperty( "to_CnsldtnSupplier" )
    @ODataField( odataName = "to_CnsldtnSupplier" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private Supplier toCnsldtnSupplier;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnSupplier</b> navigation property to query operations.
     *
     */
    public final static SupplierTextOneToOneLink<Supplier> TO_CNSLDTN_SUPPLIER =
        new SupplierTextOneToOneLink<Supplier>("to_CnsldtnSupplier");

    @Nonnull
    @Override
    public Class<SupplierText> getType()
    {
        return SupplierText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Supplier</b>
     * </p>
     *
     * @param supplier
     *            Supplier
     */
    public void setSupplier( @Nullable final String supplier )
    {
        rememberChangedField("Supplier", this.supplier);
        this.supplier = supplier;
    }

    /**
     * Constraints: Not nullable, Maximum length: 80
     * <p>
     * Original property name from the Odata EDM: <b>CnsldtnSupplierText</b>
     * </p>
     *
     * @param cnsldtnSupplierText
     *            Supplier Description
     */
    public void setCnsldtnSupplierText( @Nullable final String cnsldtnSupplierText )
    {
        rememberChangedField("CnsldtnSupplierText", this.cnsldtnSupplierText);
        this.cnsldtnSupplierText = cnsldtnSupplierText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "SupplierText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Supplier", getSupplier());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Supplier", getSupplier());
        values.put("CnsldtnSupplierText", getCnsldtnSupplierText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Supplier") ) {
                final Object value = values.remove("Supplier");
                if( (value == null) || (!value.equals(getSupplier())) ) {
                    setSupplier(((String) value));
                }
            }
            if( values.containsKey("CnsldtnSupplierText") ) {
                final Object value = values.remove("CnsldtnSupplierText");
                if( (value == null) || (!value.equals(getCnsldtnSupplierText())) ) {
                    setCnsldtnSupplierText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnSupplier") ) {
                final Object value = (values).remove("to_CnsldtnSupplier");
                if( value instanceof Map ) {
                    if( toCnsldtnSupplier == null ) {
                        toCnsldtnSupplier = new Supplier();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnSupplier.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> SupplierTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new SupplierTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> SupplierTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new SupplierTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnSupplier != null ) {
            (values).put("to_CnsldtnSupplier", toCnsldtnSupplier);
        }
        return values;
    }

    /**
     * Fetches the <b>Supplier</b> entity (one to one) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnSupplier</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>Supplier</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Supplier fetchCnsldtnSupplier()
    {
        return fetchFieldAsSingle("to_CnsldtnSupplier", Supplier.class);
    }

    /**
     * Retrieval of associated <b>Supplier</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSupplier</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnSupplier</b> of a queried <b>SupplierText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>Supplier</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public Supplier getCnsldtnSupplierOrFetch()
    {
        if( toCnsldtnSupplier == null ) {
            toCnsldtnSupplier = fetchCnsldtnSupplier();
        }
        return toCnsldtnSupplier;
    }

    /**
     * Retrieval of associated <b>Supplier</b> entity (one to one). This corresponds to the OData navigation property
     * <b>to_CnsldtnSupplier</b>.
     * <p>
     * If the navigation property for an entity <b>SupplierText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnSupplier</b> is already loaded, the result will
     *         contain the <b>Supplier</b> entity. If not, an <code>Option</code> with result state <code>empty</code>
     *         is returned.
     */
    @Nonnull
    public Option<Supplier> getCnsldtnSupplierIfPresent()
    {
        return Option.of(toCnsldtnSupplier);
    }

    /**
     * Overwrites the associated <b>Supplier</b> entity for the loaded navigation property <b>to_CnsldtnSupplier</b>.
     *
     * @param value
     *            New <b>Supplier</b> entity.
     */
    public void setCnsldtnSupplier( final Supplier value )
    {
        toCnsldtnSupplier = value;
    }

    /**
     * Helper class to allow for fluent creation of SupplierText instances.
     *
     */
    public final static class SupplierTextBuilder
    {

        private Supplier toCnsldtnSupplier;

        private SupplierText.SupplierTextBuilder toCnsldtnSupplier( final Supplier value )
        {
            toCnsldtnSupplier = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnSupplier</b> for <b>SupplierText</b> to single <b>Supplier</b>.
         *
         * @param value
         *            The Supplier to build this SupplierText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public SupplierText.SupplierTextBuilder cnsldtnSupplier( final Supplier value )
        {
            return toCnsldtnSupplier(value);
        }

    }

}
