/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.TransactionCurrencyField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.TransactionCurrencyLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.TransactionCurrencySelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Transaction Currency
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TransactionCurrencyType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TransactionCurrency extends VdmEntity<TransactionCurrency>
{

    /**
     * Selector for all available fields of TransactionCurrency.
     *
     */
    public final static TransactionCurrencySelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @Key
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static TransactionCurrencyField<String> CURRENCY = new TransactionCurrencyField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Currency_Text</b>
     * </p>
     *
     * @return Transaction Currency Description
     */
    @SerializedName( "Currency_Text" )
    @JsonProperty( "Currency_Text" )
    @Nullable
    @ODataField( odataName = "Currency_Text" )
    private String currency_Text;
    /**
     * Use with available fluent helpers to apply the <b>Currency_Text</b> field to query operations.
     *
     */
    public final static TransactionCurrencyField<String> CURRENCY_TEXT =
        new TransactionCurrencyField<String>("Currency_Text");
    /**
     * Navigation property <b>to_CnsldtnTransCurrencyT</b> for <b>TransactionCurrency</b> to multiple
     * <b>TransactionCurrencyText</b>.
     *
     */
    @SerializedName( "to_CnsldtnTransCurrencyT" )
    @JsonProperty( "to_CnsldtnTransCurrencyT" )
    @ODataField( odataName = "to_CnsldtnTransCurrencyT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<TransactionCurrencyText> toCnsldtnTransCurrencyT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnTransCurrencyT</b> navigation property to query
     * operations.
     *
     */
    public final static TransactionCurrencyLink<TransactionCurrencyText> TO_CNSLDTN_TRANS_CURRENCY_T =
        new TransactionCurrencyLink<TransactionCurrencyText>("to_CnsldtnTransCurrencyT");

    @Nonnull
    @Override
    public Class<TransactionCurrency> getType()
    {
        return TransactionCurrency.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>Currency_Text</b>
     * </p>
     *
     * @param currency_Text
     *            Transaction Currency Description
     */
    public void setCurrency_Text( @Nullable final String currency_Text )
    {
        rememberChangedField("Currency_Text", this.currency_Text);
        this.currency_Text = currency_Text;
    }

    @Override
    protected String getEntityCollection()
    {
        return "TransactionCurrency";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Currency", getCurrency());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Currency", getCurrency());
        values.put("Currency_Text", getCurrency_Text());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("Currency_Text") ) {
                final Object value = values.remove("Currency_Text");
                if( (value == null) || (!value.equals(getCurrency_Text())) ) {
                    setCurrency_Text(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnTransCurrencyT") ) {
                final Object value = (values).remove("to_CnsldtnTransCurrencyT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnTransCurrencyT == null ) {
                        toCnsldtnTransCurrencyT = Lists.newArrayList();
                    } else {
                        toCnsldtnTransCurrencyT = Lists.newArrayList(toCnsldtnTransCurrencyT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        TransactionCurrencyText entity;
                        if( toCnsldtnTransCurrencyT.size() > i ) {
                            entity = toCnsldtnTransCurrencyT.get(i);
                        } else {
                            entity = new TransactionCurrencyText();
                            toCnsldtnTransCurrencyT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> TransactionCurrencyField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TransactionCurrencyField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TransactionCurrencyField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TransactionCurrencyField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnTransCurrencyT != null ) {
            (values).put("to_CnsldtnTransCurrencyT", toCnsldtnTransCurrencyT);
        }
        return values;
    }

    /**
     * Fetches the <b>TransactionCurrencyText</b> entities (one to many) associated with this entity. This corresponds
     * to the OData navigation property <b>to_CnsldtnTransCurrencyT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>TransactionCurrencyText</b> entities. If no entities are
     *         associated then an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<TransactionCurrencyText> fetchCnsldtnTransCurrencyT()
    {
        return fetchFieldAsList("to_CnsldtnTransCurrencyT", TransactionCurrencyText.class);
    }

    /**
     * Retrieval of associated <b>TransactionCurrencyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnTransCurrencyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnTransCurrencyT</b> of a queried <b>TransactionCurrency</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>TransactionCurrencyText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<TransactionCurrencyText> getCnsldtnTransCurrencyTOrFetch()
    {
        if( toCnsldtnTransCurrencyT == null ) {
            toCnsldtnTransCurrencyT = fetchCnsldtnTransCurrencyT();
        }
        return toCnsldtnTransCurrencyT;
    }

    /**
     * Retrieval of associated <b>TransactionCurrencyText</b> entities (one to many). This corresponds to the OData
     * navigation property <b>to_CnsldtnTransCurrencyT</b>.
     * <p>
     * If the navigation property for an entity <b>TransactionCurrency</b> has not been resolved yet, this method will
     * <b>not query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnTransCurrencyT</b> is already loaded, the result
     *         will contain the <b>TransactionCurrencyText</b> entities. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<TransactionCurrencyText>> getCnsldtnTransCurrencyTIfPresent()
    {
        return Option.of(toCnsldtnTransCurrencyT);
    }

    /**
     * Overwrites the list of associated <b>TransactionCurrencyText</b> entities for the loaded navigation property
     * <b>to_CnsldtnTransCurrencyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnTransCurrencyT</b> of a queried <b>TransactionCurrency</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>TransactionCurrencyText</b> entities.
     */
    public void setCnsldtnTransCurrencyT( @Nonnull final List<TransactionCurrencyText> value )
    {
        if( toCnsldtnTransCurrencyT == null ) {
            toCnsldtnTransCurrencyT = Lists.newArrayList();
        }
        toCnsldtnTransCurrencyT.clear();
        toCnsldtnTransCurrencyT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>TransactionCurrencyText</b> entities. This corresponds to the OData
     * navigation property <b>to_CnsldtnTransCurrencyT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnTransCurrencyT</b> of a queried <b>TransactionCurrency</b> is operated
     * lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>TransactionCurrencyText</b> entities.
     */
    public void addCnsldtnTransCurrencyT( TransactionCurrencyText... entity )
    {
        if( toCnsldtnTransCurrencyT == null ) {
            toCnsldtnTransCurrencyT = Lists.newArrayList();
        }
        toCnsldtnTransCurrencyT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of TransactionCurrency instances.
     *
     */
    public final static class TransactionCurrencyBuilder
    {

        private List<TransactionCurrencyText> toCnsldtnTransCurrencyT = Lists.newArrayList();

        private TransactionCurrency.TransactionCurrencyBuilder toCnsldtnTransCurrencyT(
            final List<TransactionCurrencyText> value )
        {
            toCnsldtnTransCurrencyT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnTransCurrencyT</b> for <b>TransactionCurrency</b> to multiple
         * <b>TransactionCurrencyText</b>.
         *
         * @param value
         *            The TransactionCurrencyTexts to build this TransactionCurrency with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TransactionCurrency.TransactionCurrencyBuilder cnsldtnTransCurrencyT( TransactionCurrencyText... value )
        {
            return toCnsldtnTransCurrencyT(Lists.newArrayList(value));
        }

    }

}
