/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.TransactionCurrencySelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.TransactionCurrency
 * TransactionCurrency} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class TransactionCurrencyByKeyFluentHelper
    extends
    FluentHelperByKey<TransactionCurrencyByKeyFluentHelper, TransactionCurrency, TransactionCurrencySelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.TransactionCurrency
     * TransactionCurrency} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code TransactionCurrency}
     * @param servicePath
     *            Service path to be used to fetch a single {@code TransactionCurrency}
     * @param currency
     *            Currency Key
     *            <p>
     *            Constraints: Not nullable, Maximum length: 5
     *            </p>
     */
    public TransactionCurrencyByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String currency )
    {
        super(servicePath, entityCollection);
        this.key.put("Currency", currency);
    }

    @Override
    @Nonnull
    protected Class<TransactionCurrency> getEntityClass()
    {
        return TransactionCurrency.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
