/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.TransactionCurrencyTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.TransactionCurrencyTextOneToOneLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.TransactionCurrencyTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Transaction Currency - Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>TransactionCurrencyTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class TransactionCurrencyText extends VdmEntity<TransactionCurrencyText>
{

    /**
     * Selector for all available fields of TransactionCurrencyText.
     *
     */
    public final static TransactionCurrencyTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static TransactionCurrencyTextField<String> LANGUAGE =
        new TransactionCurrencyTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return Currency Key
     */
    @Key
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static TransactionCurrencyTextField<String> CURRENCY =
        new TransactionCurrencyTextField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrencyText</b>
     * </p>
     *
     * @return Transaction Currency Description
     */
    @SerializedName( "TransactionCurrencyText" )
    @JsonProperty( "TransactionCurrencyText" )
    @Nullable
    @ODataField( odataName = "TransactionCurrencyText" )
    private String transactionCurrencyText;
    /**
     * Use with available fluent helpers to apply the <b>TransactionCurrencyText</b> field to query operations.
     *
     */
    public final static TransactionCurrencyTextField<String> TRANSACTION_CURRENCY_TEXT =
        new TransactionCurrencyTextField<String>("TransactionCurrencyText");
    /**
     * Navigation property <b>to_CnsldtnTransactionCurrency</b> for <b>TransactionCurrencyText</b> to single
     * <b>TransactionCurrency</b>.
     *
     */
    @SerializedName( "to_CnsldtnTransactionCurrency" )
    @JsonProperty( "to_CnsldtnTransactionCurrency" )
    @ODataField( odataName = "to_CnsldtnTransactionCurrency" )
    @Nullable
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private TransactionCurrency toCnsldtnTransactionCurrency;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnTransactionCurrency</b> navigation property to query
     * operations.
     *
     */
    public final static TransactionCurrencyTextOneToOneLink<TransactionCurrency> TO_CNSLDTN_TRANSACTION_CURRENCY =
        new TransactionCurrencyTextOneToOneLink<TransactionCurrency>("to_CnsldtnTransactionCurrency");

    @Nonnull
    @Override
    public Class<TransactionCurrencyText> getType()
    {
        return TransactionCurrencyText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            Currency Key
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>TransactionCurrencyText</b>
     * </p>
     *
     * @param transactionCurrencyText
     *            Transaction Currency Description
     */
    public void setTransactionCurrencyText( @Nullable final String transactionCurrencyText )
    {
        rememberChangedField("TransactionCurrencyText", this.transactionCurrencyText);
        this.transactionCurrencyText = transactionCurrencyText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "TransactionCurrencyText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("Currency", getCurrency());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("Currency", getCurrency());
        values.put("TransactionCurrencyText", getTransactionCurrencyText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("TransactionCurrencyText") ) {
                final Object value = values.remove("TransactionCurrencyText");
                if( (value == null) || (!value.equals(getTransactionCurrencyText())) ) {
                    setTransactionCurrencyText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnTransactionCurrency") ) {
                final Object value = (values).remove("to_CnsldtnTransactionCurrency");
                if( value instanceof Map ) {
                    if( toCnsldtnTransactionCurrency == null ) {
                        toCnsldtnTransactionCurrency = new TransactionCurrency();
                    }
                    @SuppressWarnings( "unchecked" )
                    final Map<String, Object> inputMap = ((Map<String, Object>) value);
                    toCnsldtnTransactionCurrency.fromMap(inputMap);
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> TransactionCurrencyTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new TransactionCurrencyTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> TransactionCurrencyTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new TransactionCurrencyTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnTransactionCurrency != null ) {
            (values).put("to_CnsldtnTransactionCurrency", toCnsldtnTransactionCurrency);
        }
        return values;
    }

    /**
     * Fetches the <b>TransactionCurrency</b> entity (one to one) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnTransactionCurrency</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return The single associated <b>TransactionCurrency</b> entity, or {@code null} if an entity is not associated.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public TransactionCurrency fetchCnsldtnTransactionCurrency()
    {
        return fetchFieldAsSingle("to_CnsldtnTransactionCurrency", TransactionCurrency.class);
    }

    /**
     * Retrieval of associated <b>TransactionCurrency</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnTransactionCurrency</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnTransactionCurrency</b> of a queried <b>TransactionCurrencyText</b> is
     * operated lazily, an <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>TransactionCurrency</b> entity.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nullable
    public TransactionCurrency getCnsldtnTransactionCurrencyOrFetch()
    {
        if( toCnsldtnTransactionCurrency == null ) {
            toCnsldtnTransactionCurrency = fetchCnsldtnTransactionCurrency();
        }
        return toCnsldtnTransactionCurrency;
    }

    /**
     * Retrieval of associated <b>TransactionCurrency</b> entity (one to one). This corresponds to the OData navigation
     * property <b>to_CnsldtnTransactionCurrency</b>.
     * <p>
     * If the navigation property for an entity <b>TransactionCurrencyText</b> has not been resolved yet, this method
     * will <b>not query</b> further information. Instead its <code>Option</code> result state will be
     * <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnTransactionCurrency</b> is already loaded, the
     *         result will contain the <b>TransactionCurrency</b> entity. If not, an <code>Option</code> with result
     *         state <code>empty</code> is returned.
     */
    @Nonnull
    public Option<TransactionCurrency> getCnsldtnTransactionCurrencyIfPresent()
    {
        return Option.of(toCnsldtnTransactionCurrency);
    }

    /**
     * Overwrites the associated <b>TransactionCurrency</b> entity for the loaded navigation property
     * <b>to_CnsldtnTransactionCurrency</b>.
     *
     * @param value
     *            New <b>TransactionCurrency</b> entity.
     */
    public void setCnsldtnTransactionCurrency( final TransactionCurrency value )
    {
        toCnsldtnTransactionCurrency = value;
    }

    /**
     * Helper class to allow for fluent creation of TransactionCurrencyText instances.
     *
     */
    public final static class TransactionCurrencyTextBuilder
    {

        private TransactionCurrency toCnsldtnTransactionCurrency;

        private TransactionCurrencyText.TransactionCurrencyTextBuilder toCnsldtnTransactionCurrency(
            final TransactionCurrency value )
        {
            toCnsldtnTransactionCurrency = value;
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnTransactionCurrency</b> for <b>TransactionCurrencyText</b> to single
         * <b>TransactionCurrency</b>.
         *
         * @param value
         *            The TransactionCurrency to build this TransactionCurrencyText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public TransactionCurrencyText.TransactionCurrencyTextBuilder cnsldtnTransactionCurrency(
            final TransactionCurrency value )
        {
            return toCnsldtnTransactionCurrency(value);
        }

    }

}
