/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.WBSElementField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.WBSElementLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.WBSElementSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined WBS Element
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WBSElementType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WBSElement extends VdmEntity<WBSElement>
{

    /**
     * Selector for all available fields of WBSElement.
     *
     */
    public final static WBSElementSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @Key
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static WBSElementField<String> WBS_ELEMENT = new WBSElementField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement_Text</b>
     * </p>
     *
     * @return WBS Element External ID Description
     */
    @SerializedName( "WBSElement_Text" )
    @JsonProperty( "WBSElement_Text" )
    @Nullable
    @ODataField( odataName = "WBSElement_Text" )
    private String wBSElement_Text;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement_Text</b> field to query operations.
     *
     */
    public final static WBSElementField<String> WBS_ELEMENT_TEXT = new WBSElementField<String>("WBSElement_Text");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project Definition
     */
    @Key
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static WBSElementField<String> PROJECT = new WBSElementField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @return Master Data Source
     */
    @SerializedName( "AdditionalMasterDataSource" )
    @JsonProperty( "AdditionalMasterDataSource" )
    @Nullable
    @ODataField( odataName = "AdditionalMasterDataSource" )
    private String additionalMasterDataSource;
    /**
     * Use with available fluent helpers to apply the <b>AdditionalMasterDataSource</b> field to query operations.
     *
     */
    public final static WBSElementField<String> ADDITIONAL_MASTER_DATA_SOURCE =
        new WBSElementField<String>("AdditionalMasterDataSource");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static WBSElementField<String> WBS_ELEMENT_INTERNAL_ID =
        new WBSElementField<String>("WBSElementInternalID");
    /**
     * Navigation property <b>to_CnsldtnWBSElementT</b> for <b>WBSElement</b> to multiple <b>WBSElementText</b>.
     *
     */
    @SerializedName( "to_CnsldtnWBSElementT" )
    @JsonProperty( "to_CnsldtnWBSElementT" )
    @ODataField( odataName = "to_CnsldtnWBSElementT" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WBSElementText> toCnsldtnWBSElementT;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnWBSElementT</b> navigation property to query
     * operations.
     *
     */
    public final static WBSElementLink<WBSElementText> TO_CNSLDTN_WBS_ELEMENT_T =
        new WBSElementLink<WBSElementText>("to_CnsldtnWBSElementT");

    @Nonnull
    @Override
    public Class<WBSElement> getType()
    {
        return WBSElement.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement_Text</b>
     * </p>
     *
     * @param wBSElement_Text
     *            WBS Element External ID Description
     */
    public void setWBSElement_Text( @Nullable final String wBSElement_Text )
    {
        rememberChangedField("WBSElement_Text", this.wBSElement_Text);
        this.wBSElement_Text = wBSElement_Text;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project Definition
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>AdditionalMasterDataSource</b>
     * </p>
     *
     * @param additionalMasterDataSource
     *            Master Data Source
     */
    public void setAdditionalMasterDataSource( @Nullable final String additionalMasterDataSource )
    {
        rememberChangedField("AdditionalMasterDataSource", this.additionalMasterDataSource);
        this.additionalMasterDataSource = additionalMasterDataSource;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WBSElement";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WBSElement", getWBSElement());
        result.put("Project", getProject());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WBSElement", getWBSElement());
        values.put("WBSElement_Text", getWBSElement_Text());
        values.put("Project", getProject());
        values.put("AdditionalMasterDataSource", getAdditionalMasterDataSource());
        values.put("WBSElementInternalID", getWBSElementInternalID());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("WBSElement_Text") ) {
                final Object value = values.remove("WBSElement_Text");
                if( (value == null) || (!value.equals(getWBSElement_Text())) ) {
                    setWBSElement_Text(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("AdditionalMasterDataSource") ) {
                final Object value = values.remove("AdditionalMasterDataSource");
                if( (value == null) || (!value.equals(getAdditionalMasterDataSource())) ) {
                    setAdditionalMasterDataSource(((String) value));
                }
            }
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnWBSElementT") ) {
                final Object value = (values).remove("to_CnsldtnWBSElementT");
                if( value instanceof Iterable ) {
                    if( toCnsldtnWBSElementT == null ) {
                        toCnsldtnWBSElementT = Lists.newArrayList();
                    } else {
                        toCnsldtnWBSElementT = Lists.newArrayList(toCnsldtnWBSElementT);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WBSElementText entity;
                        if( toCnsldtnWBSElementT.size() > i ) {
                            entity = toCnsldtnWBSElementT.get(i);
                        } else {
                            entity = new WBSElementText();
                            toCnsldtnWBSElementT.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WBSElementField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WBSElementField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WBSElementField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WBSElementField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnWBSElementT != null ) {
            (values).put("to_CnsldtnWBSElementT", toCnsldtnWBSElementT);
        }
        return values;
    }

    /**
     * Fetches the <b>WBSElementText</b> entities (one to many) associated with this entity. This corresponds to the
     * OData navigation property <b>to_CnsldtnWBSElementT</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WBSElementText</b> entities. If no entities are associated then
     *         an empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WBSElementText> fetchCnsldtnWBSElementT()
    {
        return fetchFieldAsList("to_CnsldtnWBSElementT", WBSElementText.class);
    }

    /**
     * Retrieval of associated <b>WBSElementText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnWBSElementT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnWBSElementT</b> of a queried <b>WBSElement</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WBSElementText</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WBSElementText> getCnsldtnWBSElementTOrFetch()
    {
        if( toCnsldtnWBSElementT == null ) {
            toCnsldtnWBSElementT = fetchCnsldtnWBSElementT();
        }
        return toCnsldtnWBSElementT;
    }

    /**
     * Retrieval of associated <b>WBSElementText</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnWBSElementT</b>.
     * <p>
     * If the navigation property for an entity <b>WBSElement</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnWBSElementT</b> is already loaded, the result
     *         will contain the <b>WBSElementText</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WBSElementText>> getCnsldtnWBSElementTIfPresent()
    {
        return Option.of(toCnsldtnWBSElementT);
    }

    /**
     * Overwrites the list of associated <b>WBSElementText</b> entities for the loaded navigation property
     * <b>to_CnsldtnWBSElementT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnWBSElementT</b> of a queried <b>WBSElement</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WBSElementText</b> entities.
     */
    public void setCnsldtnWBSElementT( @Nonnull final List<WBSElementText> value )
    {
        if( toCnsldtnWBSElementT == null ) {
            toCnsldtnWBSElementT = Lists.newArrayList();
        }
        toCnsldtnWBSElementT.clear();
        toCnsldtnWBSElementT.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WBSElementText</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnWBSElementT</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnWBSElementT</b> of a queried <b>WBSElement</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WBSElementText</b> entities.
     */
    public void addCnsldtnWBSElementT( WBSElementText... entity )
    {
        if( toCnsldtnWBSElementT == null ) {
            toCnsldtnWBSElementT = Lists.newArrayList();
        }
        toCnsldtnWBSElementT.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WBSElement instances.
     *
     */
    public final static class WBSElementBuilder
    {

        private List<WBSElementText> toCnsldtnWBSElementT = Lists.newArrayList();

        private WBSElement.WBSElementBuilder toCnsldtnWBSElementT( final List<WBSElementText> value )
        {
            toCnsldtnWBSElementT.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnWBSElementT</b> for <b>WBSElement</b> to multiple <b>WBSElementText</b>.
         *
         * @param value
         *            The WBSElementTexts to build this WBSElement with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WBSElement.WBSElementBuilder cnsldtnWBSElementT( WBSElementText... value )
        {
            return toCnsldtnWBSElementT(Lists.newArrayList(value));
        }

    }

}
