/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.WBSElementInternalIDField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.WBSElementInternalIDSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.ToString;

/**
 * WBS Element Internal Id
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WBSElementInternalIDType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WBSElementInternalID extends VdmEntity<WBSElementInternalID>
{

    /**
     * Selector for all available fields of WBSElementInternalID.
     *
     */
    public final static WBSElementInternalIDSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @return WBS Element
     */
    @Key
    @SerializedName( "WBSElementInternalID" )
    @JsonProperty( "WBSElementInternalID" )
    @Nullable
    @ODataField( odataName = "WBSElementInternalID" )
    private String wBSElementInternalID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementInternalID</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> WBS_ELEMENT_INTERNAL_ID =
        new WBSElementInternalIDField<String>("WBSElementInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectInternalID</b>
     * </p>
     *
     * @return Project (internal)
     */
    @SerializedName( "ProjectInternalID" )
    @JsonProperty( "ProjectInternalID" )
    @Nullable
    @ODataField( odataName = "ProjectInternalID" )
    private String projectInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ProjectInternalID</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> PROJECT_INTERNAL_ID =
        new WBSElementInternalIDField<String>("ProjectInternalID");
    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> WBS_ELEMENT =
        new WBSElementInternalIDField<String>("WBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @return WBS Element Name
     */
    @SerializedName( "WBSDescription" )
    @JsonProperty( "WBSDescription" )
    @Nullable
    @ODataField( odataName = "WBSDescription" )
    private String wBSDescription;
    /**
     * Use with available fluent helpers to apply the <b>WBSDescription</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> WBS_DESCRIPTION =
        new WBSElementInternalIDField<String>("WBSDescription");
    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementObject</b>
     * </p>
     *
     * @return Object Number
     */
    @SerializedName( "WBSElementObject" )
    @JsonProperty( "WBSElementObject" )
    @Nullable
    @ODataField( odataName = "WBSElementObject" )
    private String wBSElementObject;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementObject</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> WBS_ELEMENT_OBJECT =
        new WBSElementInternalIDField<String>("WBSElementObject");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @return Name of Person Responsible for Creating the Object
     */
    @SerializedName( "CreatedByUser" )
    @JsonProperty( "CreatedByUser" )
    @Nullable
    @ODataField( odataName = "CreatedByUser" )
    private String createdByUser;
    /**
     * Use with available fluent helpers to apply the <b>CreatedByUser</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> CREATED_BY_USER =
        new WBSElementInternalIDField<String>("CreatedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @return Record Created On
     */
    @SerializedName( "CreationDate" )
    @JsonProperty( "CreationDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "CreationDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime creationDate;
    /**
     * Use with available fluent helpers to apply the <b>CreationDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> CREATION_DATE =
        new WBSElementInternalIDField<LocalDateTime>("CreationDate");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @return Name of Person Who Changed Object
     */
    @SerializedName( "LastChangedByUser" )
    @JsonProperty( "LastChangedByUser" )
    @Nullable
    @ODataField( odataName = "LastChangedByUser" )
    private String lastChangedByUser;
    /**
     * Use with available fluent helpers to apply the <b>LastChangedByUser</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> LAST_CHANGED_BY_USER =
        new WBSElementInternalIDField<String>("LastChangedByUser");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @return Date on which object was last changed
     */
    @SerializedName( "LastChangeDate" )
    @JsonProperty( "LastChangeDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LastChangeDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime lastChangeDate;
    /**
     * Use with available fluent helpers to apply the <b>LastChangeDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> LAST_CHANGE_DATE =
        new WBSElementInternalIDField<LocalDateTime>("LastChangeDate");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePerson</b>
     * </p>
     *
     * @return Responsible Person Number (Project Manager)
     */
    @SerializedName( "ResponsiblePerson" )
    @JsonProperty( "ResponsiblePerson" )
    @Nullable
    @ODataField( odataName = "ResponsiblePerson" )
    private String responsiblePerson;
    /**
     * Use with available fluent helpers to apply the <b>ResponsiblePerson</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> RESPONSIBLE_PERSON =
        new WBSElementInternalIDField<String>("ResponsiblePerson");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePersonName</b>
     * </p>
     *
     * @return Name of responsible person (Project manager)
     */
    @SerializedName( "ResponsiblePersonName" )
    @JsonProperty( "ResponsiblePersonName" )
    @Nullable
    @ODataField( odataName = "ResponsiblePersonName" )
    private String responsiblePersonName;
    /**
     * Use with available fluent helpers to apply the <b>ResponsiblePersonName</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> RESPONSIBLE_PERSON_NAME =
        new WBSElementInternalIDField<String>("ResponsiblePersonName");
    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ApplicantCode</b>
     * </p>
     *
     * @return Applicant number
     */
    @SerializedName( "ApplicantCode" )
    @JsonProperty( "ApplicantCode" )
    @Nullable
    @ODataField( odataName = "ApplicantCode" )
    private String applicantCode;
    /**
     * Use with available fluent helpers to apply the <b>ApplicantCode</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> APPLICANT_CODE =
        new WBSElementInternalIDField<String>("ApplicantCode");
    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ApplicantName</b>
     * </p>
     *
     * @return Applicant
     */
    @SerializedName( "ApplicantName" )
    @JsonProperty( "ApplicantName" )
    @Nullable
    @ODataField( odataName = "ApplicantName" )
    private String applicantName;
    /**
     * Use with available fluent helpers to apply the <b>ApplicantName</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> APPLICANT_NAME =
        new WBSElementInternalIDField<String>("ApplicantName");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @return Company Code
     */
    @SerializedName( "CompanyCode" )
    @JsonProperty( "CompanyCode" )
    @Nullable
    @ODataField( odataName = "CompanyCode" )
    private String companyCode;
    /**
     * Use with available fluent helpers to apply the <b>CompanyCode</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> COMPANY_CODE =
        new WBSElementInternalIDField<String>("CompanyCode");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @return Business Area
     */
    @SerializedName( "BusinessArea" )
    @JsonProperty( "BusinessArea" )
    @Nullable
    @ODataField( odataName = "BusinessArea" )
    private String businessArea;
    /**
     * Use with available fluent helpers to apply the <b>BusinessArea</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> BUSINESS_AREA =
        new WBSElementInternalIDField<String>("BusinessArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @return Controlling Area
     */
    @SerializedName( "ControllingArea" )
    @JsonProperty( "ControllingArea" )
    @Nullable
    @ODataField( odataName = "ControllingArea" )
    private String controllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ControllingArea</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> CONTROLLING_AREA =
        new WBSElementInternalIDField<String>("ControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @return Profit Center
     */
    @SerializedName( "ProfitCenter" )
    @JsonProperty( "ProfitCenter" )
    @Nullable
    @ODataField( odataName = "ProfitCenter" )
    private String profitCenter;
    /**
     * Use with available fluent helpers to apply the <b>ProfitCenter</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> PROFIT_CENTER =
        new WBSElementInternalIDField<String>("ProfitCenter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProjectType</b>
     * </p>
     *
     * @return Project type
     */
    @SerializedName( "ProjectType" )
    @JsonProperty( "ProjectType" )
    @Nullable
    @ODataField( odataName = "ProjectType" )
    private String projectType;
    /**
     * Use with available fluent helpers to apply the <b>ProjectType</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> PROJECT_TYPE =
        new WBSElementInternalIDField<String>("ProjectType");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsPlanningElement</b>
     * </p>
     *
     * @return Indicator: Planning element
     */
    @SerializedName( "WBSElementIsPlanningElement" )
    @JsonProperty( "WBSElementIsPlanningElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSElementIsPlanningElement" )
    private Boolean wBSElementIsPlanningElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementIsPlanningElement</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_ELEMENT_IS_PLANNING_ELEMENT =
        new WBSElementInternalIDField<Boolean>("WBSElementIsPlanningElement");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsAccountAssignmentElement</b>
     * </p>
     *
     * @return Indicator: Account assignment element
     */
    @SerializedName( "WBSIsAccountAssignmentElement" )
    @JsonProperty( "WBSIsAccountAssignmentElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSIsAccountAssignmentElement" )
    private Boolean wBSIsAccountAssignmentElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSIsAccountAssignmentElement</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_IS_ACCOUNT_ASSIGNMENT_ELEMENT =
        new WBSElementInternalIDField<Boolean>("WBSIsAccountAssignmentElement");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsBillingElement</b>
     * </p>
     *
     * @return Indicator: Billing element
     */
    @SerializedName( "WBSElementIsBillingElement" )
    @JsonProperty( "WBSElementIsBillingElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSElementIsBillingElement" )
    private Boolean wBSElementIsBillingElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementIsBillingElement</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_ELEMENT_IS_BILLING_ELEMENT =
        new WBSElementInternalIDField<Boolean>("WBSElementIsBillingElement");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @return Costing Sheet
     */
    @SerializedName( "CostingSheet" )
    @JsonProperty( "CostingSheet" )
    @Nullable
    @ODataField( odataName = "CostingSheet" )
    private String costingSheet;
    /**
     * Use with available fluent helpers to apply the <b>CostingSheet</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> COSTING_SHEET =
        new WBSElementInternalIDField<String>("CostingSheet");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestingCostCenter</b>
     * </p>
     *
     * @return Requesting cost center
     */
    @SerializedName( "RequestingCostCenter" )
    @JsonProperty( "RequestingCostCenter" )
    @Nullable
    @ODataField( odataName = "RequestingCostCenter" )
    private String requestingCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>RequestingCostCenter</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> REQUESTING_COST_CENTER =
        new WBSElementInternalIDField<String>("RequestingCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @return Responsible Cost Center
     */
    @SerializedName( "ResponsibleCostCenter" )
    @JsonProperty( "ResponsibleCostCenter" )
    @Nullable
    @ODataField( odataName = "ResponsibleCostCenter" )
    private String responsibleCostCenter;
    /**
     * Use with available fluent helpers to apply the <b>ResponsibleCostCenter</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> RESPONSIBLE_COST_CENTER =
        new WBSElementInternalIDField<String>("ResponsibleCostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @return Calendar
     */
    @SerializedName( "FactoryCalendar" )
    @JsonProperty( "FactoryCalendar" )
    @Nullable
    @ODataField( odataName = "FactoryCalendar" )
    private String factoryCalendar;
    /**
     * Use with available fluent helpers to apply the <b>FactoryCalendar</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FACTORY_CALENDAR =
        new WBSElementInternalIDField<String>("FactoryCalendar");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     *
     * @return Priority
     */
    @SerializedName( "PriorityCode" )
    @JsonProperty( "PriorityCode" )
    @Nullable
    @ODataField( odataName = "PriorityCode" )
    private String priorityCode;
    /**
     * Use with available fluent helpers to apply the <b>PriorityCode</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> PRIORITY_CODE =
        new WBSElementInternalIDField<String>("PriorityCode");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @return WBS element currency
     */
    @SerializedName( "Currency" )
    @JsonProperty( "Currency" )
    @Nullable
    @ODataField( odataName = "Currency" )
    private String currency;
    /**
     * Use with available fluent helpers to apply the <b>Currency</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> CURRENCY = new WBSElementInternalIDField<String>("Currency");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @return Plant
     */
    @SerializedName( "Plant" )
    @JsonProperty( "Plant" )
    @Nullable
    @ODataField( odataName = "Plant" )
    private String plant;
    /**
     * Use with available fluent helpers to apply the <b>Plant</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> PLANT = new WBSElementInternalIDField<String>("Plant");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedTableFieldSemantic</b>
     * </p>
     *
     * @return Key word ID for user-defined fields
     */
    @SerializedName( "FreeDefinedTableFieldSemantic" )
    @JsonProperty( "FreeDefinedTableFieldSemantic" )
    @Nullable
    @ODataField( odataName = "FreeDefinedTableFieldSemantic" )
    private String freeDefinedTableFieldSemantic;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedTableFieldSemantic</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_TABLE_FIELD_SEMANTIC =
        new WBSElementInternalIDField<String>("FreeDefinedTableFieldSemantic");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsStatisticalWBSElement</b>
     * </p>
     *
     * @return Statistical WBS element
     */
    @SerializedName( "WBSIsStatisticalWBSElement" )
    @JsonProperty( "WBSIsStatisticalWBSElement" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSIsStatisticalWBSElement" )
    private Boolean wBSIsStatisticalWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSIsStatisticalWBSElement</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_IS_STATISTICAL_WBS_ELEMENT =
        new WBSElementInternalIDField<Boolean>("WBSIsStatisticalWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @return Tax Jurisdiction
     */
    @SerializedName( "TaxJurisdiction" )
    @JsonProperty( "TaxJurisdiction" )
    @Nullable
    @ODataField( odataName = "TaxJurisdiction" )
    private String taxJurisdiction;
    /**
     * Use with available fluent helpers to apply the <b>TaxJurisdiction</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> TAX_JURISDICTION =
        new WBSElementInternalIDField<String>("TaxJurisdiction");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsMarkedForIntegratedPlng</b>
     * </p>
     *
     * @return Indicator 'Integrated Planning' for Cost Object Category
     */
    @SerializedName( "WBSIsMarkedForIntegratedPlng" )
    @JsonProperty( "WBSIsMarkedForIntegratedPlng" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSIsMarkedForIntegratedPlng" )
    private Boolean wBSIsMarkedForIntegratedPlng;
    /**
     * Use with available fluent helpers to apply the <b>WBSIsMarkedForIntegratedPlng</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_IS_MARKED_FOR_INTEGRATED_PLNG =
        new WBSElementInternalIDField<Boolean>("WBSIsMarkedForIntegratedPlng");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @return Functional Area
     */
    @SerializedName( "FunctionalArea" )
    @JsonProperty( "FunctionalArea" )
    @Nullable
    @ODataField( odataName = "FunctionalArea" )
    private String functionalArea;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalArea</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FUNCTIONAL_AREA =
        new WBSElementInternalIDField<String>("FunctionalArea");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @return Location
     */
    @SerializedName( "Location" )
    @JsonProperty( "Location" )
    @Nullable
    @ODataField( odataName = "Location" )
    private String location;
    /**
     * Use with available fluent helpers to apply the <b>Location</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> LOCATION = new WBSElementInternalIDField<String>("Location");
    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @return Equipment Number
     */
    @SerializedName( "Equipment" )
    @JsonProperty( "Equipment" )
    @Nullable
    @ODataField( odataName = "Equipment" )
    private String equipment;
    /**
     * Use with available fluent helpers to apply the <b>Equipment</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> EQUIPMENT =
        new WBSElementInternalIDField<String>("Equipment");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @return Functional Location
     */
    @SerializedName( "FunctionalLocation" )
    @JsonProperty( "FunctionalLocation" )
    @Nullable
    @ODataField( odataName = "FunctionalLocation" )
    private String functionalLocation;
    /**
     * Use with available fluent helpers to apply the <b>FunctionalLocation</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FUNCTIONAL_LOCATION =
        new WBSElementInternalIDField<String>("FunctionalLocation");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectObjectChangeNumber</b>
     * </p>
     *
     * @return Change Number
     */
    @SerializedName( "ProjectObjectChangeNumber" )
    @JsonProperty( "ProjectObjectChangeNumber" )
    @Nullable
    @ODataField( odataName = "ProjectObjectChangeNumber" )
    private String projectObjectChangeNumber;
    /**
     * Use with available fluent helpers to apply the <b>ProjectObjectChangeNumber</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> PROJECT_OBJECT_CHANGE_NUMBER =
        new WBSElementInternalIDField<String>("ProjectObjectChangeNumber");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectObjectReferenceElement</b>
     * </p>
     *
     * @return Reference Element PM/PS
     */
    @SerializedName( "ProjectObjectReferenceElement" )
    @JsonProperty( "ProjectObjectReferenceElement" )
    @Nullable
    @ODataField( odataName = "ProjectObjectReferenceElement" )
    private String projectObjectReferenceElement;
    /**
     * Use with available fluent helpers to apply the <b>ProjectObjectReferenceElement</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> PROJECT_OBJECT_REFERENCE_ELEMENT =
        new WBSElementInternalIDField<String>("ProjectObjectReferenceElement");
    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjInterestCalcProfile</b>
     * </p>
     *
     * @return Interest Profile for Project/Order Interest Calculation
     */
    @SerializedName( "ProjInterestCalcProfile" )
    @JsonProperty( "ProjInterestCalcProfile" )
    @Nullable
    @ODataField( odataName = "ProjInterestCalcProfile" )
    private String projInterestCalcProfile;
    /**
     * Use with available fluent helpers to apply the <b>ProjInterestCalcProfile</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> PROJ_INTEREST_CALC_PROFILE =
        new WBSElementInternalIDField<String>("ProjInterestCalcProfile");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     *
     * @return Investment Measure Profile
     */
    @SerializedName( "InvestmentProfile" )
    @JsonProperty( "InvestmentProfile" )
    @Nullable
    @ODataField( odataName = "InvestmentProfile" )
    private String investmentProfile;
    /**
     * Use with available fluent helpers to apply the <b>InvestmentProfile</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> INVESTMENT_PROFILE =
        new WBSElementInternalIDField<String>("InvestmentProfile");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BasicStartDate</b>
     * </p>
     *
     * @return WBS element: Basic start date
     */
    @SerializedName( "BasicStartDate" )
    @JsonProperty( "BasicStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BasicStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime basicStartDate;
    /**
     * Use with available fluent helpers to apply the <b>BasicStartDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> BASIC_START_DATE =
        new WBSElementInternalIDField<LocalDateTime>("BasicStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ForecastedStartDate</b>
     * </p>
     *
     * @return Forecast Start Date of WBS Element
     */
    @SerializedName( "ForecastedStartDate" )
    @JsonProperty( "ForecastedStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ForecastedStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime forecastedStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ForecastedStartDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> FORECASTED_START_DATE =
        new WBSElementInternalIDField<LocalDateTime>("ForecastedStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate</b>
     * </p>
     *
     * @return Actual start date for the WBS element
     */
    @SerializedName( "ActualStartDate" )
    @JsonProperty( "ActualStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualStartDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualStartDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> ACTUAL_START_DATE =
        new WBSElementInternalIDField<LocalDateTime>("ActualStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BasicEndDate</b>
     * </p>
     *
     * @return WBS element: Basic finish date
     */
    @SerializedName( "BasicEndDate" )
    @JsonProperty( "BasicEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "BasicEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime basicEndDate;
    /**
     * Use with available fluent helpers to apply the <b>BasicEndDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> BASIC_END_DATE =
        new WBSElementInternalIDField<LocalDateTime>("BasicEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ForecastedEndDate</b>
     * </p>
     *
     * @return Forecast Finish Date of WBS Element
     */
    @SerializedName( "ForecastedEndDate" )
    @JsonProperty( "ForecastedEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ForecastedEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime forecastedEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ForecastedEndDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> FORECASTED_END_DATE =
        new WBSElementInternalIDField<LocalDateTime>("ForecastedEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate</b>
     * </p>
     *
     * @return Actual finish date of the WBS element
     */
    @SerializedName( "ActualEndDate" )
    @JsonProperty( "ActualEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ActualEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime actualEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ActualEndDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> ACTUAL_END_DATE =
        new WBSElementInternalIDField<LocalDateTime>("ActualEndDate");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDurationUnit</b>
     * </p>
     *
     * @return Unit for duration of actual WBS element dates
     */
    @SerializedName( "ActualDurationUnit" )
    @JsonProperty( "ActualDurationUnit" )
    @Nullable
    @ODataField( odataName = "ActualDurationUnit" )
    private String actualDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ActualDurationUnit</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> ACTUAL_DURATION_UNIT =
        new WBSElementInternalIDField<String>("ActualDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ForecastedDurationUnit</b>
     * </p>
     *
     * @return Unit for duration of WBS element planned dates
     */
    @SerializedName( "ForecastedDurationUnit" )
    @JsonProperty( "ForecastedDurationUnit" )
    @Nullable
    @ODataField( odataName = "ForecastedDurationUnit" )
    private String forecastedDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>ForecastedDurationUnit</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FORECASTED_DURATION_UNIT =
        new WBSElementInternalIDField<String>("ForecastedDurationUnit");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BasicDurationUnit</b>
     * </p>
     *
     * @return Unit for duration of basic WBS element dates
     */
    @SerializedName( "BasicDurationUnit" )
    @JsonProperty( "BasicDurationUnit" )
    @Nullable
    @ODataField( odataName = "BasicDurationUnit" )
    private String basicDurationUnit;
    /**
     * Use with available fluent helpers to apply the <b>BasicDurationUnit</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> BASIC_DURATION_UNIT =
        new WBSElementInternalIDField<String>("BasicDurationUnit");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>BasicDuration</b>
     * </p>
     *
     * @return Length (duration) of the basic dates in the WBS element
     */
    @SerializedName( "BasicDuration" )
    @JsonProperty( "BasicDuration" )
    @Nullable
    @ODataField( odataName = "BasicDuration" )
    private BigDecimal basicDuration;
    /**
     * Use with available fluent helpers to apply the <b>BasicDuration</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<BigDecimal> BASIC_DURATION =
        new WBSElementInternalIDField<BigDecimal>("BasicDuration");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ForecastedDuration</b>
     * </p>
     *
     * @return Forecasted length (duration) of the WBS element
     */
    @SerializedName( "ForecastedDuration" )
    @JsonProperty( "ForecastedDuration" )
    @Nullable
    @ODataField( odataName = "ForecastedDuration" )
    private BigDecimal forecastedDuration;
    /**
     * Use with available fluent helpers to apply the <b>ForecastedDuration</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<BigDecimal> FORECASTED_DURATION =
        new WBSElementInternalIDField<BigDecimal>("ForecastedDuration");
    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActualDuration</b>
     * </p>
     *
     * @return Actual length (duration) of the WBS element
     */
    @SerializedName( "ActualDuration" )
    @JsonProperty( "ActualDuration" )
    @Nullable
    @ODataField( odataName = "ActualDuration" )
    private BigDecimal actualDuration;
    /**
     * Use with available fluent helpers to apply the <b>ActualDuration</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<BigDecimal> ACTUAL_DURATION =
        new WBSElementInternalIDField<BigDecimal>("ActualDuration");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldBasicEarliestStartDate</b>
     * </p>
     *
     * @return Earliest scheduled start date (Basic)
     */
    @SerializedName( "SchedldBasicEarliestStartDate" )
    @JsonProperty( "SchedldBasicEarliestStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedldBasicEarliestStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedldBasicEarliestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedldBasicEarliestStartDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> SCHEDLD_BASIC_EARLIEST_START_DATE =
        new WBSElementInternalIDField<LocalDateTime>("SchedldBasicEarliestStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicLatestEndDate</b>
     * </p>
     *
     * @return Latest scheduled finish date (basic)
     */
    @SerializedName( "ScheduledBasicLatestEndDate" )
    @JsonProperty( "ScheduledBasicLatestEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "ScheduledBasicLatestEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime scheduledBasicLatestEndDate;
    /**
     * Use with available fluent helpers to apply the <b>ScheduledBasicLatestEndDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> SCHEDULED_BASIC_LATEST_END_DATE =
        new WBSElementInternalIDField<LocalDateTime>("ScheduledBasicLatestEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldFcstdEarliestStartDate</b>
     * </p>
     *
     * @return Scheduled start date (Forecast)
     */
    @SerializedName( "SchedldFcstdEarliestStartDate" )
    @JsonProperty( "SchedldFcstdEarliestStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedldFcstdEarliestStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedldFcstdEarliestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedldFcstdEarliestStartDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> SCHEDLD_FCSTD_EARLIEST_START_DATE =
        new WBSElementInternalIDField<LocalDateTime>("SchedldFcstdEarliestStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldFcstdEndDate</b>
     * </p>
     *
     * @return Latest scheduled finish date (Forecast)
     */
    @SerializedName( "LatestSchedldFcstdEndDate" )
    @JsonProperty( "LatestSchedldFcstdEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldFcstdEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestSchedldFcstdEndDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldFcstdEndDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> LATEST_SCHEDLD_FCSTD_END_DATE =
        new WBSElementInternalIDField<LocalDateTime>("LatestSchedldFcstdEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TentativeActualStartDate</b>
     * </p>
     *
     * @return Tentative actual start date for WBS element
     */
    @SerializedName( "TentativeActualStartDate" )
    @JsonProperty( "TentativeActualStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TentativeActualStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime tentativeActualStartDate;
    /**
     * Use with available fluent helpers to apply the <b>TentativeActualStartDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> TENTATIVE_ACTUAL_START_DATE =
        new WBSElementInternalIDField<LocalDateTime>("TentativeActualStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TentativeActualEndDate</b>
     * </p>
     *
     * @return Tentative actual finish date for WBS element
     */
    @SerializedName( "TentativeActualEndDate" )
    @JsonProperty( "TentativeActualEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "TentativeActualEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime tentativeActualEndDate;
    /**
     * Use with available fluent helpers to apply the <b>TentativeActualEndDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> TENTATIVE_ACTUAL_END_DATE =
        new WBSElementInternalIDField<LocalDateTime>("TentativeActualEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldBasicLatestStartDate</b>
     * </p>
     *
     * @return Latest scheduled start date (basic)
     */
    @SerializedName( "SchedldBasicLatestStartDate" )
    @JsonProperty( "SchedldBasicLatestStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedldBasicLatestStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedldBasicLatestStartDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedldBasicLatestStartDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> SCHEDLD_BASIC_LATEST_START_DATE =
        new WBSElementInternalIDField<LocalDateTime>("SchedldBasicLatestStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldBasicEarliestEndDate</b>
     * </p>
     *
     * @return Earliest Finish Date
     */
    @SerializedName( "SchedldBasicEarliestEndDate" )
    @JsonProperty( "SchedldBasicEarliestEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedldBasicEarliestEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedldBasicEarliestEndDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedldBasicEarliestEndDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> SCHEDLD_BASIC_EARLIEST_END_DATE =
        new WBSElementInternalIDField<LocalDateTime>("SchedldBasicEarliestEndDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldFcstdStartDate</b>
     * </p>
     *
     * @return Latest scheduled start date (forecast)
     */
    @SerializedName( "LatestSchedldFcstdStartDate" )
    @JsonProperty( "LatestSchedldFcstdStartDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "LatestSchedldFcstdStartDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime latestSchedldFcstdStartDate;
    /**
     * Use with available fluent helpers to apply the <b>LatestSchedldFcstdStartDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> LATEST_SCHEDLD_FCSTD_START_DATE =
        new WBSElementInternalIDField<LocalDateTime>("LatestSchedldFcstdStartDate");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldFcstdEarliestEndDate</b>
     * </p>
     *
     * @return Earliest scheduled finish date (forecast)
     */
    @SerializedName( "SchedldFcstdEarliestEndDate" )
    @JsonProperty( "SchedldFcstdEarliestEndDate" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "SchedldFcstdEarliestEndDate",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime schedldFcstdEarliestEndDate;
    /**
     * Use with available fluent helpers to apply the <b>SchedldFcstdEarliestEndDate</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> SCHEDLD_FCSTD_EARLIEST_END_DATE =
        new WBSElementInternalIDField<LocalDateTime>("SchedldFcstdEarliestEndDate");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementHierarchyLevel</b>
     * </p>
     *
     * @return Level in Project Hierarchy
     */
    @SerializedName( "WBSElementHierarchyLevel" )
    @JsonProperty( "WBSElementHierarchyLevel" )
    @Nullable
    @ODataField( odataName = "WBSElementHierarchyLevel" )
    private Short wBSElementHierarchyLevel;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementHierarchyLevel</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Short> WBS_ELEMENT_HIERARCHY_LEVEL =
        new WBSElementInternalIDField<Short>("WBSElementHierarchyLevel");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OverheadCode</b>
     * </p>
     *
     * @return Overhead Key
     */
    @SerializedName( "OverheadCode" )
    @JsonProperty( "OverheadCode" )
    @Nullable
    @ODataField( odataName = "OverheadCode" )
    private String overheadCode;
    /**
     * Use with available fluent helpers to apply the <b>OverheadCode</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> OVERHEAD_CODE =
        new WBSElementInternalIDField<String>("OverheadCode");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ResultAnalysisInternalID</b>
     * </p>
     *
     * @return Results Analysis Key
     */
    @SerializedName( "ResultAnalysisInternalID" )
    @JsonProperty( "ResultAnalysisInternalID" )
    @Nullable
    @ODataField( odataName = "ResultAnalysisInternalID" )
    private String resultAnalysisInternalID;
    /**
     * Use with available fluent helpers to apply the <b>ResultAnalysisInternalID</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> RESULT_ANALYSIS_INTERNAL_ID =
        new WBSElementInternalIDField<String>("ResultAnalysisInternalID");
    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProgressAnlysAggregationWeight</b>
     * </p>
     *
     * @return Aggregation weight for POC (PS progress)
     */
    @SerializedName( "ProgressAnlysAggregationWeight" )
    @JsonProperty( "ProgressAnlysAggregationWeight" )
    @Nullable
    @ODataField( odataName = "ProgressAnlysAggregationWeight" )
    private BigDecimal progressAnlysAggregationWeight;
    /**
     * Use with available fluent helpers to apply the <b>ProgressAnlysAggregationWeight</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<BigDecimal> PROGRESS_ANLYS_AGGREGATION_WEIGHT =
        new WBSElementInternalIDField<BigDecimal>("ProgressAnlysAggregationWeight");
    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementShortID</b>
     * </p>
     *
     * @return WBS element short identification
     */
    @SerializedName( "WBSElementShortID" )
    @JsonProperty( "WBSElementShortID" )
    @Nullable
    @ODataField( odataName = "WBSElementShortID" )
    private String wBSElementShortID;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementShortID</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> WBS_ELEMENT_SHORT_ID =
        new WBSElementInternalIDField<String>("WBSElementShortID");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReqgCostCenterControllingArea</b>
     * </p>
     *
     * @return Controlling area of requesting cost center
     */
    @SerializedName( "ReqgCostCenterControllingArea" )
    @JsonProperty( "ReqgCostCenterControllingArea" )
    @Nullable
    @ODataField( odataName = "ReqgCostCenterControllingArea" )
    private String reqgCostCenterControllingArea;
    /**
     * Use with available fluent helpers to apply the <b>ReqgCostCenterControllingArea</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> REQG_COST_CENTER_CONTROLLING_AREA =
        new WBSElementInternalIDField<String>("ReqgCostCenterControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RespCostCenterControllingArea</b>
     * </p>
     *
     * @return Responsible Cost Center Controlling Area
     */
    @SerializedName( "RespCostCenterControllingArea" )
    @JsonProperty( "RespCostCenterControllingArea" )
    @Nullable
    @ODataField( odataName = "RespCostCenterControllingArea" )
    private String respCostCenterControllingArea;
    /**
     * Use with available fluent helpers to apply the <b>RespCostCenterControllingArea</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> RESP_COST_CENTER_CONTROLLING_AREA =
        new WBSElementInternalIDField<String>("RespCostCenterControllingArea");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> LANGUAGE = new WBSElementInternalIDField<String>("Language");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @return Cost center to which costs are actually posted
     */
    @SerializedName( "CostCenter" )
    @JsonProperty( "CostCenter" )
    @Nullable
    @ODataField( odataName = "CostCenter" )
    private String costCenter;
    /**
     * Use with available fluent helpers to apply the <b>CostCenter</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> COST_CENTER =
        new WBSElementInternalIDField<String>("CostCenter");
    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @return Cost Object
     */
    @SerializedName( "CostObject" )
    @JsonProperty( "CostObject" )
    @Nullable
    @ODataField( odataName = "CostObject" )
    private String costObject;
    /**
     * Use with available fluent helpers to apply the <b>CostObject</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> COST_OBJECT =
        new WBSElementInternalIDField<String>("CostObject");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsUsedInProjSmmry</b>
     * </p>
     *
     * @return Indicator: WBS element used in project summarization
     */
    @SerializedName( "WBSElementIsUsedInProjSmmry" )
    @JsonProperty( "WBSElementIsUsedInProjSmmry" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSElementIsUsedInProjSmmry" )
    private Boolean wBSElementIsUsedInProjSmmry;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementIsUsedInProjSmmry</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_ELEMENT_IS_USED_IN_PROJ_SMMRY =
        new WBSElementInternalIDField<Boolean>("WBSElementIsUsedInProjSmmry");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @return Deletion Indicator
     */
    @SerializedName( "IsMarkedForDeletion" )
    @JsonProperty( "IsMarkedForDeletion" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "IsMarkedForDeletion" )
    private Boolean isMarkedForDeletion;
    /**
     * Use with available fluent helpers to apply the <b>IsMarkedForDeletion</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> IS_MARKED_FOR_DELETION =
        new WBSElementInternalIDField<Boolean>("IsMarkedForDeletion");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType</b>
     * </p>
     *
     * @return Valuation of Special Stock
     */
    @SerializedName( "InventorySpecialStockValnType" )
    @JsonProperty( "InventorySpecialStockValnType" )
    @Nullable
    @ODataField( odataName = "InventorySpecialStockValnType" )
    private String inventorySpecialStockValnType;
    /**
     * Use with available fluent helpers to apply the <b>InventorySpecialStockValnType</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> INVENTORY_SPECIAL_STOCK_VALN_TYPE =
        new WBSElementInternalIDField<String>("InventorySpecialStockValnType");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @return Billing Plan Number / Invoicing Plan Number
     */
    @SerializedName( "BillingPlan" )
    @JsonProperty( "BillingPlan" )
    @Nullable
    @ODataField( odataName = "BillingPlan" )
    private String billingPlan;
    /**
     * Use with available fluent helpers to apply the <b>BillingPlan</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> BILLING_PLAN =
        new WBSElementInternalIDField<String>("BillingPlan");
    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsGroupingWBSElement</b>
     * </p>
     *
     * @return Indicator: Grouping WBS element
     */
    @SerializedName( "WBSElementIsGroupingWBSElement" )
    @JsonProperty( "WBSElementIsGroupingWBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElementIsGroupingWBSElement" )
    private String wBSElementIsGroupingWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementIsGroupingWBSElement</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> WBS_ELEMENT_IS_GROUPING_WBS_ELEMENT =
        new WBSElementInternalIDField<String>("WBSElementIsGroupingWBSElement");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostingVariant</b>
     * </p>
     *
     * @return Costing Variant
     */
    @SerializedName( "CostingVariant" )
    @JsonProperty( "CostingVariant" )
    @Nullable
    @ODataField( odataName = "CostingVariant" )
    private String costingVariant;
    /**
     * Use with available fluent helpers to apply the <b>CostingVariant</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> COSTING_VARIANT =
        new WBSElementInternalIDField<String>("CostingVariant");
    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @return Joint Venture
     */
    @SerializedName( "JointVenture" )
    @JsonProperty( "JointVenture" )
    @Nullable
    @ODataField( odataName = "JointVenture" )
    private String jointVenture;
    /**
     * Use with available fluent helpers to apply the <b>JointVenture</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> JOINT_VENTURE =
        new WBSElementInternalIDField<String>("JointVenture");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureRecoveryCode</b>
     * </p>
     *
     * @return Recovery Indicator
     */
    @SerializedName( "JointVentureRecoveryCode" )
    @JsonProperty( "JointVentureRecoveryCode" )
    @Nullable
    @ODataField( odataName = "JointVentureRecoveryCode" )
    private String jointVentureRecoveryCode;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureRecoveryCode</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> JOINT_VENTURE_RECOVERY_CODE =
        new WBSElementInternalIDField<String>("JointVentureRecoveryCode");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @return Equity Type
     */
    @SerializedName( "JointVentureEquityType" )
    @JsonProperty( "JointVentureEquityType" )
    @Nullable
    @ODataField( odataName = "JointVentureEquityType" )
    private String jointVentureEquityType;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureEquityType</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> JOINT_VENTURE_EQUITY_TYPE =
        new WBSElementInternalIDField<String>("JointVentureEquityType");
    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureObjectType</b>
     * </p>
     *
     * @return Joint Venture Object Type
     */
    @SerializedName( "JointVentureObjectType" )
    @JsonProperty( "JointVentureObjectType" )
    @Nullable
    @ODataField( odataName = "JointVentureObjectType" )
    private String jointVentureObjectType;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureObjectType</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> JOINT_VENTURE_OBJECT_TYPE =
        new WBSElementInternalIDField<String>("JointVentureObjectType");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureClass</b>
     * </p>
     *
     * @return JIB/JIBE Class
     */
    @SerializedName( "JointVentureClass" )
    @JsonProperty( "JointVentureClass" )
    @Nullable
    @ODataField( odataName = "JointVentureClass" )
    private String jointVentureClass;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureClass</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> JOINT_VENTURE_CLASS =
        new WBSElementInternalIDField<String>("JointVentureClass");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureSubClass</b>
     * </p>
     *
     * @return JIB/JIBE Subclass A
     */
    @SerializedName( "JointVentureSubClass" )
    @JsonProperty( "JointVentureSubClass" )
    @Nullable
    @ODataField( odataName = "JointVentureSubClass" )
    private String jointVentureSubClass;
    /**
     * Use with available fluent helpers to apply the <b>JointVentureSubClass</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> JOINT_VENTURE_SUB_CLASS =
        new WBSElementInternalIDField<String>("JointVentureSubClass");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementHasActivities</b>
     * </p>
     *
     * @return Indicator: There are activities for the WBS elements
     */
    @SerializedName( "WBSElementHasActivities" )
    @JsonProperty( "WBSElementHasActivities" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSElementHasActivities" )
    private Boolean wBSElementHasActivities;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementHasActivities</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_ELEMENT_HAS_ACTIVITIES =
        new WBSElementInternalIDField<Boolean>("WBSElementHasActivities");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSHasFcstdDateFromActivity</b>
     * </p>
     *
     * @return Indicator: Expected dates from the activities
     */
    @SerializedName( "WBSHasFcstdDateFromActivity" )
    @JsonProperty( "WBSHasFcstdDateFromActivity" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSHasFcstdDateFromActivity" )
    private Boolean wBSHasFcstdDateFromActivity;
    /**
     * Use with available fluent helpers to apply the <b>WBSHasFcstdDateFromActivity</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_HAS_FCSTD_DATE_FROM_ACTIVITY =
        new WBSElementInternalIDField<Boolean>("WBSHasFcstdDateFromActivity");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSHasFcstdDateSetManually</b>
     * </p>
     *
     * @return Indicator: Forecast dates set manually
     */
    @SerializedName( "WBSHasFcstdDateSetManually" )
    @JsonProperty( "WBSHasFcstdDateSetManually" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSHasFcstdDateSetManually" )
    private Boolean wBSHasFcstdDateSetManually;
    /**
     * Use with available fluent helpers to apply the <b>WBSHasFcstdDateSetManually</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_HAS_FCSTD_DATE_SET_MANUALLY =
        new WBSElementInternalIDField<Boolean>("WBSHasFcstdDateSetManually");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSHasBasicDateManuallySet</b>
     * </p>
     *
     * @return Indicator: Basic dates set manually
     */
    @SerializedName( "WBSHasBasicDateManuallySet" )
    @JsonProperty( "WBSHasBasicDateManuallySet" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSHasBasicDateManuallySet" )
    private Boolean wBSHasBasicDateManuallySet;
    /**
     * Use with available fluent helpers to apply the <b>WBSHasBasicDateManuallySet</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_HAS_BASIC_DATE_MANUALLY_SET =
        new WBSElementInternalIDField<Boolean>("WBSHasBasicDateManuallySet");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSHasActualDateSetManually</b>
     * </p>
     *
     * @return Indicator: Actual dates set manually
     */
    @SerializedName( "WBSHasActualDateSetManually" )
    @JsonProperty( "WBSHasActualDateSetManually" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSHasActualDateSetManually" )
    private Boolean wBSHasActualDateSetManually;
    /**
     * Use with available fluent helpers to apply the <b>WBSHasActualDateSetManually</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_HAS_ACTUAL_DATE_SET_MANUALLY =
        new WBSElementInternalIDField<Boolean>("WBSHasActualDateSetManually");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElmntHasActualDateFromActy</b>
     * </p>
     *
     * @return Indicator: Actual dates from the activities
     */
    @SerializedName( "WBSElmntHasActualDateFromActy" )
    @JsonProperty( "WBSElmntHasActualDateFromActy" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "WBSElmntHasActualDateFromActy" )
    private Boolean wBSElmntHasActualDateFromActy;
    /**
     * Use with available fluent helpers to apply the <b>WBSElmntHasActualDateFromActy</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> WBS_ELMNT_HAS_ACTUAL_DATE_FROM_ACTY =
        new WBSElementInternalIDField<Boolean>("WBSElmntHasActualDateFromActy");
    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @return Object Class
     */
    @SerializedName( "ControllingObjectClass" )
    @JsonProperty( "ControllingObjectClass" )
    @Nullable
    @ODataField( odataName = "ControllingObjectClass" )
    private String controllingObjectClass;
    /**
     * Use with available fluent helpers to apply the <b>ControllingObjectClass</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> CONTROLLING_OBJECT_CLASS =
        new WBSElementInternalIDField<String>("ControllingObjectClass");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAttribute01</b>
     * </p>
     *
     * @return 1st user field for 20 characters - WBS element-
     */
    @SerializedName( "FreeDefinedAttribute01" )
    @JsonProperty( "FreeDefinedAttribute01" )
    @Nullable
    @ODataField( odataName = "FreeDefinedAttribute01" )
    private String freeDefinedAttribute01;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedAttribute01</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_ATTRIBUTE01 =
        new WBSElementInternalIDField<String>("FreeDefinedAttribute01");
    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAttribute02</b>
     * </p>
     *
     * @return 2nd user field 20 digits - WBS element
     */
    @SerializedName( "FreeDefinedAttribute02" )
    @JsonProperty( "FreeDefinedAttribute02" )
    @Nullable
    @ODataField( odataName = "FreeDefinedAttribute02" )
    private String freeDefinedAttribute02;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedAttribute02</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_ATTRIBUTE02 =
        new WBSElementInternalIDField<String>("FreeDefinedAttribute02");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAttribute03</b>
     * </p>
     *
     * @return 3rd user-defined field 10 digits -WBS element
     */
    @SerializedName( "FreeDefinedAttribute03" )
    @JsonProperty( "FreeDefinedAttribute03" )
    @Nullable
    @ODataField( odataName = "FreeDefinedAttribute03" )
    private String freeDefinedAttribute03;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedAttribute03</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_ATTRIBUTE03 =
        new WBSElementInternalIDField<String>("FreeDefinedAttribute03");
    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAttribute04</b>
     * </p>
     *
     * @return 4th user-defined field 10 digits -WBS element
     */
    @SerializedName( "FreeDefinedAttribute04" )
    @JsonProperty( "FreeDefinedAttribute04" )
    @Nullable
    @ODataField( odataName = "FreeDefinedAttribute04" )
    private String freeDefinedAttribute04;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedAttribute04</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_ATTRIBUTE04 =
        new WBSElementInternalIDField<String>("FreeDefinedAttribute04");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedQuantity1</b>
     * </p>
     *
     * @return 1st user-defined field for quantity(length 10,3) WBS element
     */
    @SerializedName( "FreeDefinedQuantity1" )
    @JsonProperty( "FreeDefinedQuantity1" )
    @Nullable
    @ODataField( odataName = "FreeDefinedQuantity1" )
    private BigDecimal freeDefinedQuantity1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedQuantity1</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<BigDecimal> FREE_DEFINED_QUANTITY1 =
        new WBSElementInternalIDField<BigDecimal>("FreeDefinedQuantity1");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedQuantity1Unit</b>
     * </p>
     *
     * @return 1st user defined field for quantity field unit - WBS element
     */
    @SerializedName( "FreeDefinedQuantity1Unit" )
    @JsonProperty( "FreeDefinedQuantity1Unit" )
    @Nullable
    @ODataField( odataName = "FreeDefinedQuantity1Unit" )
    private String freeDefinedQuantity1Unit;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedQuantity1Unit</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_QUANTITY1_UNIT =
        new WBSElementInternalIDField<String>("FreeDefinedQuantity1Unit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedQuantity2</b>
     * </p>
     *
     * @return 2nd use field for quantity (length 10,3) WBS element
     */
    @SerializedName( "FreeDefinedQuantity2" )
    @JsonProperty( "FreeDefinedQuantity2" )
    @Nullable
    @ODataField( odataName = "FreeDefinedQuantity2" )
    private BigDecimal freeDefinedQuantity2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedQuantity2</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<BigDecimal> FREE_DEFINED_QUANTITY2 =
        new WBSElementInternalIDField<BigDecimal>("FreeDefinedQuantity2");
    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedQuantity2Unit</b>
     * </p>
     *
     * @return 2nd user defined field for quantity field unit - WBS element
     */
    @SerializedName( "FreeDefinedQuantity2Unit" )
    @JsonProperty( "FreeDefinedQuantity2Unit" )
    @Nullable
    @ODataField( odataName = "FreeDefinedQuantity2Unit" )
    private String freeDefinedQuantity2Unit;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedQuantity2Unit</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_QUANTITY2_UNIT =
        new WBSElementInternalIDField<String>("FreeDefinedQuantity2Unit");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAmount1</b>
     * </p>
     *
     * @return 1st user field for values (length 10,3) WBS element
     */
    @SerializedName( "FreeDefinedAmount1" )
    @JsonProperty( "FreeDefinedAmount1" )
    @Nullable
    @ODataField( odataName = "FreeDefinedAmount1" )
    private BigDecimal freeDefinedAmount1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedAmount1</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<BigDecimal> FREE_DEFINED_AMOUNT1 =
        new WBSElementInternalIDField<BigDecimal>("FreeDefinedAmount1");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAmount1Currency</b>
     * </p>
     *
     * @return 1st user defined field for value field unit - WBS element
     */
    @SerializedName( "FreeDefinedAmount1Currency" )
    @JsonProperty( "FreeDefinedAmount1Currency" )
    @Nullable
    @ODataField( odataName = "FreeDefinedAmount1Currency" )
    private String freeDefinedAmount1Currency;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedAmount1Currency</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_AMOUNT1_CURRENCY =
        new WBSElementInternalIDField<String>("FreeDefinedAmount1Currency");
    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAmount2</b>
     * </p>
     *
     * @return 2nd user field for values (length 10,3) -WBS element
     */
    @SerializedName( "FreeDefinedAmount2" )
    @JsonProperty( "FreeDefinedAmount2" )
    @Nullable
    @ODataField( odataName = "FreeDefinedAmount2" )
    private BigDecimal freeDefinedAmount2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedAmount2</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<BigDecimal> FREE_DEFINED_AMOUNT2 =
        new WBSElementInternalIDField<BigDecimal>("FreeDefinedAmount2");
    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAmount2Currency</b>
     * </p>
     *
     * @return 2nd user defined field for value field unit - WBS element
     */
    @SerializedName( "FreeDefinedAmount2Currency" )
    @JsonProperty( "FreeDefinedAmount2Currency" )
    @Nullable
    @ODataField( odataName = "FreeDefinedAmount2Currency" )
    private String freeDefinedAmount2Currency;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedAmount2Currency</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<String> FREE_DEFINED_AMOUNT2_CURRENCY =
        new WBSElementInternalIDField<String>("FreeDefinedAmount2Currency");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate1</b>
     * </p>
     *
     * @return 1st user field for date -WBS element
     */
    @SerializedName( "FreeDefinedDate1" )
    @JsonProperty( "FreeDefinedDate1" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FreeDefinedDate1",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime freeDefinedDate1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedDate1</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> FREE_DEFINED_DATE1 =
        new WBSElementInternalIDField<LocalDateTime>("FreeDefinedDate1");
    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate2</b>
     * </p>
     *
     * @return 2nd user field for date -WBS element
     */
    @SerializedName( "FreeDefinedDate2" )
    @JsonProperty( "FreeDefinedDate2" )
    @Nullable
    @JsonSerialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeSerializer.class )
    @JsonDeserialize( using = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.JacksonLocalDateTimeDeserializer.class )
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeAdapter.class )
    @ODataField(
        odataName = "FreeDefinedDate2",
        converter = com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.LocalDateTimeCalendarConverter.class )
    private LocalDateTime freeDefinedDate2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedDate2</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<LocalDateTime> FREE_DEFINED_DATE2 =
        new WBSElementInternalIDField<LocalDateTime>("FreeDefinedDate2");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedIndicator1</b>
     * </p>
     *
     * @return 1st user field for 'Ind. for evaluations' WBS elem.
     */
    @SerializedName( "FreeDefinedIndicator1" )
    @JsonProperty( "FreeDefinedIndicator1" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FreeDefinedIndicator1" )
    private Boolean freeDefinedIndicator1;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedIndicator1</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> FREE_DEFINED_INDICATOR1 =
        new WBSElementInternalIDField<Boolean>("FreeDefinedIndicator1");
    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedIndicator2</b>
     * </p>
     *
     * @return 2nd user field for 'Indicator for eval.s' WBS elemnt
     */
    @SerializedName( "FreeDefinedIndicator2" )
    @JsonProperty( "FreeDefinedIndicator2" )
    @Nullable
    @JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataBooleanAdapter.class )
    @ODataField( odataName = "FreeDefinedIndicator2" )
    private Boolean freeDefinedIndicator2;
    /**
     * Use with available fluent helpers to apply the <b>FreeDefinedIndicator2</b> field to query operations.
     *
     */
    public final static WBSElementInternalIDField<Boolean> FREE_DEFINED_INDICATOR2 =
        new WBSElementInternalIDField<Boolean>("FreeDefinedIndicator2");

    @Nonnull
    @Override
    public Class<WBSElementInternalID> getType()
    {
        return WBSElementInternalID.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementInternalID</b>
     * </p>
     *
     * @param wBSElementInternalID
     *            WBS Element
     */
    public void setWBSElementInternalID( @Nullable final String wBSElementInternalID )
    {
        rememberChangedField("WBSElementInternalID", this.wBSElementInternalID);
        this.wBSElementInternalID = wBSElementInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ProjectInternalID</b>
     * </p>
     *
     * @param projectInternalID
     *            Project (internal)
     */
    public void setProjectInternalID( @Nullable final String projectInternalID )
    {
        rememberChangedField("ProjectInternalID", this.projectInternalID);
        this.projectInternalID = projectInternalID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSDescription</b>
     * </p>
     *
     * @param wBSDescription
     *            WBS Element Name
     */
    public void setWBSDescription( @Nullable final String wBSDescription )
    {
        rememberChangedField("WBSDescription", this.wBSDescription);
        this.wBSDescription = wBSDescription;
    }

    /**
     * Constraints: Not nullable, Maximum length: 22
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementObject</b>
     * </p>
     *
     * @param wBSElementObject
     *            Object Number
     */
    public void setWBSElementObject( @Nullable final String wBSElementObject )
    {
        rememberChangedField("WBSElementObject", this.wBSElementObject);
        this.wBSElementObject = wBSElementObject;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CreatedByUser</b>
     * </p>
     *
     * @param createdByUser
     *            Name of Person Responsible for Creating the Object
     */
    public void setCreatedByUser( @Nullable final String createdByUser )
    {
        rememberChangedField("CreatedByUser", this.createdByUser);
        this.createdByUser = createdByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>CreationDate</b>
     * </p>
     *
     * @param creationDate
     *            Record Created On
     */
    public void setCreationDate( @Nullable final LocalDateTime creationDate )
    {
        rememberChangedField("CreationDate", this.creationDate);
        this.creationDate = creationDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>LastChangedByUser</b>
     * </p>
     *
     * @param lastChangedByUser
     *            Name of Person Who Changed Object
     */
    public void setLastChangedByUser( @Nullable final String lastChangedByUser )
    {
        rememberChangedField("LastChangedByUser", this.lastChangedByUser);
        this.lastChangedByUser = lastChangedByUser;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LastChangeDate</b>
     * </p>
     *
     * @param lastChangeDate
     *            Date on which object was last changed
     */
    public void setLastChangeDate( @Nullable final LocalDateTime lastChangeDate )
    {
        rememberChangedField("LastChangeDate", this.lastChangeDate);
        this.lastChangeDate = lastChangeDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePerson</b>
     * </p>
     *
     * @param responsiblePerson
     *            Responsible Person Number (Project Manager)
     */
    public void setResponsiblePerson( @Nullable final String responsiblePerson )
    {
        rememberChangedField("ResponsiblePerson", this.responsiblePerson);
        this.responsiblePerson = responsiblePerson;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ResponsiblePersonName</b>
     * </p>
     *
     * @param responsiblePersonName
     *            Name of responsible person (Project manager)
     */
    public void setResponsiblePersonName( @Nullable final String responsiblePersonName )
    {
        rememberChangedField("ResponsiblePersonName", this.responsiblePersonName);
        this.responsiblePersonName = responsiblePersonName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 8
     * <p>
     * Original property name from the Odata EDM: <b>ApplicantCode</b>
     * </p>
     *
     * @param applicantCode
     *            Applicant number
     */
    public void setApplicantCode( @Nullable final String applicantCode )
    {
        rememberChangedField("ApplicantCode", this.applicantCode);
        this.applicantCode = applicantCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 25
     * <p>
     * Original property name from the Odata EDM: <b>ApplicantName</b>
     * </p>
     *
     * @param applicantName
     *            Applicant
     */
    public void setApplicantName( @Nullable final String applicantName )
    {
        rememberChangedField("ApplicantName", this.applicantName);
        this.applicantName = applicantName;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CompanyCode</b>
     * </p>
     *
     * @param companyCode
     *            Company Code
     */
    public void setCompanyCode( @Nullable final String companyCode )
    {
        rememberChangedField("CompanyCode", this.companyCode);
        this.companyCode = companyCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>BusinessArea</b>
     * </p>
     *
     * @param businessArea
     *            Business Area
     */
    public void setBusinessArea( @Nullable final String businessArea )
    {
        rememberChangedField("BusinessArea", this.businessArea);
        this.businessArea = businessArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ControllingArea</b>
     * </p>
     *
     * @param controllingArea
     *            Controlling Area
     */
    public void setControllingArea( @Nullable final String controllingArea )
    {
        rememberChangedField("ControllingArea", this.controllingArea);
        this.controllingArea = controllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ProfitCenter</b>
     * </p>
     *
     * @param profitCenter
     *            Profit Center
     */
    public void setProfitCenter( @Nullable final String profitCenter )
    {
        rememberChangedField("ProfitCenter", this.profitCenter);
        this.profitCenter = profitCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ProjectType</b>
     * </p>
     *
     * @param projectType
     *            Project type
     */
    public void setProjectType( @Nullable final String projectType )
    {
        rememberChangedField("ProjectType", this.projectType);
        this.projectType = projectType;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsPlanningElement</b>
     * </p>
     *
     * @param wBSElementIsPlanningElement
     *            Indicator: Planning element
     */
    public void setWBSElementIsPlanningElement( @Nullable final Boolean wBSElementIsPlanningElement )
    {
        rememberChangedField("WBSElementIsPlanningElement", this.wBSElementIsPlanningElement);
        this.wBSElementIsPlanningElement = wBSElementIsPlanningElement;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsAccountAssignmentElement</b>
     * </p>
     *
     * @param wBSIsAccountAssignmentElement
     *            Indicator: Account assignment element
     */
    public void setWBSIsAccountAssignmentElement( @Nullable final Boolean wBSIsAccountAssignmentElement )
    {
        rememberChangedField("WBSIsAccountAssignmentElement", this.wBSIsAccountAssignmentElement);
        this.wBSIsAccountAssignmentElement = wBSIsAccountAssignmentElement;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsBillingElement</b>
     * </p>
     *
     * @param wBSElementIsBillingElement
     *            Indicator: Billing element
     */
    public void setWBSElementIsBillingElement( @Nullable final Boolean wBSElementIsBillingElement )
    {
        rememberChangedField("WBSElementIsBillingElement", this.wBSElementIsBillingElement);
        this.wBSElementIsBillingElement = wBSElementIsBillingElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>CostingSheet</b>
     * </p>
     *
     * @param costingSheet
     *            Costing Sheet
     */
    public void setCostingSheet( @Nullable final String costingSheet )
    {
        rememberChangedField("CostingSheet", this.costingSheet);
        this.costingSheet = costingSheet;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>RequestingCostCenter</b>
     * </p>
     *
     * @param requestingCostCenter
     *            Requesting cost center
     */
    public void setRequestingCostCenter( @Nullable final String requestingCostCenter )
    {
        rememberChangedField("RequestingCostCenter", this.requestingCostCenter);
        this.requestingCostCenter = requestingCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>ResponsibleCostCenter</b>
     * </p>
     *
     * @param responsibleCostCenter
     *            Responsible Cost Center
     */
    public void setResponsibleCostCenter( @Nullable final String responsibleCostCenter )
    {
        rememberChangedField("ResponsibleCostCenter", this.responsibleCostCenter);
        this.responsibleCostCenter = responsibleCostCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>FactoryCalendar</b>
     * </p>
     *
     * @param factoryCalendar
     *            Calendar
     */
    public void setFactoryCalendar( @Nullable final String factoryCalendar )
    {
        rememberChangedField("FactoryCalendar", this.factoryCalendar);
        this.factoryCalendar = factoryCalendar;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>PriorityCode</b>
     * </p>
     *
     * @param priorityCode
     *            Priority
     */
    public void setPriorityCode( @Nullable final String priorityCode )
    {
        rememberChangedField("PriorityCode", this.priorityCode);
        this.priorityCode = priorityCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>Currency</b>
     * </p>
     *
     * @param currency
     *            WBS element currency
     */
    public void setCurrency( @Nullable final String currency )
    {
        rememberChangedField("Currency", this.currency);
        this.currency = currency;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>Plant</b>
     * </p>
     *
     * @param plant
     *            Plant
     */
    public void setPlant( @Nullable final String plant )
    {
        rememberChangedField("Plant", this.plant);
        this.plant = plant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedTableFieldSemantic</b>
     * </p>
     *
     * @param freeDefinedTableFieldSemantic
     *            Key word ID for user-defined fields
     */
    public void setFreeDefinedTableFieldSemantic( @Nullable final String freeDefinedTableFieldSemantic )
    {
        rememberChangedField("FreeDefinedTableFieldSemantic", this.freeDefinedTableFieldSemantic);
        this.freeDefinedTableFieldSemantic = freeDefinedTableFieldSemantic;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsStatisticalWBSElement</b>
     * </p>
     *
     * @param wBSIsStatisticalWBSElement
     *            Statistical WBS element
     */
    public void setWBSIsStatisticalWBSElement( @Nullable final Boolean wBSIsStatisticalWBSElement )
    {
        rememberChangedField("WBSIsStatisticalWBSElement", this.wBSIsStatisticalWBSElement);
        this.wBSIsStatisticalWBSElement = wBSIsStatisticalWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 15
     * <p>
     * Original property name from the Odata EDM: <b>TaxJurisdiction</b>
     * </p>
     *
     * @param taxJurisdiction
     *            Tax Jurisdiction
     */
    public void setTaxJurisdiction( @Nullable final String taxJurisdiction )
    {
        rememberChangedField("TaxJurisdiction", this.taxJurisdiction);
        this.taxJurisdiction = taxJurisdiction;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSIsMarkedForIntegratedPlng</b>
     * </p>
     *
     * @param wBSIsMarkedForIntegratedPlng
     *            Indicator 'Integrated Planning' for Cost Object Category
     */
    public void setWBSIsMarkedForIntegratedPlng( @Nullable final Boolean wBSIsMarkedForIntegratedPlng )
    {
        rememberChangedField("WBSIsMarkedForIntegratedPlng", this.wBSIsMarkedForIntegratedPlng);
        this.wBSIsMarkedForIntegratedPlng = wBSIsMarkedForIntegratedPlng;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalArea</b>
     * </p>
     *
     * @param functionalArea
     *            Functional Area
     */
    public void setFunctionalArea( @Nullable final String functionalArea )
    {
        rememberChangedField("FunctionalArea", this.functionalArea);
        this.functionalArea = functionalArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>Location</b>
     * </p>
     *
     * @param location
     *            Location
     */
    public void setLocation( @Nullable final String location )
    {
        rememberChangedField("Location", this.location);
        this.location = location;
    }

    /**
     * Constraints: Not nullable, Maximum length: 18
     * <p>
     * Original property name from the Odata EDM: <b>Equipment</b>
     * </p>
     *
     * @param equipment
     *            Equipment Number
     */
    public void setEquipment( @Nullable final String equipment )
    {
        rememberChangedField("Equipment", this.equipment);
        this.equipment = equipment;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>FunctionalLocation</b>
     * </p>
     *
     * @param functionalLocation
     *            Functional Location
     */
    public void setFunctionalLocation( @Nullable final String functionalLocation )
    {
        rememberChangedField("FunctionalLocation", this.functionalLocation);
        this.functionalLocation = functionalLocation;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>ProjectObjectChangeNumber</b>
     * </p>
     *
     * @param projectObjectChangeNumber
     *            Change Number
     */
    public void setProjectObjectChangeNumber( @Nullable final String projectObjectChangeNumber )
    {
        rememberChangedField("ProjectObjectChangeNumber", this.projectObjectChangeNumber);
        this.projectObjectChangeNumber = projectObjectChangeNumber;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>ProjectObjectReferenceElement</b>
     * </p>
     *
     * @param projectObjectReferenceElement
     *            Reference Element PM/PS
     */
    public void setProjectObjectReferenceElement( @Nullable final String projectObjectReferenceElement )
    {
        rememberChangedField("ProjectObjectReferenceElement", this.projectObjectReferenceElement);
        this.projectObjectReferenceElement = projectObjectReferenceElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 7
     * <p>
     * Original property name from the Odata EDM: <b>ProjInterestCalcProfile</b>
     * </p>
     *
     * @param projInterestCalcProfile
     *            Interest Profile for Project/Order Interest Calculation
     */
    public void setProjInterestCalcProfile( @Nullable final String projInterestCalcProfile )
    {
        rememberChangedField("ProjInterestCalcProfile", this.projInterestCalcProfile);
        this.projInterestCalcProfile = projInterestCalcProfile;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>InvestmentProfile</b>
     * </p>
     *
     * @param investmentProfile
     *            Investment Measure Profile
     */
    public void setInvestmentProfile( @Nullable final String investmentProfile )
    {
        rememberChangedField("InvestmentProfile", this.investmentProfile);
        this.investmentProfile = investmentProfile;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BasicStartDate</b>
     * </p>
     *
     * @param basicStartDate
     *            WBS element: Basic start date
     */
    public void setBasicStartDate( @Nullable final LocalDateTime basicStartDate )
    {
        rememberChangedField("BasicStartDate", this.basicStartDate);
        this.basicStartDate = basicStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ForecastedStartDate</b>
     * </p>
     *
     * @param forecastedStartDate
     *            Forecast Start Date of WBS Element
     */
    public void setForecastedStartDate( @Nullable final LocalDateTime forecastedStartDate )
    {
        rememberChangedField("ForecastedStartDate", this.forecastedStartDate);
        this.forecastedStartDate = forecastedStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualStartDate</b>
     * </p>
     *
     * @param actualStartDate
     *            Actual start date for the WBS element
     */
    public void setActualStartDate( @Nullable final LocalDateTime actualStartDate )
    {
        rememberChangedField("ActualStartDate", this.actualStartDate);
        this.actualStartDate = actualStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>BasicEndDate</b>
     * </p>
     *
     * @param basicEndDate
     *            WBS element: Basic finish date
     */
    public void setBasicEndDate( @Nullable final LocalDateTime basicEndDate )
    {
        rememberChangedField("BasicEndDate", this.basicEndDate);
        this.basicEndDate = basicEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ForecastedEndDate</b>
     * </p>
     *
     * @param forecastedEndDate
     *            Forecast Finish Date of WBS Element
     */
    public void setForecastedEndDate( @Nullable final LocalDateTime forecastedEndDate )
    {
        rememberChangedField("ForecastedEndDate", this.forecastedEndDate);
        this.forecastedEndDate = forecastedEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ActualEndDate</b>
     * </p>
     *
     * @param actualEndDate
     *            Actual finish date of the WBS element
     */
    public void setActualEndDate( @Nullable final LocalDateTime actualEndDate )
    {
        rememberChangedField("ActualEndDate", this.actualEndDate);
        this.actualEndDate = actualEndDate;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ActualDurationUnit</b>
     * </p>
     *
     * @param actualDurationUnit
     *            Unit for duration of actual WBS element dates
     */
    public void setActualDurationUnit( @Nullable final String actualDurationUnit )
    {
        rememberChangedField("ActualDurationUnit", this.actualDurationUnit);
        this.actualDurationUnit = actualDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>ForecastedDurationUnit</b>
     * </p>
     *
     * @param forecastedDurationUnit
     *            Unit for duration of WBS element planned dates
     */
    public void setForecastedDurationUnit( @Nullable final String forecastedDurationUnit )
    {
        rememberChangedField("ForecastedDurationUnit", this.forecastedDurationUnit);
        this.forecastedDurationUnit = forecastedDurationUnit;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>BasicDurationUnit</b>
     * </p>
     *
     * @param basicDurationUnit
     *            Unit for duration of basic WBS element dates
     */
    public void setBasicDurationUnit( @Nullable final String basicDurationUnit )
    {
        rememberChangedField("BasicDurationUnit", this.basicDurationUnit);
        this.basicDurationUnit = basicDurationUnit;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>BasicDuration</b>
     * </p>
     *
     * @param basicDuration
     *            Length (duration) of the basic dates in the WBS element
     */
    public void setBasicDuration( @Nullable final BigDecimal basicDuration )
    {
        rememberChangedField("BasicDuration", this.basicDuration);
        this.basicDuration = basicDuration;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ForecastedDuration</b>
     * </p>
     *
     * @param forecastedDuration
     *            Forecasted length (duration) of the WBS element
     */
    public void setForecastedDuration( @Nullable final BigDecimal forecastedDuration )
    {
        rememberChangedField("ForecastedDuration", this.forecastedDuration);
        this.forecastedDuration = forecastedDuration;
    }

    /**
     * Constraints: Not nullable, Precision: 5, Scale: 1
     * <p>
     * Original property name from the Odata EDM: <b>ActualDuration</b>
     * </p>
     *
     * @param actualDuration
     *            Actual length (duration) of the WBS element
     */
    public void setActualDuration( @Nullable final BigDecimal actualDuration )
    {
        rememberChangedField("ActualDuration", this.actualDuration);
        this.actualDuration = actualDuration;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldBasicEarliestStartDate</b>
     * </p>
     *
     * @param schedldBasicEarliestStartDate
     *            Earliest scheduled start date (Basic)
     */
    public void setSchedldBasicEarliestStartDate( @Nullable final LocalDateTime schedldBasicEarliestStartDate )
    {
        rememberChangedField("SchedldBasicEarliestStartDate", this.schedldBasicEarliestStartDate);
        this.schedldBasicEarliestStartDate = schedldBasicEarliestStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>ScheduledBasicLatestEndDate</b>
     * </p>
     *
     * @param scheduledBasicLatestEndDate
     *            Latest scheduled finish date (basic)
     */
    public void setScheduledBasicLatestEndDate( @Nullable final LocalDateTime scheduledBasicLatestEndDate )
    {
        rememberChangedField("ScheduledBasicLatestEndDate", this.scheduledBasicLatestEndDate);
        this.scheduledBasicLatestEndDate = scheduledBasicLatestEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldFcstdEarliestStartDate</b>
     * </p>
     *
     * @param schedldFcstdEarliestStartDate
     *            Scheduled start date (Forecast)
     */
    public void setSchedldFcstdEarliestStartDate( @Nullable final LocalDateTime schedldFcstdEarliestStartDate )
    {
        rememberChangedField("SchedldFcstdEarliestStartDate", this.schedldFcstdEarliestStartDate);
        this.schedldFcstdEarliestStartDate = schedldFcstdEarliestStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldFcstdEndDate</b>
     * </p>
     *
     * @param latestSchedldFcstdEndDate
     *            Latest scheduled finish date (Forecast)
     */
    public void setLatestSchedldFcstdEndDate( @Nullable final LocalDateTime latestSchedldFcstdEndDate )
    {
        rememberChangedField("LatestSchedldFcstdEndDate", this.latestSchedldFcstdEndDate);
        this.latestSchedldFcstdEndDate = latestSchedldFcstdEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TentativeActualStartDate</b>
     * </p>
     *
     * @param tentativeActualStartDate
     *            Tentative actual start date for WBS element
     */
    public void setTentativeActualStartDate( @Nullable final LocalDateTime tentativeActualStartDate )
    {
        rememberChangedField("TentativeActualStartDate", this.tentativeActualStartDate);
        this.tentativeActualStartDate = tentativeActualStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>TentativeActualEndDate</b>
     * </p>
     *
     * @param tentativeActualEndDate
     *            Tentative actual finish date for WBS element
     */
    public void setTentativeActualEndDate( @Nullable final LocalDateTime tentativeActualEndDate )
    {
        rememberChangedField("TentativeActualEndDate", this.tentativeActualEndDate);
        this.tentativeActualEndDate = tentativeActualEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldBasicLatestStartDate</b>
     * </p>
     *
     * @param schedldBasicLatestStartDate
     *            Latest scheduled start date (basic)
     */
    public void setSchedldBasicLatestStartDate( @Nullable final LocalDateTime schedldBasicLatestStartDate )
    {
        rememberChangedField("SchedldBasicLatestStartDate", this.schedldBasicLatestStartDate);
        this.schedldBasicLatestStartDate = schedldBasicLatestStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldBasicEarliestEndDate</b>
     * </p>
     *
     * @param schedldBasicEarliestEndDate
     *            Earliest Finish Date
     */
    public void setSchedldBasicEarliestEndDate( @Nullable final LocalDateTime schedldBasicEarliestEndDate )
    {
        rememberChangedField("SchedldBasicEarliestEndDate", this.schedldBasicEarliestEndDate);
        this.schedldBasicEarliestEndDate = schedldBasicEarliestEndDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>LatestSchedldFcstdStartDate</b>
     * </p>
     *
     * @param latestSchedldFcstdStartDate
     *            Latest scheduled start date (forecast)
     */
    public void setLatestSchedldFcstdStartDate( @Nullable final LocalDateTime latestSchedldFcstdStartDate )
    {
        rememberChangedField("LatestSchedldFcstdStartDate", this.latestSchedldFcstdStartDate);
        this.latestSchedldFcstdStartDate = latestSchedldFcstdStartDate;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>SchedldFcstdEarliestEndDate</b>
     * </p>
     *
     * @param schedldFcstdEarliestEndDate
     *            Earliest scheduled finish date (forecast)
     */
    public void setSchedldFcstdEarliestEndDate( @Nullable final LocalDateTime schedldFcstdEarliestEndDate )
    {
        rememberChangedField("SchedldFcstdEarliestEndDate", this.schedldFcstdEarliestEndDate);
        this.schedldFcstdEarliestEndDate = schedldFcstdEarliestEndDate;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementHierarchyLevel</b>
     * </p>
     *
     * @param wBSElementHierarchyLevel
     *            Level in Project Hierarchy
     */
    public void setWBSElementHierarchyLevel( @Nullable final Short wBSElementHierarchyLevel )
    {
        rememberChangedField("WBSElementHierarchyLevel", this.wBSElementHierarchyLevel);
        this.wBSElementHierarchyLevel = wBSElementHierarchyLevel;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>OverheadCode</b>
     * </p>
     *
     * @param overheadCode
     *            Overhead Key
     */
    public void setOverheadCode( @Nullable final String overheadCode )
    {
        rememberChangedField("OverheadCode", this.overheadCode);
        this.overheadCode = overheadCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>ResultAnalysisInternalID</b>
     * </p>
     *
     * @param resultAnalysisInternalID
     *            Results Analysis Key
     */
    public void setResultAnalysisInternalID( @Nullable final String resultAnalysisInternalID )
    {
        rememberChangedField("ResultAnalysisInternalID", this.resultAnalysisInternalID);
        this.resultAnalysisInternalID = resultAnalysisInternalID;
    }

    /**
     * Constraints: Not nullable, Precision: 8, Scale: 0
     * <p>
     * Original property name from the Odata EDM: <b>ProgressAnlysAggregationWeight</b>
     * </p>
     *
     * @param progressAnlysAggregationWeight
     *            Aggregation weight for POC (PS progress)
     */
    public void setProgressAnlysAggregationWeight( @Nullable final BigDecimal progressAnlysAggregationWeight )
    {
        rememberChangedField("ProgressAnlysAggregationWeight", this.progressAnlysAggregationWeight);
        this.progressAnlysAggregationWeight = progressAnlysAggregationWeight;
    }

    /**
     * Constraints: Not nullable, Maximum length: 16
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementShortID</b>
     * </p>
     *
     * @param wBSElementShortID
     *            WBS element short identification
     */
    public void setWBSElementShortID( @Nullable final String wBSElementShortID )
    {
        rememberChangedField("WBSElementShortID", this.wBSElementShortID);
        this.wBSElementShortID = wBSElementShortID;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>ReqgCostCenterControllingArea</b>
     * </p>
     *
     * @param reqgCostCenterControllingArea
     *            Controlling area of requesting cost center
     */
    public void setReqgCostCenterControllingArea( @Nullable final String reqgCostCenterControllingArea )
    {
        rememberChangedField("ReqgCostCenterControllingArea", this.reqgCostCenterControllingArea);
        this.reqgCostCenterControllingArea = reqgCostCenterControllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>RespCostCenterControllingArea</b>
     * </p>
     *
     * @param respCostCenterControllingArea
     *            Responsible Cost Center Controlling Area
     */
    public void setRespCostCenterControllingArea( @Nullable final String respCostCenterControllingArea )
    {
        rememberChangedField("RespCostCenterControllingArea", this.respCostCenterControllingArea);
        this.respCostCenterControllingArea = respCostCenterControllingArea;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>CostCenter</b>
     * </p>
     *
     * @param costCenter
     *            Cost center to which costs are actually posted
     */
    public void setCostCenter( @Nullable final String costCenter )
    {
        rememberChangedField("CostCenter", this.costCenter);
        this.costCenter = costCenter;
    }

    /**
     * Constraints: Not nullable, Maximum length: 12
     * <p>
     * Original property name from the Odata EDM: <b>CostObject</b>
     * </p>
     *
     * @param costObject
     *            Cost Object
     */
    public void setCostObject( @Nullable final String costObject )
    {
        rememberChangedField("CostObject", this.costObject);
        this.costObject = costObject;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsUsedInProjSmmry</b>
     * </p>
     *
     * @param wBSElementIsUsedInProjSmmry
     *            Indicator: WBS element used in project summarization
     */
    public void setWBSElementIsUsedInProjSmmry( @Nullable final Boolean wBSElementIsUsedInProjSmmry )
    {
        rememberChangedField("WBSElementIsUsedInProjSmmry", this.wBSElementIsUsedInProjSmmry);
        this.wBSElementIsUsedInProjSmmry = wBSElementIsUsedInProjSmmry;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>IsMarkedForDeletion</b>
     * </p>
     *
     * @param isMarkedForDeletion
     *            Deletion Indicator
     */
    public void setIsMarkedForDeletion( @Nullable final Boolean isMarkedForDeletion )
    {
        rememberChangedField("IsMarkedForDeletion", this.isMarkedForDeletion);
        this.isMarkedForDeletion = isMarkedForDeletion;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>InventorySpecialStockValnType</b>
     * </p>
     *
     * @param inventorySpecialStockValnType
     *            Valuation of Special Stock
     */
    public void setInventorySpecialStockValnType( @Nullable final String inventorySpecialStockValnType )
    {
        rememberChangedField("InventorySpecialStockValnType", this.inventorySpecialStockValnType);
        this.inventorySpecialStockValnType = inventorySpecialStockValnType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>BillingPlan</b>
     * </p>
     *
     * @param billingPlan
     *            Billing Plan Number / Invoicing Plan Number
     */
    public void setBillingPlan( @Nullable final String billingPlan )
    {
        rememberChangedField("BillingPlan", this.billingPlan);
        this.billingPlan = billingPlan;
    }

    /**
     * Constraints: Not nullable, Maximum length: 1
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementIsGroupingWBSElement</b>
     * </p>
     *
     * @param wBSElementIsGroupingWBSElement
     *            Indicator: Grouping WBS element
     */
    public void setWBSElementIsGroupingWBSElement( @Nullable final String wBSElementIsGroupingWBSElement )
    {
        rememberChangedField("WBSElementIsGroupingWBSElement", this.wBSElementIsGroupingWBSElement);
        this.wBSElementIsGroupingWBSElement = wBSElementIsGroupingWBSElement;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>CostingVariant</b>
     * </p>
     *
     * @param costingVariant
     *            Costing Variant
     */
    public void setCostingVariant( @Nullable final String costingVariant )
    {
        rememberChangedField("CostingVariant", this.costingVariant);
        this.costingVariant = costingVariant;
    }

    /**
     * Constraints: Not nullable, Maximum length: 6
     * <p>
     * Original property name from the Odata EDM: <b>JointVenture</b>
     * </p>
     *
     * @param jointVenture
     *            Joint Venture
     */
    public void setJointVenture( @Nullable final String jointVenture )
    {
        rememberChangedField("JointVenture", this.jointVenture);
        this.jointVenture = jointVenture;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureRecoveryCode</b>
     * </p>
     *
     * @param jointVentureRecoveryCode
     *            Recovery Indicator
     */
    public void setJointVentureRecoveryCode( @Nullable final String jointVentureRecoveryCode )
    {
        rememberChangedField("JointVentureRecoveryCode", this.jointVentureRecoveryCode);
        this.jointVentureRecoveryCode = jointVentureRecoveryCode;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureEquityType</b>
     * </p>
     *
     * @param jointVentureEquityType
     *            Equity Type
     */
    public void setJointVentureEquityType( @Nullable final String jointVentureEquityType )
    {
        rememberChangedField("JointVentureEquityType", this.jointVentureEquityType);
        this.jointVentureEquityType = jointVentureEquityType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 4
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureObjectType</b>
     * </p>
     *
     * @param jointVentureObjectType
     *            Joint Venture Object Type
     */
    public void setJointVentureObjectType( @Nullable final String jointVentureObjectType )
    {
        rememberChangedField("JointVentureObjectType", this.jointVentureObjectType);
        this.jointVentureObjectType = jointVentureObjectType;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureClass</b>
     * </p>
     *
     * @param jointVentureClass
     *            JIB/JIBE Class
     */
    public void setJointVentureClass( @Nullable final String jointVentureClass )
    {
        rememberChangedField("JointVentureClass", this.jointVentureClass);
        this.jointVentureClass = jointVentureClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>JointVentureSubClass</b>
     * </p>
     *
     * @param jointVentureSubClass
     *            JIB/JIBE Subclass A
     */
    public void setJointVentureSubClass( @Nullable final String jointVentureSubClass )
    {
        rememberChangedField("JointVentureSubClass", this.jointVentureSubClass);
        this.jointVentureSubClass = jointVentureSubClass;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementHasActivities</b>
     * </p>
     *
     * @param wBSElementHasActivities
     *            Indicator: There are activities for the WBS elements
     */
    public void setWBSElementHasActivities( @Nullable final Boolean wBSElementHasActivities )
    {
        rememberChangedField("WBSElementHasActivities", this.wBSElementHasActivities);
        this.wBSElementHasActivities = wBSElementHasActivities;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSHasFcstdDateFromActivity</b>
     * </p>
     *
     * @param wBSHasFcstdDateFromActivity
     *            Indicator: Expected dates from the activities
     */
    public void setWBSHasFcstdDateFromActivity( @Nullable final Boolean wBSHasFcstdDateFromActivity )
    {
        rememberChangedField("WBSHasFcstdDateFromActivity", this.wBSHasFcstdDateFromActivity);
        this.wBSHasFcstdDateFromActivity = wBSHasFcstdDateFromActivity;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSHasFcstdDateSetManually</b>
     * </p>
     *
     * @param wBSHasFcstdDateSetManually
     *            Indicator: Forecast dates set manually
     */
    public void setWBSHasFcstdDateSetManually( @Nullable final Boolean wBSHasFcstdDateSetManually )
    {
        rememberChangedField("WBSHasFcstdDateSetManually", this.wBSHasFcstdDateSetManually);
        this.wBSHasFcstdDateSetManually = wBSHasFcstdDateSetManually;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSHasBasicDateManuallySet</b>
     * </p>
     *
     * @param wBSHasBasicDateManuallySet
     *            Indicator: Basic dates set manually
     */
    public void setWBSHasBasicDateManuallySet( @Nullable final Boolean wBSHasBasicDateManuallySet )
    {
        rememberChangedField("WBSHasBasicDateManuallySet", this.wBSHasBasicDateManuallySet);
        this.wBSHasBasicDateManuallySet = wBSHasBasicDateManuallySet;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSHasActualDateSetManually</b>
     * </p>
     *
     * @param wBSHasActualDateSetManually
     *            Indicator: Actual dates set manually
     */
    public void setWBSHasActualDateSetManually( @Nullable final Boolean wBSHasActualDateSetManually )
    {
        rememberChangedField("WBSHasActualDateSetManually", this.wBSHasActualDateSetManually);
        this.wBSHasActualDateSetManually = wBSHasActualDateSetManually;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>WBSElmntHasActualDateFromActy</b>
     * </p>
     *
     * @param wBSElmntHasActualDateFromActy
     *            Indicator: Actual dates from the activities
     */
    public void setWBSElmntHasActualDateFromActy( @Nullable final Boolean wBSElmntHasActualDateFromActy )
    {
        rememberChangedField("WBSElmntHasActualDateFromActy", this.wBSElmntHasActualDateFromActy);
        this.wBSElmntHasActualDateFromActy = wBSElmntHasActualDateFromActy;
    }

    /**
     * Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>ControllingObjectClass</b>
     * </p>
     *
     * @param controllingObjectClass
     *            Object Class
     */
    public void setControllingObjectClass( @Nullable final String controllingObjectClass )
    {
        rememberChangedField("ControllingObjectClass", this.controllingObjectClass);
        this.controllingObjectClass = controllingObjectClass;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAttribute01</b>
     * </p>
     *
     * @param freeDefinedAttribute01
     *            1st user field for 20 characters - WBS element-
     */
    public void setFreeDefinedAttribute01( @Nullable final String freeDefinedAttribute01 )
    {
        rememberChangedField("FreeDefinedAttribute01", this.freeDefinedAttribute01);
        this.freeDefinedAttribute01 = freeDefinedAttribute01;
    }

    /**
     * Constraints: Not nullable, Maximum length: 20
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAttribute02</b>
     * </p>
     *
     * @param freeDefinedAttribute02
     *            2nd user field 20 digits - WBS element
     */
    public void setFreeDefinedAttribute02( @Nullable final String freeDefinedAttribute02 )
    {
        rememberChangedField("FreeDefinedAttribute02", this.freeDefinedAttribute02);
        this.freeDefinedAttribute02 = freeDefinedAttribute02;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAttribute03</b>
     * </p>
     *
     * @param freeDefinedAttribute03
     *            3rd user-defined field 10 digits -WBS element
     */
    public void setFreeDefinedAttribute03( @Nullable final String freeDefinedAttribute03 )
    {
        rememberChangedField("FreeDefinedAttribute03", this.freeDefinedAttribute03);
        this.freeDefinedAttribute03 = freeDefinedAttribute03;
    }

    /**
     * Constraints: Not nullable, Maximum length: 10
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAttribute04</b>
     * </p>
     *
     * @param freeDefinedAttribute04
     *            4th user-defined field 10 digits -WBS element
     */
    public void setFreeDefinedAttribute04( @Nullable final String freeDefinedAttribute04 )
    {
        rememberChangedField("FreeDefinedAttribute04", this.freeDefinedAttribute04);
        this.freeDefinedAttribute04 = freeDefinedAttribute04;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedQuantity1</b>
     * </p>
     *
     * @param freeDefinedQuantity1
     *            1st user-defined field for quantity(length 10,3) WBS element
     */
    public void setFreeDefinedQuantity1( @Nullable final BigDecimal freeDefinedQuantity1 )
    {
        rememberChangedField("FreeDefinedQuantity1", this.freeDefinedQuantity1);
        this.freeDefinedQuantity1 = freeDefinedQuantity1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedQuantity1Unit</b>
     * </p>
     *
     * @param freeDefinedQuantity1Unit
     *            1st user defined field for quantity field unit - WBS element
     */
    public void setFreeDefinedQuantity1Unit( @Nullable final String freeDefinedQuantity1Unit )
    {
        rememberChangedField("FreeDefinedQuantity1Unit", this.freeDefinedQuantity1Unit);
        this.freeDefinedQuantity1Unit = freeDefinedQuantity1Unit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedQuantity2</b>
     * </p>
     *
     * @param freeDefinedQuantity2
     *            2nd use field for quantity (length 10,3) WBS element
     */
    public void setFreeDefinedQuantity2( @Nullable final BigDecimal freeDefinedQuantity2 )
    {
        rememberChangedField("FreeDefinedQuantity2", this.freeDefinedQuantity2);
        this.freeDefinedQuantity2 = freeDefinedQuantity2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedQuantity2Unit</b>
     * </p>
     *
     * @param freeDefinedQuantity2Unit
     *            2nd user defined field for quantity field unit - WBS element
     */
    public void setFreeDefinedQuantity2Unit( @Nullable final String freeDefinedQuantity2Unit )
    {
        rememberChangedField("FreeDefinedQuantity2Unit", this.freeDefinedQuantity2Unit);
        this.freeDefinedQuantity2Unit = freeDefinedQuantity2Unit;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAmount1</b>
     * </p>
     *
     * @param freeDefinedAmount1
     *            1st user field for values (length 10,3) WBS element
     */
    public void setFreeDefinedAmount1( @Nullable final BigDecimal freeDefinedAmount1 )
    {
        rememberChangedField("FreeDefinedAmount1", this.freeDefinedAmount1);
        this.freeDefinedAmount1 = freeDefinedAmount1;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAmount1Currency</b>
     * </p>
     *
     * @param freeDefinedAmount1Currency
     *            1st user defined field for value field unit - WBS element
     */
    public void setFreeDefinedAmount1Currency( @Nullable final String freeDefinedAmount1Currency )
    {
        rememberChangedField("FreeDefinedAmount1Currency", this.freeDefinedAmount1Currency);
        this.freeDefinedAmount1Currency = freeDefinedAmount1Currency;
    }

    /**
     * Constraints: Not nullable, Precision: 13, Scale: 3
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAmount2</b>
     * </p>
     *
     * @param freeDefinedAmount2
     *            2nd user field for values (length 10,3) -WBS element
     */
    public void setFreeDefinedAmount2( @Nullable final BigDecimal freeDefinedAmount2 )
    {
        rememberChangedField("FreeDefinedAmount2", this.freeDefinedAmount2);
        this.freeDefinedAmount2 = freeDefinedAmount2;
    }

    /**
     * Constraints: Not nullable, Maximum length: 5
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedAmount2Currency</b>
     * </p>
     *
     * @param freeDefinedAmount2Currency
     *            2nd user defined field for value field unit - WBS element
     */
    public void setFreeDefinedAmount2Currency( @Nullable final String freeDefinedAmount2Currency )
    {
        rememberChangedField("FreeDefinedAmount2Currency", this.freeDefinedAmount2Currency);
        this.freeDefinedAmount2Currency = freeDefinedAmount2Currency;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate1</b>
     * </p>
     *
     * @param freeDefinedDate1
     *            1st user field for date -WBS element
     */
    public void setFreeDefinedDate1( @Nullable final LocalDateTime freeDefinedDate1 )
    {
        rememberChangedField("FreeDefinedDate1", this.freeDefinedDate1);
        this.freeDefinedDate1 = freeDefinedDate1;
    }

    /**
     * Constraints: Not nullable, Precision: 0
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedDate2</b>
     * </p>
     *
     * @param freeDefinedDate2
     *            2nd user field for date -WBS element
     */
    public void setFreeDefinedDate2( @Nullable final LocalDateTime freeDefinedDate2 )
    {
        rememberChangedField("FreeDefinedDate2", this.freeDefinedDate2);
        this.freeDefinedDate2 = freeDefinedDate2;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedIndicator1</b>
     * </p>
     *
     * @param freeDefinedIndicator1
     *            1st user field for 'Ind. for evaluations' WBS elem.
     */
    public void setFreeDefinedIndicator1( @Nullable final Boolean freeDefinedIndicator1 )
    {
        rememberChangedField("FreeDefinedIndicator1", this.freeDefinedIndicator1);
        this.freeDefinedIndicator1 = freeDefinedIndicator1;
    }

    /**
     * Constraints: none
     * <p>
     * Original property name from the Odata EDM: <b>FreeDefinedIndicator2</b>
     * </p>
     *
     * @param freeDefinedIndicator2
     *            2nd user field for 'Indicator for eval.s' WBS elemnt
     */
    public void setFreeDefinedIndicator2( @Nullable final Boolean freeDefinedIndicator2 )
    {
        rememberChangedField("FreeDefinedIndicator2", this.freeDefinedIndicator2);
        this.freeDefinedIndicator2 = freeDefinedIndicator2;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WBSElementInternalID";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("WBSElementInternalID", getWBSElementInternalID());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("WBSElementInternalID", getWBSElementInternalID());
        values.put("ProjectInternalID", getProjectInternalID());
        values.put("WBSElement", getWBSElement());
        values.put("WBSDescription", getWBSDescription());
        values.put("WBSElementObject", getWBSElementObject());
        values.put("CreatedByUser", getCreatedByUser());
        values.put("CreationDate", getCreationDate());
        values.put("LastChangedByUser", getLastChangedByUser());
        values.put("LastChangeDate", getLastChangeDate());
        values.put("ResponsiblePerson", getResponsiblePerson());
        values.put("ResponsiblePersonName", getResponsiblePersonName());
        values.put("ApplicantCode", getApplicantCode());
        values.put("ApplicantName", getApplicantName());
        values.put("CompanyCode", getCompanyCode());
        values.put("BusinessArea", getBusinessArea());
        values.put("ControllingArea", getControllingArea());
        values.put("ProfitCenter", getProfitCenter());
        values.put("ProjectType", getProjectType());
        values.put("WBSElementIsPlanningElement", getWBSElementIsPlanningElement());
        values.put("WBSIsAccountAssignmentElement", getWBSIsAccountAssignmentElement());
        values.put("WBSElementIsBillingElement", getWBSElementIsBillingElement());
        values.put("CostingSheet", getCostingSheet());
        values.put("RequestingCostCenter", getRequestingCostCenter());
        values.put("ResponsibleCostCenter", getResponsibleCostCenter());
        values.put("FactoryCalendar", getFactoryCalendar());
        values.put("PriorityCode", getPriorityCode());
        values.put("Currency", getCurrency());
        values.put("Plant", getPlant());
        values.put("FreeDefinedTableFieldSemantic", getFreeDefinedTableFieldSemantic());
        values.put("WBSIsStatisticalWBSElement", getWBSIsStatisticalWBSElement());
        values.put("TaxJurisdiction", getTaxJurisdiction());
        values.put("WBSIsMarkedForIntegratedPlng", getWBSIsMarkedForIntegratedPlng());
        values.put("FunctionalArea", getFunctionalArea());
        values.put("Location", getLocation());
        values.put("Equipment", getEquipment());
        values.put("FunctionalLocation", getFunctionalLocation());
        values.put("ProjectObjectChangeNumber", getProjectObjectChangeNumber());
        values.put("ProjectObjectReferenceElement", getProjectObjectReferenceElement());
        values.put("ProjInterestCalcProfile", getProjInterestCalcProfile());
        values.put("InvestmentProfile", getInvestmentProfile());
        values.put("BasicStartDate", getBasicStartDate());
        values.put("ForecastedStartDate", getForecastedStartDate());
        values.put("ActualStartDate", getActualStartDate());
        values.put("BasicEndDate", getBasicEndDate());
        values.put("ForecastedEndDate", getForecastedEndDate());
        values.put("ActualEndDate", getActualEndDate());
        values.put("ActualDurationUnit", getActualDurationUnit());
        values.put("ForecastedDurationUnit", getForecastedDurationUnit());
        values.put("BasicDurationUnit", getBasicDurationUnit());
        values.put("BasicDuration", getBasicDuration());
        values.put("ForecastedDuration", getForecastedDuration());
        values.put("ActualDuration", getActualDuration());
        values.put("SchedldBasicEarliestStartDate", getSchedldBasicEarliestStartDate());
        values.put("ScheduledBasicLatestEndDate", getScheduledBasicLatestEndDate());
        values.put("SchedldFcstdEarliestStartDate", getSchedldFcstdEarliestStartDate());
        values.put("LatestSchedldFcstdEndDate", getLatestSchedldFcstdEndDate());
        values.put("TentativeActualStartDate", getTentativeActualStartDate());
        values.put("TentativeActualEndDate", getTentativeActualEndDate());
        values.put("SchedldBasicLatestStartDate", getSchedldBasicLatestStartDate());
        values.put("SchedldBasicEarliestEndDate", getSchedldBasicEarliestEndDate());
        values.put("LatestSchedldFcstdStartDate", getLatestSchedldFcstdStartDate());
        values.put("SchedldFcstdEarliestEndDate", getSchedldFcstdEarliestEndDate());
        values.put("WBSElementHierarchyLevel", getWBSElementHierarchyLevel());
        values.put("OverheadCode", getOverheadCode());
        values.put("ResultAnalysisInternalID", getResultAnalysisInternalID());
        values.put("ProgressAnlysAggregationWeight", getProgressAnlysAggregationWeight());
        values.put("WBSElementShortID", getWBSElementShortID());
        values.put("ReqgCostCenterControllingArea", getReqgCostCenterControllingArea());
        values.put("RespCostCenterControllingArea", getRespCostCenterControllingArea());
        values.put("Language", getLanguage());
        values.put("CostCenter", getCostCenter());
        values.put("CostObject", getCostObject());
        values.put("WBSElementIsUsedInProjSmmry", getWBSElementIsUsedInProjSmmry());
        values.put("IsMarkedForDeletion", getIsMarkedForDeletion());
        values.put("InventorySpecialStockValnType", getInventorySpecialStockValnType());
        values.put("BillingPlan", getBillingPlan());
        values.put("WBSElementIsGroupingWBSElement", getWBSElementIsGroupingWBSElement());
        values.put("CostingVariant", getCostingVariant());
        values.put("JointVenture", getJointVenture());
        values.put("JointVentureRecoveryCode", getJointVentureRecoveryCode());
        values.put("JointVentureEquityType", getJointVentureEquityType());
        values.put("JointVentureObjectType", getJointVentureObjectType());
        values.put("JointVentureClass", getJointVentureClass());
        values.put("JointVentureSubClass", getJointVentureSubClass());
        values.put("WBSElementHasActivities", getWBSElementHasActivities());
        values.put("WBSHasFcstdDateFromActivity", getWBSHasFcstdDateFromActivity());
        values.put("WBSHasFcstdDateSetManually", getWBSHasFcstdDateSetManually());
        values.put("WBSHasBasicDateManuallySet", getWBSHasBasicDateManuallySet());
        values.put("WBSHasActualDateSetManually", getWBSHasActualDateSetManually());
        values.put("WBSElmntHasActualDateFromActy", getWBSElmntHasActualDateFromActy());
        values.put("ControllingObjectClass", getControllingObjectClass());
        values.put("FreeDefinedAttribute01", getFreeDefinedAttribute01());
        values.put("FreeDefinedAttribute02", getFreeDefinedAttribute02());
        values.put("FreeDefinedAttribute03", getFreeDefinedAttribute03());
        values.put("FreeDefinedAttribute04", getFreeDefinedAttribute04());
        values.put("FreeDefinedQuantity1", getFreeDefinedQuantity1());
        values.put("FreeDefinedQuantity1Unit", getFreeDefinedQuantity1Unit());
        values.put("FreeDefinedQuantity2", getFreeDefinedQuantity2());
        values.put("FreeDefinedQuantity2Unit", getFreeDefinedQuantity2Unit());
        values.put("FreeDefinedAmount1", getFreeDefinedAmount1());
        values.put("FreeDefinedAmount1Currency", getFreeDefinedAmount1Currency());
        values.put("FreeDefinedAmount2", getFreeDefinedAmount2());
        values.put("FreeDefinedAmount2Currency", getFreeDefinedAmount2Currency());
        values.put("FreeDefinedDate1", getFreeDefinedDate1());
        values.put("FreeDefinedDate2", getFreeDefinedDate2());
        values.put("FreeDefinedIndicator1", getFreeDefinedIndicator1());
        values.put("FreeDefinedIndicator2", getFreeDefinedIndicator2());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("WBSElementInternalID") ) {
                final Object value = values.remove("WBSElementInternalID");
                if( (value == null) || (!value.equals(getWBSElementInternalID())) ) {
                    setWBSElementInternalID(((String) value));
                }
            }
            if( values.containsKey("ProjectInternalID") ) {
                final Object value = values.remove("ProjectInternalID");
                if( (value == null) || (!value.equals(getProjectInternalID())) ) {
                    setProjectInternalID(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("WBSDescription") ) {
                final Object value = values.remove("WBSDescription");
                if( (value == null) || (!value.equals(getWBSDescription())) ) {
                    setWBSDescription(((String) value));
                }
            }
            if( values.containsKey("WBSElementObject") ) {
                final Object value = values.remove("WBSElementObject");
                if( (value == null) || (!value.equals(getWBSElementObject())) ) {
                    setWBSElementObject(((String) value));
                }
            }
            if( values.containsKey("CreatedByUser") ) {
                final Object value = values.remove("CreatedByUser");
                if( (value == null) || (!value.equals(getCreatedByUser())) ) {
                    setCreatedByUser(((String) value));
                }
            }
            if( values.containsKey("CreationDate") ) {
                final Object value = values.remove("CreationDate");
                if( (value == null) || (!value.equals(getCreationDate())) ) {
                    setCreationDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LastChangedByUser") ) {
                final Object value = values.remove("LastChangedByUser");
                if( (value == null) || (!value.equals(getLastChangedByUser())) ) {
                    setLastChangedByUser(((String) value));
                }
            }
            if( values.containsKey("LastChangeDate") ) {
                final Object value = values.remove("LastChangeDate");
                if( (value == null) || (!value.equals(getLastChangeDate())) ) {
                    setLastChangeDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ResponsiblePerson") ) {
                final Object value = values.remove("ResponsiblePerson");
                if( (value == null) || (!value.equals(getResponsiblePerson())) ) {
                    setResponsiblePerson(((String) value));
                }
            }
            if( values.containsKey("ResponsiblePersonName") ) {
                final Object value = values.remove("ResponsiblePersonName");
                if( (value == null) || (!value.equals(getResponsiblePersonName())) ) {
                    setResponsiblePersonName(((String) value));
                }
            }
            if( values.containsKey("ApplicantCode") ) {
                final Object value = values.remove("ApplicantCode");
                if( (value == null) || (!value.equals(getApplicantCode())) ) {
                    setApplicantCode(((String) value));
                }
            }
            if( values.containsKey("ApplicantName") ) {
                final Object value = values.remove("ApplicantName");
                if( (value == null) || (!value.equals(getApplicantName())) ) {
                    setApplicantName(((String) value));
                }
            }
            if( values.containsKey("CompanyCode") ) {
                final Object value = values.remove("CompanyCode");
                if( (value == null) || (!value.equals(getCompanyCode())) ) {
                    setCompanyCode(((String) value));
                }
            }
            if( values.containsKey("BusinessArea") ) {
                final Object value = values.remove("BusinessArea");
                if( (value == null) || (!value.equals(getBusinessArea())) ) {
                    setBusinessArea(((String) value));
                }
            }
            if( values.containsKey("ControllingArea") ) {
                final Object value = values.remove("ControllingArea");
                if( (value == null) || (!value.equals(getControllingArea())) ) {
                    setControllingArea(((String) value));
                }
            }
            if( values.containsKey("ProfitCenter") ) {
                final Object value = values.remove("ProfitCenter");
                if( (value == null) || (!value.equals(getProfitCenter())) ) {
                    setProfitCenter(((String) value));
                }
            }
            if( values.containsKey("ProjectType") ) {
                final Object value = values.remove("ProjectType");
                if( (value == null) || (!value.equals(getProjectType())) ) {
                    setProjectType(((String) value));
                }
            }
            if( values.containsKey("WBSElementIsPlanningElement") ) {
                final Object value = values.remove("WBSElementIsPlanningElement");
                if( (value == null) || (!value.equals(getWBSElementIsPlanningElement())) ) {
                    setWBSElementIsPlanningElement(((Boolean) value));
                }
            }
            if( values.containsKey("WBSIsAccountAssignmentElement") ) {
                final Object value = values.remove("WBSIsAccountAssignmentElement");
                if( (value == null) || (!value.equals(getWBSIsAccountAssignmentElement())) ) {
                    setWBSIsAccountAssignmentElement(((Boolean) value));
                }
            }
            if( values.containsKey("WBSElementIsBillingElement") ) {
                final Object value = values.remove("WBSElementIsBillingElement");
                if( (value == null) || (!value.equals(getWBSElementIsBillingElement())) ) {
                    setWBSElementIsBillingElement(((Boolean) value));
                }
            }
            if( values.containsKey("CostingSheet") ) {
                final Object value = values.remove("CostingSheet");
                if( (value == null) || (!value.equals(getCostingSheet())) ) {
                    setCostingSheet(((String) value));
                }
            }
            if( values.containsKey("RequestingCostCenter") ) {
                final Object value = values.remove("RequestingCostCenter");
                if( (value == null) || (!value.equals(getRequestingCostCenter())) ) {
                    setRequestingCostCenter(((String) value));
                }
            }
            if( values.containsKey("ResponsibleCostCenter") ) {
                final Object value = values.remove("ResponsibleCostCenter");
                if( (value == null) || (!value.equals(getResponsibleCostCenter())) ) {
                    setResponsibleCostCenter(((String) value));
                }
            }
            if( values.containsKey("FactoryCalendar") ) {
                final Object value = values.remove("FactoryCalendar");
                if( (value == null) || (!value.equals(getFactoryCalendar())) ) {
                    setFactoryCalendar(((String) value));
                }
            }
            if( values.containsKey("PriorityCode") ) {
                final Object value = values.remove("PriorityCode");
                if( (value == null) || (!value.equals(getPriorityCode())) ) {
                    setPriorityCode(((String) value));
                }
            }
            if( values.containsKey("Currency") ) {
                final Object value = values.remove("Currency");
                if( (value == null) || (!value.equals(getCurrency())) ) {
                    setCurrency(((String) value));
                }
            }
            if( values.containsKey("Plant") ) {
                final Object value = values.remove("Plant");
                if( (value == null) || (!value.equals(getPlant())) ) {
                    setPlant(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedTableFieldSemantic") ) {
                final Object value = values.remove("FreeDefinedTableFieldSemantic");
                if( (value == null) || (!value.equals(getFreeDefinedTableFieldSemantic())) ) {
                    setFreeDefinedTableFieldSemantic(((String) value));
                }
            }
            if( values.containsKey("WBSIsStatisticalWBSElement") ) {
                final Object value = values.remove("WBSIsStatisticalWBSElement");
                if( (value == null) || (!value.equals(getWBSIsStatisticalWBSElement())) ) {
                    setWBSIsStatisticalWBSElement(((Boolean) value));
                }
            }
            if( values.containsKey("TaxJurisdiction") ) {
                final Object value = values.remove("TaxJurisdiction");
                if( (value == null) || (!value.equals(getTaxJurisdiction())) ) {
                    setTaxJurisdiction(((String) value));
                }
            }
            if( values.containsKey("WBSIsMarkedForIntegratedPlng") ) {
                final Object value = values.remove("WBSIsMarkedForIntegratedPlng");
                if( (value == null) || (!value.equals(getWBSIsMarkedForIntegratedPlng())) ) {
                    setWBSIsMarkedForIntegratedPlng(((Boolean) value));
                }
            }
            if( values.containsKey("FunctionalArea") ) {
                final Object value = values.remove("FunctionalArea");
                if( (value == null) || (!value.equals(getFunctionalArea())) ) {
                    setFunctionalArea(((String) value));
                }
            }
            if( values.containsKey("Location") ) {
                final Object value = values.remove("Location");
                if( (value == null) || (!value.equals(getLocation())) ) {
                    setLocation(((String) value));
                }
            }
            if( values.containsKey("Equipment") ) {
                final Object value = values.remove("Equipment");
                if( (value == null) || (!value.equals(getEquipment())) ) {
                    setEquipment(((String) value));
                }
            }
            if( values.containsKey("FunctionalLocation") ) {
                final Object value = values.remove("FunctionalLocation");
                if( (value == null) || (!value.equals(getFunctionalLocation())) ) {
                    setFunctionalLocation(((String) value));
                }
            }
            if( values.containsKey("ProjectObjectChangeNumber") ) {
                final Object value = values.remove("ProjectObjectChangeNumber");
                if( (value == null) || (!value.equals(getProjectObjectChangeNumber())) ) {
                    setProjectObjectChangeNumber(((String) value));
                }
            }
            if( values.containsKey("ProjectObjectReferenceElement") ) {
                final Object value = values.remove("ProjectObjectReferenceElement");
                if( (value == null) || (!value.equals(getProjectObjectReferenceElement())) ) {
                    setProjectObjectReferenceElement(((String) value));
                }
            }
            if( values.containsKey("ProjInterestCalcProfile") ) {
                final Object value = values.remove("ProjInterestCalcProfile");
                if( (value == null) || (!value.equals(getProjInterestCalcProfile())) ) {
                    setProjInterestCalcProfile(((String) value));
                }
            }
            if( values.containsKey("InvestmentProfile") ) {
                final Object value = values.remove("InvestmentProfile");
                if( (value == null) || (!value.equals(getInvestmentProfile())) ) {
                    setInvestmentProfile(((String) value));
                }
            }
            if( values.containsKey("BasicStartDate") ) {
                final Object value = values.remove("BasicStartDate");
                if( (value == null) || (!value.equals(getBasicStartDate())) ) {
                    setBasicStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ForecastedStartDate") ) {
                final Object value = values.remove("ForecastedStartDate");
                if( (value == null) || (!value.equals(getForecastedStartDate())) ) {
                    setForecastedStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualStartDate") ) {
                final Object value = values.remove("ActualStartDate");
                if( (value == null) || (!value.equals(getActualStartDate())) ) {
                    setActualStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("BasicEndDate") ) {
                final Object value = values.remove("BasicEndDate");
                if( (value == null) || (!value.equals(getBasicEndDate())) ) {
                    setBasicEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ForecastedEndDate") ) {
                final Object value = values.remove("ForecastedEndDate");
                if( (value == null) || (!value.equals(getForecastedEndDate())) ) {
                    setForecastedEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualEndDate") ) {
                final Object value = values.remove("ActualEndDate");
                if( (value == null) || (!value.equals(getActualEndDate())) ) {
                    setActualEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ActualDurationUnit") ) {
                final Object value = values.remove("ActualDurationUnit");
                if( (value == null) || (!value.equals(getActualDurationUnit())) ) {
                    setActualDurationUnit(((String) value));
                }
            }
            if( values.containsKey("ForecastedDurationUnit") ) {
                final Object value = values.remove("ForecastedDurationUnit");
                if( (value == null) || (!value.equals(getForecastedDurationUnit())) ) {
                    setForecastedDurationUnit(((String) value));
                }
            }
            if( values.containsKey("BasicDurationUnit") ) {
                final Object value = values.remove("BasicDurationUnit");
                if( (value == null) || (!value.equals(getBasicDurationUnit())) ) {
                    setBasicDurationUnit(((String) value));
                }
            }
            if( values.containsKey("BasicDuration") ) {
                final Object value = values.remove("BasicDuration");
                if( (value == null) || (!value.equals(getBasicDuration())) ) {
                    setBasicDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ForecastedDuration") ) {
                final Object value = values.remove("ForecastedDuration");
                if( (value == null) || (!value.equals(getForecastedDuration())) ) {
                    setForecastedDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("ActualDuration") ) {
                final Object value = values.remove("ActualDuration");
                if( (value == null) || (!value.equals(getActualDuration())) ) {
                    setActualDuration(((BigDecimal) value));
                }
            }
            if( values.containsKey("SchedldBasicEarliestStartDate") ) {
                final Object value = values.remove("SchedldBasicEarliestStartDate");
                if( (value == null) || (!value.equals(getSchedldBasicEarliestStartDate())) ) {
                    setSchedldBasicEarliestStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("ScheduledBasicLatestEndDate") ) {
                final Object value = values.remove("ScheduledBasicLatestEndDate");
                if( (value == null) || (!value.equals(getScheduledBasicLatestEndDate())) ) {
                    setScheduledBasicLatestEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SchedldFcstdEarliestStartDate") ) {
                final Object value = values.remove("SchedldFcstdEarliestStartDate");
                if( (value == null) || (!value.equals(getSchedldFcstdEarliestStartDate())) ) {
                    setSchedldFcstdEarliestStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LatestSchedldFcstdEndDate") ) {
                final Object value = values.remove("LatestSchedldFcstdEndDate");
                if( (value == null) || (!value.equals(getLatestSchedldFcstdEndDate())) ) {
                    setLatestSchedldFcstdEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TentativeActualStartDate") ) {
                final Object value = values.remove("TentativeActualStartDate");
                if( (value == null) || (!value.equals(getTentativeActualStartDate())) ) {
                    setTentativeActualStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("TentativeActualEndDate") ) {
                final Object value = values.remove("TentativeActualEndDate");
                if( (value == null) || (!value.equals(getTentativeActualEndDate())) ) {
                    setTentativeActualEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SchedldBasicLatestStartDate") ) {
                final Object value = values.remove("SchedldBasicLatestStartDate");
                if( (value == null) || (!value.equals(getSchedldBasicLatestStartDate())) ) {
                    setSchedldBasicLatestStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SchedldBasicEarliestEndDate") ) {
                final Object value = values.remove("SchedldBasicEarliestEndDate");
                if( (value == null) || (!value.equals(getSchedldBasicEarliestEndDate())) ) {
                    setSchedldBasicEarliestEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("LatestSchedldFcstdStartDate") ) {
                final Object value = values.remove("LatestSchedldFcstdStartDate");
                if( (value == null) || (!value.equals(getLatestSchedldFcstdStartDate())) ) {
                    setLatestSchedldFcstdStartDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("SchedldFcstdEarliestEndDate") ) {
                final Object value = values.remove("SchedldFcstdEarliestEndDate");
                if( (value == null) || (!value.equals(getSchedldFcstdEarliestEndDate())) ) {
                    setSchedldFcstdEarliestEndDate(((LocalDateTime) value));
                }
            }
            if( values.containsKey("WBSElementHierarchyLevel") ) {
                final Object value = values.remove("WBSElementHierarchyLevel");
                if( (value == null) || (!value.equals(getWBSElementHierarchyLevel())) ) {
                    setWBSElementHierarchyLevel(((Short) value));
                }
            }
            if( values.containsKey("OverheadCode") ) {
                final Object value = values.remove("OverheadCode");
                if( (value == null) || (!value.equals(getOverheadCode())) ) {
                    setOverheadCode(((String) value));
                }
            }
            if( values.containsKey("ResultAnalysisInternalID") ) {
                final Object value = values.remove("ResultAnalysisInternalID");
                if( (value == null) || (!value.equals(getResultAnalysisInternalID())) ) {
                    setResultAnalysisInternalID(((String) value));
                }
            }
            if( values.containsKey("ProgressAnlysAggregationWeight") ) {
                final Object value = values.remove("ProgressAnlysAggregationWeight");
                if( (value == null) || (!value.equals(getProgressAnlysAggregationWeight())) ) {
                    setProgressAnlysAggregationWeight(((BigDecimal) value));
                }
            }
            if( values.containsKey("WBSElementShortID") ) {
                final Object value = values.remove("WBSElementShortID");
                if( (value == null) || (!value.equals(getWBSElementShortID())) ) {
                    setWBSElementShortID(((String) value));
                }
            }
            if( values.containsKey("ReqgCostCenterControllingArea") ) {
                final Object value = values.remove("ReqgCostCenterControllingArea");
                if( (value == null) || (!value.equals(getReqgCostCenterControllingArea())) ) {
                    setReqgCostCenterControllingArea(((String) value));
                }
            }
            if( values.containsKey("RespCostCenterControllingArea") ) {
                final Object value = values.remove("RespCostCenterControllingArea");
                if( (value == null) || (!value.equals(getRespCostCenterControllingArea())) ) {
                    setRespCostCenterControllingArea(((String) value));
                }
            }
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("CostCenter") ) {
                final Object value = values.remove("CostCenter");
                if( (value == null) || (!value.equals(getCostCenter())) ) {
                    setCostCenter(((String) value));
                }
            }
            if( values.containsKey("CostObject") ) {
                final Object value = values.remove("CostObject");
                if( (value == null) || (!value.equals(getCostObject())) ) {
                    setCostObject(((String) value));
                }
            }
            if( values.containsKey("WBSElementIsUsedInProjSmmry") ) {
                final Object value = values.remove("WBSElementIsUsedInProjSmmry");
                if( (value == null) || (!value.equals(getWBSElementIsUsedInProjSmmry())) ) {
                    setWBSElementIsUsedInProjSmmry(((Boolean) value));
                }
            }
            if( values.containsKey("IsMarkedForDeletion") ) {
                final Object value = values.remove("IsMarkedForDeletion");
                if( (value == null) || (!value.equals(getIsMarkedForDeletion())) ) {
                    setIsMarkedForDeletion(((Boolean) value));
                }
            }
            if( values.containsKey("InventorySpecialStockValnType") ) {
                final Object value = values.remove("InventorySpecialStockValnType");
                if( (value == null) || (!value.equals(getInventorySpecialStockValnType())) ) {
                    setInventorySpecialStockValnType(((String) value));
                }
            }
            if( values.containsKey("BillingPlan") ) {
                final Object value = values.remove("BillingPlan");
                if( (value == null) || (!value.equals(getBillingPlan())) ) {
                    setBillingPlan(((String) value));
                }
            }
            if( values.containsKey("WBSElementIsGroupingWBSElement") ) {
                final Object value = values.remove("WBSElementIsGroupingWBSElement");
                if( (value == null) || (!value.equals(getWBSElementIsGroupingWBSElement())) ) {
                    setWBSElementIsGroupingWBSElement(((String) value));
                }
            }
            if( values.containsKey("CostingVariant") ) {
                final Object value = values.remove("CostingVariant");
                if( (value == null) || (!value.equals(getCostingVariant())) ) {
                    setCostingVariant(((String) value));
                }
            }
            if( values.containsKey("JointVenture") ) {
                final Object value = values.remove("JointVenture");
                if( (value == null) || (!value.equals(getJointVenture())) ) {
                    setJointVenture(((String) value));
                }
            }
            if( values.containsKey("JointVentureRecoveryCode") ) {
                final Object value = values.remove("JointVentureRecoveryCode");
                if( (value == null) || (!value.equals(getJointVentureRecoveryCode())) ) {
                    setJointVentureRecoveryCode(((String) value));
                }
            }
            if( values.containsKey("JointVentureEquityType") ) {
                final Object value = values.remove("JointVentureEquityType");
                if( (value == null) || (!value.equals(getJointVentureEquityType())) ) {
                    setJointVentureEquityType(((String) value));
                }
            }
            if( values.containsKey("JointVentureObjectType") ) {
                final Object value = values.remove("JointVentureObjectType");
                if( (value == null) || (!value.equals(getJointVentureObjectType())) ) {
                    setJointVentureObjectType(((String) value));
                }
            }
            if( values.containsKey("JointVentureClass") ) {
                final Object value = values.remove("JointVentureClass");
                if( (value == null) || (!value.equals(getJointVentureClass())) ) {
                    setJointVentureClass(((String) value));
                }
            }
            if( values.containsKey("JointVentureSubClass") ) {
                final Object value = values.remove("JointVentureSubClass");
                if( (value == null) || (!value.equals(getJointVentureSubClass())) ) {
                    setJointVentureSubClass(((String) value));
                }
            }
            if( values.containsKey("WBSElementHasActivities") ) {
                final Object value = values.remove("WBSElementHasActivities");
                if( (value == null) || (!value.equals(getWBSElementHasActivities())) ) {
                    setWBSElementHasActivities(((Boolean) value));
                }
            }
            if( values.containsKey("WBSHasFcstdDateFromActivity") ) {
                final Object value = values.remove("WBSHasFcstdDateFromActivity");
                if( (value == null) || (!value.equals(getWBSHasFcstdDateFromActivity())) ) {
                    setWBSHasFcstdDateFromActivity(((Boolean) value));
                }
            }
            if( values.containsKey("WBSHasFcstdDateSetManually") ) {
                final Object value = values.remove("WBSHasFcstdDateSetManually");
                if( (value == null) || (!value.equals(getWBSHasFcstdDateSetManually())) ) {
                    setWBSHasFcstdDateSetManually(((Boolean) value));
                }
            }
            if( values.containsKey("WBSHasBasicDateManuallySet") ) {
                final Object value = values.remove("WBSHasBasicDateManuallySet");
                if( (value == null) || (!value.equals(getWBSHasBasicDateManuallySet())) ) {
                    setWBSHasBasicDateManuallySet(((Boolean) value));
                }
            }
            if( values.containsKey("WBSHasActualDateSetManually") ) {
                final Object value = values.remove("WBSHasActualDateSetManually");
                if( (value == null) || (!value.equals(getWBSHasActualDateSetManually())) ) {
                    setWBSHasActualDateSetManually(((Boolean) value));
                }
            }
            if( values.containsKey("WBSElmntHasActualDateFromActy") ) {
                final Object value = values.remove("WBSElmntHasActualDateFromActy");
                if( (value == null) || (!value.equals(getWBSElmntHasActualDateFromActy())) ) {
                    setWBSElmntHasActualDateFromActy(((Boolean) value));
                }
            }
            if( values.containsKey("ControllingObjectClass") ) {
                final Object value = values.remove("ControllingObjectClass");
                if( (value == null) || (!value.equals(getControllingObjectClass())) ) {
                    setControllingObjectClass(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedAttribute01") ) {
                final Object value = values.remove("FreeDefinedAttribute01");
                if( (value == null) || (!value.equals(getFreeDefinedAttribute01())) ) {
                    setFreeDefinedAttribute01(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedAttribute02") ) {
                final Object value = values.remove("FreeDefinedAttribute02");
                if( (value == null) || (!value.equals(getFreeDefinedAttribute02())) ) {
                    setFreeDefinedAttribute02(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedAttribute03") ) {
                final Object value = values.remove("FreeDefinedAttribute03");
                if( (value == null) || (!value.equals(getFreeDefinedAttribute03())) ) {
                    setFreeDefinedAttribute03(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedAttribute04") ) {
                final Object value = values.remove("FreeDefinedAttribute04");
                if( (value == null) || (!value.equals(getFreeDefinedAttribute04())) ) {
                    setFreeDefinedAttribute04(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedQuantity1") ) {
                final Object value = values.remove("FreeDefinedQuantity1");
                if( (value == null) || (!value.equals(getFreeDefinedQuantity1())) ) {
                    setFreeDefinedQuantity1(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedQuantity1Unit") ) {
                final Object value = values.remove("FreeDefinedQuantity1Unit");
                if( (value == null) || (!value.equals(getFreeDefinedQuantity1Unit())) ) {
                    setFreeDefinedQuantity1Unit(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedQuantity2") ) {
                final Object value = values.remove("FreeDefinedQuantity2");
                if( (value == null) || (!value.equals(getFreeDefinedQuantity2())) ) {
                    setFreeDefinedQuantity2(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedQuantity2Unit") ) {
                final Object value = values.remove("FreeDefinedQuantity2Unit");
                if( (value == null) || (!value.equals(getFreeDefinedQuantity2Unit())) ) {
                    setFreeDefinedQuantity2Unit(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedAmount1") ) {
                final Object value = values.remove("FreeDefinedAmount1");
                if( (value == null) || (!value.equals(getFreeDefinedAmount1())) ) {
                    setFreeDefinedAmount1(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedAmount1Currency") ) {
                final Object value = values.remove("FreeDefinedAmount1Currency");
                if( (value == null) || (!value.equals(getFreeDefinedAmount1Currency())) ) {
                    setFreeDefinedAmount1Currency(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedAmount2") ) {
                final Object value = values.remove("FreeDefinedAmount2");
                if( (value == null) || (!value.equals(getFreeDefinedAmount2())) ) {
                    setFreeDefinedAmount2(((BigDecimal) value));
                }
            }
            if( values.containsKey("FreeDefinedAmount2Currency") ) {
                final Object value = values.remove("FreeDefinedAmount2Currency");
                if( (value == null) || (!value.equals(getFreeDefinedAmount2Currency())) ) {
                    setFreeDefinedAmount2Currency(((String) value));
                }
            }
            if( values.containsKey("FreeDefinedDate1") ) {
                final Object value = values.remove("FreeDefinedDate1");
                if( (value == null) || (!value.equals(getFreeDefinedDate1())) ) {
                    setFreeDefinedDate1(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FreeDefinedDate2") ) {
                final Object value = values.remove("FreeDefinedDate2");
                if( (value == null) || (!value.equals(getFreeDefinedDate2())) ) {
                    setFreeDefinedDate2(((LocalDateTime) value));
                }
            }
            if( values.containsKey("FreeDefinedIndicator1") ) {
                final Object value = values.remove("FreeDefinedIndicator1");
                if( (value == null) || (!value.equals(getFreeDefinedIndicator1())) ) {
                    setFreeDefinedIndicator1(((Boolean) value));
                }
            }
            if( values.containsKey("FreeDefinedIndicator2") ) {
                final Object value = values.remove("FreeDefinedIndicator2");
                if( (value == null) || (!value.equals(getFreeDefinedIndicator2())) ) {
                    setFreeDefinedIndicator2(((Boolean) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <
        T> WBSElementInternalIDField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WBSElementInternalIDField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WBSElementInternalIDField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WBSElementInternalIDField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

}
