/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.Map;

import javax.annotation.Nonnull;

import com.google.common.collect.Maps;
import com.sap.cloud.sdk.datamodel.odata.helper.FluentHelperByKey;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.WBSElementInternalIDSelectable;

/**
 * Fluent helper to fetch a single
 * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID
 * WBSElementInternalID} entity using key fields. This fluent helper allows methods which modify the underlying query to
 * be called before executing the query itself.
 *
 */
public class WBSElementInternalIDByKeyFluentHelper
    extends
    FluentHelperByKey<WBSElementInternalIDByKeyFluentHelper, WBSElementInternalID, WBSElementInternalIDSelectable>
{

    private final Map<String, Object> key = Maps.newHashMap();

    /**
     * Creates a fluent helper object that will fetch a single
     * {@link com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.WBSElementInternalID
     * WBSElementInternalID} entity with the provided key field values. To perform execution, call the
     * {@link #executeRequest executeRequest} method on the fluent helper object.
     *
     * @param entityCollection
     *            Entity Collection to be used to fetch a single {@code WBSElementInternalID}
     * @param wBSElementInternalID
     *            WBS Element
     *            <p>
     *            Constraints: Not nullable, Maximum length: 8
     *            </p>
     * @param servicePath
     *            Service path to be used to fetch a single {@code WBSElementInternalID}
     */
    public WBSElementInternalIDByKeyFluentHelper(
        @Nonnull final String servicePath,
        @Nonnull final String entityCollection,
        final String wBSElementInternalID )
    {
        super(servicePath, entityCollection);
        this.key.put("WBSElementInternalID", wBSElementInternalID);
    }

    @Override
    @Nonnull
    protected Class<WBSElementInternalID> getEntityClass()
    {
        return WBSElementInternalID.class;
    }

    @Override
    @Nonnull
    protected Map<String, Object> getKey()
    {
        return key;
    }

}
