/*
 * Copyright (c) 2024 SAP SE or an SAP affiliate company. All rights reserved.
 */

package com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting;

import java.util.List;
import java.util.Map;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.sap.cloud.sdk.cloudplatform.connectivity.HttpDestinationProperties;
import com.sap.cloud.sdk.datamodel.odata.client.exception.ODataException;
import com.sap.cloud.sdk.datamodel.odata.helper.VdmEntity;
import com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.annotation.Key;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.field.WBSElementTextField;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.link.WBSElementTextLink;
import com.sap.cloud.sdk.s4hana.datamodel.odata.namespaces.masterdataforgroupreporting.selectable.WBSElementTextSelectable;
import com.sap.cloud.sdk.typeconverter.TypeConverter;

import io.vavr.control.Option;
import lombok.AccessLevel;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * Combined WBS Element Text
 * <p>
 * </p>
 * <p>
 * Original entity name from the Odata EDM: <b>WBSElementTextType</b>
 * </p>
 *
 */
@Builder
@Data
@NoArgsConstructor
@AllArgsConstructor
@ToString( doNotUseGetters = true, callSuper = true )
@EqualsAndHashCode( doNotUseGetters = true, callSuper = true )
@JsonAdapter( com.sap.cloud.sdk.s4hana.datamodel.odata.adapter.ODataVdmEntityAdapterFactory.class )
public class WBSElementText extends VdmEntity<WBSElementText>
{

    /**
     * Selector for all available fields of WBSElementText.
     *
     */
    public final static WBSElementTextSelectable ALL_FIELDS = () -> "*";
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @return Language Key
     */
    @Key
    @SerializedName( "Language" )
    @JsonProperty( "Language" )
    @Nullable
    @ODataField( odataName = "Language" )
    private String language;
    /**
     * Use with available fluent helpers to apply the <b>Language</b> field to query operations.
     *
     */
    public final static WBSElementTextField<String> LANGUAGE = new WBSElementTextField<String>("Language");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @return Work Breakdown Structure Element (WBS Element)
     */
    @Key
    @SerializedName( "WBSElement" )
    @JsonProperty( "WBSElement" )
    @Nullable
    @ODataField( odataName = "WBSElement" )
    private String wBSElement;
    /**
     * Use with available fluent helpers to apply the <b>WBSElement</b> field to query operations.
     *
     */
    public final static WBSElementTextField<String> WBS_ELEMENT = new WBSElementTextField<String>("WBSElement");
    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @return Project Definition
     */
    @Key
    @SerializedName( "Project" )
    @JsonProperty( "Project" )
    @Nullable
    @ODataField( odataName = "Project" )
    private String project;
    /**
     * Use with available fluent helpers to apply the <b>Project</b> field to query operations.
     *
     */
    public final static WBSElementTextField<String> PROJECT = new WBSElementTextField<String>("Project");
    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementText</b>
     * </p>
     *
     * @return WBS Element External ID Description
     */
    @SerializedName( "WBSElementText" )
    @JsonProperty( "WBSElementText" )
    @Nullable
    @ODataField( odataName = "WBSElementText" )
    private String wBSElementText;
    /**
     * Use with available fluent helpers to apply the <b>WBSElementText</b> field to query operations.
     *
     */
    public final static WBSElementTextField<String> WBS_ELEMENT_TEXT =
        new WBSElementTextField<String>("WBSElementText");
    /**
     * Navigation property <b>to_CnsldtnWBSElement</b> for <b>WBSElementText</b> to multiple <b>WBSElement</b>.
     *
     */
    @SerializedName( "to_CnsldtnWBSElement" )
    @JsonProperty( "to_CnsldtnWBSElement" )
    @ODataField( odataName = "to_CnsldtnWBSElement" )
    @Getter( AccessLevel.NONE )
    @Setter( AccessLevel.NONE )
    private List<WBSElement> toCnsldtnWBSElement;
    /**
     * Use with available fluent helpers to apply the <b>to_CnsldtnWBSElement</b> navigation property to query
     * operations.
     *
     */
    public final static WBSElementTextLink<WBSElement> TO_CNSLDTN_WBS_ELEMENT =
        new WBSElementTextLink<WBSElement>("to_CnsldtnWBSElement");

    @Nonnull
    @Override
    public Class<WBSElementText> getType()
    {
        return WBSElementText.class;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 2
     * <p>
     * Original property name from the Odata EDM: <b>Language</b>
     * </p>
     *
     * @param language
     *            Language Key
     */
    public void setLanguage( @Nullable final String language )
    {
        rememberChangedField("Language", this.language);
        this.language = language;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>WBSElement</b>
     * </p>
     *
     * @param wBSElement
     *            Work Breakdown Structure Element (WBS Element)
     */
    public void setWBSElement( @Nullable final String wBSElement )
    {
        rememberChangedField("WBSElement", this.wBSElement);
        this.wBSElement = wBSElement;
    }

    /**
     * (Key Field) Constraints: Not nullable, Maximum length: 24
     * <p>
     * Original property name from the Odata EDM: <b>Project</b>
     * </p>
     *
     * @param project
     *            Project Definition
     */
    public void setProject( @Nullable final String project )
    {
        rememberChangedField("Project", this.project);
        this.project = project;
    }

    /**
     * Constraints: Not nullable, Maximum length: 40
     * <p>
     * Original property name from the Odata EDM: <b>WBSElementText</b>
     * </p>
     *
     * @param wBSElementText
     *            WBS Element External ID Description
     */
    public void setWBSElementText( @Nullable final String wBSElementText )
    {
        rememberChangedField("WBSElementText", this.wBSElementText);
        this.wBSElementText = wBSElementText;
    }

    @Override
    protected String getEntityCollection()
    {
        return "WBSElementText";
    }

    @Nonnull
    @Override
    protected Map<String, Object> getKey()
    {
        final Map<String, Object> result = Maps.newHashMap();
        result.put("Language", getLanguage());
        result.put("WBSElement", getWBSElement());
        result.put("Project", getProject());
        return result;
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfFields()
    {
        final Map<String, Object> values = super.toMapOfFields();
        values.put("Language", getLanguage());
        values.put("WBSElement", getWBSElement());
        values.put("Project", getProject());
        values.put("WBSElementText", getWBSElementText());
        return values;
    }

    @Override
    protected void fromMap( final Map<String, Object> inputValues )
    {
        final Map<String, Object> values = Maps.newHashMap(inputValues);
        // simple properties
        {
            if( values.containsKey("Language") ) {
                final Object value = values.remove("Language");
                if( (value == null) || (!value.equals(getLanguage())) ) {
                    setLanguage(((String) value));
                }
            }
            if( values.containsKey("WBSElement") ) {
                final Object value = values.remove("WBSElement");
                if( (value == null) || (!value.equals(getWBSElement())) ) {
                    setWBSElement(((String) value));
                }
            }
            if( values.containsKey("Project") ) {
                final Object value = values.remove("Project");
                if( (value == null) || (!value.equals(getProject())) ) {
                    setProject(((String) value));
                }
            }
            if( values.containsKey("WBSElementText") ) {
                final Object value = values.remove("WBSElementText");
                if( (value == null) || (!value.equals(getWBSElementText())) ) {
                    setWBSElementText(((String) value));
                }
            }
        }
        // structured properties
        {
        }
        // navigation properties
        {
            if( (values).containsKey("to_CnsldtnWBSElement") ) {
                final Object value = (values).remove("to_CnsldtnWBSElement");
                if( value instanceof Iterable ) {
                    if( toCnsldtnWBSElement == null ) {
                        toCnsldtnWBSElement = Lists.newArrayList();
                    } else {
                        toCnsldtnWBSElement = Lists.newArrayList(toCnsldtnWBSElement);
                    }
                    int i = 0;
                    for( Object item : ((Iterable<?>) value) ) {
                        if( !(item instanceof Map) ) {
                            continue;
                        }
                        WBSElement entity;
                        if( toCnsldtnWBSElement.size() > i ) {
                            entity = toCnsldtnWBSElement.get(i);
                        } else {
                            entity = new WBSElement();
                            toCnsldtnWBSElement.add(entity);
                        }
                        i = (i + 1);
                        @SuppressWarnings( "unchecked" )
                        final Map<String, Object> inputMap = ((Map<String, Object>) item);
                        entity.fromMap(inputMap);
                    }
                }
            }
        }
        super.fromMap(values);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param fieldType
     *            The Java type to use for the extension field when performing value comparisons.
     * @return A representation of an extension field from this entity.
     */
    @Nonnull
    public static <T> WBSElementTextField<T> field( @Nonnull final String fieldName, @Nonnull final Class<T> fieldType )
    {
        return new WBSElementTextField<T>(fieldName);
    }

    /**
     * Use with available fluent helpers to apply an extension field to query operations.
     *
     * @param typeConverter
     *            A TypeConverter<T, DomainT> instance whose first generic type matches the Java type of the field
     * @param fieldName
     *            The name of the extension field as returned by the OData service.
     * @param <T>
     *            The type of the extension field when performing value comparisons.
     * @param <DomainT>
     *            The type of the extension field as returned by the OData service.
     * @return A representation of an extension field from this entity, holding a reference to the given TypeConverter.
     */
    @Nonnull
    public static <T, DomainT> WBSElementTextField<T> field(
        @Nonnull final String fieldName,
        @Nonnull final TypeConverter<T, DomainT> typeConverter )
    {
        return new WBSElementTextField<T>(fieldName, typeConverter);
    }

    @Override
    @Nullable
    public HttpDestinationProperties getDestinationForFetch()
    {
        return super.getDestinationForFetch();
    }

    @Override
    protected void setServicePathForFetch( @Nullable final String servicePathForFetch )
    {
        super.setServicePathForFetch(servicePathForFetch);
    }

    @Override
    public
        void
        attachToService( @Nullable final String servicePath, @Nonnull final HttpDestinationProperties destination )
    {
        super.attachToService(servicePath, destination);
    }

    @Override
    @SuppressWarnings( "deprecation" )
    protected String getDefaultServicePath()
    {
        return (com.sap.cloud.sdk.s4hana.datamodel.odata.services.MasterDataForGroupReportingService.DEFAULT_SERVICE_PATH);
    }

    @Nonnull
    @Override
    protected Map<String, Object> toMapOfNavigationProperties()
    {
        final Map<String, Object> values = super.toMapOfNavigationProperties();
        if( toCnsldtnWBSElement != null ) {
            (values).put("to_CnsldtnWBSElement", toCnsldtnWBSElement);
        }
        return values;
    }

    /**
     * Fetches the <b>WBSElement</b> entities (one to many) associated with this entity. This corresponds to the OData
     * navigation property <b>to_CnsldtnWBSElement</b>.
     * <p>
     * Please note: This method will not cache or persist the query results.
     *
     * @return List containing one or more associated <b>WBSElement</b> entities. If no entities are associated then an
     *         empty list is returned.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WBSElement> fetchCnsldtnWBSElement()
    {
        return fetchFieldAsList("to_CnsldtnWBSElement", WBSElement.class);
    }

    /**
     * Retrieval of associated <b>WBSElement</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnWBSElement</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnWBSElement</b> of a queried <b>WBSElementText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @return List of associated <b>WBSElement</b> entities.
     * @throws ODataException
     *             If the entity is unmanaged, i.e. it has not been retrieved using the OData VDM's services and
     *             therefore has no ERP configuration context assigned. An entity is managed if it has been either
     *             retrieved using the VDM's services or returned from the VDM's services as the result of a CREATE or
     *             UPDATE call.
     */
    @Nonnull
    public List<WBSElement> getCnsldtnWBSElementOrFetch()
    {
        if( toCnsldtnWBSElement == null ) {
            toCnsldtnWBSElement = fetchCnsldtnWBSElement();
        }
        return toCnsldtnWBSElement;
    }

    /**
     * Retrieval of associated <b>WBSElement</b> entities (one to many). This corresponds to the OData navigation
     * property <b>to_CnsldtnWBSElement</b>.
     * <p>
     * If the navigation property for an entity <b>WBSElementText</b> has not been resolved yet, this method will <b>not
     * query</b> further information. Instead its <code>Option</code> result state will be <code>empty</code>.
     *
     * @return If the information for navigation property <b>to_CnsldtnWBSElement</b> is already loaded, the result will
     *         contain the <b>WBSElement</b> entities. If not, an <code>Option</code> with result state
     *         <code>empty</code> is returned.
     */
    @Nonnull
    public Option<List<WBSElement>> getCnsldtnWBSElementIfPresent()
    {
        return Option.of(toCnsldtnWBSElement);
    }

    /**
     * Overwrites the list of associated <b>WBSElement</b> entities for the loaded navigation property
     * <b>to_CnsldtnWBSElement</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnWBSElement</b> of a queried <b>WBSElementText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param value
     *            List of <b>WBSElement</b> entities.
     */
    public void setCnsldtnWBSElement( @Nonnull final List<WBSElement> value )
    {
        if( toCnsldtnWBSElement == null ) {
            toCnsldtnWBSElement = Lists.newArrayList();
        }
        toCnsldtnWBSElement.clear();
        toCnsldtnWBSElement.addAll(value);
    }

    /**
     * Adds elements to the list of associated <b>WBSElement</b> entities. This corresponds to the OData navigation
     * property <b>to_CnsldtnWBSElement</b>.
     * <p>
     * If the navigation property <b>to_CnsldtnWBSElement</b> of a queried <b>WBSElementText</b> is operated lazily, an
     * <b>ODataException</b> can be thrown in case of an OData query error.
     * <p>
     * Please note: <i>Lazy</i> loading of OData entity associations is the process of asynchronous retrieval and
     * persisting of items from a navigation property. If a <i>lazy</i> property is requested by the application for the
     * first time and it has not yet been loaded, an OData query will be run in order to load the missing information
     * and its result will get cached for future invocations.
     *
     * @param entity
     *            Array of <b>WBSElement</b> entities.
     */
    public void addCnsldtnWBSElement( WBSElement... entity )
    {
        if( toCnsldtnWBSElement == null ) {
            toCnsldtnWBSElement = Lists.newArrayList();
        }
        toCnsldtnWBSElement.addAll(Lists.newArrayList(entity));
    }

    /**
     * Helper class to allow for fluent creation of WBSElementText instances.
     *
     */
    public final static class WBSElementTextBuilder
    {

        private List<WBSElement> toCnsldtnWBSElement = Lists.newArrayList();

        private WBSElementText.WBSElementTextBuilder toCnsldtnWBSElement( final List<WBSElement> value )
        {
            toCnsldtnWBSElement.addAll(value);
            return this;
        }

        /**
         * Navigation property <b>to_CnsldtnWBSElement</b> for <b>WBSElementText</b> to multiple <b>WBSElement</b>.
         *
         * @param value
         *            The WBSElements to build this WBSElementText with.
         * @return This Builder to allow for a fluent interface.
         */
        @Nonnull
        public WBSElementText.WBSElementTextBuilder cnsldtnWBSElement( WBSElement... value )
        {
            return toCnsldtnWBSElement(Lists.newArrayList(value));
        }

    }

}
